/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.NodeType;
import javax.portlet.PortletPreferences;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.ecm.jcr.TypeNodeComparator;
import org.exoplatform.ecm.jcr.model.ClipboardCommand;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.comparator.NodeNameComparator;
import org.exoplatform.ecm.webui.comparator.PropertyValueComparator;
import org.exoplatform.ecm.webui.comparator.StringComparator;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentInfo;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWithTree;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentForm;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIDocumentFormController;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UISelectDocumentForm;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeExplorer;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.ecm.webui.utils.LockUtil;
import org.exoplatform.ecm.webui.utils.PermissionUtil;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.link.ItemLinkAware;
import org.exoplatform.services.cms.link.LinkUtils;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIContainerLifecycle.class)
public class UIJCRExplorer
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UIJCRExplorer");
    private LinkedList<ClipboardCommand> clipboards_ = new LinkedList();
    private LinkedList<String> nodesHistory_ = new LinkedList();
    private LinkedList<String> wsHistory_ = new LinkedList();
    private PortletPreferences pref_;
    private Preference preferences_;
    private Map<String, HistoryEntry> addressPath_ = new HashMap<String, HistoryEntry>();
    private JCRResourceResolver jcrTemplateResourceResolver_;
    private String currentRootPath_;
    private String currentPath_;
    private String currentStatePath_;
    private String currentStateWorkspaceName_;
    private String lastWorkspaceName_;
    private String currentDriveRootPath_;
    private String currentDriveWorkspaceName_;
    private String currentDriveRepositoryName_;
    private String documentInfoTemplate_;
    private String language_;
    private String tagPath_;
    private String referenceWorkspace_;
    private String pathBeforeEditing;
    private boolean isViewTag_;
    private boolean isHidePopup_;
    private boolean isReferenceNode_;
    private DriveData driveData_;
    private boolean isFilterSave_;
    private boolean isShowDocumentViewForFile_ = true;
    private boolean preferencesSaved_ = false;
    private int tagScope;
    private List<String> checkedSupportType = new ArrayList<String>();
    private Set<String> allItemFilterMap = new HashSet<String>();
    private Set<String> allItemByTypeFilterMap = new HashSet<String>();

    public Set<String> getAllItemFilterMap() {
        return this.allItemFilterMap;
    }

    public Set<String> getAllItemByTypeFilterMap() {
        return this.allItemByTypeFilterMap;
    }

    public int getTagScope() {
        return this.tagScope;
    }

    public void setTagScope(int scope) {
        this.tagScope = scope;
    }

    public boolean isFilterSave() {
        return this.isFilterSave_;
    }

    public void setFilterSave(boolean isFilterSave) {
        this.isFilterSave_ = isFilterSave;
    }

    public boolean isShowDocumentViewForFile() {
        return this.isShowDocumentViewForFile_;
    }

    public void setShowDocumentViewForFile(boolean value) {
        this.isShowDocumentViewForFile_ = value;
    }

    public boolean isPreferencesSaved() {
        return this.preferencesSaved_;
    }

    public void setPreferencesSaved(boolean value) {
        this.preferencesSaved_ = value;
    }

    public boolean isAddingDocument() {
        UIDocumentFormController controller;
        UIPopupContainer uiPopupContainer = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        UIPopupWindow uiPopup = (UIPopupWindow)uiPopupContainer.getChild(UIPopupWindow.class);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)this.getChild(UIWorkingArea.class);
        UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
        UIComponent uiComp = uiPopup.getUIComponent();
        if (uiComp instanceof UIDocumentFormController && ((UIDocumentFormController)uiComp).isRendered()) {
            return ((UIDocumentForm)((UIDocumentFormController)uiComp).getChild(UIDocumentForm.class)).isAddNew();
        }
        if (uiDocumentWorkspace.isRendered() && (controller = (UIDocumentFormController)uiDocumentWorkspace.getChild(UIDocumentFormController.class)) != null && controller.isRendered()) {
            return ((UIDocumentForm)controller.getChild(UIDocumentForm.class)).isAddNew();
        }
        return false;
    }

    public boolean isEditingDocument() {
        UIDocumentFormController controller;
        UIPopupContainer uiPopupContainer = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        UIPopupWindow uiPopup = (UIPopupWindow)uiPopupContainer.getChild(UIPopupWindow.class);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)this.getChild(UIWorkingArea.class);
        UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
        UIComponent uiComp = uiPopup.getUIComponent();
        if (uiPopup.isShow() && uiPopup.isRendered() && uiComp instanceof UIDocumentFormController && ((UIDocumentFormController)uiComp).isRendered()) {
            return true;
        }
        return uiDocumentWorkspace.isRendered() && (controller = (UIDocumentFormController)uiDocumentWorkspace.getChild(UIDocumentFormController.class)) != null && controller.isRendered();
    }

    public List<String> getCheckedSupportType() {
        return this.checkedSupportType;
    }

    public void setCheckedSupportType(List<String> checkedSupportType) {
        this.checkedSupportType = checkedSupportType;
    }

    public UIJCRExplorer() throws Exception {
        this.addChild(UIControl.class, null, null);
        this.addChild(UIWorkingArea.class, null, null);
        this.addChild(UIPopupContainer.class, null, null);
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        this.pref_ = pcontext.getRequest().getPreferences();
        ((UIWorkingArea)this.getChild(UIWorkingArea.class)).initialize();
    }

    public String filterPath(String currentPath) throws Exception {
        if (LinkUtils.getDepth((String)this.currentRootPath_) == 0) {
            return currentPath;
        }
        if (this.currentRootPath_.equals(this.currentPath_)) {
            return "/";
        }
        return currentPath.replaceFirst(this.currentRootPath_, "");
    }

    public void setRootPath(String rootPath) {
        this.currentDriveRootPath_ = rootPath;
        this.setCurrentRootPath(rootPath);
    }

    private void setCurrentRootPath(String rootPath) {
        this.currentRootPath_ = rootPath;
    }

    public Node getRootNode() throws Exception {
        return this.getNodeByPath(this.currentRootPath_, this.getSession());
    }

    public String getRootPath() {
        return this.currentRootPath_;
    }

    private String getDefaultRootPath() {
        return "/";
    }

    public Node getCurrentNode() throws Exception {
        return this.getNodeByPath(this.currentPath_, this.getSession());
    }

    public Node getRealCurrentNode() throws Exception {
        return this.getNodeByPath(this.currentPath_, this.getSession(), false);
    }

    public String getCurrentPath() {
        return this.currentPath_;
    }

    public void setCurrentPath(String currentPath) {
        if (this.currentPath_ == null || !this.currentPath_.equals(currentPath)) {
            this.isShowDocumentViewForFile_ = true;
        }
        this.currentPath_ = currentPath;
    }

    public boolean isReferenceNode() {
        return this.isReferenceNode_;
    }

    public void setIsReferenceNode(boolean isReferenceNode) {
        this.isReferenceNode_ = isReferenceNode;
    }

    public void setReferenceWorkspace(String referenceWorkspace) {
        this.referenceWorkspace_ = referenceWorkspace;
    }

    public String getReferenceWorkspace() {
        return this.referenceWorkspace_;
    }

    private String setTargetWorkspaceProperties(String workspaceName) {
        if (workspaceName != null && workspaceName.length() > 0) {
            if (!workspaceName.equals(this.getCurrentDriveWorkspace())) {
                this.setIsReferenceNode(true);
                this.setReferenceWorkspace(workspaceName);
                this.setCurrentRootPath(this.getDefaultRootPath());
                return workspaceName;
            }
            if (this.isReferenceNode()) {
                this.setIsReferenceNode(false);
                this.setCurrentRootPath(this.currentDriveRootPath_);
            }
        }
        return this.getCurrentDriveWorkspace();
    }

    @Deprecated
    public void setBackNodePath(String previousPath) throws Exception {
        this.setBackNodePath(null, previousPath);
    }

    public void setBackNodePath(String previousWorkspaceName, String previousPath) throws Exception {
        this.setBackSelectNode(previousWorkspaceName, previousPath);
        this.refreshExplorer();
    }

    public void setDriveData(DriveData driveData) {
        this.driveData_ = driveData;
    }

    public DriveData getDriveData() {
        return this.driveData_;
    }

    public void setLanguage(String language) {
        this.language_ = language;
    }

    public String getLanguage() {
        return this.language_;
    }

    public LinkedList<String> getNodesHistory() {
        return this.nodesHistory_;
    }

    @Deprecated
    public void setNodesHistory(LinkedList<String> h) {
        this.nodesHistory_ = h;
    }

    public LinkedList<String> getWorkspacesHistory() {
        return this.wsHistory_;
    }

    @Deprecated
    public void setWorkspaceHistory(LinkedList<String> wsHistory) {
        this.wsHistory_ = wsHistory;
    }

    public Collection<HistoryEntry> getHistory() {
        return this.addressPath_.values();
    }

    @Deprecated
    public Set<String> getAddressPath() {
        return this.addressPath_.keySet();
    }

    @Deprecated
    public void setAddressPath(Set<String> s) {
    }

    public SessionProvider getSessionProvider() {
        return SessionProviderFactory.createSessionProvider();
    }

    public SessionProvider getSystemProvider() {
        return SessionProviderFactory.createSystemProvider();
    }

    public Session getTargetSession() throws Exception {
        return this.getCurrentNode().getSession();
    }

    public Session getSession() throws Exception {
        if (this.isReferenceNode_) {
            return this.getSessionProvider().getSession(this.referenceWorkspace_, this.getRepository());
        }
        return this.getSessionProvider().getSession(this.currentDriveWorkspaceName_, this.getRepository());
    }

    public Session getSystemSession() throws Exception {
        if (this.isReferenceNode_) {
            return this.getSystemProvider().getSession(this.referenceWorkspace_, this.getRepository());
        }
        return this.getSystemProvider().getSession(this.currentDriveWorkspaceName_, this.getRepository());
    }

    public String getDocumentInfoTemplate() {
        return this.documentInfoTemplate_;
    }

    public void setRenderTemplate(String template) {
        this.newJCRTemplateResourceResolver();
        this.documentInfoTemplate_ = template;
    }

    public void setCurrentState() {
        this.setCurrentState(this.currentDriveWorkspaceName_, this.currentPath_);
    }

    public void setCurrentState(String currentStateWorkspaceName, String currentStatePath) {
        this.currentStateWorkspaceName_ = currentStateWorkspaceName;
        this.currentStatePath_ = currentStatePath;
    }

    public String getCurrentStatePath() {
        return this.currentStatePath_;
    }

    public void setCurrentStatePath(String currentStatePath) {
        this.setCurrentState(this.currentDriveWorkspaceName_, currentStatePath);
    }

    public Node getCurrentStateNode() throws Exception {
        return this.getNodeByPath(this.currentStatePath_, this.getSessionProvider().getSession(this.currentStateWorkspaceName_, this.getRepository()));
    }

    public JCRResourceResolver getJCRTemplateResourceResolver() {
        return this.jcrTemplateResourceResolver_;
    }

    public void newJCRTemplateResourceResolver() {
        try {
            DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
            DMSRepositoryConfiguration dmsRepoConfig = dmsConfiguration.getConfig();
            String workspace = dmsRepoConfig.getSystemWorkspace();
            this.jcrTemplateResourceResolver_ = new JCRResourceResolver(workspace);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot instantiate the JCRResourceResolver", (Throwable)e);
        }
    }

    public void setRepositoryName(String repositoryName) {
        this.currentDriveRepositoryName_ = repositoryName;
    }

    public String getRepositoryName() {
        try {
            return ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository().getConfiguration().getName();
        }
        catch (RepositoryException e) {
            String repoName = System.getProperty("gatein.tenant.repository.name");
            if (repoName != null) {
                return repoName;
            }
            return this.currentDriveRepositoryName_;
        }
    }

    public void setWorkspaceName(String workspaceName) {
        this.currentDriveWorkspaceName_ = workspaceName;
        if (this.lastWorkspaceName_ == null) {
            this.setLastWorkspace(workspaceName);
        }
    }

    private void setLastWorkspace(String lastWorkspaceName) {
        this.lastWorkspaceName_ = lastWorkspaceName;
    }

    public String getCurrentDriveWorkspace() {
        return this.currentDriveWorkspaceName_;
    }

    public String getCurrentWorkspace() {
        try {
            return this.getCurrentNode().getSession().getWorkspace().getName();
        }
        catch (Exception e) {
            LOG.warn((Object)"The workspace of the current node cannot be found, the workspace of the drive will be used", (Throwable)e);
            return this.getCurrentDriveWorkspace();
        }
    }

    public ManageableRepository getRepository() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getCurrentRepository();
    }

    public Session getSessionByWorkspace(String wsName) throws Exception {
        if (wsName == null) {
            return this.getSession();
        }
        return this.getSessionProvider().getSession(wsName, this.getRepository());
    }

    public boolean isSystemWorkspace() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String systemWS = repositoryService.getCurrentRepository().getConfiguration().getSystemWorkspaceName();
        return this.getCurrentWorkspace().equals(systemWS);
    }

    public void refreshExplorer() throws Exception {
        this.refreshExplorer(null, true);
    }

    public void refreshExplorerWithoutClosingPopup() throws Exception {
        this.refreshExplorer(null, false);
    }

    public void setPathToAddressBar(String path) throws Exception {
        ((UIAddressBar)this.findFirstComponentOfType(UIAddressBar.class)).getUIStringInput("address").setValue((Object)this.filterPath(path));
    }

    private void refreshExplorer(Node currentNode) throws Exception {
        this.refreshExplorer(currentNode, true);
    }

    public void refreshExplorer(Node currentNode, boolean closePopup) throws Exception {
        try {
            Node nodeGet;
            Node node = nodeGet = currentNode == null ? this.getCurrentNode() : currentNode;
            if (nodeGet.hasProperty("exo:language")) {
                this.setLanguage(nodeGet.getProperty("exo:language").getValue().getString());
            }
        }
        catch (PathNotFoundException path) {
            LOG.error((Object)"The node cannot be found ", (Throwable)path);
            this.setCurrentPath(this.currentRootPath_);
        }
        ((UIAddressBar)this.findFirstComponentOfType(UIAddressBar.class)).getUIStringInput("address").setValue((Object)this.filterPath(this.currentPath_));
        UIWorkingArea uiWorkingArea = (UIWorkingArea)this.getChild(UIWorkingArea.class);
        UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
        if (uiDocumentWorkspace.isRendered()) {
            if (uiDocumentWorkspace.getChild(UIDocumentFormController.class) == null || !((UIDocumentFormController)uiDocumentWorkspace.getChild(UIDocumentFormController.class)).isRendered()) {
                UIDocumentContainer uiDocumentContainer = (UIDocumentContainer)uiDocumentWorkspace.getChild(UIDocumentContainer.class);
                UIDocumentWithTree uiDocumentWithTree = (UIDocumentWithTree)uiDocumentContainer.getChildById("UIDocumentWithTree");
                if (this.isShowViewFile() && !this.isShowDocumentViewForFile()) {
                    uiDocumentWithTree.updatePageListData();
                    uiDocumentContainer.setRenderedChild("UIDocumentWithTree");
                } else {
                    UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)uiDocumentContainer.getChildById("UIDocumentInfo");
                    uiDocumentInfo.updatePageListData();
                    uiDocumentContainer.setRenderedChild("UIDocumentInfo");
                }
                if (this.getCurrentNode().isNodeType("nt:folder") || this.getCurrentNode().isNodeType("nt:unstructured")) {
                    uiDocumentWithTree.updatePageListData();
                }
                uiDocumentWorkspace.setRenderedChild(UIDocumentContainer.class);
            } else {
                UIDocumentFormController uiDocController = (UIDocumentFormController)uiDocumentWorkspace.getChild(UIDocumentFormController.class);
                UISelectDocumentForm uiSelectDoc = (UISelectDocumentForm)uiDocController.getChild(UISelectDocumentForm.class);
                if (uiSelectDoc != null && uiSelectDoc.isRendered()) {
                    uiSelectDoc.updatePageListData();
                }
            }
        }
        UISideBar uiSideBar = (UISideBar)uiWorkingArea.findFirstComponentOfType(UISideBar.class);
        uiSideBar.setRendered(this.preferences_.isShowSideBar());
        if (this.preferences_.isShowSideBar()) {
            UITreeExplorer treeExplorer = (UITreeExplorer)this.findFirstComponentOfType(UITreeExplorer.class);
            treeExplorer.buildTree();
            uiSideBar.updateSideBarView();
        }
        if (closePopup) {
            UIPopupContainer popupAction = (UIPopupContainer)this.getChild(UIPopupContainer.class);
            popupAction.deActivate();
        }
    }

    public boolean nodeIsLocked(String path, Session session) throws Exception {
        Node node = this.getNodeByPath(path, session);
        return this.nodeIsLocked(node);
    }

    public boolean nodeIsLocked(Node node) throws Exception {
        if (!node.isLocked()) {
            return false;
        }
        String lockToken = LockUtil.getLockTokenOfUser((Node)node);
        if (lockToken != null) {
            node.getSession().addLockToken(LockUtil.getLockToken((Node)node));
            return false;
        }
        return true;
    }

    public void addLockToken(Node node) throws Exception {
        String lockToken;
        if (node.isLocked() && (lockToken = LockUtil.getLockToken((Node)node)) != null) {
            node.getSession().addLockToken(lockToken);
        }
    }

    public boolean hasAddPermission() {
        try {
            ((ExtendedNode)this.getCurrentNode()).checkPermission("add_node");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean hasEditPermission() {
        try {
            ((ExtendedNode)this.getCurrentNode()).checkPermission("set_property");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean hasRemovePermission() {
        try {
            ((ExtendedNode)this.getCurrentNode()).checkPermission("remove");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean hasReadPermission() {
        try {
            ((ExtendedNode)this.getCurrentNode()).checkPermission("read");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public Node getViewNode(String nodeType) throws Exception {
        try {
            Node primaryNode;
            Item primaryItem = this.getCurrentNode().getPrimaryItem();
            if (primaryItem == null || !primaryItem.isNode()) {
                return this.getCurrentNode();
            }
            if (primaryItem != null && primaryItem.isNode() && (primaryNode = (Node)primaryItem).isNodeType(nodeType)) {
                return primaryNode;
            }
        }
        catch (ItemNotFoundException item) {
            LOG.error((Object)("Primary item not found for " + this.getCurrentNode().getPath()));
            return this.getCurrentNode();
        }
        catch (Exception e) {
            LOG.error((Object)"The node cannot be seen", (Throwable)e);
            return this.getCurrentNode();
        }
        return this.getCurrentNode();
    }

    public List<String> getMultiValues(Node node, String name) throws Exception {
        Value[] values;
        ArrayList<String> list = new ArrayList<String>();
        if (!node.hasProperty(name)) {
            return list;
        }
        if (!node.getProperty(name).getDefinition().isMultiple()) {
            try {
                if (node.hasProperty(name)) {
                    list.add(node.getProperty(name).getString());
                }
            }
            catch (Exception e) {
                LOG.error((Object)("The property '" + name + "' cannot be found "), (Throwable)e);
                list.add("");
            }
            return list;
        }
        for (Value value : values = node.getProperty(name).getValues()) {
            list.add(value.getString());
        }
        return list;
    }

    public void setIsHidePopup(boolean isHidePopup) {
        this.isHidePopup_ = isHidePopup;
    }

    public void updateAjax(Event<?> event) throws Exception {
        UIPopupContainer popupAction;
        UIDocumentWorkspace uiDocWorkspace;
        UIJCRExplorerPortlet uiPortlet = (UIJCRExplorerPortlet)this.getAncestorOfType(UIJCRExplorerPortlet.class);
        UIAddressBar uiAddressBar = (UIAddressBar)this.findFirstComponentOfType(UIAddressBar.class);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)this.getChild(UIWorkingArea.class);
        UIActionBar uiActionBar = (UIActionBar)this.findFirstComponentOfType(UIActionBar.class);
        UISideBar uiSideBar = (UISideBar)this.findFirstComponentOfType(UISideBar.class);
        uiAddressBar.getUIStringInput("address").setValue((Object)Text.unescapeIllegalJcrChars((String)this.filterPath(this.currentPath_)));
        event.getRequestContext().addUIComponentToUpdateByAjax(this.getChild(UIControl.class));
        if (this.preferences_.isShowSideBar()) {
            ((UITreeExplorer)this.findFirstComponentOfType(UITreeExplorer.class)).buildTree();
        }
        if ((uiDocWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class)).isRendered()) {
            if (uiDocWorkspace.getChild(UIDocumentFormController.class) == null || !((UIDocumentFormController)uiDocWorkspace.getChild(UIDocumentFormController.class)).isRendered()) {
                UIDocumentContainer uiDocumentContainer = (UIDocumentContainer)uiDocWorkspace.getChild(UIDocumentContainer.class);
                UIDocumentWithTree uiDocumentWithTree = (UIDocumentWithTree)uiDocumentContainer.getChildById("UIDocumentWithTree");
                if (this.isShowViewFile() && !this.isShowDocumentViewForFile()) {
                    uiDocumentWithTree.updatePageListData();
                    uiDocumentContainer.setRenderedChild("UIDocumentWithTree");
                } else {
                    UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)uiDocumentContainer.getChildById("UIDocumentInfo");
                    uiDocumentInfo.updatePageListData();
                    uiDocumentContainer.setRenderedChild("UIDocumentInfo");
                }
                if (this.getCurrentNode().isNodeType("nt:folder") || this.getCurrentNode().isNodeType("nt:unstructured")) {
                    uiDocumentWithTree.updatePageListData();
                }
                uiDocWorkspace.setRenderedChild(UIDocumentContainer.class);
            } else {
                UIDocumentFormController uiDocController = (UIDocumentFormController)uiDocWorkspace.getChild(UIDocumentFormController.class);
                UISelectDocumentForm uiSelectDoc = (UISelectDocumentForm)uiDocController.getChild(UISelectDocumentForm.class);
                if (uiSelectDoc != null && uiSelectDoc.isRendered()) {
                    uiSelectDoc.updatePageListData();
                }
            }
        }
        uiActionBar.setRendered(uiPortlet.isShowActionBar());
        uiAddressBar.setRendered(uiPortlet.isShowTopBar());
        uiSideBar.setRendered(this.getPreference().isShowSideBar());
        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWorkingArea);
        if (uiSideBar.isRendered()) {
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSideBar);
        }
        event.getRequestContext().addUIComponentToUpdateByAjax(this.getChild(UIControl.class));
        if (!this.isHidePopup_ && (popupAction = (UIPopupContainer)this.getChild(UIPopupContainer.class)).isRendered()) {
            popupAction.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)popupAction);
        }
        this.isHidePopup_ = false;
    }

    public boolean isShowViewFile() throws Exception {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        NodeType nodeType = this.getCurrentNode().getPrimaryNodeType();
        NodeType[] superTypes = nodeType.getSupertypes();
        boolean isFolder = false;
        for (NodeType superType : superTypes) {
            if (!superType.getName().equals("nt:folder") && !superType.getName().equals("nt:unstructured")) continue;
            isFolder = true;
        }
        return isFolder && templateService.getDocumentTemplates().contains(nodeType.getName());
    }

    public void cancelAction() throws Exception {
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIPopupContainer popupAction = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        popupAction.deActivate();
        context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
    }

    public void record(String str, String ws) {
        this.nodesHistory_.add(str);
        this.wsHistory_.add(ws);
        this.addressPath_.put(str, new HistoryEntry(ws, str));
        UIWorkingArea uiWorkingArea = (UIWorkingArea)this.getChild(UIWorkingArea.class);
        UIDocumentWorkspace uiDocWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
        UIDocumentContainer uiDocumentContainer = (UIDocumentContainer)uiDocWorkspace.getChild(UIDocumentContainer.class);
    }

    public void clearNodeHistory(String currentPath) {
        this.nodesHistory_.clear();
        this.wsHistory_.clear();
        this.addressPath_.clear();
        this.currentPath_ = currentPath;
    }

    public String rewind() {
        return this.nodesHistory_.removeLast();
    }

    public String previousWsName() {
        return this.wsHistory_.removeLast();
    }

    @Deprecated
    public void setSelectNode(String uri, Session session) throws Exception {
        this.setSelectNode(session.getWorkspace().getName(), uri);
    }

    public void setSelectNode(String workspaceName, String uri) throws Exception {
        String lastWorkspaceName = this.setTargetWorkspaceProperties(workspaceName);
        this.setSelectNode(uri);
        this.setLastWorkspace(lastWorkspaceName);
    }

    public void setBackSelectNode(String workspaceName, String uri) throws Exception {
        String lastWorkspaceName = this.setTargetWorkspaceProperties(workspaceName);
        this.setSelectNode(uri, true);
        this.setLastWorkspace(lastWorkspaceName);
    }

    public void setSelectRootNode() throws Exception {
        this.setSelectNode(this.getCurrentDriveWorkspace(), this.getRootPath());
    }

    public void setSelectNode(String uri) throws Exception {
        this.setSelectNode(uri, false);
    }

    private boolean checkTargetForSymlink(String uri) throws Exception {
        Node testedNode;
        NodeFinder nodeFinder = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
        try {
            testedNode = (Node)nodeFinder.getItem(this.getSession(), uri, true);
        }
        catch (Exception e) {
            LOG.warn((Object)("Cannot find the node at " + uri));
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage("UIJCRExplorer.msg.target-path-not-found", null, 1));
            return false;
        }
        if (testedNode.isNodeType("exo:restoreLocation")) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            uiApp.addMessage(new ApplicationMessage("UIJCRExplorer.msg.target-path-not-found", null, 1));
            return false;
        }
        return true;
    }

    public void setSelectNode(String uri, boolean back) throws Exception {
        Node currentNode = null;
        if (uri == null || uri.length() == 0) {
            uri = "/";
        }
        String previousPath = this.currentPath_;
        if (this.checkTargetForSymlink(uri)) {
            try {
                this.setCurrentPath(uri);
                currentNode = this.getCurrentNode();
            }
            catch (Exception e) {
                LOG.error((Object)("Cannot find the node at " + uri), (Throwable)e);
                this.setCurrentPath(LinkUtils.getParentPath((String)this.currentPath_));
                currentNode = this.getCurrentNode();
            }
        } else {
            currentNode = this.getCurrentNode();
        }
        if (currentNode.hasProperty("exo:language")) {
            this.setLanguage(currentNode.getProperty("exo:language").getValue().getString());
        }
        if (previousPath != null && !this.currentPath_.equals(previousPath) && !back) {
            this.record(previousPath, this.lastWorkspaceName_);
        }
    }

    public List<Node> getChildrenList(String path, boolean isReferences) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        Node node = (Node)ItemLinkAware.newInstance((Session)this.getSession(), (String)path, (Item)this.getNodeByPath(path, this.getSession()));
        NodeIterator childrenIterator = node.getNodes();
        ArrayList<Node> childrenList = new ArrayList<Node>();
        NodeType nodeType = node.getPrimaryNodeType();
        NodeType[] superTypes = nodeType.getSupertypes();
        boolean isFolder = false;
        for (NodeType superType : superTypes) {
            if (!superType.getName().equals("nt:folder") && !superType.getName().equals("nt:unstructured")) continue;
            isFolder = true;
        }
        if (!this.preferences_.isJcrEnable() && templateService.isManagedNodeType(nodeType.getName()) && !isFolder) {
            return childrenList;
        }
        if (this.isReferenceableNode(this.getCurrentNode()) && isReferences) {
            ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
            SessionProvider sessionProvider = SessionProviderFactory.createSystemProvider();
            for (String workspace : manageableRepository.getWorkspaceNames()) {
                Session session = sessionProvider.getSession(workspace, manageableRepository);
                try {
                    Node taxonomyNode = session.getNodeByUUID(this.getCurrentNode().getUUID());
                    PropertyIterator categoriesIter = taxonomyNode.getReferences();
                    while (categoriesIter.hasNext()) {
                        Property exoCategoryProp = categoriesIter.nextProperty();
                        Node refNode = exoCategoryProp.getParent();
                        childrenList.add(refNode);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (!this.preferences_.isShowNonDocumentType()) {
            List documentTypes = templateService.getDocumentTemplates();
            while (childrenIterator.hasNext()) {
                String typeName;
                Node child = (Node)childrenIterator.next();
                if (!PermissionUtil.canRead((Node)child)) continue;
                NodeType type = child.getPrimaryNodeType();
                String primaryTypeName = typeName = type.getName();
                if (typeName.equals("exo:symlink")) {
                    primaryTypeName = child.getProperty("exo:primaryType").getString();
                }
                if ("nt:unstructured".equals(primaryTypeName) || "nt:folder".equals(primaryTypeName)) {
                    childrenList.add(child);
                    continue;
                }
                if (typeName.equals("exo:symlink") && documentTypes.contains(primaryTypeName)) {
                    childrenList.add(child);
                    continue;
                }
                if (!documentTypes.contains(typeName)) continue;
                childrenList.add(child);
            }
        } else {
            while (childrenIterator.hasNext()) {
                Node child = (Node)childrenIterator.next();
                if (!PermissionUtil.canRead((Node)child)) continue;
                childrenList.add(child);
            }
        }
        ArrayList<Node> childList = new ArrayList();
        if (!this.preferences_.isShowHiddenNode()) {
            for (Node child : childrenList) {
                Node realChild;
                Node node2 = realChild = child instanceof NodeLinkAware ? ((NodeLinkAware)child).getRealNode() : child;
                if (!PermissionUtil.canRead((Node)child) || realChild.isNodeType("exo:hiddenable")) continue;
                childList.add(child);
            }
        } else {
            childList = childrenList;
        }
        this.sort(childList);
        return childList;
    }

    private void sort(List<Node> childrenList) {
        if ("Alphabetic".equals(this.preferences_.getSortType())) {
            Collections.sort(childrenList, new NodeNameComparator(this.preferences_.getOrder()));
        } else if ("Type".equals(this.preferences_.getSortType())) {
            Collections.sort(childrenList, new TypeNodeComparator(this.preferences_.getOrder()));
        } else if ("Versionable".equals(this.preferences_.getSortType())) {
            Collections.sort(childrenList, new StringComparator(this.preferences_.getOrder(), "Versionable"));
        } else if ("Auditing".equals(this.preferences_.getSortType())) {
            Collections.sort(childrenList, new StringComparator(this.preferences_.getOrder(), "Auditing"));
        } else if ("CreatedDate".equals(this.preferences_.getSortType())) {
            Collections.sort(childrenList, new PropertyValueComparator("exo:dateCreated", this.preferences_.getOrder()));
        } else if ("ModifiedDate".equals(this.preferences_.getSortType())) {
            Collections.sort(childrenList, new PropertyValueComparator("exo:dateModified", this.preferences_.getOrder()));
        } else {
            Collections.sort(childrenList, new PropertyValueComparator(this.preferences_.getSortType(), this.preferences_.getOrder()));
        }
    }

    public boolean isReferenceableNode(Node node) throws Exception {
        return node.isNodeType("mix:referenceable");
    }

    public boolean isPreferenceNode(Node node) {
        try {
            return !this.getCurrentNode().hasNode(node.getName());
        }
        catch (Exception e) {
            return false;
        }
    }

    public Node getNodeByPath(String nodePath, Session session) throws Exception {
        return this.getNodeByPath(nodePath, session, true);
    }

    public Node getNodeByPath(String nodePath, Session session, boolean giveTarget) throws Exception {
        return this.getNodeByPath(nodePath.trim(), session, giveTarget, true);
    }

    private Node getNodeByPath(String nodePath, Session session, boolean giveTarget, boolean firstTime) throws Exception {
        Node node2;
        NodeFinder nodeFinder = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
        try {
            node2 = (Node)nodeFinder.getItem(session, nodePath, giveTarget);
        }
        catch (Exception e) {
            if (nodePath.equals(this.currentPath_) && !nodePath.equals(this.currentRootPath_)) {
                this.setCurrentPath(LinkUtils.getParentPath((String)this.currentPath_));
                return this.getNodeByPath(this.currentPath_, session, giveTarget, false);
            }
            try {
                Node node2 = (Node)nodeFinder.getItem(session, nodePath, !giveTarget);
                return node2;
            }
            catch (Exception e3) {
                if (firstTime) {
                    UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
                    JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                    WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
                    context.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    String workspace = null;
                    try {
                        workspace = session.getWorkspace().getName();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    LOG.warn((Object)("The node cannot be found at " + nodePath + (workspace == null ? "" : " into the workspace " + workspace)));
                }
                throw e;
            }
        }
        if (!firstTime) {
            this.refreshExplorer(node2);
        }
        return node2;
    }

    public void setTagPath(String tagPath) {
        this.tagPath_ = tagPath;
    }

    public String getTagPath() {
        return this.tagPath_;
    }

    public List<Node> getDocumentByTag() throws Exception {
        NewFolksonomyService newFolksonomyService = (NewFolksonomyService)this.getApplicationComponent(NewFolksonomyService.class);
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        List documentsType = templateService.getDocumentTemplates();
        ArrayList<Node> documentsOnTag = new ArrayList<Node>();
        WebuiRequestContext ctx = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        SessionProvider sessionProvider = ctx.getRemoteUser() == null ? SessionProviderFactory.createAnonimProvider() : SessionProviderFactory.createSessionProvider();
        for (Node node : newFolksonomyService.getAllDocumentsByTag(this.tagPath_, this.getRepository().getConfiguration().getDefaultWorkspaceName(), sessionProvider)) {
            if (!documentsType.contains(node.getPrimaryNodeType().getName()) || !PermissionUtil.canRead((Node)node)) continue;
            documentsOnTag.add(node);
        }
        return documentsOnTag;
    }

    public void setIsViewTag(boolean isViewTag) {
        this.isViewTag_ = isViewTag;
    }

    public boolean isViewTag() {
        return this.isViewTag_;
    }

    public LinkedList<ClipboardCommand> getAllClipBoard() {
        return this.clipboards_;
    }

    public PortletPreferences getPortletPreferences() {
        return this.pref_;
    }

    public boolean isReadAuthorized(ExtendedNode node) throws RepositoryException {
        try {
            node.checkPermission("read");
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }

    public static Cookie getCookieByCookieName(String cookieName, Cookie[] cookies) {
        String userId = Util.getPortalRequestContext().getRemoteUser();
        cookieName = cookieName + userId;
        for (int loopIndex = 0; loopIndex < cookies.length; ++loopIndex) {
            Cookie cookie1 = cookies[loopIndex];
            if (!cookie1.getName().equals(cookieName)) continue;
            return cookie1;
        }
        return null;
    }

    public Preference getPreference() {
        if (this.preferencesSaved_) {
            if (this.preferences_ != null && !((UIJCRExplorerPortlet)this.getAncestorOfType(UIJCRExplorerPortlet.class)).isShowSideBar()) {
                this.preferences_.setShowSideBar(false);
            }
            return this.preferences_;
        }
        HttpServletRequest request = Util.getPortalRequestContext().getRequest();
        Cookie[] cookies = request.getCookies();
        Cookie getCookieForUser = UIJCRExplorer.getCookieByCookieName(Preference.PREFERENCE_ENABLESTRUCTURE, cookies);
        if (getCookieForUser != null && this.preferences_ != null) {
            if (getCookieForUser.getValue().equals("true")) {
                this.preferences_.setJcrEnable(true);
            } else {
                this.preferences_.setJcrEnable(false);
            }
        }
        if ((getCookieForUser = UIJCRExplorer.getCookieByCookieName(Preference.PREFERENCE_SHOWSIDEBAR, cookies)) != null && this.preferences_ != null) {
            if (getCookieForUser.getValue().equals("true")) {
                this.preferences_.setShowSideBar(true);
            } else {
                this.preferences_.setShowSideBar(false);
            }
        }
        if (this.preferences_ != null && !((UIJCRExplorerPortlet)this.getAncestorOfType(UIJCRExplorerPortlet.class)).isShowSideBar()) {
            this.preferences_.setShowSideBar(false);
        }
        if ((getCookieForUser = UIJCRExplorer.getCookieByCookieName("showNonDocumentType", cookies)) != null && this.preferences_ != null) {
            if (getCookieForUser.getValue().equals("true")) {
                this.preferences_.setShowNonDocumentType(true);
            } else {
                this.preferences_.setShowNonDocumentType(false);
            }
        }
        if ((getCookieForUser = UIJCRExplorer.getCookieByCookieName(Preference.PREFERENCE_SHOWREFDOCUMENTS, cookies)) != null && this.preferences_ != null) {
            if (getCookieForUser.getValue().equals("true")) {
                this.preferences_.setShowPreferenceDocuments(true);
            } else {
                this.preferences_.setShowPreferenceDocuments(false);
            }
        }
        if ((getCookieForUser = UIJCRExplorer.getCookieByCookieName(Preference.PREFERENCE_SHOW_HIDDEN_NODE, cookies)) != null && this.preferences_ != null) {
            if (getCookieForUser.getValue().equals("true")) {
                this.preferences_.setShowHiddenNode(true);
            } else {
                this.preferences_.setShowHiddenNode(false);
            }
        }
        if ((getCookieForUser = UIJCRExplorer.getCookieByCookieName("EnableDragAndDrop", cookies)) != null && this.preferences_ != null) {
            if (getCookieForUser.getValue().equals("true")) {
                this.preferences_.setEnableDragAndDrop(true);
            } else {
                this.preferences_.setEnableDragAndDrop(false);
            }
        }
        if ((getCookieForUser = UIJCRExplorer.getCookieByCookieName(Preference.PREFERENCE_QUERY_TYPE, cookies)) != null && this.preferences_ != null) {
            this.preferences_.setQueryType(getCookieForUser.getValue());
        }
        if ((getCookieForUser = UIJCRExplorer.getCookieByCookieName(Preference.PREFERENCE_SORT_BY, cookies)) != null && this.preferences_ != null) {
            this.preferences_.setSortType(getCookieForUser.getValue());
        }
        if ((getCookieForUser = UIJCRExplorer.getCookieByCookieName(Preference.PREFERENCE_ORDER_BY, cookies)) != null && this.preferences_ != null) {
            this.preferences_.setOrder(getCookieForUser.getValue());
        }
        if ((getCookieForUser = UIJCRExplorer.getCookieByCookieName(Preference.NODES_PER_PAGE, cookies)) != null && this.preferences_ != null) {
            this.preferences_.setNodesPerPage(Integer.parseInt(getCookieForUser.getValue()));
        }
        return this.preferences_;
    }

    public void setPreferences(Preference preference) {
        this.preferences_ = preference;
    }

    public void closeEditingFile() throws Exception {
        UIDocumentFormController controller;
        UIPopupContainer uiPopupContainer = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        UIPopupWindow uiPopup = (UIPopupWindow)uiPopupContainer.getChild(UIPopupWindow.class);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)this.getChild(UIWorkingArea.class);
        UIDocumentWorkspace uiDocumentWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
        UIComponent uiComp = uiPopup.getUIComponent();
        if (uiComp instanceof UIDocumentFormController && ((UIDocumentFormController)uiComp).isRendered()) {
            uiPopupContainer.deActivate();
            this.refreshExplorer();
            return;
        }
        if (uiDocumentWorkspace.isRendered() && (controller = (UIDocumentFormController)uiDocumentWorkspace.getChild(UIDocumentFormController.class)) != null) {
            ((UIDocumentFormController)uiDocumentWorkspace.removeChild(UIDocumentFormController.class)).deActivate();
            uiDocumentWorkspace.setRenderedChild(UIDocumentContainer.class);
            this.refreshExplorer();
        }
    }

    @Deprecated
    public String getPreferencesPath() {
        String prefPath = this.driveData_.getHomePath();
        if (prefPath == null || prefPath.length() == 0 || prefPath.equals("/")) {
            return "";
        }
        return prefPath;
    }

    @Deprecated
    public String getPreferencesWorkspace() {
        String workspaceName = this.driveData_.getWorkspace();
        if (workspaceName == null || workspaceName.length() == 0) {
            return "";
        }
        return workspaceName;
    }

    public static class HistoryEntry {
        private final String workspace;
        private final String path;

        private HistoryEntry(String workspace, String path) {
            this.workspace = workspace;
            this.path = path;
        }

        public String getWorkspace() {
            return this.workspace;
        }

        public String getPath() {
            return this.path;
        }
    }
}

