/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.ecm.jcr.model.ClipboardCommand;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorerPortlet;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.link.NodeFinder;
import org.exoplatform.services.cms.link.NodeLinkAware;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.ext.UIExtension;
import org.exoplatform.webui.ext.UIExtensionManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/webui/component/explorer/UIWorkingArea.gtmpl"), @ComponentConfig(type=UIRightClickPopupMenu.class, id="ECMContextMenu", template="app:/groovy/webui/component/explorer/UIRightClickPopupMenu.gtmpl")})
public class UIWorkingArea
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger((String)"dms.UIWorkingArea");
    public static final Pattern FILE_EXPLORER_URL_SYNTAX = Pattern.compile("([^:/]+):(/.*)");
    public static final String WS_NAME = "workspaceName";
    public static final String EXTENSION_TYPE = "org.exoplatform.ecm.dms.UIWorkingArea";
    public static final String ITEM_CONTEXT_MENU = "ItemContextMenu";
    public static final String MULTI_ITEM_CONTEXT_MENU = "MultiItemContextMenu";
    public static final String GROUND_CONTEXT_MENU = "GroundContextMenu";
    public static final String ITEM_GROUND_CONTEXT_MENU = "ItemGroundContextMenu";
    public static final String MOVE_NODE = "MoveNode";
    public static final String CREATE_LINK = "CreateLink";
    public static final String CUSTOM_ACTIONS = "CustomActions";
    public static final String PERMLINK = "PermlinkContextMenu";
    private List<UIAbstractManagerComponent> managers = Collections.synchronizedList(new ArrayList());
    private List<ClipboardCommand> virtualClipboards_ = Collections.synchronizedList(new LinkedList());

    public UIWorkingArea() throws Exception {
        this.addChild(UIRightClickPopupMenu.class, "ECMContextMenu", null);
        this.addChild(UISideBar.class, null, null);
        this.addChild(UIDocumentWorkspace.class, null, null);
        ((UIDrivesArea)this.addChild(UIDrivesArea.class, null, null)).setRendered(false);
    }

    private List<UIExtension> getUIExtensionList() {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        return manager.getUIExtensions(EXTENSION_TYPE);
    }

    public synchronized void initialize() throws Exception {
        List<UIExtension> extensions = this.getUIExtensionList();
        if (extensions == null) {
            return;
        }
        this.managers.clear();
        for (UIExtension extension : extensions) {
            UIComponent component = this.addUIExtension(extension, null);
            if (component == null || this.managers.contains(component)) continue;
            this.managers.add((UIAbstractManagerComponent)component);
        }
    }

    private synchronized UIComponent addUIExtension(UIExtension extension, Map<String, Object> context) throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        UIComponent component = manager.addUIExtension(extension, context, (UIContainer)this);
        if (component instanceof UIAbstractManagerComponent) {
            UIAbstractManagerComponent uiAbstractManagerComponent = (UIAbstractManagerComponent)component;
            uiAbstractManagerComponent.setUIExtensionName(extension.getName());
            uiAbstractManagerComponent.setUIExtensionCategory(extension.getCategory());
            return component;
        }
        if (component != null) {
            LOG.warn((Object)("All the extension '" + extension.getName() + "' of type '" + EXTENSION_TYPE + "' must be associated to a component of type " + UIAbstractManagerComponent.class));
            this.removeChild(component.getClass());
        }
        return null;
    }

    public List<UIAbstractManagerComponent> getManagers() {
        ArrayList<UIAbstractManagerComponent> managers = new ArrayList<UIAbstractManagerComponent>();
        managers.addAll(this.managers);
        return managers;
    }

    public void unregister(UIAbstractManagerComponent component) {
        this.managers.remove(component);
    }

    public List<ClipboardCommand> getVirtualClipboards() {
        return this.virtualClipboards_;
    }

    public boolean isShowSideBar() throws Exception {
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getParent();
        return jcrExplorer.getPreference().isShowSideBar() && ((UIJCRExplorerPortlet)this.getAncestorOfType(UIJCRExplorerPortlet.class)).isShowSideBar();
    }

    public void setShowSideBar(boolean b) throws Exception {
        UIJCRExplorer jcrExplorer = (UIJCRExplorer)this.getParent();
        jcrExplorer.getPreference().setShowSideBar(b);
    }

    public Node getNodeByUUID(String uuid) throws Exception {
        String repository = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
        ManageableRepository repo = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getCurrentRepository();
        String workspace = repo.getConfiguration().getDefaultWorkspaceName();
        Session session = SessionProviderFactory.createSystemProvider().getSession(workspace, repo);
        return session.getNodeByUUID(uuid);
    }

    public boolean isPreferenceNode(Node node) {
        return ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).isPreferenceNode(node);
    }

    public String getVersionNumber(Node node) throws RepositoryException {
        if (!Utils.isVersionable((Node)node)) {
            return "-";
        }
        return node.getBaseVersion().getName();
    }

    public boolean isJcrViewEnable() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        return uiExplorer.getPreference().isJcrEnable();
    }

    private Map<String, Object> createContext(Node currentNode) throws Exception {
        HashMap<String, Object> context = new HashMap<String, Object>();
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
        context.put(Node.class.getName(), currentNode);
        context.put(UIWorkingArea.class.getName(), (Object)this);
        context.put(UIApplication.class.getName(), uiApp);
        context.put(UIJCRExplorer.class.getName(), (Object)uiExplorer);
        context.put(WebuiRequestContext.class.getName(), requestContext);
        return context;
    }

    List<UIComponent> getGroundActionsExtensionList() throws Exception {
        ArrayList<UIComponent> uiGroundActionList = new ArrayList<UIComponent>();
        List<UIExtension> uiExtensionList = this.getUIExtensionList();
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        Node currentNode = uiExplorer.getCurrentNode();
        for (UIExtension uiextension : uiExtensionList) {
            UIComponent uiAddedActionManage;
            if (!GROUND_CONTEXT_MENU.equals(uiextension.getCategory()) && !ITEM_GROUND_CONTEXT_MENU.equals(uiextension.getCategory()) || (uiAddedActionManage = this.addUIExtension(uiextension, this.createContext(currentNode))) == null || uiGroundActionList.contains(uiAddedActionManage)) continue;
            uiGroundActionList.add(uiAddedActionManage);
        }
        return uiGroundActionList;
    }

    List<UIComponent> getMultiActionsExtensionList() throws Exception {
        ArrayList<UIComponent> uiActionList = new ArrayList<UIComponent>();
        List<UIExtension> uiExtensionList = this.getUIExtensionList();
        for (UIExtension uiextension : uiExtensionList) {
            UIComponent uiAddedActionManage;
            if (!ITEM_CONTEXT_MENU.equals(uiextension.getCategory()) && !ITEM_GROUND_CONTEXT_MENU.equals(uiextension.getCategory()) && !MULTI_ITEM_CONTEXT_MENU.equals(uiextension.getCategory()) || (uiAddedActionManage = this.addUIExtension(uiextension, null)) == null || uiActionList.contains(uiAddedActionManage)) continue;
            uiActionList.add(uiAddedActionManage);
        }
        return uiActionList;
    }

    public String getActionsExtensionList(Node node) throws Exception {
        StringBuffer actionsList = new StringBuffer(1024);
        List<UIExtension> uiExtensionList = this.getUIExtensionList();
        try {
            NodeFinder nodeFinder = (NodeFinder)this.getApplicationComponent(NodeFinder.class);
            nodeFinder.getItem(((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getSession(), node.getPath());
        }
        catch (PathNotFoundException pne) {
            return "";
        }
        for (UIExtension uiextension : uiExtensionList) {
            UIComponent uiAddedActionManage;
            if (!uiextension.getCategory().startsWith(ITEM_CONTEXT_MENU) && !ITEM_GROUND_CONTEXT_MENU.equals(uiextension.getCategory()) || (uiAddedActionManage = this.addUIExtension(uiextension, this.createContext(node))) == null) continue;
            actionsList.append(uiextension.getName()).append(",");
        }
        if (actionsList.length() > 0) {
            return actionsList.substring(0, actionsList.length() - 1);
        }
        return actionsList.toString();
    }

    public synchronized UIComponent getJCRMoveAction() throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        return manager.addUIExtension(EXTENSION_TYPE, MOVE_NODE, null, (UIContainer)this);
    }

    public synchronized UIComponent getCreateLinkAction() throws Exception {
        UIExtensionManager manager = (UIExtensionManager)this.getApplicationComponent(UIExtensionManager.class);
        return manager.addUIExtension(EXTENSION_TYPE, CREATE_LINK, null, (UIContainer)this);
    }

    public synchronized UIComponent getPermlink(Node node) throws Exception {
        UIComponent uicomponent = null;
        List<UIExtension> uiExtensionList = this.getUIExtensionList();
        for (UIExtension uiextension : uiExtensionList) {
            if (!PERMLINK.equals(uiextension.getCategory())) continue;
            uicomponent = this.addUIExtension(uiextension, this.createContext(node));
        }
        return uicomponent;
    }

    public synchronized UIComponent getCustomAction() throws Exception {
        UIComponent uicomponent = null;
        List<UIExtension> uiExtensionList = this.getUIExtensionList();
        for (UIExtension uiextension : uiExtensionList) {
            if (!CUSTOM_ACTIONS.equals(uiextension.getCategory())) continue;
            uicomponent = this.addUIExtension(uiextension, null);
        }
        return uicomponent;
    }

    private boolean hasPermission(String userName, Value[] roles) throws Exception {
        IdentityRegistry identityRegistry = (IdentityRegistry)this.getApplicationComponent(IdentityRegistry.class);
        if (IdentityConstants.SYSTEM.equalsIgnoreCase(userName)) {
            return true;
        }
        Identity identity = identityRegistry.getIdentity(userName);
        if (identity == null) {
            return false;
        }
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i].getString();
            if ("*".equalsIgnoreCase(role)) {
                return true;
            }
            MembershipEntry membershipEntry = MembershipEntry.parse((String)role);
            if (membershipEntry == null) {
                return false;
            }
            if (!identity.isMemberOf(membershipEntry)) continue;
            return true;
        }
        return false;
    }

    public List<Node> getCustomActions(Node node) throws Exception {
        if (node instanceof NodeLinkAware) {
            NodeLinkAware nodeLA = (NodeLinkAware)node;
            try {
                node = nodeLA.getTargetNode().getRealNode();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        ArrayList<Node> safeActions = new ArrayList<Node>();
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        String userName = context.getRemoteUser();
        ActionServiceContainer actionContainer = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        List unsafeActions = actionContainer.getCustomActionsNode(node, "read");
        if (unsafeActions == null) {
            return new ArrayList<Node>();
        }
        for (Node actionNode : unsafeActions) {
            Value[] roles = actionNode.getProperty("exo:roles").getValues();
            if (!this.hasPermission(userName, roles)) continue;
            safeActions.add(actionNode);
        }
        return safeActions;
    }

    public String getTitle(Node node) throws Exception {
        Node content;
        String title = null;
        if (node.hasProperty("exo:title")) {
            title = node.getProperty("exo:title").getValue().getString();
        } else if (node.hasNode("jcr:content") && (content = node.getNode("jcr:content")).hasProperty("dc:title")) {
            try {
                title = content.getProperty("dc:title").getValues()[0].getString();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (title == null || title != null && title.trim().length() == 0) {
            title = node.getName();
        }
        return Text.unescapeIllegalJcrChars((String)title);
    }
}

