/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.popup.admin;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentInfo;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionListContainer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionManager;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionViewContainer;
import org.exoplatform.ecm.webui.component.explorer.popup.admin.UIActionViewTemplate;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeExplorer;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/explorer/popup/admin/UIActionList.gtmpl", events={@EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIActionList.msg.confirm-delete-action"), @EventConfig(listeners={CloseActionListener.class}), @EventConfig(listeners={EditActionListener.class})})
public class UIActionList
extends UIContainer {
    public static final String[] ACTIONS = new String[]{"View", "Edit", "Delete"};

    public UIActionList() throws Exception {
        this.addChild(UIPageIterator.class, null, "ActionListIterator");
    }

    public void updateGrid(Node node, int currentPage) throws Exception {
        UIPageIterator uiIterator = (UIPageIterator)this.getChild(UIPageIterator.class);
        ListAccessImpl actionList = new ListAccessImpl(Object.class, NodeLocation.getLocationsByNodeList(this.getAllActions(node)));
        LazyPageList objPageList = new LazyPageList((ListAccess)actionList, 10);
        uiIterator.setPageList((PageList)objPageList);
        if (currentPage > uiIterator.getAvailablePage()) {
            uiIterator.setCurrentPage(uiIterator.getAvailablePage());
        } else {
            uiIterator.setCurrentPage(currentPage);
        }
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public boolean hasActions() throws Exception {
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class);
        ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        return actionService.hasActions(uiExplorer.getCurrentNode());
    }

    public List<Node> getAllActions(Node node) {
        ActionServiceContainer actionService = (ActionServiceContainer)this.getApplicationComponent(ActionServiceContainer.class);
        try {
            return actionService.getActions(node);
        }
        catch (Exception e) {
            return new ArrayList<Node>();
        }
    }

    public List getListActions() throws Exception {
        UIPageIterator uiIterator = (UIPageIterator)this.getChild(UIPageIterator.class);
        return NodeLocation.getNodeListByLocationList((List)uiIterator.getCurrentPageData());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIActionList> {
        public void execute(Event<UIActionList> event) throws Exception {
            UIActionList uiActionList = (UIActionList)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiActionList.getAncestorOfType(UIJCRExplorer.class);
            ActionServiceContainer actionService = (ActionServiceContainer)uiActionList.getApplicationComponent(ActionServiceContainer.class);
            String actionName = event.getRequestContext().getRequestParameter("objectId");
            UIActionListContainer uiActionListContainer = (UIActionListContainer)uiActionList.getParent();
            UIPopupWindow uiPopup = (UIPopupWindow)uiActionListContainer.getChildById("editActionPopup");
            UIApplication uiApp = (UIApplication)uiActionList.getAncestorOfType(UIApplication.class);
            if (uiPopup != null && uiPopup.isShow()) {
                uiApp.addMessage(new ApplicationMessage("UIActionList.msg.remove-popup-first", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (uiPopup != null && uiPopup.isRendered()) {
                uiActionListContainer.removeChildById("editActionPopup");
            }
            try {
                actionService.removeAction(uiExplorer.getCurrentNode(), actionName, uiExplorer.getRepositoryName());
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIActionList.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            UIActionManager uiActionManager = (UIActionManager)uiExplorer.findFirstComponentOfType(UIActionManager.class);
            uiActionManager.removeChild(UIActionViewContainer.class);
            uiActionList.updateGrid(uiExplorer.getCurrentNode(), ((UIPageIterator)uiActionList.getChild(UIPageIterator.class)).getCurrentPage());
            uiActionManager.setRenderedChild(UIActionListContainer.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIActionList> {
        public void execute(Event<UIActionList> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIActionList)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            uiExplorer.setIsHidePopup(false);
            uiExplorer.cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends EventListener<UIActionList> {
        public void execute(Event<UIActionList> event) throws Exception {
            UIActionList uiActionList = (UIActionList)((Object)event.getSource());
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiActionList.getAncestorOfType(UIJCRExplorer.class);
            UIActionListContainer uiActionListContainer = (UIActionListContainer)uiActionList.getParent();
            String actionName = event.getRequestContext().getRequestParameter("objectId");
            TemplateService templateService = (TemplateService)uiActionList.getApplicationComponent(TemplateService.class);
            String userName = event.getRequestContext().getRemoteUser();
            String repository = ((UIJCRExplorer)uiActionList.getAncestorOfType(UIJCRExplorer.class)).getRepositoryName();
            Node currentNode = uiExplorer.getCurrentNode();
            ActionServiceContainer actionService = (ActionServiceContainer)uiActionList.getApplicationComponent(ActionServiceContainer.class);
            Node selectedAction = null;
            try {
                selectedAction = actionService.getAction(currentNode, actionName);
            }
            catch (PathNotFoundException path) {
                currentNode.refresh(false);
                UIDocumentContainer uiDocumentContainer = (UIDocumentContainer)uiExplorer.findFirstComponentOfType(UIDocumentContainer.class);
                UIDocumentInfo uiDocumentInfo = (UIDocumentInfo)uiDocumentContainer.getChild(UIDocumentInfo.class);
                uiDocumentInfo.updatePageListData();
                if (uiExplorer.isShowViewFile()) {
                    uiDocumentInfo.setRendered(false);
                } else {
                    uiDocumentInfo.setRendered(true);
                }
                if (uiExplorer.getPreference().isShowSideBar()) {
                    UITreeExplorer treeExplorer = (UITreeExplorer)uiExplorer.findFirstComponentOfType(UITreeExplorer.class);
                    treeExplorer.buildTree();
                }
                selectedAction = actionService.getAction(currentNode, actionName);
            }
            String nodeTypeName = selectedAction.getPrimaryNodeType().getName();
            UIApplication uiApp = (UIApplication)uiActionList.getAncestorOfType(UIApplication.class);
            try {
                templateService.getTemplatePathByUser(true, nodeTypeName, userName);
            }
            catch (PathNotFoundException path) {
                Object[] args = new Object[]{actionName};
                uiApp.addMessage(new ApplicationMessage("UIActionList.msg.template-empty", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            uiActionListContainer.initEditPopup(selectedAction);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiActionListContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewActionListener
    extends EventListener<UIActionList> {
        public void execute(Event<UIActionList> event) throws Exception {
            UIActionList uiActionList = (UIActionList)((Object)event.getSource());
            String actionName = event.getRequestContext().getRequestParameter("objectId");
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((UIActionList)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            UIActionManager uiActionManager = (UIActionManager)uiExplorer.findFirstComponentOfType(UIActionManager.class);
            ActionServiceContainer actionService = (ActionServiceContainer)uiActionList.getApplicationComponent(ActionServiceContainer.class);
            Node node = actionService.getAction(uiExplorer.getCurrentNode(), actionName);
            String nodeTypeName = node.getPrimaryNodeType().getName();
            String userName = event.getRequestContext().getRemoteUser();
            TemplateService templateService = (TemplateService)uiActionList.getApplicationComponent(TemplateService.class);
            UIApplication uiApp = (UIApplication)uiActionList.getAncestorOfType(UIApplication.class);
            try {
                String path = templateService.getTemplatePathByUser(false, nodeTypeName, userName);
                if (path == null) {
                    Object[] args = new Object[]{actionName};
                    uiApp.addMessage(new ApplicationMessage("UIActionList.msg.template-null", args, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            }
            catch (PathNotFoundException path) {
                Object[] args = new Object[]{actionName};
                uiApp.addMessage(new ApplicationMessage("UIActionList.msg.template-empty", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (AccessDeniedException ace) {
                uiApp.addMessage(new ApplicationMessage("UIActionList.msg.access-denied", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (uiActionManager.getChild(UIActionViewContainer.class) != null) {
                uiActionManager.removeChild(UIActionViewContainer.class);
            }
            UIActionViewContainer uiActionViewContainer = (UIActionViewContainer)uiActionManager.createUIComponent(UIActionViewContainer.class, null, null);
            UIActionViewTemplate uiViewTemplate = (UIActionViewTemplate)uiActionViewContainer.createUIComponent(UIActionViewTemplate.class, null, null);
            uiViewTemplate.setTemplateNode(node);
            uiActionViewContainer.addChild((UIComponent)uiViewTemplate);
            uiActionManager.addChild((UIComponent)uiActionViewContainer);
            uiActionManager.setRenderedChild(UIActionViewContainer.class);
        }
    }
}

