/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl;

import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.sql.DataSource;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.dataflow.DataManager;
import org.exoplatform.services.jcr.ext.backup.BackupChainLog;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupChainLog;
import org.exoplatform.services.jcr.ext.backup.RepositoryRestoreExeption;
import org.exoplatform.services.jcr.ext.backup.impl.BackupManagerImpl;
import org.exoplatform.services.jcr.ext.backup.impl.JobRepositoryRestore;
import org.exoplatform.services.jcr.impl.backup.BackupException;
import org.exoplatform.services.jcr.impl.backup.Backupable;
import org.exoplatform.services.jcr.impl.backup.DataRestor;
import org.exoplatform.services.jcr.impl.backup.JCRRestor;
import org.exoplatform.services.jcr.impl.backup.JdbcBackupable;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.util.io.FileCleanerHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobExistingRepositorySameConfigRestore
extends JobRepositoryRestore {
    public JobExistingRepositorySameConfigRestore(RepositoryService repoService, BackupManagerImpl backupManagerImpl, RepositoryEntry repositoryEntry, Map<String, BackupChainLog> workspacesMapping, RepositoryBackupChainLog backupChainLog) {
        super(repoService, backupManagerImpl, repositoryEntry, workspacesMapping, backupChainLog);
    }

    @Override
    protected void restoreRepository() throws RepositoryRestoreExeption {
        ArrayList<DataRestor> dataRestorer = new ArrayList<DataRestor>();
        try {
            WorkspaceEntry wsEntry = (WorkspaceEntry)this.repositoryEntry.getWorkspaceEntries().get(0);
            Connection jdbcConn = null;
            if (!Boolean.parseBoolean(wsEntry.getContainer().getParameterValue("multi-db"))) {
                String dsName = wsEntry.getContainer().getParameterValue("source-name");
                final DataSource ds = (DataSource)new InitialContext().lookup(dsName);
                if (ds == null) {
                    throw new NameNotFoundException("Data source " + dsName + " not found");
                }
                jdbcConn = SecurityHelper.doPrivilegedSQLExceptionAction(new PrivilegedExceptionAction<Connection>(){

                    @Override
                    public Connection run() throws Exception {
                        return ds.getConnection();
                    }
                });
                jdbcConn.setAutoCommit(false);
            }
            this.repositoryService.getRepository(this.repositoryEntry.getName()).setState(3);
            for (WorkspaceEntry wEntry : this.repositoryEntry.getWorkspaceEntries()) {
                List backupable = this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponentInstancesOfType(Backupable.class);
                File fullBackupDir = JCRRestor.getFullBackupFile((File)((BackupChainLog)this.workspacesMapping.get(wEntry.getName())).getBackupConfig().getBackupDir());
                for (Backupable component : backupable) {
                    if (component instanceof JdbcBackupable && jdbcConn != null) {
                        dataRestorer.add(((JdbcBackupable)component).getDataRestorer(fullBackupDir, jdbcConn));
                        continue;
                    }
                    dataRestorer.add(component.getDataRestorer(fullBackupDir));
                }
            }
            for (DataRestor restorer : dataRestorer) {
                restorer.clean();
            }
            for (DataRestor restorer : dataRestorer) {
                restorer.restore();
            }
            for (DataRestor restorer : dataRestorer) {
                restorer.commit();
            }
            this.repositoryService.getRepository(this.repositoryEntry.getName()).setState(1);
            for (WorkspaceEntry wEntry : this.repositoryEntry.getWorkspaceEntries()) {
                this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponentInstancesOfType(Backupable.class);
                WorkspacePersistentDataManager dataManager = (WorkspacePersistentDataManager)this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponent(WorkspacePersistentDataManager.class);
                FileCleanerHolder fileCleanHolder = (FileCleanerHolder)this.repositoryService.getRepository(this.repositoryEntry.getName()).getWorkspaceContainer(wEntry.getName()).getComponent(FileCleanerHolder.class);
                File storageDir = JCRRestor.getFullBackupFile((File)((BackupChainLog)this.workspacesMapping.get(wEntry.getName())).getBackupConfig().getBackupDir());
                JCRRestor restorer = new JCRRestor((DataManager)dataManager, fileCleanHolder.getFileCleaner());
                for (File incrBackupFile : JCRRestor.getIncrementalFiles((File)storageDir)) {
                    restorer.incrementalRestore(incrBackupFile);
                }
            }
        }
        catch (Throwable t) {
            for (DataRestor restorer : dataRestorer) {
                try {
                    restorer.rollback();
                }
                catch (BackupException e) {
                    log.error("Can't rollback changes", e);
                }
            }
            throw new RepositoryRestoreExeption("Repository " + this.repositoryEntry.getName() + " was not restored", t);
        }
        finally {
            for (DataRestor restorer : dataRestorer) {
                try {
                    restorer.close();
                }
                catch (BackupException e) {
                    log.error("Can't close restorer", e);
                }
            }
            try {
                this.repositoryService.getRepository(this.repositoryEntry.getName()).setState(1);
            }
            catch (RepositoryException e) {
                log.error("Can't resume repository", e);
            }
            catch (RepositoryConfigurationException e) {
                log.error("Can't resume repository", e);
            }
        }
    }
}

