/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.lock.jbosscache;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.lock.LockException;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.jcr.config.MappedParametrizedObjectEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.core.lock.LockRemoverHolder;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.AbstractCacheableLockManager;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.CacheableSessionLockManager;
import org.exoplatform.services.jcr.impl.core.lock.cacheable.LockData;
import org.exoplatform.services.jcr.impl.core.lock.jbosscache.ControllerCacheLoader;
import org.exoplatform.services.jcr.impl.dataflow.persistent.WorkspacePersistentDataManager;
import org.exoplatform.services.jcr.impl.storage.jdbc.DBConstants;
import org.exoplatform.services.jcr.impl.storage.jdbc.DialectDetecter;
import org.exoplatform.services.jcr.jbosscache.ExoJBossCacheFactory;
import org.exoplatform.services.jcr.jbosscache.PrivilegedJBossCacheHelper;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.services.transaction.TransactionService;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.CacheStatus;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.loader.CacheLoader;
import org.jboss.cache.loader.CacheLoaderManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="lockmanager")})
public class CacheableLockManagerImpl
extends AbstractCacheableLockManager {
    public static final String JBOSSCACHE_JDBC_CL_DATASOURCE = "jbosscache-cl-cache.jdbc.datasource";
    public static final String JBOSSCACHE_JDBC_CL_NODE_COLUMN = "jbosscache-cl-cache.jdbc.node.type";
    public static final String JBOSSCACHE_JDBC_CL_FQN_COLUMN = "jbosscache-cl-cache.jdbc.fqn.type";
    public static final String JBOSSCACHE_JDBC_TABLE_NAME = "jbosscache-cl-cache.jdbc.table.name";
    public static final String JBOSSCACHE_SHAREABLE = "jbosscache-shareable";
    public static final Boolean JBOSSCACHE_SHAREABLE_DEFAULT = Boolean.FALSE;
    public static final String JBOSSCACHE_JDBC_CL_AUTO = "auto";
    public static final String LOCKS = "$LOCKS";
    public static final String LOCK_DATA = "$LOCK_DATA";
    private final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.CacheableLockManagerImpl");
    private Cache<Serializable, Object> cache;
    private final Fqn<String> lockRoot;
    private final boolean shareable;

    public CacheableLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, TransactionService transactionService, ConfigurationManager cfm, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException, RepositoryException {
        this(dataManager, config, context, transactionService.getTransactionManager(), cfm, lockRemoverHolder);
    }

    public CacheableLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, ConfigurationManager cfm, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException, RepositoryException {
        this(dataManager, config, context, (TransactionManager)null, cfm, lockRemoverHolder);
    }

    public CacheableLockManagerImpl(WorkspacePersistentDataManager dataManager, WorkspaceEntry config, InitialContextInitializer context, TransactionManager transactionManager, ConfigurationManager cfm, LockRemoverHolder lockRemoverHolder) throws RepositoryConfigurationException, RepositoryException {
        super(dataManager, config, transactionManager, lockRemoverHolder);
        if (config.getLockManager() != null) {
            ExoJBossCacheFactory factory = new ExoJBossCacheFactory(cfm, transactionManager);
            this.configureJDBCCacheLoader(config.getLockManager());
            this.cache = factory.createCache(config.getLockManager());
            Fqn rootFqn = Fqn.fromElements((Object[])new String[]{config.getUniqueName()});
            this.lockRoot = Fqn.fromRelativeElements((Fqn)rootFqn, (Object[])new String[]{LOCKS});
            this.shareable = config.getLockManager().getParameterBoolean(JBOSSCACHE_SHAREABLE, JBOSSCACHE_SHAREABLE_DEFAULT);
            this.cache = ExoJBossCacheFactory.getUniqueInstance(ExoJBossCacheFactory.CacheType.LOCK_CACHE, (Fqn<String>)rootFqn, this.cache, this.shareable);
            PrivilegedJBossCacheHelper.create(this.cache);
            if (this.cache.getCacheStatus().startAllowed()) {
                this.addCacheLoader();
                PrivilegedJBossCacheHelper.start(this.cache);
            }
        } else {
            throw new RepositoryConfigurationException("Cache configuration not found");
        }
        this.createStructuredNode(this.lockRoot);
        context.recall();
        this.getNumLocks = new AbstractCacheableLockManager.LockActionNonTxAware<Integer, Object>(){

            @Override
            public Integer execute(Object arg) {
                return ((CacheSPI)CacheableLockManagerImpl.this.cache).getNumberOfNodes() - 1;
            }
        };
        this.hasLocks = new AbstractCacheableLockManager.LockActionNonTxAware<Boolean, Object>(){

            @Override
            public Boolean execute(Object arg) {
                return ((CacheSPI)CacheableLockManagerImpl.this.cache).getNode(CacheableLockManagerImpl.this.lockRoot).hasChildrenDirect();
            }
        };
        this.isLockLive = new AbstractCacheableLockManager.LockActionNonTxAware<Boolean, String>(){

            @Override
            public Boolean execute(String nodeId) {
                if (CacheableLockManagerImpl.this.cache.get(CacheableLockManagerImpl.this.makeLockFqn(nodeId), (Object)CacheableLockManagerImpl.LOCK_DATA) != null) {
                    return true;
                }
                return false;
            }
        };
        this.refresh = new AbstractCacheableLockManager.LockActionNonTxAware<Object, LockData>(){

            @Override
            public Object execute(LockData newLockData) throws LockException {
                Fqn fqn = CacheableLockManagerImpl.this.makeLockFqn(newLockData.getNodeIdentifier());
                Object oldValue = PrivilegedJBossCacheHelper.put((Cache<Serializable, Object>)CacheableLockManagerImpl.this.cache, fqn, (Serializable)((Object)CacheableLockManagerImpl.LOCK_DATA), (Object)newLockData);
                if (oldValue == null) {
                    throw new LockException("Can't refresh lock for node " + newLockData.getNodeIdentifier() + " since lock is not exist");
                }
                return null;
            }
        };
        this.lockExist = new AbstractCacheableLockManager.LockActionNonTxAware<Boolean, String>(){

            @Override
            public Boolean execute(String nodeId) throws LockException {
                return CacheableLockManagerImpl.this.cache.get(CacheableLockManagerImpl.this.makeLockFqn(nodeId), (Object)CacheableLockManagerImpl.LOCK_DATA) != null;
            }
        };
        this.getLockDataById = new AbstractCacheableLockManager.LockActionNonTxAware<LockData, String>(){

            @Override
            public LockData execute(String nodeId) throws LockException {
                return (LockData)CacheableLockManagerImpl.this.cache.get(CacheableLockManagerImpl.this.makeLockFqn(nodeId), (Object)CacheableLockManagerImpl.LOCK_DATA);
            }
        };
        this.getLockList = new AbstractCacheableLockManager.LockActionNonTxAware<List<LockData>, Object>(){

            @Override
            public List<LockData> execute(Object arg) throws LockException {
                Set nodesId = CacheableLockManagerImpl.this.cache.getChildrenNames(CacheableLockManagerImpl.this.lockRoot);
                ArrayList<LockData> locksData = new ArrayList<LockData>();
                for (Object nodeId : nodesId) {
                    LockData lockData = (LockData)CacheableLockManagerImpl.this.cache.get(CacheableLockManagerImpl.this.makeLockFqn((String)nodeId), (Object)CacheableLockManagerImpl.LOCK_DATA);
                    if (lockData == null) continue;
                    locksData.add(lockData);
                }
                return locksData;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureJDBCCacheLoader(MappedParametrizedObjectEntry parameterEntry) throws RepositoryException {
        String dataSourceName = parameterEntry.getParameterValue(JBOSSCACHE_JDBC_CL_DATASOURCE, null);
        if (dataSourceName != null) {
            String dialect;
            block30: {
                try {
                    final DataSource dataSource = (DataSource)new InitialContext().lookup(dataSourceName);
                    if (dataSource == null) {
                        throw new RepositoryException("DataSource (" + dataSourceName + ") can't be null");
                    }
                    Connection jdbcConn = null;
                    try {
                        PrivilegedExceptionAction<Connection> action = new PrivilegedExceptionAction<Connection>(){

                            @Override
                            public Connection run() throws Exception {
                                return dataSource.getConnection();
                            }
                        };
                        try {
                            jdbcConn = AccessController.doPrivileged(action);
                        }
                        catch (PrivilegedActionException pae) {
                            Throwable cause = pae.getCause();
                            if (cause instanceof SQLException) {
                                throw (SQLException)cause;
                            }
                            if (cause instanceof RuntimeException) {
                                throw (RuntimeException)cause;
                            }
                            throw new RuntimeException(cause);
                        }
                        dialect = DialectDetecter.detect(jdbcConn.getMetaData());
                        Object var10_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_11 = null;
                        if (jdbcConn != null && !jdbcConn.isClosed()) {
                            try {
                                jdbcConn.close();
                            }
                            catch (SQLException e) {
                                throw new RepositoryException("Error of connection close", (Throwable)e);
                            }
                        }
                        throw throwable;
                    }
                    if (jdbcConn == null || jdbcConn.isClosed()) break block30;
                    try {
                        jdbcConn.close();
                    }
                    catch (SQLException e) {
                        throw new RepositoryException("Error of connection close", (Throwable)e);
                    }
                }
                catch (Exception e) {
                    throw new RepositoryException("Error configuring JDBC cache loader", (Throwable)e);
                }
            }
            String blobType = "BLOB";
            String charType = "VARCHAR(512)";
            if (dialect.equals(DBConstants.DB_DIALECT_HSQLDB)) {
                blobType = "VARBINARY(65535)";
            } else if (dialect.equals(DBConstants.DB_DIALECT_MYSQL) || dialect.equals(DBConstants.DB_DIALECT_MYSQL_UTF8)) {
                blobType = "LONGBLOB";
            } else if (dialect.equals(DBConstants.DB_DIALECT_ORACLE) || dialect.equals(DBConstants.DB_DIALECT_ORACLEOCI)) {
                charType = "VARCHAR2(512)";
            } else if (dialect.equals(DBConstants.DB_DIALECT_PGSQL)) {
                blobType = "bytea";
            } else if (dialect.equals(DBConstants.DB_DIALECT_MSSQL)) {
                blobType = "VARBINARY(MAX)";
            } else if (dialect.equals(DBConstants.DB_DIALECT_SYBASE)) {
                blobType = "IMAGE";
            } else if (dialect.equals(DBConstants.DB_DIALECT_INGRES)) {
                blobType = "long byte";
            }
            if (parameterEntry.getParameterValue(JBOSSCACHE_JDBC_CL_NODE_COLUMN, JBOSSCACHE_JDBC_CL_AUTO).equalsIgnoreCase(JBOSSCACHE_JDBC_CL_AUTO)) {
                parameterEntry.putParameterValue(JBOSSCACHE_JDBC_CL_NODE_COLUMN, blobType);
            }
            if (parameterEntry.getParameterValue(JBOSSCACHE_JDBC_CL_FQN_COLUMN, JBOSSCACHE_JDBC_CL_AUTO).equalsIgnoreCase(JBOSSCACHE_JDBC_CL_AUTO)) {
                parameterEntry.putParameterValue(JBOSSCACHE_JDBC_CL_FQN_COLUMN, charType);
            }
        } else {
            this.LOG.warn((Object)"CacheLoader DataSource jbosscache-cl-cache.jdbc.datasource is not configured.");
        }
    }

    private void addCacheLoader() {
        List oldConfigs;
        CacheLoaderConfig config = this.cache.getConfiguration().getCacheLoaderConfig();
        if (config == null || (oldConfigs = config.getIndividualCacheLoaderConfigs()) == null || oldConfigs.isEmpty()) {
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)"No cache loader has been defined, thus no need to encapsulate any cache loader.");
            }
            return;
        }
        CacheLoaderManager clm = (CacheLoaderManager)((CacheSPI)this.cache).getComponentRegistry().getComponent(CacheLoaderManager.class);
        if (clm == null) {
            this.LOG.error((Object)"The CacheLoaderManager cannot be found");
            return;
        }
        CacheLoader currentCL = clm.getCacheLoader();
        if (currentCL == null) {
            this.LOG.error((Object)"The CacheLoader cannot be found");
            return;
        }
        ControllerCacheLoader ccl = new ControllerCacheLoader(currentCL);
        ArrayList<CacheLoaderConfig.IndividualCacheLoaderConfig> newConfig = new ArrayList<CacheLoaderConfig.IndividualCacheLoaderConfig>(1);
        CacheLoaderConfig.IndividualCacheLoaderConfig cclConfig = new CacheLoaderConfig.IndividualCacheLoaderConfig();
        cclConfig.setCacheLoader((CacheLoader)ccl);
        cclConfig.setFetchPersistentState(clm.isFetchPersistentState());
        cclConfig.setAsync(false);
        cclConfig.setIgnoreModifications(false);
        CacheLoaderConfig.IndividualCacheLoaderConfig first = config.getFirstCacheLoaderConfig();
        cclConfig.setPurgeOnStartup(first != null && first.isPurgeOnStartup());
        newConfig.add(cclConfig);
        config.setIndividualCacheLoaderConfigs(newConfig);
        if (this.LOG.isInfoEnabled()) {
            this.LOG.info((Object)"The configured cache loader has been encapsulated successfully");
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.shareable) {
            this.cache.evict(this.lockRoot);
        } else {
            PrivilegedJBossCacheHelper.stop(this.cache);
        }
    }

    @Override
    protected synchronized void internalLock(String sessionId, String nodeIdentifier) throws LockException {
        CacheableSessionLockManager session = (CacheableSessionLockManager)this.sessionLockManagers.get(sessionId);
        if (session != null && session.containsPendingLock(nodeIdentifier)) {
            LockData lockData = session.getPendingLock(nodeIdentifier);
            Fqn<String> lockPath = this.makeLockFqn(lockData.getNodeIdentifier());
            Node node = this.cache.getRoot().addChild(lockPath);
            LockData oldLockData = (LockData)node.putIfAbsent((Object)LOCK_DATA, (Object)lockData);
            if (oldLockData != null) {
                throw new LockException("Unable to write LockData. Node [" + lockData.getNodeIdentifier() + "] already has LockData!");
            }
        } else {
            throw new LockException("No lock in pending locks");
        }
        session.notifyLockPersisted(nodeIdentifier);
    }

    @Override
    protected synchronized void internalUnLock(String sessionId, String nodeIdentifier) throws LockException {
        LockData lData = this.getLockDataById(nodeIdentifier);
        if (lData != null) {
            this.cache.removeNode(this.makeLockFqn(nodeIdentifier));
            CacheableSessionLockManager sessMgr = (CacheableSessionLockManager)this.sessionLockManagers.get(sessionId);
            if (sessMgr != null) {
                sessMgr.notifyLockRemoved(nodeIdentifier);
            }
        }
    }

    private Fqn<String> makeLockFqn(String nodeId) {
        return Fqn.fromRelativeElements(this.lockRoot, (Object[])new String[]{nodeId});
    }

    private void createStructuredNode(final Fqn<String> fqn) {
        Node<Serializable, Object> node = this.cache.getRoot().getChild(fqn);
        if (node == null) {
            PrivilegedAction<Node<Serializable, Object>> action = new PrivilegedAction<Node<Serializable, Object>>(){

                @Override
                public Node<Serializable, Object> run() {
                    CacheableLockManagerImpl.this.cache.getInvocationContext().getOptionOverrides().setCacheModeLocal(true);
                    return CacheableLockManagerImpl.this.cache.getRoot().addChild(fqn);
                }
            };
            node = AccessController.doPrivileged(action);
        }
        node.setResident(true);
    }

    @Override
    protected void putDirectly(LockData lockData) {
        Fqn<String> lockPath = this.makeLockFqn(lockData.getNodeIdentifier());
        Node node = this.cache.getRoot().addChild(lockPath);
        node.putIfAbsent((Object)LOCK_DATA, (Object)lockData);
    }

    @Override
    protected void cleanCacheDirectly() {
        if (this.cache.getCacheStatus() != CacheStatus.STARTED) {
            this.cache.removeNode(this.lockRoot);
            this.createStructuredNode(this.lockRoot);
        }
    }
}

