/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.storage.jdbc.db;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.PropertyData;
import org.exoplatform.services.jcr.impl.storage.jdbc.db.SingleDbJDBCConnection;
import org.exoplatform.services.jcr.impl.util.io.FileCleaner;
import org.exoplatform.services.jcr.storage.value.ValueStoragePluginProvider;

public class HSQLDBSingleDbJDBCConnection
extends SingleDbJDBCConnection {
    public HSQLDBSingleDbJDBCConnection(Connection dbConnection, boolean readOnly, String containerName, ValueStoragePluginProvider valueStorageProvider, int maxBufferSize, File swapDirectory, FileCleaner swapCleaner) throws SQLException {
        super(dbConnection, readOnly, containerName, valueStorageProvider, maxBufferSize, swapDirectory, swapCleaner);
    }

    protected final void prepareQueries() throws SQLException {
        super.prepareQueries();
        this.FIND_ITEM_BY_NAME = "select * from JCR_SITEM where PARENT_ID=? and CONTAINER_NAME=? and NAME=? and I_INDEX=? order by I_CLASS, VERSION DESC";
        this.FIND_PROPERTY_BY_NAME = "select V.DATA from JCR_SITEM I, JCR_SVALUE V where I.PARENT_ID=? and I.I_CLASS=2 and I.CONTAINER_NAME=? and I.NAME=? and I.ID=V.PROPERTY_ID order by V.ORDER_NUM";
        this.FIND_NODES_BY_PARENTID = "select * from JCR_SITEM where PARENT_ID=? and I_CLASS=1 and CONTAINER_NAME=? order by N_ORDER_NUM";
        this.FIND_LAST_ORDER_NUMBER_BY_PARENTID = "select count(*), max(N_ORDER_NUM) from JCR_SITEM where PARENT_ID=? and I_CLASS=1 and CONTAINER_NAME=?";
        this.FIND_NODES_COUNT_BY_PARENTID = "select count(ID) from JCR_SITEM where PARENT_ID=? and I_CLASS=1 and CONTAINER_NAME=?";
        this.FIND_PROPERTIES_BY_PARENTID = "select * from JCR_SITEM where PARENT_ID=? and I_CLASS=2 and CONTAINER_NAME=? order by ID";
    }

    protected ResultSet findItemByName(String parentId, String name, int index) throws SQLException {
        if (this.findItemByName == null) {
            this.findItemByName = this.dbConnection.prepareStatement(this.FIND_ITEM_BY_NAME);
        } else {
            this.findItemByName.clearParameters();
        }
        this.findItemByName.setString(1, parentId);
        this.findItemByName.setString(2, this.containerName);
        this.findItemByName.setString(3, name);
        this.findItemByName.setInt(4, index);
        PrivilegedExceptionAction<ResultSet> action = new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.this.findItemByName.executeQuery();
            }
        };
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected ResultSet findPropertyByName(String parentCid, String name) throws SQLException {
        if (this.findPropertyByName == null) {
            this.findPropertyByName = this.dbConnection.prepareStatement(this.FIND_PROPERTY_BY_NAME);
        } else {
            this.findPropertyByName.clearParameters();
        }
        this.findPropertyByName.setString(1, parentCid);
        this.findPropertyByName.setString(2, this.containerName);
        this.findPropertyByName.setString(3, name);
        PrivilegedExceptionAction<ResultSet> action = new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.this.findPropertyByName.executeQuery();
            }
        };
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected ResultSet findChildNodesByParentIdentifier(String parentCid) throws SQLException {
        if (this.findNodesByParentId == null) {
            this.findNodesByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_BY_PARENTID);
        } else {
            this.findNodesByParentId.clearParameters();
        }
        this.findNodesByParentId.setString(1, parentCid);
        this.findNodesByParentId.setString(2, this.containerName);
        PrivilegedExceptionAction<ResultSet> action = new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.this.findNodesByParentId.executeQuery();
            }
        };
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected ResultSet findLastOrderNumberByParentIdentifier(String parentIdentifier) throws SQLException {
        if (this.findLastOrderNumberByParentId == null) {
            this.findLastOrderNumberByParentId = this.dbConnection.prepareStatement(this.FIND_LAST_ORDER_NUMBER_BY_PARENTID);
        } else {
            this.findLastOrderNumberByParentId.clearParameters();
        }
        this.findLastOrderNumberByParentId.setString(1, parentIdentifier);
        this.findLastOrderNumberByParentId.setString(2, this.containerName);
        PrivilegedExceptionAction<ResultSet> action = new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.this.findLastOrderNumberByParentId.executeQuery();
            }
        };
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected ResultSet findChildNodesCountByParentIdentifier(String parentCid) throws SQLException {
        if (this.findNodesCountByParentId == null) {
            this.findNodesCountByParentId = this.dbConnection.prepareStatement(this.FIND_NODES_COUNT_BY_PARENTID);
        } else {
            this.findNodesCountByParentId.clearParameters();
        }
        this.findNodesCountByParentId.setString(1, parentCid);
        this.findNodesCountByParentId.setString(2, this.containerName);
        PrivilegedExceptionAction<ResultSet> action = new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.this.findNodesCountByParentId.executeQuery();
            }
        };
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected ResultSet findChildPropertiesByParentIdentifier(String parentCid) throws SQLException {
        if (this.findPropertiesByParentId == null) {
            this.findPropertiesByParentId = this.dbConnection.prepareStatement(this.FIND_PROPERTIES_BY_PARENTID);
        } else {
            this.findPropertiesByParentId.clearParameters();
        }
        this.findPropertiesByParentId.setString(1, parentCid);
        this.findPropertiesByParentId.setString(2, this.containerName);
        PrivilegedExceptionAction<ResultSet> action = new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.this.findPropertiesByParentId.executeQuery();
            }
        };
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected int addNodeRecord(final NodeData data) throws SQLException {
        PrivilegedExceptionAction<Integer> action = new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.addNodeRecord(data);
            }
        };
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected int addPropertyRecord(final PropertyData prop) throws SQLException {
        PrivilegedExceptionAction<Integer> action = new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.addPropertyRecord(prop);
            }
        };
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected ResultSet findItemByIdentifier(final String identifier) throws SQLException {
        PrivilegedExceptionAction<ResultSet> action = new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.findItemByIdentifier(identifier);
            }
        };
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected int addReference(final PropertyData data) throws SQLException, IOException {
        PrivilegedExceptionAction<Integer> action = new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.addReference(data);
            }
        };
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected int renameNode(final NodeData data) throws SQLException {
        PrivilegedExceptionAction<Integer> action = new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.renameNode(data);
            }
        };
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected int deleteReference(final String propertyIdentifier) throws SQLException {
        PrivilegedExceptionAction<Integer> action = new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.deleteReference(propertyIdentifier);
            }
        };
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected ResultSet findReferences(final String nodeIdentifier) throws SQLException {
        PrivilegedExceptionAction<ResultSet> action = new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.findReferences(nodeIdentifier);
            }
        };
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected int deleteItemByIdentifier(final String identifier) throws SQLException {
        PrivilegedExceptionAction<Integer> action = new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.deleteItemByIdentifier(identifier);
            }
        };
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected int updateNodeByIdentifier(final int version, final int index, final int orderNumb, final String identifier) throws SQLException {
        PrivilegedExceptionAction<Integer> action = new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.updateNodeByIdentifier(version, index, orderNumb, identifier);
            }
        };
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected int updatePropertyByIdentifier(final int version, final int type, final String identifier) throws SQLException {
        PrivilegedExceptionAction<Integer> action = new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.updatePropertyByIdentifier(version, type, identifier);
            }
        };
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected int addValueData(final String cid, final int orderNumber, final InputStream stream, final int streamLength, final String storageId) throws SQLException {
        PrivilegedExceptionAction<Integer> action = new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.addValueData(cid, orderNumber, stream, streamLength, storageId);
            }
        };
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected int deleteValueData(final String cid) throws SQLException {
        PrivilegedExceptionAction<Integer> action = new PrivilegedExceptionAction<Integer>(){

            @Override
            public Integer run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.deleteValueData(cid);
            }
        };
        return (Integer)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected ResultSet findValuesByPropertyId(final String cid) throws SQLException {
        PrivilegedExceptionAction<ResultSet> action = new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.findValuesByPropertyId(cid);
            }
        };
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected ResultSet findValuesStorageDescriptorsByPropertyId(final String cid) throws SQLException {
        PrivilegedExceptionAction<ResultSet> action = new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.findValuesStorageDescriptorsByPropertyId(cid);
            }
        };
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }

    protected ResultSet findValueByPropertyIdOrderNumber(final String cid, final int orderNumb) throws SQLException {
        PrivilegedExceptionAction<ResultSet> action = new PrivilegedExceptionAction<ResultSet>(){

            @Override
            public ResultSet run() throws Exception {
                return HSQLDBSingleDbJDBCConnection.super.findValueByPropertyIdOrderNumber(cid, orderNumb);
            }
        };
        return (ResultSet)SecurityHelper.doPrivilegedSQLExceptionAction((PrivilegedExceptionAction)action);
    }
}

