/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.tree.selectone;

import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.UITreeTaxonomyBuilder;
import org.exoplatform.ecm.webui.tree.selectone.UIOneTaxonomySelector;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormSelectBox;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/ecm/webui/form/UIFormWithoutAction.gtmpl", events={@EventConfig(listeners={ChangeTaxonomyTreeActionListener.class}), @EventConfig(listeners={AddRootNodeActionListener.class})})
public class UITreeTaxonomyList
extends UIForm {
    private static String ROOT_NODE_INFO = "rootNodeInfo";
    private static String ROOT_NODE_PATH = "rootNodePath";
    public static String TAXONOMY_TREE = "taxonomyTree";
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UITreeTaxonomyList");
    private boolean isShowSystem_ = true;

    public UITreeTaxonomyList() throws Exception {
        ArrayList taxonomyTreeList = new ArrayList();
        UIFormSelectBox uiTaxonomyTreeList = new UIFormSelectBox(TAXONOMY_TREE, TAXONOMY_TREE, taxonomyTreeList);
        uiTaxonomyTreeList.setOnChange("ChangeTaxonomyTree");
        this.addUIFormInput((UIFormInput)uiTaxonomyTreeList);
        UIFormInputSetWithAction rootNodeInfo = new UIFormInputSetWithAction(ROOT_NODE_INFO);
        rootNodeInfo.addUIFormInput((UIFormInput)new UIFormInputInfo(ROOT_NODE_PATH, ROOT_NODE_PATH, null));
        String[] actionInfor = new String[]{"AddRootNode"};
        rootNodeInfo.setActionInfo(ROOT_NODE_PATH, actionInfor);
        rootNodeInfo.showActionInfo(true);
        rootNodeInfo.setRendered(true);
        this.addUIComponentInput((UIComponent)rootNodeInfo);
    }

    public void setIsShowSystem(boolean isShowSystem) {
        this.isShowSystem_ = isShowSystem;
    }

    public boolean isShowSystemWorkspace() {
        return this.isShowSystem_;
    }

    public void setShowRootPathSelect(boolean isRender) {
        UIFormInputSetWithAction uiInputAction = (UIFormInputSetWithAction)this.getChildById(ROOT_NODE_INFO);
        uiInputAction.setRendered(isRender);
    }

    private String getTaxonomyLabel(String taxonomyTree) {
        String display = taxonomyTree;
        PortalRequestContext context = Util.getPortalRequestContext();
        ResourceBundle res = context.getApplicationResourceBundle();
        try {
            return res.getString("eXoTaxonomies.".concat(taxonomyTree).concat(".label"));
        }
        catch (MissingResourceException me) {
            return display;
        }
    }

    @Deprecated
    public void setTaxonomyTreeList(String repository) throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        List listNode = taxonomyService.getAllTaxonomyTrees();
        ArrayList<SelectItemOption> taxonomyTree = new ArrayList<SelectItemOption>();
        for (Node itemNode : listNode) {
            taxonomyTree.add(new SelectItemOption(this.getTaxonomyLabel(itemNode.getName()), (Object)itemNode.getName()));
        }
        UIFormSelectBox uiTreeTaxonomyList = this.getUIFormSelectBox(TAXONOMY_TREE);
        uiTreeTaxonomyList.setOptions(taxonomyTree);
    }

    public void setTaxonomyTreeList() throws Exception {
        TaxonomyService taxonomyService = (TaxonomyService)this.getApplicationComponent(TaxonomyService.class);
        List listNode = taxonomyService.getAllTaxonomyTrees();
        ArrayList<SelectItemOption> taxonomyTree = new ArrayList<SelectItemOption>();
        for (Node itemNode : listNode) {
            taxonomyTree.add(new SelectItemOption(this.getTaxonomyLabel(itemNode.getName()), (Object)itemNode.getName()));
        }
        UIFormSelectBox uiTreeTaxonomyList = this.getUIFormSelectBox(TAXONOMY_TREE);
        uiTreeTaxonomyList.setOptions(taxonomyTree);
    }

    private Node getRootNode(String workspaceName, String pathNode) throws RepositoryException, RepositoryConfigurationException {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getCurrentRepository();
        SessionProvider sessionProvider = SessionProviderFactory.createSessionProvider();
        return (Node)sessionProvider.getSession(workspaceName, manageableRepository).getItem(pathNode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddRootNodeActionListener
    extends EventListener<UITreeTaxonomyList> {
        public void execute(Event<UITreeTaxonomyList> event) throws Exception {
            UITreeTaxonomyList uiTreeTaxonomyList = (UITreeTaxonomyList)((Object)event.getSource());
            String taxoTreeName = (String)uiTreeTaxonomyList.getUIFormSelectBox(TAXONOMY_TREE).getValue();
            UIOneTaxonomySelector uiTaxonomySelector = (UIOneTaxonomySelector)uiTreeTaxonomyList.getParent();
            String returnField = uiTaxonomySelector.getReturnFieldName();
            ((UISelectable)uiTaxonomySelector.getSourceComponent()).doSelect(returnField, taxoTreeName);
            if (uiTaxonomySelector instanceof UIOneTaxonomySelector) {
                UIComponent component;
                UIComponent uiComponent = uiTaxonomySelector.getParent();
                if (uiComponent instanceof UIPopupWindow) {
                    ((UIPopupWindow)uiComponent).setShow(false);
                    ((UIPopupWindow)uiComponent).setRendered(false);
                    event.getRequestContext().addUIComponentToUpdateByAjax(uiComponent);
                }
                if ((component = uiTaxonomySelector.getSourceComponent().getParent()) != null) {
                    event.getRequestContext().addUIComponentToUpdateByAjax(component);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeTaxonomyTreeActionListener
    extends EventListener<UITreeTaxonomyList> {
        public void execute(Event<UITreeTaxonomyList> event) throws Exception {
            UITreeTaxonomyList uiTreeTaxonomyList = (UITreeTaxonomyList)((Object)event.getSource());
            UIOneTaxonomySelector uiOneTaxonomySelector = (UIOneTaxonomySelector)uiTreeTaxonomyList.getParent();
            String taxoTreeName = (String)uiTreeTaxonomyList.getUIFormSelectBox(TAXONOMY_TREE).getValue();
            Node taxoTreeNode = uiOneTaxonomySelector.getTaxoTreeNode(taxoTreeName);
            String workspaceName = taxoTreeNode.getSession().getWorkspace().getName();
            String pathTaxonomy = taxoTreeNode.getPath();
            UIApplication uiApp = (UIApplication)uiTreeTaxonomyList.getAncestorOfType(UIApplication.class);
            if (taxoTreeNode.hasNodes()) {
                uiOneTaxonomySelector.setWorkspaceName(workspaceName);
                uiOneTaxonomySelector.setRootTaxonomyName(taxoTreeNode.getName());
                uiOneTaxonomySelector.setRootTreePath(taxoTreeNode.getPath());
                UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)uiOneTaxonomySelector.getChildById("BreadcumbOneTaxonomy");
                uiBreadcumbs.getPath().clear();
                UITreeTaxonomyBuilder uiTreeJCRExplorer = (UITreeTaxonomyBuilder)uiOneTaxonomySelector.getChild(UITreeTaxonomyBuilder.class);
                try {
                    uiTreeJCRExplorer.setRootTreeNode(uiTreeTaxonomyList.getRootNode(workspaceName, pathTaxonomy));
                    uiTreeJCRExplorer.buildTree();
                }
                catch (AccessDeniedException ade) {
                    UIFormSelectBox uiTaxonomyTree = uiTreeTaxonomyList.getUIFormSelectBox(TAXONOMY_TREE);
                    List taxonomyTree = uiTaxonomyTree.getOptions();
                    if (taxonomyTree != null && taxonomyTree.size() > 0) {
                        uiTaxonomyTree.setValue((String)((SelectItemOption)taxonomyTree.get(0)).getValue());
                    }
                    uiApp.addMessage(new ApplicationMessage("UIWorkspaceList.msg.AccessDeniedException", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    event.getRequestContext().addUIComponentToUpdateByAjax(uiTaxonomyTree.getParent());
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)"Unexpected error", (Throwable)e);
                    return;
                }
            } else {
                UIFormSelectBox uiTaxonomyTree = uiTreeTaxonomyList.getUIFormSelectBox(TAXONOMY_TREE);
                List taxonomyTree = uiTaxonomyTree.getOptions();
                if (taxonomyTree != null && taxonomyTree.size() > 0) {
                    uiTaxonomyTree.setValue((String)((SelectItemOption)taxonomyTree.get(0)).getValue());
                }
                uiApp.addMessage(new ApplicationMessage("UITreeTaxonomyList.msg.NoChild", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiOneTaxonomySelector);
        }
    }
}

