/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.ReferentialIntegrityException;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.jcr.model.ClipboardCommand;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyManager;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionInfo;
import org.exoplatform.ecm.webui.component.admin.taxonomy.info.UIPermissionManager;
import org.exoplatform.services.cms.categories.CategoriesService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/taxonomy/UITaxonomyWorkingArea.gtmpl", events={@EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}, confirm="UITaxonomyManager.msg.confirm-delete"), @EventConfig(listeners={CopyActionListener.class}), @EventConfig(listeners={PasteActionListener.class}), @EventConfig(listeners={CutActionListener.class}), @EventConfig(listeners={ViewPermissionActionListener.class})})
public class UITaxonomyWorkingArea
extends UIContainer {
    private UIPageIterator uiPageIterator_;
    private List taxonomyNodes_;
    private ClipboardCommand clipboard_ = new ClipboardCommand();
    private String selectedPath_;
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UITaxonomyWorkingArea");

    public UITaxonomyWorkingArea() throws Exception {
        this.uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UICategoriesSelect");
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public void updateGrid() throws Exception {
        ListAccessImpl nodeList = new ListAccessImpl(Object.class, this.getNodeList());
        LazyPageList dataPageList = new LazyPageList((ListAccess)nodeList, 10);
        this.uiPageIterator_.setPageList((PageList)dataPageList);
    }

    public List getListNodes() throws Exception {
        return NodeLocation.getNodeListByLocationList((List)this.uiPageIterator_.getCurrentPageData());
    }

    public void setNodeList(List<Node> nodes) {
        this.taxonomyNodes_ = NodeLocation.getLocationsByNodeList(nodes);
    }

    public List getNodeList() {
        return this.taxonomyNodes_;
    }

    private String getRepository() throws Exception {
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getParent();
        return uiManager.getRepository().getConfiguration().getName();
    }

    public boolean isRootNode() throws Exception {
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getParent();
        String selectedPath = uiManager.getSelectedPath();
        if (selectedPath == null) {
            selectedPath = uiManager.getRootNode().getPath();
        }
        return selectedPath.equals(uiManager.getRootNode().getPath());
    }

    public void setSelectedPath(String selectedPath) {
        this.selectedPath_ = selectedPath;
    }

    public void update() throws Exception {
        UITaxonomyManager uiManager = (UITaxonomyManager)this.getParent();
        if (this.selectedPath_ != null) {
            Node selectedTaxonomy = uiManager.getNodeByPath(this.selectedPath_);
            NodeIterator nodeIter = selectedTaxonomy.getNodes();
            ArrayList<Node> listNodes = new ArrayList<Node>();
            while (nodeIter.hasNext()) {
                Node node = nodeIter.nextNode();
                listNodes.add(node);
            }
            this.setNodeList(listNodes);
        }
        this.updateGrid();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewPermissionActionListener
    extends EventListener<UITaxonomyWorkingArea> {
        public void execute(Event<UITaxonomyWorkingArea> event) throws Exception {
            UITaxonomyWorkingArea uiManager = (UITaxonomyWorkingArea)((Object)event.getSource());
            UITaxonomyManager uiTaxoManager = (UITaxonomyManager)uiManager.getParent();
            String path = event.getRequestContext().getRequestParameter("objectId");
            UIPopupContainer uiPopupContainer = uiTaxoManager.initPopupPermission("TaxonomyViewPermissionPopup");
            UIPermissionManager uiPerMan = (UIPermissionManager)uiPopupContainer.createUIComponent(UIPermissionManager.class, null, null);
            ((UIPermissionInfo)uiPerMan.getChild(UIPermissionInfo.class)).setCurrentNode(uiTaxoManager.getNodeByPath(path));
            ((UIPermissionForm)uiPerMan.getChild(UIPermissionForm.class)).setCurrentNode(uiTaxoManager.getNodeByPath(path));
            uiPopupContainer.activate((UIComponent)uiPerMan, 650, 550);
            uiPopupContainer.setRendered(true);
            uiPerMan.checkPermissonInfo(uiTaxoManager.getNodeByPath(path));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CutActionListener
    extends EventListener<UITaxonomyWorkingArea> {
        public void execute(Event<UITaxonomyWorkingArea> event) throws Exception {
            UITaxonomyWorkingArea uiManager = (UITaxonomyWorkingArea)((Object)event.getSource());
            String realPath = event.getRequestContext().getRequestParameter("objectId");
            uiManager.clipboard_.setType("cut");
            uiManager.clipboard_.setSrcPath(realPath);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PasteActionListener
    extends EventListener<UITaxonomyWorkingArea> {
        public void execute(Event<UITaxonomyWorkingArea> event) throws Exception {
            UITaxonomyWorkingArea uiWorkingArea = (UITaxonomyWorkingArea)((Object)event.getSource());
            UITaxonomyManager uiManager = (UITaxonomyManager)uiWorkingArea.getParent();
            String realPath = event.getRequestContext().getRequestParameter("objectId");
            UIApplication uiApp = (UIApplication)uiWorkingArea.getAncestorOfType(UIApplication.class);
            String type = uiWorkingArea.clipboard_.getType();
            String srcPath = uiWorkingArea.clipboard_.getSrcPath();
            if (type == null || srcPath == null) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyWorkingArea.msg.can-not-paste", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (type.equals("cut") && realPath.equals(srcPath)) {
                Object[] arg = new Object[]{realPath};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyWorkingArea.msg.node-is-cutting", arg, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (srcPath == null) {
                Object[] arg = new Object[]{realPath};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyWorkingArea.msg.no-taxonomy-selected", arg, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            String destPath = realPath + srcPath.substring(srcPath.lastIndexOf("/"));
            Node realNode = uiManager.getNodeByPath(realPath);
            if (realNode.hasNode(srcPath.substring(srcPath.lastIndexOf("/") + 1))) {
                Object[] args = new Object[]{srcPath.substring(srcPath.lastIndexOf("/") + 1)};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyForm.msg.exist", args, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            CategoriesService categoriesService = (CategoriesService)uiWorkingArea.getApplicationComponent(CategoriesService.class);
            try {
                categoriesService.moveTaxonomyNode(srcPath, destPath, type, uiWorkingArea.getRepository());
                uiManager.update(realPath);
            }
            catch (Exception e) {
                uiApp.addMessage(new ApplicationMessage("UITaxonomyWorkingArea.msg.referential-integrity", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CopyActionListener
    extends EventListener<UITaxonomyWorkingArea> {
        public void execute(Event<UITaxonomyWorkingArea> event) throws Exception {
            UITaxonomyWorkingArea uiManager = (UITaxonomyWorkingArea)((Object)event.getSource());
            String realPath = event.getRequestContext().getRequestParameter("objectId");
            uiManager.clipboard_ = new ClipboardCommand();
            uiManager.clipboard_.setType("copy");
            uiManager.clipboard_.setSrcPath(realPath);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UITaxonomyWorkingArea> {
        public void execute(Event<UITaxonomyWorkingArea> event) throws Exception {
            UITaxonomyWorkingArea uiWorkingArea = (UITaxonomyWorkingArea)((Object)event.getSource());
            UITaxonomyManager uiManager = (UITaxonomyManager)uiWorkingArea.getParent();
            UIApplication uiApp = (UIApplication)uiWorkingArea.getAncestorOfType(UIApplication.class);
            String path = event.getRequestContext().getRequestParameter("objectId");
            Node selectedNode = uiManager.getNodeByPath(path);
            try {
                uiWorkingArea.setSelectedPath(selectedNode.getParent().getPath());
                ((CategoriesService)uiWorkingArea.getApplicationComponent(CategoriesService.class)).removeTaxonomyNode(path, uiWorkingArea.getRepository());
            }
            catch (ReferentialIntegrityException ref) {
                Object[] arg = new Object[]{path};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyWorkingArea.msg.reference-exception", arg, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                Object[] arg = new Object[]{path};
                uiApp.addMessage(new ApplicationMessage("UITaxonomyWorkingArea.msg.path-error", arg, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (uiManager.getChildById("TaxonomyPopup") != null) {
                uiManager.removeChildById("TaxonomyPopup");
            }
            uiWorkingArea.update();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UITaxonomyWorkingArea> {
        public void execute(Event<UITaxonomyWorkingArea> event) throws Exception {
            UITaxonomyWorkingArea uiWorkingArea = (UITaxonomyWorkingArea)((Object)event.getSource());
            String path = event.getRequestContext().getRequestParameter("objectId");
            UITaxonomyManager uiManager = (UITaxonomyManager)uiWorkingArea.getParent();
            uiManager.initPopup(path);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }
}

