/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.documents.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.documents.TrashService;
import org.exoplatform.services.cms.folksonomy.NewFolksonomyService;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.seo.SEOService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.PreferencesInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrashServiceImpl
implements TrashService {
    private static final String FILE_EXPLORER_PORTLET = "FileExplorerPortlet";
    public static final String EXO_TOTAL = "exo:total".intern();
    public static final String MIX_REFERENCEABLE = "mix:referenceable";
    public static final String TAXONOMY_LINK = "exo:taxonomyLink";
    public static final String UUID = "exo:uuid";
    public static final String SYMLINK = "exo:symlink";
    public static final String EXO_WORKSPACE = "exo:workspace";
    public static final String EXO_TARGETWS = "exo:targetWorkspace";
    public static final String EXO_TARGETPATH = "exo:targetPath";
    private RepositoryService repositoryService;
    private LinkManager linkManager;
    private TaxonomyService taxonomyService_;
    private String trashWorkspace_;
    private String trashHome_;
    private ExoCache<String, Object> cache;

    public TrashServiceImpl(RepositoryService repositoryService, LinkManager linkManager, TaxonomyService taxonomyService, InitParams initParams) throws Exception {
        this.repositoryService = repositoryService;
        this.linkManager = linkManager;
        this.taxonomyService_ = taxonomyService;
        this.trashWorkspace_ = initParams.getValueParam("trashWorkspace").getValue();
        this.trashHome_ = initParams.getValueParam("trashHomeNodePath").getValue();
        this.cache = WCMCoreUtils.getService(CacheService.class).getCacheInstance("wcm.seo");
        ExoContainer manager = ExoContainerContext.getCurrentContainer();
        PortletInvoker portletInvoker = (PortletInvoker)manager.getComponentInstance(PortletInvoker.class);
        if (portletInvoker != null) {
            Set portlets = portletInvoker.getPortlets();
            for (Portlet portlet : portlets) {
                PortletInfo info = portlet.getInfo();
                String portletName = info.getName();
                if (!FILE_EXPLORER_PORTLET.equalsIgnoreCase(portletName)) continue;
                PreferencesInfo prefs = info.getPreferences();
                String trashWorkspace = (String)prefs.getPreference("trashWorkspace").getDefaultValue().get(0);
                String trashHome = (String)prefs.getPreference("trashHomeNodePath").getDefaultValue().get(0);
                if (trashWorkspace != null && !trashWorkspace.equals(this.trashWorkspace_)) {
                    this.trashWorkspace_ = trashWorkspace;
                }
                if (trashHome == null || trashHome.equals(this.trashHome_)) break;
                this.trashHome_ = trashHome;
                break;
            }
        }
    }

    @Override
    @Deprecated
    public void moveToTrash(Node node, String trashPath, String trashWorkspace, String repository, SessionProvider sessionProvider) throws Exception {
        this.moveToTrash(node, trashPath, trashWorkspace, repository, sessionProvider, 0);
    }

    @Override
    @Deprecated
    public void moveToTrash(Node node, String trashPath, String trashWorkspace, SessionProvider sessionProvider) throws Exception {
        this.moveToTrash(node, sessionProvider, 0);
    }

    @Override
    public void moveToTrash(Node node, SessionProvider sessionProvider) throws Exception {
        this.moveToTrash(node, sessionProvider, 0);
    }

    @Deprecated
    public void moveToTrash(Node node, String trashPath, String trashWorkspace, String repository, SessionProvider sessionProvider, int deep) throws Exception {
        this.moveToTrash(node, trashPath, trashWorkspace, sessionProvider, deep);
    }

    @Deprecated
    public void moveToTrash(Node node, String trashPath, String trashWorkspace, SessionProvider sessionProvider, int deep) throws Exception {
        this.moveToTrash(node, sessionProvider, deep);
    }

    public void moveToTrash(Node node, SessionProvider sessionProvider, int deep) throws Exception {
        String taxonomyLinkWS;
        String nodeUUID;
        String nodeName = node.getName();
        Session nodeSession = node.getSession();
        String nodeWorkspaceName = nodeSession.getWorkspace().getName();
        ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
        List<Node> categories = this.taxonomyService_.getAllCategories(node, true);
        String string = nodeUUID = node.isNodeType(MIX_REFERENCEABLE) ? node.getUUID() : null;
        if (node.isNodeType(SYMLINK)) {
            nodeUUID = null;
        }
        String taxonomyLinkUUID = node.isNodeType(TAXONOMY_LINK) ? node.getProperty(UUID).getString() : null;
        String string2 = taxonomyLinkWS = node.isNodeType(TAXONOMY_LINK) ? node.getProperty(EXO_WORKSPACE).getString() : null;
        if (nodeUUID != null) {
            SEOService seoService = (SEOService)myContainer.getComponentInstanceOfType(SEOService.class);
            this.cache.remove((Serializable)((Object)seoService.getHash(nodeUUID)));
        }
        if (!node.isNodeType("exo:restoreLocation")) {
            node.addMixin("exo:restoreLocation");
            node.setProperty("exo:restorePath", this.fixRestorePath(node.getPath()));
            node.setProperty("exo:restoreWorkspace", nodeWorkspaceName);
            nodeSession.save();
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session trashSession = sessionProvider.getSession(this.trashWorkspace_, manageableRepository);
            String actualTrashPath = this.trashHome_ + (this.trashHome_.endsWith("/") ? "" : "/") + this.fixRestorePath(nodeName);
            if (trashSession.getWorkspace().getName().equals(nodeSession.getWorkspace().getName())) {
                trashSession.getWorkspace().move(node.getPath(), actualTrashPath);
            } else {
                trashSession.getWorkspace().clone(nodeWorkspaceName, node.getPath(), actualTrashPath, true);
                if (node.isNodeType(MIX_REFERENCEABLE)) {
                    Node clonedNode = trashSession.getNodeByUUID(node.getUUID());
                    NewFolksonomyService newFolksonomyService = (NewFolksonomyService)myContainer.getComponentInstanceOfType(NewFolksonomyService.class);
                    String tagWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
                    List<Node> tags = newFolksonomyService.getLinkedTagsOfDocument(node, tagWorkspace);
                    for (Node tag : tags) {
                        newFolksonomyService.removeTagOfDocument(tag.getPath(), node, tagWorkspace);
                        this.linkManager.createLink(tag, clonedNode);
                        long total = tag.hasProperty(EXO_TOTAL) ? tag.getProperty(EXO_TOTAL).getLong() : 0L;
                        tag.setProperty(EXO_TOTAL, total + 1L);
                        tag.getSession().save();
                    }
                }
                node.remove();
            }
            nodeSession.save();
            trashSession.save();
            if (deep == 0 && nodeUUID != null) {
                for (Node category : categories) {
                    NodeIterator iter = category.getNodes();
                    while (iter.hasNext()) {
                        Node categoryChild = iter.nextNode();
                        if (!categoryChild.isNodeType(TAXONOMY_LINK) || !categoryChild.hasProperty(UUID) || !categoryChild.hasProperty(EXO_WORKSPACE) || !nodeUUID.equals(categoryChild.getProperty(UUID).getString()) || !nodeWorkspaceName.equals(categoryChild.getProperty(EXO_WORKSPACE).getString())) continue;
                        try {
                            this.moveToTrash(categoryChild, sessionProvider, deep + 1);
                        }
                        catch (Exception e) {}
                    }
                }
            }
            trashSession.save();
            if (deep == 0 && taxonomyLinkUUID != null && taxonomyLinkWS != null) {
                Session targetNodeSession = sessionProvider.getSession(taxonomyLinkWS, manageableRepository);
                Node targetNode = null;
                try {
                    targetNode = targetNodeSession.getNodeByUUID(taxonomyLinkUUID);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (targetNode != null && this.isInTaxonomyTree(node, targetNode)) {
                    List<Node> symlinks = this.linkManager.getAllLinks(targetNode, SYMLINK);
                    boolean found = false;
                    for (Node symlink : symlinks) {
                        if (symlink.isNodeType("exo:restoreLocation")) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.moveToTrash(targetNode, sessionProvider);
                    }
                }
            }
            trashSession.save();
        }
        nodeSession.save();
    }

    private boolean isInTaxonomyTree(Node taxonomyNode, Node targetNode) {
        try {
            List<Node> taxonomyTrees = this.taxonomyService_.getAllTaxonomyTrees(true);
            for (Node tree : taxonomyTrees) {
                if (!taxonomyNode.getPath().contains(tree.getPath())) continue;
                Node taxonomyActionNode = tree.getNode("exo:actions/taxonomyAction");
                String targetWorkspace = taxonomyActionNode.getProperty(EXO_TARGETWS).getString();
                String targetPath = taxonomyActionNode.getProperty(EXO_TARGETPATH).getString();
                if (!targetNode.getSession().getWorkspace().getName().equals(targetWorkspace) || !targetNode.getPath().contains(targetPath)) break;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    @Deprecated
    public void restoreFromTrash(Node trashHomeNode, String trashNodePath, String repository, SessionProvider sessionProvider) throws Exception {
        this.restoreFromTrash(trashNodePath, sessionProvider, 0);
    }

    @Override
    @Deprecated
    public void restoreFromTrash(Node trashHomeNode, String trashNodePath, SessionProvider sessionProvider) throws Exception {
        this.restoreFromTrash(trashNodePath, sessionProvider, 0);
    }

    @Override
    public void restoreFromTrash(String trashNodePath, SessionProvider sessionProvider) throws Exception {
        this.restoreFromTrash(trashNodePath, sessionProvider, 0);
    }

    private void restoreFromTrash(String trashNodePath, SessionProvider sessionProvider, int deep) throws Exception {
        Node trashChild;
        NodeIterator iter;
        String nodeUUID;
        Node trashHomeNode = this.getTrashHomeNode();
        Session trashNodeSession = trashHomeNode.getSession();
        Node trashNode = (Node)trashNodeSession.getItem(trashNodePath);
        String trashWorkspace = trashNodeSession.getWorkspace().getName();
        String restoreWorkspace = trashNode.getProperty("exo:restoreWorkspace").getString();
        String restorePath = trashNode.getProperty("exo:restorePath").getString();
        String string = nodeUUID = trashNode.isNodeType(MIX_REFERENCEABLE) ? trashNode.getUUID() : null;
        if (trashNode.isNodeType(SYMLINK)) {
            nodeUUID = null;
        }
        String taxonomyLinkUUID = trashNode.isNodeType(TAXONOMY_LINK) ? trashNode.getProperty(UUID).getString() : null;
        String taxonomyLinkWS = trashNode.isNodeType(TAXONOMY_LINK) ? trashNode.getProperty(EXO_WORKSPACE).getString() : null;
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session restoreSession = sessionProvider.getSession(restoreWorkspace, manageableRepository);
        if (restoreWorkspace.equals(trashWorkspace)) {
            trashNodeSession.getWorkspace().move(trashNodePath, restorePath);
        } else {
            restoreSession.getWorkspace().clone(trashWorkspace, trashNodePath, restorePath, true);
            if (trashNode.isNodeType(MIX_REFERENCEABLE)) {
                Node restoredNode = restoreSession.getNodeByUUID(trashNode.getUUID());
                ExoContainer myContainer = ExoContainerContext.getCurrentContainer();
                NewFolksonomyService newFolksonomyService = (NewFolksonomyService)myContainer.getComponentInstanceOfType(NewFolksonomyService.class);
                String tagWorkspace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
                List<Node> tags = newFolksonomyService.getLinkedTagsOfDocument(trashNode, tagWorkspace);
                for (Node tag : tags) {
                    newFolksonomyService.removeTagOfDocument(tag.getPath(), trashNode, tagWorkspace);
                    this.linkManager.createLink(tag, restoredNode);
                    long total = tag.hasProperty(EXO_TOTAL) ? tag.getProperty(EXO_TOTAL).getLong() : 0L;
                    tag.setProperty(EXO_TOTAL, total + 1L);
                    tag.getSession().save();
                }
            }
            trashNodeSession.getItem(trashNodePath).remove();
        }
        this.removeMixinEXO_RESTORE_LOCATION(restoreSession, restorePath);
        trashNodeSession.save();
        restoreSession.save();
        if (deep == 0 && nodeUUID != null) {
            boolean found;
            block5: do {
                found = false;
                iter = trashHomeNode.getNodes();
                while (iter.hasNext()) {
                    trashChild = iter.nextNode();
                    if (!trashChild.isNodeType(TAXONOMY_LINK) || !trashChild.hasProperty(UUID) || !trashChild.hasProperty(EXO_WORKSPACE) || !nodeUUID.equals(trashChild.getProperty(UUID).getString()) || !restoreWorkspace.equals(trashChild.getProperty(EXO_WORKSPACE))) continue;
                    try {
                        this.restoreFromTrash(trashChild.getPath(), sessionProvider, deep + 1);
                        found = true;
                        continue block5;
                    }
                    catch (Exception e) {
                    }
                }
            } while (found);
        }
        trashNodeSession.save();
        restoreSession.save();
        if (deep == 0 && taxonomyLinkUUID != null && taxonomyLinkWS != null) {
            boolean found;
            block7: do {
                found = false;
                iter = trashHomeNode.getNodes();
                while (iter.hasNext()) {
                    trashChild = iter.nextNode();
                    if (!trashChild.isNodeType(MIX_REFERENCEABLE) || !taxonomyLinkUUID.equals(trashChild.getUUID()) || !taxonomyLinkWS.equals(trashChild.getProperty("exo:restoreWorkspace").getString())) continue;
                    try {
                        this.restoreFromTrash(trashChild.getPath(), sessionProvider, deep + 1);
                        found = true;
                        continue block7;
                    }
                    catch (Exception e) {
                    }
                }
            } while (found);
        }
        trashNodeSession.save();
        restoreSession.save();
    }

    @Override
    @Deprecated
    public List<Node> getAllNodeInTrash(String trashWorkspace, String repository, SessionProvider sessionProvider) throws Exception {
        return this.getAllNodeInTrash(sessionProvider);
    }

    @Override
    @Deprecated
    public List<Node> getAllNodeInTrash(String trashWorkspace, SessionProvider sessionProvider) throws Exception {
        return this.getAllNodeInTrash(sessionProvider);
    }

    @Override
    public List<Node> getAllNodeInTrash(SessionProvider sessionProvider) throws Exception {
        StringBuilder query = new StringBuilder("SELECT * FROM nt:base WHERE exo:restorePath IS NOT NULL");
        return this.selectNodesByQuery(sessionProvider, query.toString(), "sql");
    }

    @Override
    @Deprecated
    public List<Node> getAllNodeInTrashByUser(String trashWorkspace, String repository, SessionProvider sessionProvider, String userName) throws Exception {
        return this.getAllNodeInTrashByUser(sessionProvider, userName);
    }

    @Override
    @Deprecated
    public List<Node> getAllNodeInTrashByUser(String trashWorkspace, SessionProvider sessionProvider, String userName) throws Exception {
        return this.getAllNodeInTrashByUser(sessionProvider, userName);
    }

    @Override
    public List<Node> getAllNodeInTrashByUser(SessionProvider sessionProvider, String userName) throws Exception {
        StringBuilder query = new StringBuilder("SELECT * FROM nt:base WHERE exo:restorePath IS NOT NULL AND exo:lastModifier='").append(userName).append("'");
        return this.selectNodesByQuery(sessionProvider, query.toString(), "sql");
    }

    @Override
    @Deprecated
    public void removeRelations(Node node, SessionProvider sessionProvider, String repository) throws Exception {
        this.removeRelations(node, sessionProvider);
    }

    @Override
    public void removeRelations(Node node, SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        String[] workspaces = manageableRepository.getWorkspaceNames();
        String queryString = "SELECT * FROM exo:relationable WHERE exo:relation IS NOT NULL";
        boolean error = false;
        for (String ws : workspaces) {
            Session session = sessionProvider.getSession(ws, manageableRepository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                try {
                    iter.nextNode().removeMixin("exo:relationable");
                    session.save();
                }
                catch (Exception e) {
                    error = true;
                }
            }
        }
        if (error) {
            throw new Exception("Can't remove exo:relationable of all related nodes");
        }
    }

    @Override
    public boolean isInTrash(Node node) throws RepositoryException {
        return node.getPath().startsWith(this.trashHome_);
    }

    @Override
    public Node getTrashHomeNode() {
        try {
            Session session = WCMCoreUtils.getSystemSessionProvider().getSession(this.trashWorkspace_, this.repositoryService.getCurrentRepository());
            return (Node)session.getItem(this.trashHome_);
        }
        catch (Exception e) {
            return null;
        }
    }

    private List<Node> selectNodesByQuery(SessionProvider sessionProvider, String queryString, String language) throws Exception {
        ArrayList<Node> ret = new ArrayList<Node>();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(this.trashWorkspace_, manageableRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryString, language);
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        while (iter.hasNext()) {
            ret.add(iter.nextNode());
        }
        return ret;
    }

    private String fixRestorePath(String path) {
        int leftBracket = path.lastIndexOf(91);
        int rightBracket = path.lastIndexOf(93);
        if (leftBracket == -1 || rightBracket == -1 || leftBracket >= rightBracket) {
            return path;
        }
        try {
            Integer.parseInt(path.substring(leftBracket + 1, rightBracket));
        }
        catch (Exception ex) {
            return path;
        }
        return path.substring(0, leftBracket);
    }

    private void removeMixinEXO_RESTORE_LOCATION(Session session, String restorePath) throws Exception {
        Node sameNameNode = (Node)session.getItem(restorePath);
        Node parent = sameNameNode.getParent();
        String name = sameNameNode.getName();
        NodeIterator nodeIter = parent.getNodes(name);
        while (nodeIter.hasNext()) {
            Node node = nodeIter.nextNode();
            if (!node.isNodeType("exo:restoreLocation")) continue;
            node.removeMixin("exo:restoreLocation");
        }
    }
}

