/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.sitemap;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.seo.SEOService;

public class SitemapServlet
extends HttpServlet {
    private static final Log LOG = ExoLogger.getLogger(SitemapServlet.class);

    public void init(ServletConfig config) throws ServletException {
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setHeader("Cache-Control", "private max-age=600, s-maxage=120");
        String path = null;
        String portalName = null;
        path = request.getRequestURI();
        String sitemapContent = "";
        try {
            portalName = path.substring(path.lastIndexOf("/") + 1, path.length());
            if (portalName != null && portalName.length() > 0) {
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                SEOService seoService = (SEOService)container.getComponentInstanceOfType(SEOService.class);
                sitemapContent = seoService.getSitemap(portalName);
            }
            response.setContentType("text/xml");
            PrintWriter out = response.getWriter();
            out.println(sitemapContent);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }
}

