/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.tree.selectmany;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.selectmany.UICategoriesSelector;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UISelectedCategoriesGrid.msg.confirm-delete"), @EventConfig(listeners={SaveCategoriesActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UISelectedCategoriesGrid
extends UIGrid {
    public static final String[] BEAN_FIELD = new String[]{"categoryName"};
    public static final String[] BEAN_ACTIONS = new String[]{"Delete"};
    public static final String[] ACTIONS = new String[]{"SaveCategories", "Cancel"};
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UISelectedCategoriesGrid");
    private List<String> selectedCategories = new ArrayList<String>();
    private boolean isDeleteAllCategory;

    public UISelectedCategoriesGrid() throws Exception {
        this.getUIPageIterator().setId("UICategoriesGrid");
        this.configure("categoryPath", BEAN_FIELD, BEAN_ACTIONS);
    }

    public void updateGrid(int currentPage) throws Exception {
        ArrayList<CategoryData> categoryDataList = new ArrayList<CategoryData>();
        for (String categoryPath : this.getSelectedCategories()) {
            CategoryData bean = new CategoryData();
            String[] array = categoryPath.split("/");
            String value = "";
            if (array.length > 4) {
                for (int i = 4; i < array.length; ++i) {
                    value = value + array[i];
                    if (i >= array.length - 1) continue;
                    value = value + "/";
                }
            } else {
                value = categoryPath;
            }
            bean.setCategoryName(value);
            bean.setCategoryPath(categoryPath);
            categoryDataList.add(bean);
        }
        Collections.sort(categoryDataList, new CategoryComparator());
        ListAccessImpl categoryList = new ListAccessImpl(CategoryData.class, categoryDataList);
        LazyPageList dataPageList = new LazyPageList((ListAccess)categoryList, 5);
        this.getUIPageIterator().setPageList((PageList)dataPageList);
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void addCategory(String categoryPath) {
        this.selectedCategories.add(categoryPath);
    }

    public void removeCategory(String categoryPath) {
        this.selectedCategories.remove(categoryPath);
    }

    public List<String> getSelectedCategories() {
        return this.selectedCategories;
    }

    public void setSelectedCategories(List<String> list) {
        this.selectedCategories = new ArrayList<String>(list);
    }

    public boolean isDeleteAllCategory() {
        return this.isDeleteAllCategory;
    }

    public void setDeleteAllCategory(boolean isDeleteAllCategory) {
        this.isDeleteAllCategory = isDeleteAllCategory;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UISelectedCategoriesGrid> {
        public void execute(Event<UISelectedCategoriesGrid> event) throws Exception {
            UISelectedCategoriesGrid uiSelectedCategoriesGrid = (UISelectedCategoriesGrid)((Object)event.getSource());
            UIComponent uiComponent = uiSelectedCategoriesGrid.getParent();
            if (uiComponent != null) {
                if (uiComponent instanceof UIPopupWindow) {
                    ((UIPopupWindow)uiComponent).setShow(false);
                    ((UIPopupWindow)uiComponent).setRendered(false);
                    event.getRequestContext().addUIComponentToUpdateByAjax(((UIPopupWindow)uiComponent).getParent());
                    return;
                }
                uiSelectedCategoriesGrid.getParent().broadcast(event, event.getExecutionPhase());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveCategoriesActionListener
    extends EventListener<UISelectedCategoriesGrid> {
        public void execute(Event<UISelectedCategoriesGrid> event) throws Exception {
            UISelectedCategoriesGrid uiSelectedCategoriesGrid = (UISelectedCategoriesGrid)((Object)event.getSource());
            UICategoriesSelector uiCategoriesSelector = (UICategoriesSelector)uiSelectedCategoriesGrid.getAncestorOfType(UICategoriesSelector.class);
            String returnField = uiCategoriesSelector.getReturnFieldName();
            List<String> selectedCategories = uiSelectedCategoriesGrid.getSelectedCategories();
            ArrayList<String> selectedCategoriesName = new ArrayList<String>();
            for (String item : selectedCategories) {
                selectedCategoriesName.add(item.replaceAll("/jcr:system/exo:ecm/exo:taxonomies/", ""));
            }
            UIApplication uiApplication = (UIApplication)uiSelectedCategoriesGrid.getAncestorOfType(UIApplication.class);
            if (selectedCategories.size() == 0 && !uiSelectedCategoriesGrid.isDeleteAllCategory()) {
                uiApplication.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.non-categories", null, 2));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApplication.getUIPopupMessages());
                return;
            }
            try {
                ((UISelectable)uiCategoriesSelector.getSourceComponent()).doSelect(returnField, selectedCategoriesName);
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                uiApplication.addMessage(new ApplicationMessage("UISelectedCategoriesGrid.msg.cannot-save", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApplication.getUIPopupMessages());
            }
            uiCategoriesSelector.deActivate();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UISelectedCategoriesGrid> {
        public void execute(Event<UISelectedCategoriesGrid> event) throws Exception {
            UISelectedCategoriesGrid uiSelectedCategoriesGrid = (UISelectedCategoriesGrid)((Object)event.getSource());
            String value = event.getRequestContext().getRequestParameter("objectId");
            uiSelectedCategoriesGrid.removeCategory(value);
            if (uiSelectedCategoriesGrid.getSelectedCategories().size() == 0) {
                uiSelectedCategoriesGrid.setDeleteAllCategory(true);
            }
            uiSelectedCategoriesGrid.updateGrid(uiSelectedCategoriesGrid.getUIPageIterator().getCurrentPage());
            if (uiSelectedCategoriesGrid.getSelectedCategories().size() == 0) {
                uiSelectedCategoriesGrid.setRendered(false);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSelectedCategoriesGrid.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CategoryComparator
    implements Comparator<CategoryData> {
        @Override
        public int compare(CategoryData cData1, CategoryData cData2) {
            return cData1.getCategoryName().compareTo(cData2.getCategoryName());
        }
    }

    public class CategoryData {
        private String categoryName;
        private String categoryPath;

        public String getCategoryName() {
            return this.categoryName;
        }

        public void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        public String getCategoryPath() {
            return this.categoryPath;
        }

        public void setCategoryPath(String categoryPath) {
            this.categoryPath = categoryPath;
        }
    }
}

