/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.jdbc;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.InvalidNameException;
import org.exoplatform.commons.utils.IdentifierUtil;
import org.exoplatform.services.database.DAO;
import org.exoplatform.services.database.DBObject;
import org.exoplatform.services.database.DBObjectMapper;
import org.exoplatform.services.database.DBObjectQuery;
import org.exoplatform.services.database.DBPageList;
import org.exoplatform.services.database.ExoDatasource;
import org.exoplatform.services.database.StandardSQLDAO;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.Group;
import org.exoplatform.services.organization.Membership;
import org.exoplatform.services.organization.MembershipEventListener;
import org.exoplatform.services.organization.MembershipHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.jdbc.MembershipImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipDAOImpl
extends StandardSQLDAO<MembershipImpl>
implements MembershipHandler {
    protected static Log log = ExoLogger.getLogger((String)"exo.core.component.organization.jdbc.MembershipDAOImpl");
    protected final OrganizationService service;
    protected ListenerService listenerService_;

    public MembershipDAOImpl(ListenerService lService, ExoDatasource datasource, DBObjectMapper<MembershipImpl> mapper, OrganizationService service) {
        super(datasource, mapper, MembershipImpl.class);
        this.service = service;
        this.listenerService_ = lService;
    }

    public Membership createMembershipInstance() {
        return new MembershipImpl();
    }

    public void createMembership(Membership membership, boolean broadcast) throws Exception {
        if (this.service.getMembershipTypeHandler().findMembershipType(membership.getMembershipType()) == null) {
            throw new InvalidNameException("Can not create membership record " + membership.getId() + " because membership type " + membership.getMembershipType() + " not exists.");
        }
        MembershipImpl membershipImpl = (MembershipImpl)membership;
        if (broadcast) {
            this.listenerService_.broadcast("organization.membership.preSave", (Object)this, (Object)membershipImpl);
        }
        membershipImpl.setId(IdentifierUtil.generateUUID((Object)membership));
        super.save((DBObject)membershipImpl);
        if (broadcast) {
            this.listenerService_.broadcast("organization.membership.postSave", (Object)this, (Object)membershipImpl);
        }
    }

    public void linkMembership(User user, Group group, MembershipType mt, boolean broadcast) throws Exception {
        if (user == null) {
            throw new InvalidNameException("Can not create membership record because group is null");
        }
        if (group == null) {
            throw new InvalidNameException("Can not create membership record for " + user.getUserName() + " because group is null");
        }
        if (mt == null) {
            throw new InvalidNameException("Can not create membership record for " + user.getUserName() + " because membership type is null");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("LINK MEMBER SHIP (" + user.getUserName() + ", " + group.getId() + " , " + mt.getName() + ");"));
        }
        MembershipImpl membership = new MembershipImpl();
        membership.setUserName(user.getUserName());
        membership.setMembershipType(mt.getName());
        membership.setGroupId(group.getId());
        if (this.findMembershipByUserGroupAndType(user.getUserName(), group.getId(), mt.getName()) != null) {
            return;
        }
        this.createMembership(membership, broadcast);
    }

    public Membership findMembership(String id) throws Exception {
        if (id == null) {
            return null;
        }
        DBObjectQuery query = new DBObjectQuery(MembershipImpl.class);
        query.addLIKE("MEMBERSHIP_ID", id);
        return (Membership)this.loadUnique(query.toQuery());
    }

    public Membership findMembershipByUserGroupAndType(String userName, String groupId, String type) throws Exception {
        if (userName == null || groupId == null || type == null) {
            return null;
        }
        DBObjectQuery query = new DBObjectQuery(MembershipImpl.class);
        query.addLIKE("USER_NAME", userName);
        query.addLIKE("GROUP_ID", groupId);
        query.addLIKE("MEMBERSHIP_TYPE", type);
        Membership member = (Membership)this.loadUnique(query.toQuery());
        if (log.isDebugEnabled()) {
            log.debug((Object)("FIND MEMBERSHIP BY USER " + userName + ", GROUP " + groupId + ", TYPE " + type + " - " + (member != null)));
        }
        return member;
    }

    public Collection findMembershipsByGroup(Group group) throws Exception {
        if (group == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        DBObjectQuery query = new DBObjectQuery(MembershipImpl.class);
        query.addLIKE("GROUP_ID", group.getId());
        this.loadInstances(query.toQuery(), list);
        return list;
    }

    public Collection findMembershipsByUser(String userName) throws Exception {
        if (userName == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        DBObjectQuery query = new DBObjectQuery(MembershipImpl.class);
        query.addLIKE("USER_NAME", userName);
        this.loadInstances(query.toQuery(), list);
        if (log.isDebugEnabled()) {
            log.debug((Object)("FIND MEMBERSHIP BY USER " + userName + " Size = " + list.size()));
        }
        return list;
    }

    public Collection findMembershipsByUserAndGroup(String userName, String groupId) throws Exception {
        if (userName == null || groupId == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        DBObjectQuery query = new DBObjectQuery(MembershipImpl.class);
        query.addLIKE("USER_NAME", userName);
        query.addLIKE("GROUP_ID", groupId);
        this.loadInstances(query.toQuery(), list);
        if (log.isDebugEnabled()) {
            log.debug((Object)("FIND MEMBERSHIP BY USER " + userName + ", GROUP " + groupId + " Size = " + list.size()));
        }
        return list;
    }

    public Membership removeMembership(String id, boolean broadcast) throws Exception {
        DBObjectQuery query = new DBObjectQuery(MembershipImpl.class);
        query.addLIKE("MEMBERSHIP_ID", id);
        Connection connection = this.eXoDS_.getConnection();
        try {
            MembershipImpl membershipImpl = (MembershipImpl)super.loadUnique(connection, query.toQuery());
            if (membershipImpl == null) {
                Membership membership = null;
                return membership;
            }
            if (broadcast) {
                this.listenerService_.broadcast("organization.membership.preDelete", (Object)this, (Object)membershipImpl);
            }
            String sql = this.eXoDS_.getQueryBuilder().createRemoveQuery(this.type_, membershipImpl.getDBObjectId());
            super.execute(connection, sql, (DBObject)null);
            if (broadcast) {
                this.listenerService_.broadcast("organization.membership.postDelete", (Object)this, (Object)membershipImpl);
            }
            MembershipImpl membershipImpl2 = membershipImpl;
            return membershipImpl2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.eXoDS_.closeConnection(connection);
        }
    }

    public Collection removeMembershipByUser(String username, boolean broadcast) throws Exception {
        List members = (List)this.findMembershipsByUser(username);
        for (Membership member : members) {
            this.removeMembership(member.getId(), true);
        }
        return members;
    }

    public Collection removeMemberships(DBObjectQuery<MembershipImpl> query, boolean broadcast) throws Exception {
        DBPageList pageList = new DBPageList(20, (DAO)this, query);
        List list = pageList.getAll();
        Connection connection = this.eXoDS_.getConnection();
        try {
            for (MembershipImpl membershipImpl : list) {
                if (broadcast) {
                    this.listenerService_.broadcast("organization.membership.preDelete", (Object)this, (Object)membershipImpl);
                }
                if (membershipImpl == null) {
                    Collection collection = null;
                    return collection;
                }
                String sql = this.eXoDS_.getQueryBuilder().createRemoveQuery(this.type_, membershipImpl.getDBObjectId());
                super.execute(connection, sql, (DBObject)null);
                if (!broadcast) continue;
                this.listenerService_.broadcast("organization.membership.postDelete", (Object)this, (Object)membershipImpl);
            }
            List i$ = list;
            return i$;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            this.eXoDS_.closeConnection(connection);
        }
    }

    public void addMembershipEventListener(MembershipEventListener listener) {
        throw new RuntimeException("This method is not supported anymore, please use the new api");
    }
}

