/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.search;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.search.UIConstraintsForm;
import org.exoplatform.ecm.webui.component.explorer.search.UIECMSearch;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchContainer;
import org.exoplatform.ecm.webui.component.explorer.search.UISearchResult;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormInputInfo;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={MoreConstraintsActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveConstraintActionListener.class}, phase=Event.Phase.DECODE)})
public class UISimpleSearch
extends UIForm {
    public static final String INPUT_SEARCH = "input";
    public static final String CONSTRAINTS = "constraints";
    public static final String NODE_PATH = "nodePath";
    public static final String FIRST_OPERATOR = "firstOperator";
    public static final String OR = "or".intern();
    public static final String AND = "and".intern();
    private static final Log LOG = ExoLogger.getLogger((String)"explorer.UISimpleSearch");
    private List<String> constraints_ = new ArrayList<String>();
    private List<String> virtualConstraints_ = new ArrayList<String>();
    private List<String> categoryPathList = new ArrayList<String>();
    private static final String ROOT_XPATH_QUERY = "//*";
    private static final String XPATH_QUERY = "/jcr:root$0//*";
    private static final String ROOT_SQL_QUERY = "SELECT * FROM nt:base WHERE jcr:path LIKE '/%' ";
    private static final String SQL_QUERY = "SELECT * FROM nt:base WHERE jcr:path LIKE '$0/%' ";
    private String _OR;
    private String _AND;

    public List<String> getCategoryPathList() {
        return this.categoryPathList;
    }

    public void setCategoryPathList(List<String> categoryPathListItem) {
        this.categoryPathList = categoryPathListItem;
    }

    public UISimpleSearch() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormInputInfo(NODE_PATH, NODE_PATH, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(INPUT_SEARCH, INPUT_SEARCH, null));
        ArrayList<SelectItemOption> operators = new ArrayList<SelectItemOption>();
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        this._AND = res.getString("UIConstraintForm.label.and");
        this._OR = res.getString("UIConstraintForm.label.or");
        operators.add(new SelectItemOption(this._AND, (Object)AND));
        operators.add(new SelectItemOption(this._OR, (Object)OR));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIRST_OPERATOR, FIRST_OPERATOR, operators));
        UIFormInputSetWithAction uiInputAct = new UIFormInputSetWithAction("moreConstraints");
        uiInputAct.addUIFormInput((UIFormInput)new UIFormInputInfo(CONSTRAINTS, CONSTRAINTS, null));
        this.addUIComponentInput((UIComponent)uiInputAct);
        this.setActions(new String[]{"MoreConstraints", "Search", "Save", "Cancel"});
    }

    public List<String> getConstraints() {
        return this.constraints_;
    }

    public void updateAdvanceConstraint(String constraint, String operator, String virtualDateQuery) {
        if (constraint.length() > 0) {
            if (this.constraints_.size() == 0) {
                this.constraints_.add("(" + constraint + " )");
                if (virtualDateQuery != null) {
                    this.virtualConstraints_.add("(" + virtualDateQuery + " )");
                } else {
                    this.virtualConstraints_.add("(" + constraint + " )");
                }
            } else {
                this.constraints_.add(" " + operator.toLowerCase() + " (" + constraint + " ) ");
                if (virtualDateQuery != null) {
                    this.virtualConstraints_.add(" " + operator.toLowerCase() + " (" + virtualDateQuery + " ) ");
                } else {
                    this.virtualConstraints_.add(" " + operator.toLowerCase() + " (" + constraint + " ) ");
                }
            }
        }
        UIFormInputSetWithAction inputInfor = (UIFormInputSetWithAction)this.getChildById("moreConstraints");
        inputInfor.setIsDeleteOnly(true);
        inputInfor.setListInfoField(CONSTRAINTS, this.virtualConstraints_);
        String[] actionInfor = new String[]{"RemoveConstraint"};
        inputInfor.setActionInfo(CONSTRAINTS, actionInfor);
    }

    private String getQueryStatement() throws Exception {
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        StringBuilder statement = new StringBuilder(1024);
        String text = (String)this.getUIStringInput(INPUT_SEARCH).getValue();
        if (text != null && this.constraints_.size() == 0) {
            if ("/".equals(currentNode.getPath())) {
                statement.append(ROOT_XPATH_QUERY);
            } else {
                statement.append(StringUtils.replace((String)XPATH_QUERY, (String)"$0", (String)currentNode.getPath()));
            }
            statement.append("[(jcr:contains(.,'").append(text.replaceAll("'", "''")).append("'))]");
        } else if (this.constraints_.size() > 0) {
            if (text == null) {
                if ("/".equals(currentNode.getPath())) {
                    statement.append(ROOT_XPATH_QUERY).append("[(");
                } else {
                    statement.append(StringUtils.replace((String)XPATH_QUERY, (String)"$0", (String)currentNode.getPath())).append("[(");
                }
            } else {
                String operator = (String)this.getUIFormSelectBox(FIRST_OPERATOR).getValue();
                if ("/".equals(currentNode.getPath())) {
                    statement.append(ROOT_XPATH_QUERY);
                } else {
                    statement.append(StringUtils.replace((String)XPATH_QUERY, (String)"$0", (String)currentNode.getPath()));
                }
                statement.append("[(jcr:contains(.,'").append(text.replaceAll("'", "''")).append("')) ").append(operator).append(" (");
            }
            for (String constraint : this.constraints_) {
                statement.append(constraint);
            }
            statement.append(")]");
        }
        return statement.toString();
    }

    private String getSQLStatement() throws Exception {
        Node currentNode = ((UIJCRExplorer)this.getAncestorOfType(UIJCRExplorer.class)).getCurrentNode();
        StringBuilder statement = new StringBuilder(1024);
        String text = (String)this.getUIStringInput(INPUT_SEARCH).getValue();
        if (text != null && this.constraints_.size() == 0) {
            if ("/".equals(currentNode.getPath())) {
                statement.append(ROOT_SQL_QUERY);
            } else {
                statement.append(StringUtils.replace((String)SQL_QUERY, (String)"$0", (String)currentNode.getPath()));
            }
            statement.append("AND CONTAINS(*,'").append(text.replaceAll("'", "''")).append("')");
        } else if (this.constraints_.size() > 0) {
            if (text == null) {
                if ("/".equals(currentNode.getPath())) {
                    statement.append(ROOT_SQL_QUERY);
                } else {
                    statement.append(StringUtils.replace((String)SQL_QUERY, (String)"$0", (String)currentNode.getPath()));
                }
            } else {
                if ("/".equals(currentNode.getPath())) {
                    statement.append(ROOT_SQL_QUERY);
                } else {
                    statement.append(StringUtils.replace((String)SQL_QUERY, (String)"$0", (String)currentNode.getPath()));
                }
                statement.append("AND CONTAINS(*,'").append(text.replaceAll("'", "''")).append("') ");
            }
            String operator = (String)this.getUIFormSelectBox(FIRST_OPERATOR).getValue();
            statement.append(operator).append(" ");
            for (String constraint : this.constraints_) {
                statement.append(constraint);
            }
        }
        return statement.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoreConstraintsActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            UISearchContainer uiSearchContainer = (UISearchContainer)((UISimpleSearch)((Object)event.getSource())).getParent();
            UIConstraintsForm uiConstraintsForm = (UIConstraintsForm)uiSearchContainer.getChild(UIConstraintsForm.class);
            if (uiConstraintsForm.isRendered()) {
                uiConstraintsForm.setRendered(false);
            } else {
                uiConstraintsForm.setRendered(true);
            }
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSearchContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            String statementReplace;
            String statement;
            UISimpleSearch uiSimpleSearch = (UISimpleSearch)((Object)event.getSource());
            String text = (String)uiSimpleSearch.getUIStringInput(UISimpleSearch.INPUT_SEARCH).getValue();
            UIJCRExplorer uiExplorer = (UIJCRExplorer)uiSimpleSearch.getAncestorOfType(UIJCRExplorer.class);
            Node currentNode = uiExplorer.getCurrentNode();
            UIECMSearch uiECMSearch = (UIECMSearch)uiSimpleSearch.getAncestorOfType(UIECMSearch.class);
            UISearchResult uiSearchResult = (UISearchResult)uiECMSearch.getChild(UISearchResult.class);
            UIApplication uiApp = (UIApplication)uiSimpleSearch.getAncestorOfType(UIApplication.class);
            if (text == null && uiSimpleSearch.constraints_.size() == 0) {
                uiApp.addMessage(new ApplicationMessage("UISimpleSearch.msg.value-null", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            uiSearchResult.setCategoryPathList(uiSimpleSearch.getCategoryPathList());
            Preference pref = uiExplorer.getPreference();
            String queryType = pref.getQueryType();
            List<String> searchCategoryPathList = uiSimpleSearch.getCategoryPathList();
            if (queryType.equals("XPATH")) {
                statement = uiSimpleSearch.getQueryStatement() + " order by @exo:dateCreated descending";
                if (searchCategoryPathList != null && searchCategoryPathList.size() > 0) {
                    for (String searchCategoryPath : searchCategoryPathList) {
                        statement = statementReplace = statement.replaceAll("@exo:category = '" + searchCategoryPath + "'", "@jcr:mixinTypes = 'mix:referenceable'");
                    }
                }
            } else {
                statement = uiSimpleSearch.getSQLStatement() + " order by exo:dateCreated DESC";
                if (searchCategoryPathList != null && searchCategoryPathList.size() > 0) {
                    for (String searchCategoryPath : searchCategoryPathList) {
                        statement = statementReplace = statement.replaceAll("exo:category = '" + searchCategoryPath + "'", "jcr:mixinTypes = 'mix:referenceable'");
                    }
                }
            }
            long startTime = System.currentTimeMillis();
            try {
                uiSearchResult.setQuery(statement, currentNode.getSession().getWorkspace().getName(), queryType.equals("XPATH") ? "xpath" : "sql", IdentityConstants.SYSTEM.equals(currentNode.getSession().getUserID()), null);
                uiSearchResult.updateGrid();
            }
            catch (RepositoryException reEx) {
                uiApp.addMessage(new ApplicationMessage("UISimpleSearch.msg.inputSearch-invalid", null, 1));
                return;
            }
            catch (Exception e) {
                LOG.error((Object)"Unexpected error", (Throwable)e);
                uiApp.addMessage(new ApplicationMessage("UISimpleSearch.msg.query-invalid", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            long time = System.currentTimeMillis() - startTime;
            uiSearchResult.setSearchTime(time);
            uiECMSearch.setRenderedChild(UISearchResult.class);
            uiSimpleSearch.getUIFormInputInfo(UISimpleSearch.NODE_PATH).setValue((Object)currentNode.getPath());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveConstraintActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            UISimpleSearch uiSimpleSearch = (UISimpleSearch)((Object)event.getSource());
            int intIndex = Integer.parseInt(event.getRequestContext().getRequestParameter("objectId"));
            uiSimpleSearch.constraints_.remove(intIndex);
            uiSimpleSearch.virtualConstraints_.remove(intIndex);
            if (uiSimpleSearch.categoryPathList.size() > intIndex) {
                uiSimpleSearch.categoryPathList.remove(intIndex);
            }
            if (uiSimpleSearch.constraints_.size() > 0 && intIndex == 0) {
                String newFirstConstraint = null;
                String newFirstVirtualConstraint = null;
                if (((String)uiSimpleSearch.constraints_.get(0)).trim().startsWith(OR)) {
                    newFirstConstraint = ((String)uiSimpleSearch.constraints_.get(0)).substring(3, ((String)uiSimpleSearch.constraints_.get(0)).length());
                    newFirstVirtualConstraint = ((String)uiSimpleSearch.virtualConstraints_.get(0)).substring(3, ((String)uiSimpleSearch.virtualConstraints_.get(0)).length());
                    uiSimpleSearch.constraints_.set(0, newFirstConstraint);
                    uiSimpleSearch.virtualConstraints_.set(0, newFirstVirtualConstraint);
                } else if (((String)uiSimpleSearch.constraints_.get(0)).trim().startsWith(AND)) {
                    newFirstConstraint = ((String)uiSimpleSearch.constraints_.get(0)).substring(4, ((String)uiSimpleSearch.constraints_.get(0)).length());
                    newFirstVirtualConstraint = ((String)uiSimpleSearch.virtualConstraints_.get(0)).substring(4, ((String)uiSimpleSearch.virtualConstraints_.get(0)).length());
                    uiSimpleSearch.constraints_.set(0, newFirstConstraint);
                    uiSimpleSearch.virtualConstraints_.set(0, newFirstVirtualConstraint);
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiSimpleSearch.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            ((UIJCRExplorer)((UISimpleSearch)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class)).cancelAction();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends EventListener<UISimpleSearch> {
        public void execute(Event<UISimpleSearch> event) throws Exception {
            UISimpleSearch uiSimpleSearch = (UISimpleSearch)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiSimpleSearch.getAncestorOfType(UIApplication.class);
            String text = (String)uiSimpleSearch.getUIStringInput(UISimpleSearch.INPUT_SEARCH).getValue();
            if (text == null && uiSimpleSearch.constraints_.size() == 0) {
                uiApp.addMessage(new ApplicationMessage("UISimpleSearch.msg.value-save-null", null));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            UISearchContainer uiSearchContainer = (UISearchContainer)uiSimpleSearch.getParent();
            uiSearchContainer.initSaveQueryPopup(uiSimpleSearch.getQueryStatement(), true, "xpath");
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSearchContainer);
        }
    }
}

