/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.nodetype;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipInputStream;
import javax.jcr.RepositoryException;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeImport;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeImportPopup;
import org.exoplatform.ecm.webui.component.admin.nodetype.UINodeTypeManager;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeValuesList;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={UploadActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})
public class UINodeTypeUpload
extends UIForm {
    public static final String FIELD_UPLOAD = "upload";

    public UINodeTypeUpload() throws Exception {
        this.setMultiPart(true);
        UIFormUploadInput uiInput = new UIFormUploadInput(FIELD_UPLOAD, FIELD_UPLOAD);
        uiInput.setAutoUpload(true);
        this.addUIFormInput((UIFormInput)uiInput);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UINodeTypeUpload> {
        public void execute(Event<UINodeTypeUpload> event) throws Exception {
            UINodeTypeUpload uiUpload = (UINodeTypeUpload)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiUpload.getAncestorOfType(UIPopupWindow.class);
            uiPopup.setRendered(false);
            uiPopup.setShow(false);
            UINodeTypeManager uiManager = (UINodeTypeManager)uiUpload.getAncestorOfType(UINodeTypeManager.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class UploadActionListener
    extends EventListener<UINodeTypeUpload> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Event<UINodeTypeUpload> event) throws Exception {
            UINodeTypeUpload uiUploadForm = (UINodeTypeUpload)((Object)event.getSource());
            UINodeTypeManager uiManager = (UINodeTypeManager)uiUploadForm.getAncestorOfType(UINodeTypeManager.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiManager.findComponentById("NodeTypeImportPopup");
            uiPopup.setShowMask(true);
            UINodeTypeImportPopup uiImportPopup = (UINodeTypeImportPopup)uiManager.findComponentById("UINodeTypeImportPopup");
            UIApplication uiApp = (UIApplication)uiUploadForm.getAncestorOfType(UIApplication.class);
            UIFormUploadInput input = (UIFormUploadInput)uiUploadForm.getUIInput(UINodeTypeUpload.FIELD_UPLOAD);
            if (input.getUploadResource() == null) {
                uiApp.addMessage(new ApplicationMessage("UINodeTypeUpload.msg.filename-error", null));
                return;
            }
            String fileName = input.getUploadResource().getFileName();
            if (fileName == null || fileName.trim().length() == 0) {
                uiApp.addMessage(new ApplicationMessage("UINodeTypeUpload.msg.filename-error", null));
                return;
            }
            DMSMimeTypeResolver resolver = DMSMimeTypeResolver.getInstance();
            String mimeType = resolver.getMimeType(fileName);
            InputStream is = null;
            UINodeTypeImport uiNodeTypeImport = (UINodeTypeImport)uiImportPopup.getChild(UINodeTypeImport.class);
            try {
                if (mimeType.trim().equals("text/xml")) {
                    is = new BufferedInputStream(input.getUploadDataAsStream());
                } else if (mimeType.trim().equals("application/zip")) {
                    ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(input.getUploadDataAsStream()));
                    is = Utils.extractFirstEntryFromZipFile((ZipInputStream)zipInputStream);
                } else {
                    uiApp.addMessage(new ApplicationMessage("UINodeTypeUpload.msg.data-file-error", null));
                    return;
                }
                IBindingFactory factory = BindingDirectory.getFactory(NodeTypeValuesList.class);
                IUnmarshallingContext uctx = factory.createUnmarshallingContext();
                NodeTypeValuesList nodeTypeValuesList = (NodeTypeValuesList)uctx.unmarshalDocument(is, null);
                ArrayList ntvList = nodeTypeValuesList.getNodeTypeValuesList();
                uiNodeTypeImport.update(ntvList);
                if (uiNodeTypeImport.getRegisteredNodeType().size() > 0 || uiNodeTypeImport.getUndefinedNodeTypes().size() > 0) {
                    Class[] childrenToRender = new Class[]{UINodeTypeImport.class, UIPopupWindow.class};
                    uiImportPopup.setRenderedChildrenOfTypes(childrenToRender);
                    uiPopup.setShow(true);
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiManager);
                }
                if (uiNodeTypeImport.getRegisteredNodeType().size() > 0) {
                    uiApp.addMessage(new ApplicationMessage("UINodeTypeUpload.msg.nodetype-exist", new Object[]{uiNodeTypeImport.getRegisteredNodeType().toString()}, 1));
                }
                if (uiNodeTypeImport.getUndefinedNamespace().size() > 0) {
                    uiApp.addMessage(new ApplicationMessage("UINodeTypeUpload.msg.namespace-invalid", new Object[]{uiNodeTypeImport.getUndefinedNamespace().toString()}, 1));
                }
            }
            catch (JiBXException e) {
                uiApp.addMessage(new ApplicationMessage("UINodeTypeUpload.msg.data-invalid", null, 0));
                return;
            }
            catch (RepositoryException e) {
                uiApp.addMessage(new ApplicationMessage("UINodeTypeUpload.msg.data-invalid", null, 0));
                return;
            }
            finally {
                UploadService uploadService = (UploadService)uiUploadForm.getApplicationComponent(UploadService.class);
                UIFormUploadInput uiUploadInput = (UIFormUploadInput)uiUploadForm.getChild(UIFormUploadInput.class);
                uploadService.removeUploadResource(uiUploadInput.getUploadId());
                if (is != null) {
                    is.close();
                }
            }
        }
    }
}

