/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.ListAccessImpl;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.views.UITabForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewContainer;
import org.exoplatform.ecm.webui.component.admin.views.UIViewForm;
import org.exoplatform.ecm.webui.component.admin.views.UIViewFormTabPane;
import org.exoplatform.ecm.webui.component.admin.views.UIViewManager;
import org.exoplatform.ecm.webui.core.UIPagingGrid;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.cms.views.ViewConfig;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="system:/groovy/ecm/webui/UIGridWithButton.gtmpl", events={@EventConfig(listeners={DeleteActionListener.class}, confirm="UIViewList.msg.confirm-delete"), @EventConfig(listeners={EditInfoActionListener.class}), @EventConfig(listeners={ViewActionListener.class}), @EventConfig(listeners={AddViewActionListener.class})})
public class UIViewList
extends UIPagingGrid {
    public static final String[] ACTIONS = new String[]{"AddView"};
    public static final String ST_VIEW = "ViewPopup";
    public static final String ST_EDIT = "EditPopup";
    public static final String ST_ADD = "AddPopup";
    private static String[] VIEW_BEAN_FIELD = new String[]{"name", "permissions", "tabList", "baseVersion"};
    private static String[] VIEW_ACTION = new String[]{"View", "EditInfo", "Delete"};

    public UIViewList() throws Exception {
        this.getUIPageIterator().setId("UIViewsGrid");
        this.configure("name", VIEW_BEAN_FIELD, VIEW_ACTION);
    }

    private String getBaseVersion(String name) throws Exception {
        Node node = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getViewByName(name, WCMCoreUtils.getSystemSessionProvider());
        if (node == null) {
            return null;
        }
        if (!node.isNodeType("mix:versionable") || node.isNodeType(Utils.NT_FROZEN)) {
            return "";
        }
        return node.getBaseVersion().getName();
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void refresh(int currentPage) throws Exception {
        List<ViewBean> viewBean = this.getViewsBean();
        Collections.sort(viewBean, new ViewComparator());
        ListAccessImpl viewBeanList = new ListAccessImpl(ViewBean.class, viewBean);
        this.getUIPageIterator().setPageList((PageList)new LazyPageList((ListAccess)viewBeanList, this.getUIPageIterator().getItemsPerPage()));
        this.getUIPageIterator().setTotalItems(viewBean.size());
        if (currentPage > this.getUIPageIterator().getAvailablePage()) {
            this.getUIPageIterator().setCurrentPage(this.getUIPageIterator().getAvailablePage());
        } else {
            this.getUIPageIterator().setCurrentPage(currentPage);
        }
    }

    private List<ViewBean> getViewsBean() throws Exception {
        List views = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getAllViews();
        ArrayList<ViewBean> viewBeans = new ArrayList<ViewBean>();
        for (ViewConfig view : views) {
            ArrayList<String> tabsName = new ArrayList<String>();
            for (ViewConfig.Tab tab : view.getTabList()) {
                tabsName.add(tab.getTabName());
            }
            ViewBean bean = new ViewBean(view.getName(), view.getPermissions(), tabsName);
            if (this.getBaseVersion(view.getName()) == null) continue;
            bean.setBaseVersion(this.getBaseVersion(view.getName()));
            viewBeans.add(bean);
        }
        return viewBeans;
    }

    public boolean canDelete(List drivers, String viewName) {
        for (Object driver : drivers) {
            String views = ((DriveData)driver).getViews();
            for (String view : views.split(",")) {
                if (!viewName.equals(view.trim())) continue;
                return false;
            }
        }
        return true;
    }

    public String getRepository() {
        return ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
    }

    public class ViewBean {
        private String name;
        private String permissions;
        private String tabList;
        private String baseVersion = "";

        public ViewBean(String n, String per, List tabs) {
            this.name = n;
            this.permissions = per;
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < tabs.size(); ++i) {
                str.append(" [ ").append(tabs.get(i)).append(" ]");
            }
            this.tabList = str.toString();
        }

        public String getBaseVersion() {
            return this.baseVersion;
        }

        public void setBaseVersion(String s) {
            this.baseVersion = s;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String s) {
            this.name = s;
        }

        public String getPermissions() {
            return this.permissions;
        }

        public void setPermissions(String s) {
            this.permissions = s;
        }

        public String getTabList() {
            return this.tabList;
        }

        public void setTabList(String ls) {
            this.tabList = ls;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewActionListener
    extends EventListener<UIViewList> {
        public void execute(Event<UIViewList> event) throws Exception {
            UIViewList uiViewList = (UIViewList)((Object)event.getSource());
            uiViewList.setRenderSibling(UIViewList.class);
            String viewName = event.getRequestContext().getRequestParameter("objectId");
            Node viewNode = ((ManageViewService)uiViewList.getApplicationComponent(ManageViewService.class)).getViewByName(viewName, WCMCoreUtils.getSystemSessionProvider());
            UIViewContainer uiViewContainer = (UIViewContainer)uiViewList.getParent();
            uiViewContainer.removeChildById(UIViewList.ST_EDIT);
            uiViewContainer.removeChildById(UIViewList.ST_ADD);
            uiViewContainer.initPopup(UIViewList.ST_VIEW);
            UIViewFormTabPane uiViewTabPane = (UIViewFormTabPane)uiViewContainer.findFirstComponentOfType(UIViewFormTabPane.class);
            UIViewForm uiViewForm = (UIViewForm)uiViewTabPane.getChild(UIViewForm.class);
            uiViewForm.refresh(false);
            uiViewForm.update(viewNode, true, null);
            uiViewForm.setActionInfo("permission", null);
            uiViewForm.setActions(new String[]{"Close"}, null);
            ((UITabForm)uiViewTabPane.getChild(UITabForm.class)).setActions(new String[]{"BackViewForm"}, null);
            uiViewTabPane.setRenderedChild(UIViewForm.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditInfoActionListener
    extends EventListener<UIViewList> {
        public void execute(Event<UIViewList> event) throws Exception {
            UIViewList uiViewList = (UIViewList)((Object)event.getSource());
            uiViewList.setRenderSibling(UIViewList.class);
            String viewName = event.getRequestContext().getRequestParameter("objectId");
            Node viewNode = ((ManageViewService)uiViewList.getApplicationComponent(ManageViewService.class)).getViewByName(viewName, WCMCoreUtils.getSystemSessionProvider());
            UIViewContainer uiViewContainer = (UIViewContainer)uiViewList.getParent();
            uiViewContainer.removeChildById(UIViewList.ST_VIEW);
            uiViewContainer.removeChildById(UIViewList.ST_ADD);
            uiViewContainer.initPopup(UIViewList.ST_EDIT);
            UIViewFormTabPane viewTabPane = (UIViewFormTabPane)uiViewContainer.findFirstComponentOfType(UIViewFormTabPane.class);
            UIViewForm viewForm = (UIViewForm)viewTabPane.getChild(UIViewForm.class);
            viewForm.refresh(true);
            viewForm.update(viewNode, false, null);
            if (viewForm.getUIFormCheckBoxInput("enableVersion").isChecked()) {
                viewForm.getUIFormCheckBoxInput("enableVersion").setEnable(false);
                viewForm.setActions(new String[]{"Save", "Restore", "Cancel", "AddTabForm"}, null);
            } else {
                viewForm.getUIFormCheckBoxInput("enableVersion").setEnable(true);
                viewForm.setActions(new String[]{"Save", "Cancel", "AddTabForm"}, null);
            }
            viewForm.setActionInfo("permission", new String[]{"AddPermission", "RemovePermission"});
            ((UITabForm)viewTabPane.getChild(UITabForm.class)).setActions(new String[]{"Save"}, null);
            viewTabPane.setSelectedTab(viewForm.getId());
            UIViewManager uiManager = (UIViewManager)uiViewList.getAncestorOfType(UIViewManager.class);
            uiManager.setRenderedChild(UIViewContainer.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeleteActionListener
    extends EventListener<UIViewList> {
        public void execute(Event<UIViewList> event) throws Exception {
            UIViewList viewList = (UIViewList)((Object)event.getSource());
            viewList.setRenderSibling(UIViewList.class);
            String viewName = event.getRequestContext().getRequestParameter("objectId");
            ManageDriveService manageDrive = (ManageDriveService)viewList.getApplicationComponent(ManageDriveService.class);
            if (!viewList.canDelete(manageDrive.getAllDrives(), viewName)) {
                UIApplication app = (UIApplication)viewList.getAncestorOfType(UIApplication.class);
                Object[] args = new Object[]{viewName};
                app.addMessage(new ApplicationMessage("UIViewList.msg.template-in-use", args));
                event.getRequestContext().addUIComponentToUpdateByAjax(viewList.getParent());
                return;
            }
            ((ManageViewService)viewList.getApplicationComponent(ManageViewService.class)).removeView(viewName);
            viewList.refresh(viewList.getUIPageIterator().getCurrentPage());
            event.getRequestContext().addUIComponentToUpdateByAjax(viewList.getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddViewActionListener
    extends EventListener<UIViewList> {
        public void execute(Event<UIViewList> event) throws Exception {
            UIViewList uiViewList = (UIViewList)((Object)event.getSource());
            if (uiViewList.getViewsBean().size() == 0) {
                UIApplication uiApp = (UIApplication)((UIViewList)((Object)event.getSource())).getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIViewList.msg.access-denied", null, 1));
                return;
            }
            UIViewContainer uiViewContainer = (UIViewContainer)uiViewList.getParent();
            uiViewContainer.removeChildById(UIViewList.ST_VIEW);
            uiViewContainer.removeChildById(UIViewList.ST_EDIT);
            uiViewContainer.initPopup(UIViewList.ST_ADD);
            UIViewFormTabPane uiViewTabPane = (UIViewFormTabPane)uiViewContainer.findFirstComponentOfType(UIViewFormTabPane.class);
            uiViewTabPane.reset();
            UIViewManager uiManager = (UIViewManager)uiViewList.getAncestorOfType(UIViewManager.class);
            uiManager.setRenderedChild(UIViewContainer.class);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiViewContainer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewComparator
    implements Comparator<ViewBean> {
        @Override
        public int compare(ViewBean v1, ViewBean v2) throws ClassCastException {
            String name1 = v1.getName();
            String name2 = v2.getName();
            return name1.compareToIgnoreCase(name2);
        }
    }
}

