/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.relations.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.cms.relations.RelationsService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationsServiceImpl
implements RelationsService,
Startable {
    private static final String RELATION_MIXIN = "exo:relationable";
    private static final String RELATION_PROP = "exo:relation";
    private RepositoryService repositoryService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private static final Log LOG = ExoLogger.getLogger(RelationsServiceImpl.class);

    public RelationsServiceImpl(RepositoryService repositoryService, NodeHierarchyCreator nodeHierarchyCreator, InitParams params) {
        this.repositoryService_ = repositoryService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    @Override
    public boolean hasRelations(Node node) throws Exception {
        return node.isNodeType(RELATION_MIXIN);
    }

    private Node getNodeByUUID(String uuid, SessionProvider provider) throws Exception {
        String[] workspaces;
        ManageableRepository manageRepo = this.repositoryService_.getCurrentRepository();
        for (String ws : workspaces = manageRepo.getWorkspaceNames()) {
            try {
                return provider.getSession(ws, manageRepo).getNodeByUUID(uuid);
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public List<Node> getRelations(Node node, String repository, SessionProvider provider) {
        return this.getRelations(node, provider);
    }

    @Override
    public List<Node> getRelations(Node node, SessionProvider provider) {
        ArrayList<Node> rels = new ArrayList<Node>();
        try {
            if (node.hasProperty(RELATION_PROP)) {
                Value[] values = node.getProperty(RELATION_PROP).getValues();
                for (int i = 0; i < values.length; ++i) {
                    if (this.getNodeByUUID(values[i].getString(), provider) == null) continue;
                    rels.add(this.getNodeByUUID(values[i].getString(), provider));
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return rels;
    }

    @Override
    @Deprecated
    public void removeRelation(Node node, String relationPath, String repository) throws Exception {
        this.removeRelation(node, relationPath);
    }

    @Override
    public void removeRelation(Node node, String relationPath) throws Exception {
        ArrayList<Value> vals = new ArrayList<Value>();
        if (!"*".equals(relationPath)) {
            SessionProvider provider = SessionProvider.createSystemProvider();
            Property relations = node.getProperty(RELATION_PROP);
            if (relations != null) {
                Value[] values = relations.getValues();
                String uuid2Remove = null;
                for (int i = 0; i < values.length; ++i) {
                    String uuid = values[i].getString();
                    Node refNode = this.getNodeByUUID(uuid, provider);
                    if (refNode == null) continue;
                    if (refNode.getPath().equals(relationPath)) {
                        uuid2Remove = uuid;
                        continue;
                    }
                    vals.add(values[i]);
                }
                if (uuid2Remove == null) {
                    return;
                }
            }
            provider.close();
        }
        if (vals.size() == 0) {
            node.removeMixin(RELATION_MIXIN);
        } else {
            node.setProperty(RELATION_PROP, vals.toArray(new Value[vals.size()]));
        }
        node.save();
    }

    @Override
    @Deprecated
    public void addRelation(Node node, String relationPath, String workspace, String repository) throws Exception {
        this.addRelation(node, relationPath, workspace);
    }

    @Override
    public void addRelation(Node node, String relationPath, String workspace) throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        Session session = this.getSession(workspace, provider);
        Node catNode = (Node)session.getItem(relationPath);
        if (!catNode.isNodeType("mix:referenceable")) {
            catNode.addMixin("mix:referenceable");
            catNode.save();
            session.save();
        }
        Value value2add = session.getValueFactory().createValue(catNode);
        if (!node.isNodeType(RELATION_MIXIN)) {
            node.addMixin(RELATION_MIXIN);
            node.setProperty(RELATION_PROP, new Value[]{value2add});
            node.save();
            session.save();
        } else {
            ArrayList<Value> vals = new ArrayList<Value>();
            Value[] values = node.getProperty(RELATION_PROP).getValues();
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                String uuid = value.getString();
                Node refNode = null;
                try {
                    refNode = this.getNodeByUUID(uuid, provider);
                }
                catch (ItemNotFoundException ie) {
                    this.removeRelation(node, relationPath);
                    continue;
                }
                if (refNode.getPath().equals(relationPath)) {
                    return;
                }
                vals.add(value);
            }
            vals.add(value2add);
            node.setProperty(RELATION_PROP, vals.toArray(new Value[vals.size()]));
            node.save();
            session.save();
            session.logout();
            provider.close();
        }
    }

    public void start() {
    }

    public void stop() {
    }

    @Override
    @Deprecated
    public void init(String repository) throws Exception {
        this.init();
    }

    @Override
    public void init() throws Exception {
    }

    protected Session getSession() throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getCurrentRepository();
        String workspaceName = manageableRepository.getConfiguration().getSystemWorkspaceName();
        return manageableRepository.getSystemSession(workspaceName);
    }

    private Session getSession(String workspace, SessionProvider provider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getCurrentRepository();
        return provider.getSession(workspace, manageableRepository);
    }
}

