/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.link;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.apache.commons.httpclient.methods.GetMethod;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.html.HTMLDocument;
import org.exoplatform.services.html.HTMLNode;
import org.exoplatform.services.html.parser.HTMLParser;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.link.HyperLinkUtilExtended;
import org.exoplatform.services.wcm.link.LinkBean;
import org.exoplatform.services.wcm.link.LiveLinkManagerService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveLinkManagerServiceImpl
implements LiveLinkManagerService {
    private ExoCache<String, List<String>> brokenLinksCache;
    private WCMConfigurationService configurationService;
    private RepositoryService repositoryService;
    private LivePortalManagerService livePortalManagerService;
    private String internalServerPath;
    private static Log log = ExoLogger.getLogger(LiveLinkManagerServiceImpl.class);

    public LiveLinkManagerServiceImpl(WCMConfigurationService configurationService, RepositoryService repositoryService, LivePortalManagerService livePortalManagerService, CacheService cacheService, InitParams initParams) throws Exception {
        this.configurationService = configurationService;
        this.repositoryService = repositoryService;
        this.livePortalManagerService = livePortalManagerService;
        this.brokenLinksCache = cacheService.getCacheInstance(this.getClass().getName());
        PropertiesParam propertiesParam = initParams.getPropertiesParam("server.config");
        String scheme = propertiesParam.getProperty("scheme");
        String hostName = propertiesParam.getProperty("hostName");
        String port = propertiesParam.getProperty("port");
        StringBuilder builder = new StringBuilder();
        builder.append(scheme).append("://").append(hostName).append(":").append(port);
        this.internalServerPath = builder.toString();
    }

    @Override
    public List<LinkBean> getBrokenLinks(String portalName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node portal = this.livePortalManagerService.getLivePortal(sessionProvider, portalName);
        String path = portal.getPath();
        Session session = portal.getSession();
        ArrayList<LinkBean> listBrokenLinks = new ArrayList<LinkBean>();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery("select * from exo:webContent where jcr:path like '" + path + "/%'", "sql");
        QueryResult results = query.execute();
        NodeIterator iter = results.getNodes();
        while (iter.hasNext()) {
            Node webContent = iter.nextNode();
            List<String> listBrokenUrls = this.getBrokenLinks(webContent);
            for (String brokenUrl : listBrokenUrls) {
                LinkBean linkBean = new LinkBean(brokenUrl, "broken");
                listBrokenLinks.add(linkBean);
            }
        }
        return listBrokenLinks;
    }

    @Override
    public List<String> getBrokenLinks(Node webContent) throws Exception {
        ArrayList<String> listBrokenUrls = (ArrayList<String>)this.brokenLinksCache.get((Serializable)((Object)webContent.getUUID()));
        if (listBrokenUrls == null) {
            listBrokenUrls = new ArrayList<String>();
            for (Value value : webContent.getProperty("exo:links").getValues()) {
                String link = value.getString();
                LinkBean linkBean = LinkBean.parse(link);
                if (!linkBean.isBroken()) continue;
                listBrokenUrls.add(linkBean.getUrl());
            }
            this.brokenLinksCache.put((Serializable)((Object)webContent.getUUID()), listBrokenUrls);
        }
        return listBrokenUrls;
    }

    @Override
    public void updateLinks() throws Exception {
        try {
            Collection<NodeLocation> nodeLocationCollection = this.configurationService.getAllLivePortalsLocation();
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            Session session = null;
            for (NodeLocation nodeLocation : nodeLocationCollection) {
                String workspace = nodeLocation.getWorkspace();
                String path = nodeLocation.getPath();
                ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
                session = sessionProvider.getSession(workspace, manageableRepository);
                this.updateLinkStatus(session, "select * from exo:linkable where jcr:path like '" + path + "/%'");
            }
        }
        catch (Exception e) {
            log.error((Object)"Error when perform updateLinks: ", (Throwable)e);
        }
    }

    @Override
    public void updateLinks(String portalName) throws Exception {
        try {
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            Node portal = this.livePortalManagerService.getLivePortal(sessionProvider, portalName);
            String path = portal.getPath();
            Session session = portal.getSession();
            this.updateLinkStatus(session, "select * from exo:linkable where jcr:path like '" + path + "/%'");
        }
        catch (Exception e) {
            log.error((Object)"Error when perform updateLinks: ", (Throwable)e);
        }
    }

    private void updateLinkStatus(Session session, String queryCommand) throws Exception {
        ArrayList<String> listBrokenLinks = new ArrayList<String>();
        ValueFactory valueFactory = session.getValueFactory();
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryCommand, "sql");
        QueryResult results = query.execute();
        NodeIterator iter = results.getNodes();
        while (iter.hasNext()) {
            Node webContent = iter.nextNode();
            if (!webContent.isCheckedOut() || webContent.isLocked() || webContent.isCheckedOut() && !webContent.getParent().isCheckedOut()) continue;
            Property links = webContent.getProperty("exo:links");
            Value[] oldValues = links.getValues();
            Value[] newValues = new Value[oldValues.length];
            for (int iValues = 0; iValues < oldValues.length; ++iValues) {
                String oldLink = oldValues[iValues].getString();
                if (oldLink.equals("")) continue;
                LinkBean linkBean = LinkBean.parse(oldLink);
                String oldUrl = linkBean.getUrl();
                String oldStatus = this.getLinkStatus(oldUrl);
                String updatedLink = new LinkBean(oldUrl, oldStatus).toString();
                log.info((Object)updatedLink);
                newValues[iValues] = valueFactory.createValue(updatedLink);
                if (!oldStatus.equals("broken")) continue;
                listBrokenLinks.add(oldUrl);
            }
            webContent.setProperty("exo:links", newValues);
            this.brokenLinksCache.put((Serializable)((Object)webContent.getUUID()), listBrokenLinks);
        }
        session.save();
    }

    private String getLinkStatus(String strUrl) {
        try {
            GetMethod getMethod;
            HttpClient httpClient;
            String fullUrl = strUrl;
            if (strUrl.startsWith("/")) {
                fullUrl = this.internalServerPath + strUrl;
            }
            if ((httpClient = new HttpClient((HttpConnectionManager)new SimpleHttpConnectionManager())).executeMethod((HttpMethod)(getMethod = new GetMethod(fullUrl = fullUrl.replaceAll(" ", "%20")))) == 200) {
                return "active";
            }
            return "broken";
        }
        catch (Exception e) {
            log.info((Object)("URL Link: \"" + strUrl + "\" is broken"));
            return "broken";
        }
    }

    @Override
    public List<String> extractLinks(Node htmlFile) throws Exception {
        String htmlData = htmlFile.getNode("jcr:content").getProperty("jcr:data").getString();
        HTMLDocument document = HTMLParser.createDocument((String)htmlData);
        ArrayList<String> listHyperlink = new ArrayList<String>();
        HTMLNode htmlRootNode = document.getRoot();
        HyperLinkUtilExtended linkUtil = new HyperLinkUtilExtended();
        for (String link : linkUtil.getSiteLink(htmlRootNode)) {
            if (listHyperlink.contains(link)) continue;
            listHyperlink.add(link);
        }
        for (String image : linkUtil.getImageLink(htmlRootNode)) {
            if (listHyperlink.contains(image)) continue;
            listHyperlink.add(image);
        }
        return listHyperlink;
    }

    @Override
    public void updateLinkDataForNode(Node webContent, List<String> newLinks) throws Exception {
        ValueFactory valueFactory = webContent.getSession().getValueFactory();
        if (webContent.canAddMixin("exo:linkable")) {
            webContent.addMixin("exo:linkable");
        }
        ArrayList<String> listExtractedLink = new ArrayList<String>();
        if (webContent.hasProperty("exo:links")) {
            Property property = webContent.getProperty("exo:links");
            for (Value value : property.getValues()) {
                listExtractedLink.add(value.getString());
            }
        }
        ArrayList<String> listResult = new ArrayList<String>();
        for (String extractedLink : listExtractedLink) {
            for (String newUrl : newLinks) {
                if (!LinkBean.parse(extractedLink).getUrl().equals(newUrl)) continue;
                listResult.add(extractedLink);
            }
        }
        ArrayList<String> listTemp = new ArrayList<String>();
        listTemp.addAll(newLinks);
        for (String newUrl : newLinks) {
            for (String extractedLink : listExtractedLink) {
                if (!newUrl.equals(LinkBean.parse(extractedLink).getUrl())) continue;
                listTemp.set(newLinks.indexOf(newUrl), "");
            }
        }
        for (String strTemp : listTemp) {
            if (strTemp.equals("")) continue;
            listResult.add(strTemp);
        }
        Value[] values = new Value[listResult.size()];
        for (String url : listResult) {
            if (url.indexOf("status=") < 0) {
                LinkBean linkBean = new LinkBean(url, "unchecked");
                values[listResult.indexOf((Object)url)] = valueFactory.createValue(linkBean.toString());
                continue;
            }
            values[listResult.indexOf((Object)url)] = valueFactory.createValue(url);
        }
        webContent.setProperty("exo:links", values);
    }
}

