/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.vt2;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.chromattic.metamodel.mapping.jcr.PropertyMetaType;
import org.chromattic.metamodel.type.SimpleTypeProviders;
import org.chromattic.spi.type.SimpleTypeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueDefinition<I, E> {
    private static final ValueDefinition<String, String> STRING = new ValueDefinition(String.class, PropertyMetaType.STRING, new SimpleTypeProviders.STRING(), null);
    private static final ValueDefinition<String, String> PATH = new ValueDefinition(String.class, PropertyMetaType.PATH, new SimpleTypeProviders.PATH(), null);
    private static final ValueDefinition<String, String> NAME = new ValueDefinition(String.class, PropertyMetaType.NAME, new SimpleTypeProviders.NAME(), null);
    private static final ValueDefinition<Boolean, Boolean> BOOLEAN = new ValueDefinition(Boolean.class, PropertyMetaType.BOOLEAN, new SimpleTypeProviders.BOOLEAN(), null);
    private static final ValueDefinition<Double, Double> DOUBLE = new ValueDefinition(Double.class, PropertyMetaType.DOUBLE, new SimpleTypeProviders.DOUBLE(), null);
    private static final ValueDefinition<Long, Long> LONG = new ValueDefinition(Long.class, PropertyMetaType.LONG, new SimpleTypeProviders.LONG(), null);
    private static final ValueDefinition<InputStream, InputStream> BINARY = new ValueDefinition(InputStream.class, PropertyMetaType.BINARY, new SimpleTypeProviders.BINARY(), null);
    private final Class<?> realType;
    private final SimpleTypeProvider<I, E> valueType;
    private final List<String> defaultValue;
    private final PropertyMetaType<I> propertyMetaType;

    public static ValueDefinition<?, ?> get(Object o) {
        int code;
        if (o instanceof String) {
            code = 1;
        } else if (o instanceof Long) {
            code = 3;
        } else if (o instanceof Boolean) {
            code = 6;
        } else if (o instanceof Double) {
            code = 4;
        } else if (o instanceof InputStream) {
            code = 2;
        } else if (o instanceof Long) {
            code = 3;
        } else if (o instanceof Date) {
            code = 5;
        } else {
            return null;
        }
        return ValueDefinition.get(code);
    }

    public static ValueDefinition<?, ?> get(int code) {
        switch (code) {
            case 1: {
                return STRING;
            }
            case 8: {
                return PATH;
            }
            case 7: {
                return NAME;
            }
            case 3: {
                return LONG;
            }
            case 6: {
                return BOOLEAN;
            }
            case 4: {
                return DOUBLE;
            }
            case 2: {
                return BINARY;
            }
            case 0: {
                return null;
            }
        }
        throw new AssertionError((Object)("Unsupported JCR type " + code));
    }

    public ValueDefinition(Class<?> realType, PropertyMetaType<I> propertyMetaType, SimpleTypeProvider<I, E> valueType, List<String> defaultValue) {
        this.realType = realType;
        this.valueType = valueType;
        this.defaultValue = defaultValue;
        this.propertyMetaType = propertyMetaType;
    }

    public boolean isPrimitive() {
        return this.realType.isPrimitive();
    }

    public List<E> getDefaultValue() {
        if (this.defaultValue != null) {
            ArrayList<Object> a = new ArrayList<Object>();
            for (String d : this.defaultValue) {
                a.add(this.valueType.fromString(d));
            }
            return a;
        }
        return null;
    }

    public Value get(ValueFactory factory, int expectedType, E value) throws RepositoryException, ClassCastException {
        if (expectedType != 0 && expectedType != this.propertyMetaType.getCode()) {
            throw new ClassCastException("Cannot cast type " + this.valueType.getExternalType() + " to type " + expectedType);
        }
        Object internal = this.valueType.getInternal(value);
        return this.propertyMetaType.getValue(factory, internal);
    }

    public E get(Value value) throws RepositoryException, ClassCastException {
        if (value.getType() == this.propertyMetaType.getCode()) {
            Object internal = this.propertyMetaType.getValue(value);
            return (E)this.valueType.getExternal(internal);
        }
        throw new ClassCastException();
    }

    public Class<?> getRealType() {
        return this.realType;
    }

    public Class<E> getObjectType() {
        return this.valueType.getExternalType();
    }
}

