/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderResponse;
import org.exoplatform.ecm.jcr.model.Preference;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentContainer;
import org.exoplatform.ecm.webui.component.explorer.UIDocumentWorkspace;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesArea;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditContainer;
import org.exoplatform.ecm.webui.component.explorer.UIJcrExplorerEditForm;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIAddressBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.component.explorer.control.action.AddDocumentActionComponent;
import org.exoplatform.ecm.webui.component.explorer.control.action.EditDocumentActionComponent;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UISideBar;
import org.exoplatform.ecm.webui.component.explorer.sidebar.UITreeExplorer;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.cms.drives.ManageDriveService;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.views.ManageViewService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiApplication;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class)
public class UIJCRExplorerPortlet
extends UIPortletApplication {
    private static final Log LOG = ExoLogger.getLogger(UIJCRExplorerPortlet.class);
    public static final String REPOSITORY = "repository";
    public static final String CATEGORY_MANDATORY = "categoryMandatoryWhenFileUpload";
    public static final String MAX_SIZE_UPLOAD = "uploadFileSizeLimitMB";
    public static final String ISDIRECTLY_DRIVE = "isDirectlyDrive";
    public static final String DRIVE_NAME = "driveName";
    public static final String USECASE = "usecase";
    public static final String JAILED = "jailed";
    public static final String SOCIAL = "social";
    public static final String SELECTION = "selection";
    public static final String PERSONAL = "personal";
    public static final String PARAMETERIZE = "parameterize";
    public static final String PARAMETERIZE_PATH = "nodePath";
    public static final String SHOW_TOP_BAR = "showTopBar";
    public static final String SHOW_ACTION_BAR = "showActionBar";
    public static final String SHOW_SIDE_BAR = "showSideBar";
    public static final String SHOW_FILTER_BAR = "showFilterBar";
    public static final String EDIT_IN_NEW_WINDOW = "editInNewWindow";
    private String backTo = "";
    private boolean flagSelect = false;

    public UIJCRExplorerPortlet() throws Exception {
        UIJcrExplorerContainer explorerContainer = (UIJcrExplorerContainer)this.addChild(UIJcrExplorerContainer.class, null, null);
        explorerContainer.initExplorer();
        ((UIJcrExplorerEditContainer)this.addChild(UIJcrExplorerEditContainer.class, null, null)).setRendered(false);
    }

    public boolean isFlagSelect() {
        return this.flagSelect;
    }

    public void setFlagSelect(boolean flagSelect) {
        this.flagSelect = flagSelect;
    }

    public boolean isShowTopBar() {
        PortletPreferences portletpref = this.getPortletPreferences();
        return Boolean.valueOf(portletpref.getValue(SHOW_TOP_BAR, "false"));
    }

    public boolean isShowActionBar() {
        PortletPreferences portletpref = this.getPortletPreferences();
        return Boolean.valueOf(portletpref.getValue(SHOW_ACTION_BAR, "false")) != false && !((UIJCRExplorer)this.findFirstComponentOfType(UIJCRExplorer.class)).isAddingDocument();
    }

    public boolean isShowSideBar() {
        PortletPreferences portletpref = this.getPortletPreferences();
        return Boolean.valueOf(portletpref.getValue(SHOW_SIDE_BAR, "false"));
    }

    public boolean isShowFilterBar() {
        PortletPreferences portletpref = this.getPortletPreferences();
        return Boolean.valueOf(portletpref.getValue(SHOW_FILTER_BAR, "false"));
    }

    public String getBacktoValue() {
        return this.backTo;
    }

    public void processRender(WebuiApplication app, WebuiRequestContext context) throws Exception {
        HashMap changeDrive;
        UIJcrExplorerContainer explorerContainer = (UIJcrExplorerContainer)this.getChild(UIJcrExplorerContainer.class);
        UIJcrExplorerEditContainer editContainer = (UIJcrExplorerEditContainer)this.getChild(UIJcrExplorerEditContainer.class);
        PortletRequestContext portletReqContext = (PortletRequestContext)context;
        HashMap map = this.getElementByContext(context);
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String backToValue = Util.getPortalRequestContext().getRequestParameter("backto");
        if (!portletReqContext.useAjax()) {
            this.backTo = backToValue;
        }
        if ((changeDrive = (HashMap)pcontext.getAttribute("jcrexplorer-show-document")) != null) {
            map = changeDrive;
            context.setAttribute("jcrexplorer-show-document", null);
        }
        if (portletReqContext.getApplicationMode() == PortletMode.VIEW) {
            if (map.size() > 0) {
                this.showDocument(context, map);
            } else {
                this.initwhenDirect(explorerContainer, editContainer);
            }
            explorerContainer.setRendered(true);
            UIJCRExplorer uiExplorer = (UIJCRExplorer)explorerContainer.getChild(UIJCRExplorer.class);
            if (uiExplorer != null) {
                try {
                    uiExplorer.getSession();
                    try {
                        uiExplorer.getSession().getItem(uiExplorer.getRootPath());
                    }
                    catch (PathNotFoundException e) {
                        this.reloadWhenBroken(uiExplorer);
                        super.processRender(app, context);
                        return;
                    }
                }
                catch (RepositoryException repo) {
                    super.processRender(app, context);
                }
            }
            ((UIJcrExplorerEditContainer)this.getChild(UIJcrExplorerEditContainer.class)).setRendered(false);
        } else if (portletReqContext.getApplicationMode() == PortletMode.HELP) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"\n\n>>>>>>>>>>>>>>>>>>> IN HELP  MODE \n");
            }
        } else if (portletReqContext.getApplicationMode() == PortletMode.EDIT) {
            explorerContainer.setRendered(false);
            ((UIJcrExplorerEditContainer)this.getChild(UIJcrExplorerEditContainer.class)).setRendered(true);
        }
        RenderResponse response = (RenderResponse)context.getResponse();
        Element elementS = response.createElement("script");
        elementS.setAttribute("type", "text/javascript");
        elementS.setAttribute("src", "/eXoWCMResources/javascript/eXo/wcm/backoffice/public/Components.js");
        response.addProperty("javax.portlet.markup.head.element", elementS);
        super.processRender(app, context);
    }

    public void initwhenDirect(UIJcrExplorerContainer explorerContainer, UIJcrExplorerEditContainer editContainer) throws Exception {
        if (((UIJcrExplorerEditForm)editContainer.getChild(UIJcrExplorerEditForm.class)).isFlagSelectRender()) {
            explorerContainer.initExplorer();
            ((UIJcrExplorerEditForm)editContainer.getChild(UIJcrExplorerEditForm.class)).setFlagSelectRender(false);
        }
    }

    public String getPreferenceRepository() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences portletPref = pcontext.getRequest().getPreferences();
        String repository = portletPref.getValue(org.exoplatform.ecm.webui.utils.Utils.REPOSITORY, "");
        return repository;
    }

    public String getPreferenceTrashHomeNodePath() {
        return this.getPortletPreferences().getValue(org.exoplatform.ecm.webui.utils.Utils.TRASH_HOME_NODE_PATH, "");
    }

    public String getPreferenceTrashRepository() {
        return this.getPortletPreferences().getValue(org.exoplatform.ecm.webui.utils.Utils.TRASH_REPOSITORY, "");
    }

    public String getPreferenceTrashWorkspace() {
        return this.getPortletPreferences().getValue(org.exoplatform.ecm.webui.utils.Utils.TRASH_WORKSPACE, "");
    }

    public boolean isEditInNewWindow() {
        return Boolean.parseBoolean(this.getPortletPreferences().getValue(EDIT_IN_NEW_WINDOW, "true"));
    }

    public PortletPreferences getPortletPreferences() {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return pcontext.getRequest().getPreferences();
    }

    @Deprecated
    public DriveData getUserDrive(String repoName, String userType) throws Exception {
        return this.getUserDrive(userType);
    }

    public DriveData getUserDrive(String userType) throws Exception {
        ManageDriveService manageDriveService = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        List userRoles = org.exoplatform.ecm.webui.utils.Utils.getMemberships();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        for (DriveData userDrive : manageDriveService.getPersonalDrives(userId, userRoles)) {
            if (!userDrive.getName().equalsIgnoreCase(userType)) continue;
            return userDrive;
        }
        return null;
    }

    @Deprecated
    public boolean canUseConfigDrive(String repoName, String driveName) throws Exception {
        return this.canUseConfigDrive(driveName);
    }

    public boolean canUseConfigDrive(String driveName) throws Exception {
        ManageDriveService dservice = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        List userRoles = org.exoplatform.ecm.webui.utils.Utils.getMemberships();
        for (DriveData drive : dservice.getDriveByUserRoles(userId, userRoles)) {
            if (!drive.getName().equals(driveName)) continue;
            return true;
        }
        return false;
    }

    public void reloadWhenBroken(UIJCRExplorer uiExplorer) {
        ((UIControl)uiExplorer.getChild(UIControl.class)).setRendered(false);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)uiExplorer.getChild(UIWorkingArea.class);
        uiWorkingArea.setRenderedChild(UIDrivesArea.class);
        UIRightClickPopupMenu uiRightClickPopupMenu = (UIRightClickPopupMenu)uiWorkingArea.getChild(UIRightClickPopupMenu.class);
        if (uiRightClickPopupMenu != null) {
            uiRightClickPopupMenu.setRendered(true);
        }
    }

    private HashMap<String, String> getElementByContext(WebuiRequestContext context) {
        String nodePathUrl;
        String[] uri;
        Matcher matcher;
        HashMap<String, String> mapParam = new HashMap<String, String>();
        if (context.useAjax()) {
            return mapParam;
        }
        Pattern patternUrl = Pattern.compile("([^/]+)/([^/]+)/([^/]+)/(.*)");
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String nodePathParam = pcontext.getRequestParameter("path");
        if (nodePathParam != null) {
            patternUrl = Pattern.compile("([^/]+)/([^/]+)/(.*)");
            matcher = patternUrl.matcher(nodePathParam);
            if (matcher.find()) {
                mapParam.put(REPOSITORY, matcher.group(1));
                mapParam.put("drive", matcher.group(2));
                mapParam.put("path", matcher.group(3));
                return mapParam;
            }
            patternUrl = Pattern.compile("([^/]+)/(.*)");
            matcher = patternUrl.matcher(nodePathParam);
            if (matcher.find()) {
                mapParam.put(REPOSITORY, matcher.group(1));
                mapParam.put("drive", matcher.group(2));
                mapParam.put("path", "/");
            }
        }
        if ((uri = (nodePathUrl = pcontext.getNodePath()).split("/")) == null || uri.length < 3) {
            return mapParam;
        }
        patternUrl = Pattern.compile("([^/]+)/([^/]+)/([^/]+)/(.*)");
        matcher = patternUrl.matcher(nodePathUrl);
        if (matcher.find()) {
            mapParam.put(REPOSITORY, matcher.group(2));
            mapParam.put("drive", matcher.group(3));
            mapParam.put("path", "/" + matcher.group(4));
        } else {
            patternUrl = Pattern.compile("([^/]+)/([^/]+)/(.*)");
            matcher = patternUrl.matcher(nodePathUrl);
            if (matcher.find()) {
                mapParam.put(REPOSITORY, matcher.group(2));
                mapParam.put("drive", matcher.group(3));
                mapParam.put("path", "/");
            }
        }
        return mapParam;
    }

    private void showDocument(WebuiRequestContext context, HashMap<String, String> map) throws Exception {
        Object[] args;
        String repositoryName = String.valueOf(map.get(REPOSITORY));
        String driveName = String.valueOf(map.get("drive"));
        String path = String.valueOf(map.get("path"));
        if (path.indexOf("&") > 0) {
            path = path.substring(0, path.indexOf("&"));
        }
        if (!path.equals("/")) {
            ArrayList<String> encodeNameArr = new ArrayList<String>();
            for (String name : path.split("/")) {
                if (name.length() <= 0) continue;
                encodeNameArr.add(Text.escapeIllegalJcrChars((String)name));
            }
            StringBuilder encodedPath = new StringBuilder();
            for (String encodedName : encodeNameArr) {
                encodedPath.append("/").append(encodedName);
            }
            path = encodedPath.toString();
        }
        UIApplication uiApp = (UIApplication)this.findFirstComponentOfType(UIApplication.class);
        ManageDriveService manageDrive = (ManageDriveService)this.getApplicationComponent(ManageDriveService.class);
        DriveData driveData = null;
        try {
            driveData = manageDrive.getDriveByName(driveName);
            if (driveData == null) {
                throw new PathNotFoundException();
            }
        }
        catch (PathNotFoundException e) {
            Object[] args2 = new Object[]{driveName};
            uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.drive-not-exist", args2, 1));
            return;
        }
        RepositoryService rservice = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        String userId = Util.getPortalRequestContext().getRemoteUser();
        ArrayList<String> viewList = new ArrayList<String>();
        for (String role : org.exoplatform.ecm.webui.utils.Utils.getMemberships()) {
            for (String viewName : driveData.getViews().split(",")) {
                if (viewList.contains(viewName.trim())) continue;
                Node viewNode = ((ManageViewService)this.getApplicationComponent(ManageViewService.class)).getViewByName(viewName.trim(), WCMCoreUtils.getSystemSessionProvider());
                String permiss = viewNode.getProperty("exo:accessPermissions").getString();
                if (permiss.contains("${userId}")) {
                    permiss = permiss.replace("${userId}", userId);
                }
                String[] viewPermissions = permiss.split(",");
                if (permiss.equals("*")) {
                    viewList.add(viewName.trim());
                }
                if (!driveData.hasPermission(viewPermissions, role)) continue;
                viewList.add(viewName.trim());
            }
        }
        String viewListStr = "";
        ArrayList<SelectItemOption> viewOptions = new ArrayList<SelectItemOption>();
        ResourceBundle res = context.getApplicationResourceBundle();
        String viewLabel = null;
        for (String viewName : viewList) {
            try {
                viewLabel = res.getString("Views.label." + viewName);
            }
            catch (MissingResourceException e) {
                viewLabel = viewName;
            }
            viewOptions.add(new SelectItemOption(viewLabel, (Object)viewName));
            if (viewListStr.length() > 0) {
                viewListStr = viewListStr + "," + viewName;
                continue;
            }
            viewListStr = viewName;
        }
        driveData.setViews(viewListStr);
        String homePath = driveData.getHomePath();
        if (homePath.contains("${userId}")) {
            homePath = Utils.getPersonalDrivePath((String)homePath, (String)userId);
        }
        this.setFlagSelect(true);
        UIJCRExplorer uiExplorer = (UIJCRExplorer)this.findFirstComponentOfType(UIJCRExplorer.class);
        uiExplorer.setDriveData(driveData);
        uiExplorer.setIsReferenceNode(false);
        try {
            Session session = WCMCoreUtils.getUserSessionProvider().getSession(driveData.getWorkspace(), rservice.getCurrentRepository());
            session.getItem(homePath);
        }
        catch (AccessDeniedException ace) {
            args = new Object[]{driveName};
            uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.access-denied", args, 1));
            return;
        }
        catch (NoSuchWorkspaceException nosuchWS) {
            args = new Object[]{driveName};
            uiApp.addMessage(new ApplicationMessage("UIDrivesBrowser.msg.workspace-not-exist", args, 1));
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        uiExplorer.setRepositoryName(repositoryName);
        uiExplorer.setWorkspaceName(driveData.getWorkspace());
        uiExplorer.setRootPath(homePath);
        path = homePath.concat(path).replaceAll("/+", "/");
        Preference pref = uiExplorer.getPreference();
        pref.setShowSideBar(driveData.getViewSideBar());
        pref.setShowNonDocumentType(driveData.getViewNonDocument());
        pref.setShowPreferenceDocuments(driveData.getViewPreferences());
        pref.setAllowCreateFoder(driveData.getAllowCreateFolders());
        pref.setShowHiddenNode(driveData.getShowHiddenNode());
        uiExplorer.setIsReferenceNode(false);
        UIControl uiControl = (UIControl)uiExplorer.getChild(UIControl.class);
        UIAddressBar uiAddressBar = (UIAddressBar)uiControl.getChild(UIAddressBar.class);
        uiAddressBar.setViewList(viewList);
        uiAddressBar.setSelectedViewName((String)viewList.get(0));
        uiAddressBar.setRendered(this.isShowTopBar());
        UIActionBar uiActionbar = (UIActionBar)uiControl.getChild(UIActionBar.class);
        boolean isShowActionBar = this.isShowActionBar();
        uiActionbar.setTabOptions((String)viewList.get(0));
        uiActionbar.setRendered(isShowActionBar);
        uiExplorer.setSelectNode(driveData.getWorkspace(), path);
        UIWorkingArea uiWorkingArea = (UIWorkingArea)this.findFirstComponentOfType(UIWorkingArea.class);
        UISideBar uiSideBar = (UISideBar)uiWorkingArea.findFirstComponentOfType(UISideBar.class);
        if (uiSideBar.isRendered()) {
            uiSideBar.updateSideBarView();
            ((UITreeExplorer)uiSideBar.getChild(UITreeExplorer.class)).buildTree();
        }
        UIDocumentWorkspace uiDocWorkspace = (UIDocumentWorkspace)uiWorkingArea.getChild(UIDocumentWorkspace.class);
        uiDocWorkspace.setRenderedChild(UIDocumentContainer.class);
        uiDocWorkspace.setRendered(true);
        UIDrivesArea uiDrive = (UIDrivesArea)uiWorkingArea.getChild(UIDrivesArea.class);
        if (uiDrive != null) {
            uiDrive.setRendered(false);
        }
        context.addUIComponentToUpdateByAjax((UIComponent)uiDocWorkspace);
        UIPopupContainer popupAction = (UIPopupContainer)this.getChild(UIPopupContainer.class);
        if (popupAction != null && popupAction.isRendered()) {
            popupAction.deActivate();
            context.addUIComponentToUpdateByAjax((UIComponent)popupAction);
        }
        Boolean isEdit = Boolean.valueOf(Util.getPortalRequestContext().getRequestParameter("edit"));
        Node selectedNode = uiExplorer.getCurrentNode();
        if (isEdit.booleanValue()) {
            if (uiExplorer.getCurrentPath().equals(path) && this.canManageNode(selectedNode, uiApp, uiExplorer, uiActionbar, context, EditDocumentActionComponent.getFilters())) {
                EditDocumentActionComponent.editDocument(null, context, (UIComponent)this, uiExplorer, selectedNode, uiApp);
            } else {
                uiApp.addMessage(new ApplicationMessage("UIJCRExplorerPortlet.msg.file-access-denied", null, 1));
            }
        }
        boolean isAddNew = Boolean.valueOf(Util.getPortalRequestContext().getRequestParameter("addNew"));
        if (!isEdit.booleanValue() && isAddNew) {
            if (this.canManageNode(selectedNode, uiApp, uiExplorer, uiActionbar, context, AddDocumentActionComponent.getFilters())) {
                AddDocumentActionComponent.addDocument(null, uiExplorer, uiApp, (UIComponent)this, context);
            } else {
                uiApp.addMessage(new ApplicationMessage("UIJCRExplorerPortlet.msg.file-access-denied", null, 1));
            }
        }
        uiExplorer.refreshExplorer(null, isAddNew && isEdit != false && this.isEditInNewWindow());
        uiExplorer.setRenderSibling(UIJCRExplorer.class);
    }

    private boolean canManageNode(Node selectedNode, UIApplication uiApp, UIJCRExplorer uiExplorer, UIActionBar uiActionBar, Object context, List<UIExtensionFilter> filters) throws Exception {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        ctx.put(UIActionBar.class.getName(), (Object)uiActionBar);
        ctx.put(UIJCRExplorer.class.getName(), (Object)uiExplorer);
        ctx.put(UIApplication.class.getName(), uiApp);
        ctx.put(Node.class.getName(), selectedNode);
        ctx.put(WebuiRequestContext.class.getName(), context);
        for (UIExtensionFilter filter : filters) {
            try {
                if (filter.accept(ctx)) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }
}

