/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.migration;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

public class ActionMigrationService
implements Startable {
    private RepositoryService repoService_;
    private static final Log LOG = ExoLogger.getLogger((String)ActionMigrationService.class.getName());

    public ActionMigrationService(RepositoryService repositoryService) {
        this.repoService_ = repositoryService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        String exoNodeTypeName = "exo:nodeTypeName";
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        try {
            ManageableRepository repository = this.repoService_.getCurrentRepository();
            Session session = null;
            for (String wsName : repository.getWorkspaceNames()) {
                try {
                    session = sessionProvider.getSession(wsName, repository);
                    QueryManager manager = session.getWorkspace().getQueryManager();
                    String statement = "SELECT * from exo:action WHERE " + exoNodeTypeName + " IS NOT NULL";
                    Query query = manager.createQuery(statement.toString(), "sql");
                    NodeIterator nodes = query.execute().getNodes();
                    while (nodes.hasNext()) {
                        Node node = (Node)nodes.next();
                        if (node.getProperty(exoNodeTypeName).getValues().length != 0) continue;
                        node.setProperty(exoNodeTypeName, (Value[])null);
                    }
                    session.save();
                    session.logout();
                }
                catch (Exception e) {
                    if (session != null && session.isLive()) {
                        session.logout();
                    }
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)("An unexpected problem occurs when migrating data for action nodes in workspace " + wsName), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)"An unexpected problem occurs when migrating data for action nodes", (Throwable)e);
            }
        }
        finally {
            sessionProvider.close();
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Action nodes data migrated successfully!...");
        }
    }

    public void stop() {
    }
}

