/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui;

import com.ibm.icu.text.Transliterator;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.user.UserNavigation;
import org.exoplatform.portal.mop.user.UserNode;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.portal.webui.workspace.UIWorkingWorkspace;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.mimetype.DMSMimeTypeResolver;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.navigation.NavigationUtils;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.core.UIPopupWindow;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.url.navigation.NodeURL;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPortletApplication;
import org.owasp.validator.html.AntiSamy;
import org.owasp.validator.html.CleanResults;
import org.owasp.validator.html.Policy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    public static final String TURN_ON_QUICK_EDIT = "turnOnQuickEdit";
    private static final String SQL_PARAM_PATTERN = "\\$\\{([^\\$\\{\\}])+\\}";
    private static final String POLICY_FILE_LOCATION = "jar:/conf/portal/antisamy.xml";
    private static final String JCR_CONTENT = "jcr:content";
    private static final String JCR_DATA = "jcr:data";
    private static final String JCR_MIMETYPE = "jcr:mimeType";
    private static final String NT_FILE = "nt:file";
    private static final String NT_UNSTRUCTURED = "nt:unstructured";
    private static ConfigurationManager cservice_;

    @Deprecated
    public static boolean isEditPortletInCreatePageWizard() {
        UIPortalApplication portalApplication = Util.getUIPortalApplication();
        UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)portalApplication.getChildById("UIMaskWorkspace");
        return uiMaskWS.getWindowWidth() > 0 && uiMaskWS.getWindowHeight() < 0;
    }

    @Deprecated
    public static boolean isQuickEditMode(UIContainer container, String popupWindowId) {
        UIPopupContainer popupContainer = Utils.getPopupContainer(container);
        if (popupContainer == null) {
            return false;
        }
        UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.getChildById(popupWindowId);
        return popupWindow != null;
    }

    @Deprecated
    public static boolean isPortletViewMode() {
        return Utils.getCurrentMode().equals(PortletMode.VIEW);
    }

    public static boolean isPortalEditMode() {
        return Util.getUIPortalApplication().getModeState() != 0;
    }

    public static String getRealPortletId(PortletRequestContext portletRequestContext) {
        String portletId = portletRequestContext.getWindowId();
        int modeState = Util.getUIPortalApplication().getModeState();
        switch (modeState) {
            case 0: {
                return portletId;
            }
            case 1: {
                return "UIPortlet-" + portletId;
            }
            case 2: {
                return "EditMode-" + portletId;
            }
        }
        return null;
    }

    public static boolean canEditCurrentPortal(String remoteUser) throws Exception {
        if (remoteUser == null) {
            return false;
        }
        IdentityRegistry identityRegistry = (IdentityRegistry)Util.getUIPortalApplication().getApplicationComponent(IdentityRegistry.class);
        Identity identity = identityRegistry.getIdentity(remoteUser);
        if (identity == null) {
            return false;
        }
        UIPortal uiPortal = Util.getUIPortal();
        String editPermission = uiPortal.getEditPermission();
        MembershipEntry membershipEntry = MembershipEntry.parse((String)editPermission);
        return identity.isMemberOf(membershipEntry);
    }

    public static String cleanString(String str) {
        Transliterator accentsconverter = Transliterator.getInstance((String)"Latin; NFD; [:Nonspacing Mark:] Remove; NFC;");
        str = accentsconverter.transliterate(str);
        StringBuffer cleanedStr = new StringBuffer(str.trim());
        for (int i = 0; i < cleanedStr.length(); ++i) {
            char c = cleanedStr.charAt(i);
            if (c == ' ') {
                if (i > 0 && cleanedStr.charAt(i - 1) == '-') {
                    cleanedStr.deleteCharAt(i--);
                    continue;
                }
                c = '-';
                cleanedStr.setCharAt(i, c);
                continue;
            }
            if (i > 0 && !Character.isLetterOrDigit(c) && c != '-') {
                cleanedStr.deleteCharAt(i--);
                continue;
            }
            if (i <= 0 || c != 45 || cleanedStr.charAt(i - 1) != '-') continue;
            cleanedStr.deleteCharAt(i--);
        }
        return cleanedStr.toString().toLowerCase();
    }

    public static void updatePortal(PortletRequestContext context) {
        UIPortalApplication portalApplication = Util.getUIPortalApplication();
        PortalRequestContext portalRequestContext = (PortalRequestContext)context.getParentAppRequestContext();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)portalApplication.getChildById("UIWorkingWorkspace");
        portalRequestContext.addUIComponentToUpdateByAjax((UIComponent)uiWorkingWS);
        UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)portalApplication.getChildById("UIMaskWorkspace");
        portalRequestContext.addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
        portalRequestContext.setFullRender(true);
    }

    public static Node getViewableNodeByComposer(String repository, String workspace, String nodeIdentifier) {
        return Utils.getViewableNodeByComposer(repository, workspace, nodeIdentifier, null);
    }

    public static Node getViewableNodeByComposer(String repository, String workspace, String nodeIdentifier, String version) {
        return Utils.getViewableNodeByComposer(repository, workspace, nodeIdentifier, version, "user");
    }

    public static Node getViewableNodeByComposer(String repository, String workspace, String nodeIdentifier, String version, String cacheVisibility) {
        try {
            HashMap<String, String> filters = new HashMap<String, String>();
            StringBuffer filterLang = new StringBuffer(Util.getPortalRequestContext().getLocale().getLanguage());
            String country = Util.getPortalRequestContext().getLocale().getCountry();
            if (country != null && country.length() > 0) {
                filterLang.append("_").append(country);
            }
            filters.put("filter-language", filterLang.toString());
            filters.put("filter-mode", Utils.getCurrentMode());
            PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletMode portletMode = portletRequestContext.getApplicationMode();
            filters.put("portlet-mode", portletMode.toString());
            if (version != null) {
                filters.put("filter-version", version);
            }
            filters.put("filter-visibility", cacheVisibility);
            return ((WCMComposer)WCMCoreUtils.getService(WCMComposer.class)).getContent(workspace, Text.escapeIllegalJcrChars((String)nodeIdentifier), filters, WCMCoreUtils.getUserSessionProvider());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getCurrentMode() {
        Object isQuickEditable = Util.getPortalRequestContext().getRequest().getSession().getAttribute(TURN_ON_QUICK_EDIT);
        if (isQuickEditable == null) {
            return "Live";
        }
        boolean turnOnQuickEdit = Boolean.parseBoolean(isQuickEditable.toString());
        return turnOnQuickEdit ? "Edit" : "Live";
    }

    public static boolean isLiveMode() {
        return "Live".equals(Utils.getCurrentMode());
    }

    public static boolean isShowDraft(Node content) {
        if (content == null) {
            return false;
        }
        try {
            if (content.isNodeType("nt:frozenNode")) {
                return false;
            }
            WCMPublicationService wcmPublicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
            String contentState = wcmPublicationService.getContentState(content);
            boolean isDraftContent = false;
            if ("draft".equals(contentState)) {
                isDraftContent = true;
            }
            boolean isShowDraft = false;
            if ("Edit".equals(Utils.getCurrentMode())) {
                isShowDraft = true;
            }
            return isDraftContent && isShowDraft;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isShowQuickEdit() {
        try {
            boolean isEditMode = false;
            if ("Edit".equals(Utils.getCurrentMode())) {
                isEditMode = true;
            }
            return isEditMode;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isShowDelete(Node content) {
        return false;
    }

    public static boolean isShowQuickEdit(Node content) {
        if (content == null) {
            return true;
        }
        try {
            boolean isEditMode = false;
            if ("Edit".equals(Utils.getCurrentMode()) || Util.getUIPortalApplication().getModeState() != 0) {
                isEditMode = true;
            }
            ((ExtendedNode)content).checkPermission("set_property");
            ((ExtendedNode)content).checkPermission("add_node");
            ((ExtendedNode)content).checkPermission("remove");
            return isEditMode;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getEditLink(Node node, boolean isEditable, boolean isNew) {
        try {
            String itemPath = node.getSession().getWorkspace().getName() + node.getPath();
            return Utils.getEditLink(itemPath, isEditable, isNew);
        }
        catch (RepositoryException e) {
            return null;
        }
    }

    public static String getEditLink(String itemPath, boolean isEditable, boolean isNew) {
        PortalRequestContext pContext = Util.getPortalRequestContext();
        String backto = pContext.getRequestURI();
        WCMConfigurationService configurationService = (WCMConfigurationService)Util.getUIPortalApplication().getApplicationComponent(WCMConfigurationService.class);
        String editorPageURI = configurationService.getRuntimeContextParam(isEditable || isNew ? "editorPageURI" : "siteExplorerURI");
        UserNode editorNode = Utils.getEditorNode(editorPageURI);
        if (editorNode == null) {
            return "";
        }
        NodeURL nodeURL = (NodeURL)pContext.createURL(NodeURL.TYPE);
        nodeURL.setNode(editorNode).setQueryParameterValue("path", itemPath);
        if (isEditable) {
            nodeURL.setQueryParameterValue("edit", "true");
        }
        if (isNew) {
            nodeURL.setQueryParameterValue("addNew", "true");
        }
        nodeURL.setQueryParameterValue("backto", backto);
        return nodeURL.toString();
    }

    private static UserNode getEditorNode(String editorPageURI) {
        UserPortal userPortal = Util.getPortalRequestContext().getUserPortalConfig().getUserPortal();
        List allNavs = userPortal.getNavigations();
        for (UserNavigation nav : allNavs) {
            UserNode userNode;
            if (!nav.getKey().getType().equals((Object)SiteType.GROUP) || (userNode = userPortal.resolvePath(nav, null, editorPageURI)) == null) continue;
            return userNode;
        }
        return null;
    }

    public static void createPopupWindow(UIContainer container, UIComponent component, String popupWindowId, int width) throws Exception {
        UIPopupContainer popupContainer = Utils.initPopup(container, component, popupWindowId, width);
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        requestContext.addUIComponentToUpdateByAjax((UIComponent)popupContainer);
    }

    public static void createPopupWindow(UIContainer container, UIComponent component, String popupWindowId, int width, boolean isShowMask) throws Exception {
        UIPopupContainer popupContainer = Utils.initPopup(container, component, popupWindowId, width);
        UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.getChildById(popupWindowId);
        popupWindow.setShowMask(isShowMask);
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        requestContext.addUIComponentToUpdateByAjax((UIComponent)popupContainer);
    }

    public static void createPopupWindow(UIContainer container, UIComponent component, String popupWindowId, int width, int top, int left) throws Exception {
        UIPopupContainer popupContainer = Utils.initPopup(container, component, popupWindowId, width);
        UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.getChildById(popupWindowId);
        popupWindow.setCoordindate(top, left);
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        requestContext.addUIComponentToUpdateByAjax((UIComponent)popupContainer);
    }

    private static UIPopupContainer initPopup(UIContainer container, UIComponent component, String popupWindowId, int width) throws Exception {
        UIPopupContainer popupContainer = Utils.getPopupContainer(container);
        popupContainer.removeChildById(popupWindowId);
        UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.addChild(UIPopupWindow.class, null, popupWindowId);
        popupWindow.setUIComponent(component);
        popupWindow.setWindowSize(width, 0);
        popupWindow.setShow(true);
        popupWindow.setRendered(true);
        popupWindow.setResizable(true);
        popupWindow.setShowMask(true);
        return popupContainer;
    }

    public static void closePopupWindow(UIContainer container, String popupWindowId) {
        UIPopupContainer popupContainer = Utils.getPopupContainer(container);
        popupContainer.removeChildById(popupWindowId);
    }

    public static void updatePopupWindow(UIContainer container, UIComponent component, String popupWindowId) {
        UIPopupContainer popupContainer = Utils.getPopupContainer(container);
        UIPopupWindow popupWindow = (UIPopupWindow)popupContainer.getChildById(popupWindowId);
        popupWindow.setUIComponent(component);
    }

    public static UIPopupContainer getPopupContainer(UIContainer container) {
        if (container instanceof UIPortletApplication) {
            return (UIPopupContainer)container.getChild(UIPopupContainer.class);
        }
        UIPortletApplication portletApplication = (UIPortletApplication)container.getAncestorOfType(UIPortletApplication.class);
        return (UIPopupContainer)portletApplication.getChild(UIPopupContainer.class);
    }

    public static void createPopupMessage(UIContainer container, String message, Object[] args, int type) {
        UIApplication application = (UIApplication)container.getAncestorOfType(UIApplication.class);
        application.addMessage(new ApplicationMessage(message, args, type));
    }

    @Deprecated
    public static <T> T getService(Class<T> clazz) {
        UIPortalApplication portalApplication = Util.getUIPortalApplication();
        return clazz.cast(portalApplication.getApplicationComponent(clazz));
    }

    @Deprecated
    public static SessionProvider getSessionProvider() {
        return WCMCoreUtils.getUserSessionProvider();
    }

    @Deprecated
    public static SessionProvider getSystemSessionProvider() {
        return WCMCoreUtils.getSystemSessionProvider();
    }

    public static String getPortletPreference(String preferenceName) {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        return preferences.getValue(preferenceName, null);
    }

    public static PortletPreferences getAllPortletPreferences() {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        return portletRequestContext.getRequest().getPreferences();
    }

    public static boolean isViewable(Node node) {
        try {
            node.refresh(true);
            ((ExtendedNode)node).checkPermission("read");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Node getRealNode(Node node) throws Exception {
        if (node.isNodeType("nt:frozenNode")) {
            String uuid = node.getProperty("jcr:frozenUuid").getString();
            return node.getSession().getNodeByUUID(uuid);
        }
        return node;
    }

    public static String getRealNodePath(Node node) throws Exception {
        if (node.isNodeType("nt:frozenNode")) {
            Node realNode = Utils.getRealNode(node);
            return Text.escape((String)realNode.getPath(), (char)'%', (boolean)true) + "?version=" + node.getParent().getName();
        }
        return Text.escape((String)node.getPath(), (char)'%', (boolean)true);
    }

    public static String getWebdavURL(Node node) throws Exception {
        return Utils.getWebdavURL(node, true);
    }

    public static String getWebdavURL(Node node, boolean withTimeParam) throws Exception {
        return Utils.getWebdavURL(node, withTimeParam, true);
    }

    public static String getWebdavURL(Node node, boolean withTimeParam, boolean isGetRealNodePath) throws Exception {
        NodeLocation location = NodeLocation.getNodeLocationByNode((Node)Utils.getRealNode(node));
        String repository = location.getRepository();
        String workspace = location.getWorkspace();
        String currentProtal = PortalContainer.getCurrentRestContextName();
        String portalName = PortalContainer.getCurrentPortalContainerName();
        String originalNodePath = isGetRealNodePath ? Utils.getRealNodePath(node) : Text.escape((String)node.getPath(), (char)'%', (boolean)true);
        StringBuffer imagePath = new StringBuffer();
        imagePath.append("/").append(portalName).append("/").append(currentProtal).append("/jcr/").append(repository).append("/").append(workspace).append(originalNodePath);
        if (withTimeParam) {
            if (imagePath.indexOf("?") > 0) {
                imagePath.append("&time=");
            } else {
                imagePath.append("?time=");
            }
            imagePath.append(System.currentTimeMillis());
        }
        return imagePath.toString();
    }

    public static Node getRealNode(String strRepository, String strWorkspace, String strIdentifier, boolean isWCMBase) throws RepositoryException {
        return Utils.getRealNode(strRepository, strWorkspace, strIdentifier, isWCMBase, "user");
    }

    public static Node getRealNode(String strRepository, String strWorkspace, String strIdentifier, boolean isWCMBase, String cacheVisibility) throws RepositoryException {
        LinkManager linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        Node selectedNode = isWCMBase ? Utils.getViewableNodeByComposer(strRepository, strWorkspace, strIdentifier, "base", cacheVisibility) : Utils.getViewableNodeByComposer(strRepository, strWorkspace, strIdentifier, null, cacheVisibility);
        if (selectedNode != null && !org.exoplatform.ecm.webui.utils.Utils.isInTrash(selectedNode)) {
            if (linkManager.isLink((Item)selectedNode)) {
                if (linkManager.isTargetReachable(selectedNode) && !org.exoplatform.ecm.webui.utils.Utils.isInTrash(selectedNode = linkManager.getTarget(selectedNode))) {
                    return selectedNode;
                }
            } else {
                return selectedNode;
            }
        }
        return null;
    }

    public static boolean hasEditPermissionOnPage() throws Exception {
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIWorkingWorkspace uiWorkingWS = (UIWorkingWorkspace)portalApp.getChildById("UIWorkingWorkspace");
        UIPageBody pageBody = (UIPageBody)uiWorkingWS.findFirstComponentOfType(UIPageBody.class);
        UIPage uiPage = (UIPage)pageBody.getUIComponent();
        UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
        if (uiPage != null) {
            return userACL.hasEditPermissionOnPage(uiPage.getOwnerType(), uiPage.getOwnerId(), uiPage.getEditPermission());
        }
        UIPortal currentUIPortal = (UIPortal)((UIWorkingWorkspace)portalApp.findComponentById("UIWorkingWorkspace")).findFirstComponentOfType(UIPortal.class);
        UserNode currentNode = currentUIPortal.getSelectedUserNode();
        String pageReference = currentNode.getPageRef();
        if (pageReference == null) {
            return false;
        }
        DataStorage dataStorage = (DataStorage)portalApp.getApplicationComponent(DataStorage.class);
        Page page = dataStorage.getPage(pageReference);
        if (page == null) {
            return false;
        }
        return userACL.hasEditPermission(page);
    }

    public static boolean hasEditPermissionOnNavigation() throws Exception {
        UserNavigation selectedNavigation = Utils.getSelectedNavigation();
        if (selectedNavigation == null) {
            return false;
        }
        return selectedNavigation.isModifiable();
    }

    public static boolean hasEditPermissionOnPortal() throws Exception {
        UIPortalApplication portalApp = Util.getUIPortalApplication();
        UIPortal currentUIPortal = (UIPortal)((UIWorkingWorkspace)portalApp.findComponentById("UIWorkingWorkspace")).findFirstComponentOfType(UIPortal.class);
        UserACL userACL = (UserACL)portalApp.getApplicationComponent(UserACL.class);
        return userACL.hasEditPermissionOnPortal(currentUIPortal.getSiteKey().getTypeName(), currentUIPortal.getSiteKey().getName(), currentUIPortal.getEditPermission());
    }

    public static UserNavigation getSelectedNavigation() throws Exception {
        return NavigationUtils.getUserNavigationOfPortal((UserPortal)Util.getPortalRequestContext().getUserPortalConfig().getUserPortal(), (String)Util.getUIPortal().getSiteKey().getName());
    }

    public static String sanitize(String value) {
        try {
            cservice_ = (ConfigurationManager)WCMCoreUtils.getService(ConfigurationManager.class);
            InputStream in = cservice_.getInputStream(POLICY_FILE_LOCATION);
            Policy policy = Policy.getInstance((InputStream)in);
            AntiSamy as = new AntiSamy();
            CleanResults cr = as.scan(value, policy);
            value = cr.getCleanHTML();
            return value;
        }
        catch (Exception ex) {
            return value;
        }
    }

    public static String sanitizeSearch(String value) {
        try {
            value = Utils.sanitize(value);
            value = value.replaceAll("<iframe", "").replaceAll("<frame", "").replaceAll("<frameset", "");
            return value;
        }
        catch (Exception ex) {
            return value;
        }
    }

    public static boolean isEmptyContent(String inputValue) {
        boolean isEmpty = true;
        inputValue = inputValue.trim().replaceAll("<p>", "").replaceAll("</p>", "");
        inputValue = inputValue.replaceAll("\n", "").replaceAll("\t", "");
        if ((inputValue = inputValue.replaceAll("&nbsp;", "")) != null && inputValue.length() > 0) {
            return false;
        }
        return isEmpty;
    }

    public static boolean checkQuery(String workspace, String strQuery, String SQLLanguage) {
        try {
            Session session = WCMCoreUtils.getUserSessionProvider().getSession(workspace, ((RepositoryService)WCMCoreUtils.getService(RepositoryService.class)).getCurrentRepository());
            QueryManager qm = session.getWorkspace().getQueryManager();
            Query query = qm.createQuery(strQuery, SQLLanguage);
            query.execute();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static HashSet<String> getQueryParams(String sqlQuery) {
        HashSet<String> params = new HashSet<String>();
        if (sqlQuery == null) {
            return params;
        }
        Matcher matcher = Pattern.compile(SQL_PARAM_PATTERN).matcher(sqlQuery);
        while (matcher.find()) {
            String param = matcher.group();
            param = param.replaceAll("\\$\\{", "").replaceAll("\\}", "");
            params.add(param);
        }
        return params;
    }

    public static String buildQuery(String sqlQuery, HashMap<String, String> params) {
        if (!Utils.hasParam(sqlQuery) || params == null || params.isEmpty()) {
            return sqlQuery;
        }
        String query = sqlQuery;
        for (String param : params.keySet()) {
            query = query.replaceAll("\\$\\{" + param + "\\}", params.get(param));
        }
        return query;
    }

    public static boolean hasParam(String sqlQuery) {
        if (sqlQuery == null || sqlQuery.trim().length() == 0) {
            return false;
        }
        return Pattern.compile(SQL_PARAM_PATTERN).matcher(sqlQuery).find();
    }

    public static String getDownloadLink(Node node) throws Exception {
        if (!Utils.getRealNode(node).getPrimaryNodeType().getName().equals(NT_FILE)) {
            return null;
        }
        DownloadService dservice = (DownloadService)WCMCoreUtils.getService(DownloadService.class);
        Node jcrContentNode = node.getNode(JCR_CONTENT);
        InputStream input = jcrContentNode.getProperty(JCR_DATA).getStream();
        String mimeType = jcrContentNode.getProperty(JCR_MIMETYPE).getString();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, mimeType);
        DMSMimeTypeResolver mimeTypeSolver = DMSMimeTypeResolver.getInstance();
        String ext = "." + mimeTypeSolver.getExtension(mimeType);
        String fileName = Utils.getRealNode(node).getName();
        if (fileName.lastIndexOf(ext) < 0 && !mimeTypeSolver.getMimeType(fileName).equals(mimeType)) {
            dresource.setDownloadName(fileName + ext);
        } else {
            dresource.setDownloadName(fileName);
        }
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public static Node getFileLangNode(Node currentNode) throws Exception {
        if (currentNode.isNodeType(NT_UNSTRUCTURED) && currentNode.getNodes().getSize() > 0L) {
            NodeIterator nodeIter = currentNode.getNodes();
            while (nodeIter.hasNext()) {
                Node ntFile = nodeIter.nextNode();
                if (!ntFile.getPrimaryNodeType().getName().equals(NT_FILE)) continue;
                return ntFile;
            }
            return currentNode;
        }
        return currentNode;
    }
}

