/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.jbosscache;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.IndexerCacheLoader;
import org.exoplatform.services.jcr.impl.core.query.jbosscache.JBossCacheIndexChangesFilter;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Fqn;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.loader.SingletonStoreCacheLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexerSingletonStoreCacheLoader
extends SingletonStoreCacheLoader {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.IndexerSingletonStoreCacheLoader");

    protected void activeStatusChanged(final boolean newActiveState) throws SingletonStoreCacheLoader.PushStateException {
        new Thread(new Runnable(){

            public void run() {
                IndexerSingletonStoreCacheLoader.this.setIndexerMode(newActiveState);
                try {
                    IndexerSingletonStoreCacheLoader.super.activeStatusChanged(newActiveState);
                }
                catch (SingletonStoreCacheLoader.PushStateException e) {
                    LOG.error((Object)"Failed to initiate PushState.", (Throwable)e);
                }
            }
        }, "JCR Indexer ActiveStatusChanged-handler").start();
    }

    protected Callable<?> createPushStateTask() {
        return new Callable(){

            public Object call() throws Exception {
                boolean debugEnabled = LOG.isDebugEnabled();
                if (debugEnabled) {
                    LOG.debug((Object)"start pushing in-memory state to cache cacheLoader collection");
                }
                Set children = IndexerSingletonStoreCacheLoader.this.cache.getRoot().getChildren();
                for (NodeSPI wsChildren : children) {
                    HashSet<String> removedNodes = new HashSet<String>();
                    HashSet<String> addedNodes = new HashSet<String>();
                    HashSet<String> parentRemovedNodes = new HashSet<String>();
                    HashSet<String> parentAddedNodes = new HashSet<String>();
                    Set changes = wsChildren.getChildren();
                    for (NodeSPI aChildren : changes) {
                        Fqn fqn = aChildren.getFqn();
                        Object value = IndexerSingletonStoreCacheLoader.this.cache.get(fqn, (Object)JBossCacheIndexChangesFilter.LISTWRAPPER);
                        if (!(value instanceof ChangesFilterListsWrapper)) continue;
                        ChangesFilterListsWrapper listsWrapper = (ChangesFilterListsWrapper)value;
                        if (listsWrapper.withChanges()) {
                            if (listsWrapper.getChanges() != null) {
                                addedNodes.addAll(listsWrapper.getChanges().getAddIds());
                                removedNodes.addAll(listsWrapper.getChanges().getRemove());
                            }
                            if (listsWrapper.getParentChanges() == null) continue;
                            parentAddedNodes.addAll(listsWrapper.getParentChanges().getAddIds());
                            parentRemovedNodes.addAll(listsWrapper.getParentChanges().getRemove());
                            continue;
                        }
                        addedNodes.addAll(listsWrapper.getAddedNodes());
                        removedNodes.addAll(listsWrapper.getRemovedNodes());
                        parentAddedNodes.addAll(listsWrapper.getParentAddedNodes());
                        parentRemovedNodes.addAll(listsWrapper.getParentAddedNodes());
                    }
                    String id = IdGenerator.generate();
                    IndexerSingletonStoreCacheLoader.this.cache.put(Fqn.fromRelativeElements((Fqn)wsChildren.getFqn(), (Object[])new String[]{id}), (Object)JBossCacheIndexChangesFilter.LISTWRAPPER, (Object)new ChangesFilterListsWrapper(addedNodes, removedNodes, parentAddedNodes, parentRemovedNodes));
                    for (NodeSPI aChildren : children) {
                        IndexerSingletonStoreCacheLoader.this.cache.getInvocationContext().getOptionOverrides().setForceAsynchronous(true);
                        IndexerSingletonStoreCacheLoader.this.cache.removeNode(aChildren.getFqn());
                    }
                }
                if (debugEnabled) {
                    LOG.debug((Object)"in-memory state passed to cache cacheLoader successfully");
                }
                return null;
            }
        };
    }

    public Object put(Fqn name, Object key, Object value) throws Exception {
        return this.getCacheLoader().put(name, key, value);
    }

    protected void setIndexerMode(boolean writeEnabled) {
        if (this.getCacheLoader() instanceof IndexerCacheLoader) {
            ((IndexerCacheLoader)this.getCacheLoader()).setMode(writeEnabled ? IndexerIoMode.READ_WRITE : IndexerIoMode.READ_ONLY);
            LOG.info((Object)("Set indexer io mode to:" + (Object)((Object)(writeEnabled ? IndexerIoMode.READ_WRITE : IndexerIoMode.READ_ONLY))));
        }
    }
}

