/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.tree;

import java.util.MissingResourceException;
import javax.jcr.Node;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.util.Text;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIRightClickPopupMenu;
import org.exoplatform.webui.core.UITree;

@ComponentConfig(template="system:/groovy/webui/core/UITree.gtmpl", events={@EventConfig(listeners={UITree.ChangeNodeActionListener.class})})
public class UINodeTree
extends UITree {
    private static final Log LOG = ExoLogger.getLogger((String)UINodeTree.class.getName());
    private String rootPath = "";
    private boolean isTaxonomyLocalize;

    public boolean isTaxonomyLocalize() {
        return this.isTaxonomyLocalize;
    }

    public void setTaxonomyLocalize(boolean isTaxonomyLocalize) {
        this.isTaxonomyLocalize = isTaxonomyLocalize;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public String renderNode(Object obj) throws Exception {
        String beanIconField;
        Node node = (Node)obj;
        String nodeTypeIcon = Utils.getNodeTypeIcon(node, "16x16Icon");
        String nodeIcon = this.getExpandIcon();
        String iconGroup = this.getIcon();
        String note = "";
        if (this.isSelected(obj)) {
            nodeIcon = this.getColapseIcon();
            iconGroup = this.getSelectedIcon();
            note = " NodeSelected";
        }
        if ((beanIconField = this.getBeanIconField()) != null && beanIconField.length() > 0 && this.getFieldValue(obj, beanIconField) != null) {
            iconGroup = (String)this.getFieldValue(obj, beanIconField);
        }
        String objId = Utils.formatNodeName(String.valueOf(this.getId(obj)));
        String actionLink = this.event("ChangeNode", objId);
        StringBuilder builder = new StringBuilder();
        if (nodeIcon.equals(this.getExpandIcon())) {
            builder.append(" <a class=\"").append(nodeIcon).append(" ").append(nodeTypeIcon).append("\" href=\"").append(actionLink).append("\">");
        } else {
            builder.append(" <a class=\"").append(nodeIcon).append(" ").append(nodeTypeIcon).append("\" onclick=\"eXo.portal.UIPortalControl.collapseTree(this)").append("\">");
        }
        UIRightClickPopupMenu popupMenu = this.getUiPopupMenu();
        String beanFieldValue = this.getDisplayFieldValue(obj);
        beanFieldValue = Text.unescapeIllegalJcrChars((String)Utils.getTitle(node));
        String className = "NodeIcon";
        boolean flgSymlink = false;
        if (Utils.isSymLink(node)) {
            flgSymlink = true;
            className = "NodeIconLink";
        }
        if (popupMenu == null) {
            builder.append(" <div class=\"").append(className).append(" ").append(iconGroup).append(" ").append(nodeTypeIcon).append(note).append("\"").append(" title=\"").append(beanFieldValue).append("\"").append(">");
            if (flgSymlink) {
                builder.append("  <div class=\"LinkSmall\">").append(beanFieldValue).append("</div>");
            } else {
                builder.append(beanFieldValue);
            }
            builder.append("</div>");
        } else {
            builder.append(" <div class=\"").append(className).append(" ").append(iconGroup).append(" ").append(nodeTypeIcon).append(note).append("\" ").append(popupMenu.getJSOnclickShowPopup(objId, null)).append(" title=\"").append(beanFieldValue).append("\"").append(">");
            if (flgSymlink) {
                builder.append("  <div class=\"LinkSmall\">").append(beanFieldValue).append("</div>");
            } else {
                builder.append(beanFieldValue);
            }
            builder.append("</div>");
        }
        builder.append(" </a>");
        return builder.toString();
    }

    private String getDisplayFieldValue(Object bean) throws Exception {
        block3: {
            if (this.isTaxonomyLocalize && Node.class.isInstance(bean)) {
                String path = ((Node)bean).getPath();
                String taxonomyTreeName = this.rootPath.substring(this.rootPath.lastIndexOf("/") + 1);
                try {
                    String display = taxonomyTreeName.concat(path.replace(this.rootPath, "")).replaceAll("/", ".");
                    return Utils.getResourceBundle("eXoTaxonomies.".concat(display).concat(".label"));
                }
                catch (MissingResourceException me) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn((Object)me.getMessage());
                }
            }
        }
        return String.valueOf(this.getFieldValue(bean, this.getBeanLabelField()));
    }

    public boolean isSelected(Object obj) throws Exception {
        Node selectedNode = (Node)this.getSelected();
        Node node = (Node)obj;
        if (selectedNode == null) {
            return false;
        }
        return selectedNode.getPath().equals(node.getPath());
    }
}

