/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.version.Version;
import javax.portlet.PortletMode;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.ecm.publication.IncorrectStateUpdateLifecycleException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.extensions.publication.impl.PublicationManagerImpl;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.authoring.ui.UIPublicationContainer;
import org.exoplatform.services.wcm.extensions.publication.lifecycle.impl.LifecyclesConfig;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.StageAndVersionPublicationPlugin;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.config.VersionData;
import org.exoplatform.services.wcm.publication.lifecycle.stageversion.config.VersionLog;
import org.exoplatform.services.wcm.publication.listener.navigation.NavigationEventListenerDelegate;
import org.exoplatform.services.wcm.publication.listener.page.PageEventListenerDelegate;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthoringPublicationPlugin
extends StageAndVersionPublicationPlugin {
    private static final Log LOG = ExoLogger.getLogger((String)AuthoringPublicationPlugin.class.getName());
    private PageEventListenerDelegate pageEventListenerDelegate = new PageEventListenerDelegate("Authoring publication", null);
    private NavigationEventListenerDelegate navigationEventListenerDelegate = new NavigationEventListenerDelegate("Authoring publication", null);

    public void changeState(Node node, String newState, HashMap<String, String> context) throws IncorrectStateUpdateLifecycleException, Exception {
        ListenerService listenerService;
        VersionData versionData;
        String containerName;
        ValueFactory valueFactory;
        VersionLog versionLog;
        Map<String, VersionData> revisionsMap;
        Node selectedRevision;
        String userId;
        String logItemName;
        block56: {
            String versionName;
            logItemName = versionName = context.get("Publication.context.currentVersion");
            userId = "";
            try {
                userId = Util.getPortalRequestContext().getRemoteUser();
            }
            catch (Exception e) {
                userId = node.getSession().getUserID();
            }
            selectedRevision = null;
            if (node.getName().equals(versionName) || versionName == null) {
                selectedRevision = node;
                logItemName = node.getName();
            } else {
                selectedRevision = node.getVersionHistory().getVersion(versionName);
            }
            revisionsMap = this.getRevisionData(node);
            versionLog = null;
            valueFactory = node.getSession().getValueFactory();
            containerName = context.get("containerName");
            try {
                if (containerName == null) {
                    containerName = PortalContainer.getCurrentPortalContainerName();
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block56;
                LOG.warn((Object)e.getMessage());
            }
        }
        if ("pending".equals(newState)) {
            node.setProperty("publication:currentState", newState);
            versionLog = new VersionLog(logItemName, newState, userId, GregorianCalendar.getInstance(), "PublicationService.StageAndVersionPublicationPlugin.changeState.draft");
            this.addLog(node, versionLog);
            versionData = revisionsMap.get(node.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState(newState);
            } else {
                versionData = new VersionData(node.getUUID(), newState, userId);
            }
            revisionsMap.put(node.getUUID(), versionData);
            this.addRevisionData(node, revisionsMap.values());
        } else if ("approved".equals(newState)) {
            node.setProperty("publication:currentState", newState);
            versionLog = new VersionLog(logItemName, newState, userId, GregorianCalendar.getInstance(), "PublicationService.AuthoringPublicationPlugin.changeState.approved");
            this.addLog(node, versionLog);
            versionData = revisionsMap.get(node.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState(newState);
            } else {
                versionData = new VersionData(node.getUUID(), newState, userId);
            }
            revisionsMap.put(node.getUUID(), versionData);
            this.addRevisionData(node, revisionsMap.values());
        } else if ("staged".equals(newState)) {
            node.setProperty("publication:currentState", newState);
            versionLog = new VersionLog(logItemName, newState, userId, GregorianCalendar.getInstance(), "PublicationService.AuthoringPublicationPlugin.changeState.staged");
            this.addLog(node, versionLog);
            versionData = revisionsMap.get(node.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState(newState);
            } else {
                versionData = new VersionData(node.getUUID(), newState, userId);
            }
            revisionsMap.put(node.getUUID(), versionData);
            this.addRevisionData(node, revisionsMap.values());
        } else if ("enrolled".equalsIgnoreCase(newState)) {
            versionLog = new VersionLog(logItemName, newState, userId, GregorianCalendar.getInstance(), "PublicationService.StageAndVersionPublicationPlugin.changeState.enrolled");
            node.setProperty("publication:currentState", newState);
            VersionData revisionData = new VersionData(node.getUUID(), newState, userId);
            revisionsMap.put(node.getUUID(), revisionData);
            this.addRevisionData(node, revisionsMap.values());
            this.addLog(node, versionLog);
        } else if ("unpublished".equalsIgnoreCase(newState)) {
            versionLog = new VersionLog(selectedRevision.getName(), "unpublished", userId, (Calendar)new GregorianCalendar(), "PublicationService.AuthoringPublicationPlugin.changeState.unpublished");
            VersionData selectedVersionData = revisionsMap.get(selectedRevision.getUUID());
            if (selectedVersionData != null) {
                selectedVersionData.setAuthor(userId);
                selectedVersionData.setState("unpublished");
            } else {
                selectedVersionData = new VersionData(selectedRevision.getUUID(), "unpublished", userId);
            }
            VersionData versionData2 = revisionsMap.get(node.getUUID());
            if (versionData2 != null) {
                versionData2.setAuthor(userId);
                versionData2.setState("unpublished");
            } else {
                versionData2 = new VersionData(selectedRevision.getUUID(), "unpublished", userId);
            }
            revisionsMap.put(node.getUUID(), versionData2);
            revisionsMap.put(selectedRevision.getUUID(), selectedVersionData);
            this.addLog(node, versionLog);
            node.setProperty("publication:currentState", "unpublished");
            Value value = valueFactory.createValue(selectedRevision);
            Value liveRevision = null;
            if (node.hasProperty("publication:liveRevision")) {
                liveRevision = node.getProperty("publication:liveRevision").getValue();
            }
            if (liveRevision != null && value.getString().equals(liveRevision.getString())) {
                node.setProperty("publication:liveRevision", valueFactory.createValue(""));
            }
            this.addRevisionData(node, revisionsMap.values());
        } else if ("obsolete".equals(newState)) {
            node.setProperty("publication:currentState", newState);
            versionLog = new VersionLog(selectedRevision.getName(), newState, userId, GregorianCalendar.getInstance(), "PublicationService.AuthoringPublicationPlugin.changeState.obsoleted");
            this.addLog(node, versionLog);
            versionData = revisionsMap.get(selectedRevision.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState(newState);
            } else {
                versionData = new VersionData(selectedRevision.getUUID(), newState, userId);
            }
            revisionsMap.put(selectedRevision.getUUID(), versionData);
            this.addRevisionData(node, revisionsMap.values());
        } else if ("archived".equalsIgnoreCase(newState)) {
            Value value = valueFactory.createValue(selectedRevision);
            Value liveRevision = node.getProperty("publication:liveRevision").getValue();
            if (liveRevision != null && value.getString().equals(liveRevision.getString())) {
                node.setProperty("publication:liveRevision", valueFactory.createValue(""));
            }
            versionLog = new VersionLog(selectedRevision.getName(), "archived", userId, (Calendar)new GregorianCalendar(), "PublicationService.AuthoringPublicationPlugin.changeState.archived");
            VersionData versionData3 = revisionsMap.get(selectedRevision.getUUID());
            if (versionData3 != null) {
                versionData3.setAuthor(userId);
                versionData3.setState("archived");
            } else {
                versionData3 = new VersionData(selectedRevision.getUUID(), "archived", userId);
            }
            revisionsMap.put(selectedRevision.getUUID(), versionData3);
            this.addLog(node, versionLog);
            node.setProperty("publication:currentState", "archived");
            this.addRevisionData(node, revisionsMap.values());
        } else if ("draft".equalsIgnoreCase(newState)) {
            node.setProperty("publication:currentState", newState);
            versionLog = new VersionLog(logItemName, newState, userId, GregorianCalendar.getInstance(), "PublicationService.StageAndVersionPublicationPlugin.changeState.draft");
            this.addLog(node, versionLog);
            versionData = revisionsMap.get(node.getUUID());
            if (versionData != null) {
                versionData.setAuthor(userId);
                versionData.setState(newState);
            } else {
                versionData = new VersionData(node.getUUID(), newState, userId);
            }
            revisionsMap.put(node.getUUID(), versionData);
            this.addRevisionData(node, revisionsMap.values());
        } else if ("published".equals(newState)) {
            if (!node.isCheckedOut()) {
                node.checkout();
            }
            Version liveVersion = node.checkin();
            node.checkout();
            Node oldLiveRevision = this.getLiveRevision(node);
            if (oldLiveRevision != null) {
                VersionData versionData4 = revisionsMap.get(oldLiveRevision.getUUID());
                if (versionData4 != null) {
                    versionData4.setAuthor(userId);
                    versionData4.setState("unpublished");
                } else {
                    versionData4 = new VersionData(oldLiveRevision.getUUID(), "unpublished", userId);
                }
                revisionsMap.put(oldLiveRevision.getUUID(), versionData4);
                versionLog = new VersionLog(oldLiveRevision.getName(), "unpublished", userId, (Calendar)new GregorianCalendar(), "PublicationService.AuthoringPublicationPlugin.changeState.unpublished");
                this.addLog(node, versionLog);
            }
            versionLog = new VersionLog(liveVersion.getName(), newState, userId, (Calendar)new GregorianCalendar(), "PublicationService.AuthoringPublicationPlugin.changeState.published");
            this.addLog(node, versionLog);
            node.setProperty("publication:currentState", "published");
            VersionData editableRevision = revisionsMap.get(node.getUUID());
            if (editableRevision != null) {
                String lifecycleName;
                PublicationManagerImpl publicationManagerImpl = (PublicationManagerImpl)WCMCoreUtils.getService(PublicationManagerImpl.class, (String)containerName);
                LifecyclesConfig.Lifecycle lifecycle = publicationManagerImpl.getLifecycle(lifecycleName = node.getProperty("publication:lifecycle").getString());
                List<LifecyclesConfig.State> states = lifecycle.getStates();
                if (states == null || states.size() <= 0) {
                    editableRevision.setState("enrolled");
                } else {
                    editableRevision.setState(states.get(0).getState());
                }
                editableRevision.setAuthor(userId);
            } else {
                editableRevision = new VersionData(node.getUUID(), "enrolled", userId);
            }
            revisionsMap.put(node.getUUID(), editableRevision);
            versionLog = new VersionLog(node.getBaseVersion().getName(), "draft", userId, (Calendar)new GregorianCalendar(), "PublicationService.StageAndVersionPublicationPlugin.changeState.enrolled");
            Value liveVersionValue = valueFactory.createValue((Node)liveVersion);
            node.setProperty("publication:liveRevision", liveVersionValue);
            node.setProperty("publication:liveDate", (Calendar)new GregorianCalendar());
            VersionData liveRevisionData = new VersionData(liveVersion.getUUID(), "published", userId);
            revisionsMap.put(liveVersion.getUUID(), liveRevisionData);
            this.addRevisionData(node, revisionsMap.values());
        }
        if (!"__system".equals(userId)) {
            node.setProperty("publication:lastUser", userId);
        }
        if (!node.isNew()) {
            node.save();
        }
        if (!"enrolled".equalsIgnoreCase(newState)) {
            listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class);
            CmsService cmsService = (CmsService)WCMCoreUtils.getService(CmsService.class);
            if ("true".equalsIgnoreCase(context.get("Publication.context.isInitialPhase"))) {
                listenerService.broadcast("PublicationService.event.postInitState", (Object)cmsService, (Object)node);
            } else {
                listenerService.broadcast("PublicationService.event.postChangeState", (Object)cmsService, (Object)node);
            }
        }
        listenerService = (ListenerService)WCMCoreUtils.getService(ListenerService.class, (String)containerName);
        listenerService.broadcast("PublicationService.event.postUpdateState", null, (Object)node);
    }

    public String[] getPossibleStates() {
        return new String[]{"enrolled", "draft", "pending", "published", "obsolete"};
    }

    public String getLifecycleName() {
        return "Authoring publication";
    }

    public String getLifecycleType() {
        return "publication:authoringPublication";
    }

    public UIForm getStateUI(Node node, UIComponent component) throws Exception {
        UIPublicationContainer publicationContainer = (UIPublicationContainer)component.createUIComponent(UIPublicationContainer.class, null, null);
        publicationContainer.initContainer(node);
        return publicationContainer;
    }

    public void addMixin(Node node) throws Exception {
        node.addMixin("publication:authoringPublication");
        String nodetypes = System.getProperty("wcm.nodetypes.ignoreversion");
        if (nodetypes == null || nodetypes.length() == 0) {
            nodetypes = "exo:webContent";
        }
        if (Utils.isMakeVersionable((Node)node, (String[])nodetypes.split(",")) && !node.isNodeType("mix:versionable")) {
            node.addMixin("mix:versionable");
        }
    }

    public boolean canAddMixin(Node node) throws Exception {
        return node.canAddMixin("publication:authoringPublication");
    }

    public void updateLifecycleOnChangeNavigation(NavigationContext navigationContext, String remoteUser) throws Exception {
        this.navigationEventListenerDelegate.updateLifecycleOnChangeNavigation(navigationContext, remoteUser, (WebpagePublicationPlugin)this);
    }

    public void updateLifecycleOnRemovePage(Page page, String remoteUser) throws Exception {
        this.pageEventListenerDelegate.updateLifecycleOnRemovePage(page, remoteUser, (WebpagePublicationPlugin)this);
    }

    public void updateLifecyleOnChangePage(Page page, String remoteUser) throws Exception {
        this.pageEventListenerDelegate.updateLifecyleOnChangePage(page, remoteUser, (WebpagePublicationPlugin)this);
    }

    public void updateLifecyleOnCreateNavigation(NavigationContext navigationContext) throws Exception {
        this.navigationEventListenerDelegate.updateLifecyleOnCreateNavigation(navigationContext);
    }

    public void updateLifecyleOnCreatePage(Page page, String remoteUser) throws Exception {
        this.pageEventListenerDelegate.updateLifecyleOnCreatePage(page, remoteUser, (WebpagePublicationPlugin)this);
    }

    public void updateLifecyleOnRemoveNavigation(NavigationContext navigationContext) throws Exception {
        this.navigationEventListenerDelegate.updateLifecyleOnRemoveNavigation(navigationContext);
    }

    private void addLog(Node node, VersionLog versionLog) throws Exception {
        Value[] values = node.getProperty("publication:history").getValues();
        ValueFactory valueFactory = node.getSession().getValueFactory();
        ArrayList<Value> list = new ArrayList<Value>(Arrays.asList(values));
        list.add(valueFactory.createValue(versionLog.toString()));
        node.setProperty("publication:history", list.toArray(new Value[0]));
    }

    private void addRevisionData(Node node, Collection<VersionData> list) throws Exception {
        ArrayList<Value> valueList = new ArrayList<Value>();
        ValueFactory factory = node.getSession().getValueFactory();
        for (VersionData versionData : list) {
            valueList.add(factory.createValue(versionData.toStringValue()));
        }
        node.setProperty("publication:revisionData", valueList.toArray(new Value[0]));
    }

    private Map<String, VersionData> getRevisionData(Node node) throws Exception {
        HashMap<String, VersionData> map = new HashMap<String, VersionData>();
        try {
            for (Value v : node.getProperty("publication:revisionData").getValues()) {
                VersionData versionData = VersionData.toVersionData((String)v.getString());
                map.put(versionData.getUUID(), versionData);
            }
        }
        catch (Exception e) {
            return map;
        }
        return map;
    }

    public void updateLifecyleOnChangeContent(Node node, String remoteUser, String newState) throws Exception {
        PublicationManagerImpl publicationManagerImpl;
        LifecyclesConfig.Lifecycle lifecycle;
        List<LifecyclesConfig.State> states;
        String state = node.getProperty("publication:currentState").getString();
        if (newState == null && (states = (lifecycle = (publicationManagerImpl = (PublicationManagerImpl)WCMCoreUtils.getService(PublicationManagerImpl.class)).getLifecycle(node.getProperty("publication:lifecycle").getString())).getStates()) != null && states.size() > 0) {
            newState = states.get(0).getState();
        }
        if (state.equals(newState)) {
            return;
        }
        HashMap<String, String> context = new HashMap<String, String>();
        this.changeState(node, newState, context);
    }

    private Node getLiveRevision(Node node) {
        try {
            String nodeVersionUUID = node.getProperty("publication:liveRevision").getString();
            if ("".equals(nodeVersionUUID) && "published".equals(node.getProperty("publication:currentState").getString())) {
                return node;
            }
            return node.getVersionHistory().getSession().getNodeByUUID(nodeVersionUUID);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Node getNodeView(Node node, Map<String, Object> context) throws Exception {
        WCMPublicationService wcmPublicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
        String currentState = wcmPublicationService.getContentState(node);
        if ("enrolled".equals(currentState) || "unpublished".equals(currentState)) {
            return null;
        }
        if (context == null || context.get("filter-mode").equals("Edit") || PortletMode.EDIT.toString().equals(context.get("portlet-mode"))) {
            return node;
        }
        Node liveNode = this.getLiveRevision(node);
        if (liveNode != null) {
            if (liveNode.hasNode("jcr:frozenNode")) {
                return liveNode.getNode("jcr:frozenNode");
            }
            return liveNode;
        }
        return null;
    }
}

