/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.deployment.plugins;

import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.deployment.DeploymentDescriptor;
import org.exoplatform.services.deployment.DeploymentPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class XMLDeploymentPlugin
extends DeploymentPlugin {
    private ConfigurationManager configurationManager;
    private RepositoryService repositoryService;
    private static final Log LOG = ExoLogger.getLogger((String)XMLDeploymentPlugin.class.getName());

    public XMLDeploymentPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService) {
        super(initParams);
        this.configurationManager = configurationManager;
        this.repositoryService = repositoryService;
    }

    public void deploy(SessionProvider sessionProvider) throws Exception {
        ManageableRepository repository = this.repositoryService.getCurrentRepository();
        Iterator iterator = this.initParams.getObjectParamIterator();
        DeploymentDescriptor deploymentDescriptor = null;
        try {
            while (iterator.hasNext()) {
                ObjectParameter objectParameter = (ObjectParameter)iterator.next();
                deploymentDescriptor = (DeploymentDescriptor)objectParameter.getObject();
                String sourcePath = deploymentDescriptor.getSourcePath();
                String versionHistoryPath = deploymentDescriptor.getVersionHistoryPath();
                Boolean cleanupPublication = deploymentDescriptor.getCleanupPublication();
                InputStream inputStream = this.configurationManager.getInputStream(sourcePath);
                Session session = sessionProvider.getSession(deploymentDescriptor.getTarget().getWorkspace(), repository);
                session.importXML(deploymentDescriptor.getTarget().getNodePath(), inputStream, 0);
                if (cleanupPublication.booleanValue()) {
                    QueryManager manager = session.getWorkspace().getQueryManager();
                    String statement = "select * from nt:base where jcr:path LIKE '" + deploymentDescriptor.getTarget().getNodePath() + "/%'";
                    Query query = manager.createQuery(statement.toString(), "sql");
                    NodeIterator iter = query.execute().getNodes();
                    while (iter.hasNext()) {
                        Node node = iter.nextNode();
                        if (!node.hasProperty("publication:liveRevision") || !node.hasProperty("publication:currentState")) continue;
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("\"" + node.getName() + "\" publication lifecycle has been cleaned up"));
                        }
                        node.setProperty("publication:liveRevision", "");
                        node.setProperty("publication:currentState", "published");
                    }
                }
                if (versionHistoryPath != null && versionHistoryPath.length() > 0) {
                    Node currentNode = (Node)session.getItem(deploymentDescriptor.getTarget().getNodePath());
                    Map<String, String> mapHistoryValue = Utils.getMapImportHistory(this.configurationManager.getInputStream(versionHistoryPath));
                    Utils.processImportHistory(currentNode, this.configurationManager.getInputStream(versionHistoryPath), mapHistoryValue);
                }
                session.save();
                if (!LOG.isInfoEnabled()) continue;
                LOG.info((Object)(deploymentDescriptor.getSourcePath() + " is deployed succesfully into " + deploymentDescriptor.getTarget().getNodePath()));
            }
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)("deploy " + deploymentDescriptor.getSourcePath() + " into " + deploymentDescriptor.getTarget().getNodePath() + " is FAILURE at " + new Date().toString() + "\n"), (Throwable)ex);
            }
            throw ex;
        }
    }
}

