/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.seo.impl;

import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.ecm.utils.MessageDigester;
import org.exoplatform.ecm.utils.text.Text;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.seo.PageMetadataModel;
import org.exoplatform.services.seo.SEOConfig;
import org.exoplatform.services.seo.SEOService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SEOServiceImpl
implements SEOService {
    private ExoCache<String, Object> cache;
    public static String METADATA_BASE_PATH = "SEO";
    public static String METADATA_PAGE_PATH = "pages";
    public static String METADATA_CONTENT_PATH = "contents";
    public static String SITEMAP_NAME = "sitemaps";
    public static String ROBOTS_NAME = "robots";
    private static String PUBLIC_MODE = "public";
    private static String PRIVATE_MODE = "private";
    private List<String> robotsindex = new ArrayList<String>();
    private List<String> robotsfollow = new ArrayList<String>();
    private List<String> frequency = new ArrayList<String>();
    private SEOConfig seoConfig = null;
    private boolean isCached = true;

    public SEOServiceImpl(InitParams initParams) throws Exception {
        ObjectParameter param = initParams.getObjectParam("seo.config");
        if (param != null) {
            this.seoConfig = (SEOConfig)param.getObject();
            this.robotsindex = this.seoConfig.getRobotsIndex();
            this.robotsfollow = this.seoConfig.getRobotsFollow();
            this.frequency = this.seoConfig.getFrequency();
        }
        this.cache = WCMCoreUtils.getService(CacheService.class).getCacheInstance("wcm.seo");
    }

    @Override
    public List<String> getRobotsIndexOptions() {
        return this.robotsindex;
    }

    @Override
    public List<String> getRobotsFollowOptions() {
        return this.robotsfollow;
    }

    @Override
    public List<String> getFrequencyOptions() {
        return this.frequency;
    }

    @Override
    public void storePageMetadata(PageMetadataModel metaModel, String portalName, boolean onContent) throws Exception {
        String hash;
        String uri = metaModel.getUri();
        String pageReference = metaModel.getPageReference();
        String keyword = metaModel.getKeywords();
        String description = metaModel.getDescription();
        String robots = metaModel.getRobotsContent();
        String fullStatus = metaModel.getFullStatus();
        boolean sitemap = metaModel.getSitemap();
        float priority = metaModel.getPriority();
        String frequency = metaModel.getFrequency();
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Session session = null;
        LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
        Node dummyNode = livePortalManagerService.getLivePortal(sessionProvider, portalName);
        session = dummyNode.getSession();
        if (!dummyNode.hasNode(METADATA_BASE_PATH)) {
            dummyNode.addNode(METADATA_BASE_PATH);
            session.save();
        }
        if (!dummyNode.getNode(METADATA_BASE_PATH).hasNode(ROBOTS_NAME)) {
            dummyNode.getNode(METADATA_BASE_PATH).addNode(ROBOTS_NAME, "nt:file");
            Node robotsFolder = dummyNode.getNode(METADATA_BASE_PATH + "/" + ROBOTS_NAME);
            Node robotsNode = robotsFolder.addNode("jcr:content", "nt:resource");
            robotsNode.setProperty("jcr:mimeType", "text/plain");
            PortalRequestContext ctx = Util.getPortalRequestContext();
            StringBuffer robotsContent = new StringBuffer("# robots.txt \n");
            robotsContent.append("User-agent: * \n");
            robotsContent.append("Disallow: \n");
            if (ctx.getRequest().getServerPort() != 80) {
                robotsContent.append("Sitemap: ").append(ctx.getRequest().getScheme()).append("://").append(ctx.getRequest().getServerName()).append(":").append(ctx.getRequest().getServerPort()).append(ctx.getPortalURI()).append("sitemaps.xml \n");
            } else {
                robotsContent.append("Sitemap: ").append(ctx.getRequest().getScheme()).append("://").append(ctx.getRequest().getServerName()).append(ctx.getPortalURI()).append("sitemaps.xml \n");
            }
            robotsNode.setProperty("jcr:data", robotsContent.toString());
            robotsNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
            this.cache.put((Serializable)((Object)this.getHash(portalName + ROBOTS_NAME)), (Object)robotsContent);
        }
        Node seoNode = null;
        if (onContent) {
            seoNode = session.getNodeByUUID(uri);
            if (!seoNode.isNodeType("mix:referenceable")) {
                seoNode.addMixin("mix:referenceable");
            }
        } else {
            session = sessionProvider.getSession("portal-system", WCMCoreUtils.getRepository());
            String uuid = Util.getUIPortal().getSelectedUserNode().getId();
            seoNode = session.getNodeByUUID(uuid);
        }
        if (seoNode.isNodeType("exo:pageMetadata")) {
            seoNode.setProperty("exo:metaKeywords", keyword);
            seoNode.setProperty("exo:metaDescription", description);
            seoNode.setProperty("exo:metaFully", fullStatus);
            if (!onContent) {
                seoNode.setProperty("exo:metaRobots", robots);
                seoNode.setProperty("exo:metaSitemap", sitemap);
                seoNode.setProperty("exo:metaPriority", (double)priority);
                seoNode.setProperty("exo:metaFrequency", frequency);
                this.updateSiteMap(uri, priority, frequency, sitemap, portalName);
            }
            hash = null;
            hash = onContent ? this.getHash(uri) : this.getHash(pageReference);
            if (hash != null) {
                this.cache.put((Serializable)((Object)hash), (Object)metaModel);
            }
        } else {
            hash = null;
            seoNode.addMixin("exo:pageMetadata");
            seoNode.setProperty("exo:metaKeywords", keyword);
            seoNode.setProperty("exo:metaDescription", description);
            seoNode.setProperty("exo:metaFully", fullStatus);
            if (onContent) {
                seoNode.setProperty("exo:metaUri", seoNode.getUUID());
                hash = this.getHash(seoNode.getUUID());
            } else {
                seoNode.setProperty("exo:metaUri", pageReference);
                seoNode.setProperty("exo:metaRobots", robots);
                seoNode.setProperty("exo:metaSitemap", sitemap);
                seoNode.setProperty("exo:metaPriority", (double)priority);
                seoNode.setProperty("exo:metaFrequency", frequency);
                this.updateSiteMap(uri, priority, frequency, sitemap, portalName);
                hash = this.getHash(pageReference);
            }
            if (hash != null) {
                this.cache.put((Serializable)((Object)hash), (Object)metaModel);
            }
        }
        session.save();
    }

    @Override
    public PageMetadataModel getMetadata(ArrayList<String> params, String pageReference) throws Exception {
        PageMetadataModel metaModel = null;
        metaModel = params != null ? this.getContentMetadata(params) : this.getPageMetadata(pageReference);
        return metaModel;
    }

    @Override
    public PageMetadataModel getContentMetadata(ArrayList<String> params) throws Exception {
        String hash;
        PageMetadataModel metaModel = null;
        String pageUri = null;
        Node contentNode = null;
        for (int i = 0; i < params.size() && (contentNode = this.getContentNode(params.get(i).toString())) == null; ++i) {
        }
        if (contentNode == null) {
            return null;
        }
        if (!contentNode.isNodeType("mix:referenceable")) {
            contentNode.addMixin("mix:referenceable");
        }
        if (this.cache.get((Serializable)((Object)(hash = this.getHash(contentNode.getUUID())))) != null) {
            metaModel = (PageMetadataModel)this.cache.get((Serializable)((Object)hash));
        }
        if (metaModel == null && contentNode.isNodeType("exo:pageMetadata")) {
            metaModel = new PageMetadataModel();
            metaModel.setUri(pageUri);
            if (contentNode.hasProperty("exo:metaKeywords")) {
                metaModel.setKeywords(contentNode.getProperty("exo:metaKeywords").getString());
            }
            if (contentNode.hasProperty("exo:metaDescription")) {
                metaModel.setDescription(contentNode.getProperty("exo:metaDescription").getString());
            }
            if (contentNode.hasProperty("exo:metaRobots")) {
                metaModel.setRobotsContent(contentNode.getProperty("exo:metaRobots").getString());
            }
            if (contentNode.hasProperty("exo:metaSitemap")) {
                metaModel.setSiteMap(Boolean.parseBoolean(contentNode.getProperty("exo:metaSitemap").getString()));
            }
            if (contentNode.hasProperty("exo:metaPriority")) {
                metaModel.setPriority(Long.parseLong(contentNode.getProperty("exo:metaPriority").getString()));
            }
            if (contentNode.hasProperty("exo:metaFrequency")) {
                metaModel.setFrequency(contentNode.getProperty("exo:metaFrequency").getString());
            }
            if (contentNode.hasProperty("exo:metaFully")) {
                metaModel.setFullStatus(contentNode.getProperty("exo:metaFully").getString());
            }
            this.cache.put((Serializable)((Object)hash), (Object)metaModel);
        }
        return metaModel;
    }

    @Override
    public PageMetadataModel getPageMetadata(String pageUri) throws Exception {
        String uuid;
        SessionProvider sessionProvider;
        Session session;
        Node pageNode;
        PageMetadataModel metaModel = null;
        String hash = this.getHash(pageUri);
        if (this.cache.get((Serializable)((Object)hash)) != null) {
            metaModel = (PageMetadataModel)this.cache.get((Serializable)((Object)hash));
        }
        if (metaModel == null && (pageNode = (session = (sessionProvider = WCMCoreUtils.getSystemSessionProvider()).getSession("portal-system", WCMCoreUtils.getRepository())).getNodeByUUID(uuid = Util.getUIPortal().getSelectedUserNode().getId())) != null && pageNode.isNodeType("exo:pageMetadata")) {
            metaModel = new PageMetadataModel();
            if (pageNode.hasProperty("exo:metaKeywords")) {
                metaModel.setKeywords(pageNode.getProperty("exo:metaKeywords").getString());
            }
            if (pageNode.hasProperty("exo:metaDescription")) {
                metaModel.setDescription(pageNode.getProperty("exo:metaDescription").getString());
            }
            if (pageNode.hasProperty("exo:metaRobots")) {
                metaModel.setRobotsContent(pageNode.getProperty("exo:metaRobots").getString());
            }
            if (pageNode.hasProperty("exo:metaSitemap")) {
                metaModel.setSiteMap(Boolean.parseBoolean(pageNode.getProperty("exo:metaSitemap").getString()));
            }
            if (pageNode.hasProperty("exo:metaPriority")) {
                metaModel.setPriority(Long.parseLong(pageNode.getProperty("exo:metaPriority").getString()));
            }
            if (pageNode.hasProperty("exo:metaFrequency")) {
                metaModel.setFrequency(pageNode.getProperty("exo:metaFrequency").getString());
            }
            if (pageNode.hasProperty("exo:metaFully")) {
                metaModel.setFullStatus(pageNode.getProperty("exo:metaFully").getString());
            }
            this.cache.put((Serializable)((Object)hash), (Object)metaModel);
        }
        return metaModel;
    }

    @Override
    public void removePageMetadata(PageMetadataModel metaModel, String portalName, boolean onContent) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository currentRepo = repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(currentRepo.getConfiguration().getDefaultWorkspaceName(), currentRepo);
        String hash = "";
        Node seoNode = null;
        if (onContent) {
            seoNode = session.getNodeByUUID(metaModel.getUri());
        } else {
            session = sessionProvider.getSession("portal-system", WCMCoreUtils.getRepository());
            String uuid = Util.getUIPortal().getSelectedUserNode().getId();
            seoNode = session.getNodeByUUID(uuid);
        }
        if (seoNode.isNodeType("exo:pageMetadata")) {
            seoNode.removeMixin("exo:pageMetadata");
            hash = onContent ? this.getHash(metaModel.getUri()) : this.getHash(metaModel.getPageReference());
            this.cache.remove((Serializable)((Object)hash));
        }
        session.save();
    }

    public void updateSiteMap(String uri, float priority, String frequency, boolean visibleSitemap, String portalName) throws Exception {
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
        Node dummyNode = livePortalManagerService.getLivePortal(sessionProvider, portalName);
        Session session = dummyNode.getSession();
        uri = this.getStandardURL(uri);
        String uri_clone = "";
        String public_path = "/" + PUBLIC_MODE + "/";
        String private_path = "/" + PRIVATE_MODE + "/";
        if (uri.indexOf(public_path) > 0) {
            uri_clone = uri.replaceFirst(public_path, private_path);
        } else if (uri.indexOf(private_path) > 0) {
            uri_clone = uri.replaceFirst(private_path, public_path);
        }
        String sitemapData = "";
        if (!dummyNode.getNode(METADATA_BASE_PATH).hasNode(SITEMAP_NAME)) {
            dummyNode.getNode(METADATA_BASE_PATH).addNode(SITEMAP_NAME, "nt:file");
            Node simapFolder = dummyNode.getNode(METADATA_BASE_PATH + "/" + SITEMAP_NAME);
            Node sitemapNode = simapFolder.addNode("jcr:content", "nt:resource");
            sitemapNode.setProperty("jcr:mimeType", "text/xml");
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("urlset");
            rootElement.setAttribute("xmlns", "http://www.sitemaps.org/schemas/sitemap/0.9");
            rootElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            rootElement.setAttribute("xsi:schemaLocation", "http://www.sitemaps.org/schemas/sitemap/0.9 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd");
            doc.appendChild(rootElement);
            if (visibleSitemap) {
                Element urlElement = doc.createElement("url");
                rootElement.appendChild(urlElement);
                Element locElement = doc.createElement("loc");
                locElement.setTextContent(uri);
                urlElement.appendChild(locElement);
                Element freqElement = doc.createElement("changefreq");
                freqElement.setTextContent(frequency);
                urlElement.appendChild(freqElement);
                Element priorityElement = doc.createElement("priority");
                priorityElement.setTextContent(String.valueOf(priority));
                urlElement.appendChild(priorityElement);
                if (uri_clone != null && uri_clone.length() > 0) {
                    urlElement = doc.createElement("url");
                    rootElement.appendChild(urlElement);
                    locElement = doc.createElement("loc");
                    locElement.setTextContent(uri_clone);
                    urlElement.appendChild(locElement);
                    freqElement = doc.createElement("changefreq");
                    freqElement.setTextContent(frequency);
                    urlElement.appendChild(freqElement);
                    priorityElement = doc.createElement("priority");
                    priorityElement.setTextContent(String.valueOf(priority));
                    urlElement.appendChild(priorityElement);
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            transformer.transform(source, new StreamResult(writer));
            sitemapData = writer.toString();
            sitemapNode.setProperty("jcr:data", sitemapData);
            sitemapNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
            session.save();
        } else {
            int i;
            Node sitemapFolder = dummyNode.getNode(METADATA_BASE_PATH + "/" + SITEMAP_NAME);
            Node sitemapNode = sitemapFolder.getNode("jcr:content");
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputStream stream = sitemapNode.getProperty("jcr:data").getStream();
            Document doc = docBuilder.parse(stream);
            boolean fLoc = false;
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            ArrayList<org.w3c.dom.Node> arrNodes = new ArrayList<org.w3c.dom.Node>();
            NodeList listOfUrls = doc.getElementsByTagName("url");
            for (i = 0; i < listOfUrls.getLength(); ++i) {
                Element urlElement;
                NodeList locList;
                Element locElement;
                String locationValue;
                org.w3c.dom.Node urlNode = listOfUrls.item(i);
                if (urlNode.getNodeType() != 1 || !((locationValue = (locElement = (Element)(locList = (urlElement = (Element)urlNode).getElementsByTagName("loc")).item(0)).getChildNodes().item(0).getNodeValue()) != null & (locationValue.trim().equals(uri) || locationValue.trim().equals(uri_clone)))) continue;
                fLoc = true;
                if (visibleSitemap) {
                    org.w3c.dom.Node freqNode = urlElement.getElementsByTagName("changefreq").item(0);
                    freqNode.setTextContent(frequency);
                    org.w3c.dom.Node priorityNode = urlElement.getElementsByTagName("priority").item(0);
                    priorityNode.setTextContent(String.valueOf(priority));
                    continue;
                }
                arrNodes.add(urlNode);
            }
            if (arrNodes != null && arrNodes.size() > 0) {
                for (i = 0; i < arrNodes.size(); ++i) {
                    root.removeChild((org.w3c.dom.Node)arrNodes.get(i));
                }
            }
            if (!fLoc && visibleSitemap) {
                Element urlElement = doc.createElement("url");
                Element locElement = doc.createElement("loc");
                locElement.setTextContent(uri);
                Element freqElement = doc.createElement("changefreq");
                freqElement.setTextContent(frequency);
                Element priorityElement = doc.createElement("priority");
                priorityElement.setTextContent(String.valueOf(priority));
                urlElement.appendChild(locElement);
                urlElement.appendChild(freqElement);
                urlElement.appendChild(priorityElement);
                root.appendChild(urlElement);
                if (uri_clone != null && uri_clone.length() > 0) {
                    urlElement = doc.createElement("url");
                    locElement = doc.createElement("loc");
                    locElement.setTextContent(uri_clone);
                    freqElement = doc.createElement("changefreq");
                    freqElement.setTextContent(frequency);
                    priorityElement = doc.createElement("priority");
                    priorityElement.setTextContent(String.valueOf(priority));
                    urlElement.appendChild(locElement);
                    urlElement.appendChild(freqElement);
                    urlElement.appendChild(priorityElement);
                    root.appendChild(urlElement);
                }
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            transformer.transform(source, new StreamResult(writer));
            sitemapData = writer.toString();
            sitemapNode.setProperty("jcr:data", sitemapData);
            sitemapNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
        }
        if (sitemapData != null && sitemapData.length() > 0) {
            String hash = this.getHash(portalName + SITEMAP_NAME);
            this.cache.put((Serializable)((Object)hash), (Object)sitemapData);
        }
        session.save();
    }

    @Override
    public String getSitemap(String portalName) throws Exception {
        String sitemapContent = null;
        String hash = this.getHash(portalName + SITEMAP_NAME);
        if (this.cache.get((Serializable)((Object)hash)) != null) {
            sitemapContent = (String)this.cache.get((Serializable)((Object)hash));
        }
        if (sitemapContent == null || sitemapContent.length() == 0) {
            SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
            LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
            Node dummyNode = livePortalManagerService.getLivePortal(sessionProvider, portalName);
            Session session = dummyNode.getSession();
            if (dummyNode.hasNode(METADATA_BASE_PATH) && dummyNode.getNode(METADATA_BASE_PATH).hasNode(SITEMAP_NAME)) {
                Node sitemapFolder = dummyNode.getNode(METADATA_BASE_PATH + "/" + SITEMAP_NAME);
                Node sitemapNode = sitemapFolder.getNode("jcr:content");
                DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
                InputStream stream = sitemapNode.getProperty("jcr:data").getStream();
                Document doc = docBuilder.parse(stream);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StringWriter writer = new StringWriter();
                transformer.transform(source, new StreamResult(writer));
                sitemapContent = writer.toString();
            } else {
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("urlset");
                doc.appendChild(rootElement);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource source = new DOMSource(doc);
                StringWriter writer = new StringWriter();
                transformer.transform(source, new StreamResult(writer));
                sitemapContent = writer.toString();
            }
            session.save();
            this.cache.put((Serializable)((Object)hash), (Object)sitemapContent);
        }
        return sitemapContent;
    }

    @Override
    public String getRobots(String portalName) throws Exception {
        String hash = this.getHash(portalName + ROBOTS_NAME);
        String robotsCache = (String)this.cache.get((Serializable)((Object)hash));
        if (robotsCache != null && robotsCache.trim().length() > 0) {
            return robotsCache;
        }
        StringBuffer robotsContent = null;
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        LivePortalManagerService livePortalManagerService = WCMCoreUtils.getService(LivePortalManagerService.class);
        Node dummyNode = livePortalManagerService.getLivePortal(sessionProvider, portalName);
        Session session = dummyNode.getSession();
        if (dummyNode.hasNode(METADATA_BASE_PATH) && dummyNode.getNode(METADATA_BASE_PATH).hasNode(ROBOTS_NAME)) {
            Node robotsFolder = dummyNode.getNode(METADATA_BASE_PATH + "/" + ROBOTS_NAME);
            Node robotsNode = robotsFolder.getNode("jcr:content");
            robotsContent = new StringBuffer(robotsNode.getProperty("jcr:data").getValue().getString());
        } else {
            robotsContent = new StringBuffer("# robots.txt \n");
            robotsContent.append("User-agent: * \n");
            robotsContent.append("Disallow: \n");
        }
        session.save();
        this.cache.put((Serializable)((Object)hash), (Object)robotsContent.toString());
        return robotsContent.toString();
    }

    @Override
    public String getHash(String uri) throws Exception {
        String key = uri;
        return MessageDigester.getHash(key);
    }

    private String getStandardURL(String path) throws Exception {
        if (path.substring(path.length() - 1, path.length()).equals("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    @Override
    public Node getContentNode(String seoPath) throws Exception {
        Node seoNode = null;
        if (seoPath != null && seoPath.length() > 0) {
            String[] arrPath;
            String tmpPath = seoPath.trim();
            if (tmpPath.startsWith("/")) {
                tmpPath = tmpPath.substring(1, tmpPath.length());
            }
            if ((arrPath = tmpPath.split("/")) != null && arrPath.length > 3) {
                String repo = arrPath[0];
                String ws = arrPath[1];
                if (repo != null && ws != null) {
                    boolean isWs = false;
                    String nodePath = tmpPath.substring(tmpPath.indexOf(ws) + ws.length(), tmpPath.length());
                    if (nodePath != null && nodePath.length() > 0) {
                        Session session;
                        ManageableRepository manageRepo = WCMCoreUtils.getRepository();
                        ArrayList wsList = manageRepo.getConfiguration().getWorkspaceEntries();
                        for (int i = 0; i < wsList.size(); ++i) {
                            WorkspaceEntry wsEntry = (WorkspaceEntry)wsList.get(i);
                            if (!wsEntry.getName().equals(ws)) continue;
                            isWs = true;
                            break;
                        }
                        if (isWs && (session = WCMCoreUtils.getUserSessionProvider().getSession(ws, manageRepo)).getItem(nodePath = Text.escapeIllegalJcrChars(nodePath.replaceAll("//", "/"))) != null && session.getItem(nodePath).isNode()) {
                            seoNode = (Node)session.getItem(nodePath);
                        }
                    }
                }
            }
        }
        return seoNode;
    }

    @Managed
    @ManagedDescription(value="Is the cache used ?")
    public boolean isCached() {
        return this.isCached;
    }

    @Managed
    @ManagedDescription(value="How many nodes in the cache ?")
    public int getCachedEntries() {
        return this.cache.getCacheSize();
    }

    @Managed
    @ManagedDescription(value="Activate/deactivate the composer cache ?")
    public void setCached(@ManagedDescription(value="Enable/Disable the cache ?") @ManagedName(value="isCached") boolean isCached) {
        this.isCached = isCached;
    }
}

