/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl;

import java.security.Permission;
import javax.jcr.RepositoryException;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.security.JCRRuntimePermissions;

public abstract class AbstractRepositorySuspender {
    protected final ManageableRepository repository;

    public AbstractRepositorySuspender(ManageableRepository repository) {
        this.repository = repository;
    }

    protected void suspendRepository() throws RepositoryException {
        SecurityHelper.validateSecurityPermission((Permission)JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        this.repository.setState(3);
    }

    protected void resumeRepository() throws RepositoryException {
        SecurityHelper.validateSecurityPermission((Permission)JCRRuntimePermissions.MANAGE_REPOSITORY_PERMISSION);
        this.repository.setState(1);
    }

    protected String getRepositoryStateTitle() {
        return this.repository.getStateTitle();
    }

    protected int getRepositoryState() {
        return this.repository.getState();
    }
}

