/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query.lucene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.store.Directory;
import org.exoplatform.commons.utils.PrivilegedFileHelper;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.dataflow.ItemDataConsumer;
import org.exoplatform.services.jcr.datamodel.ItemData;
import org.exoplatform.services.jcr.datamodel.NodeData;
import org.exoplatform.services.jcr.datamodel.NodeDataIndexing;
import org.exoplatform.services.jcr.impl.backup.SuspendException;
import org.exoplatform.services.jcr.impl.core.query.IndexRecovery;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeListener;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.NodeDataIndexingIterator;
import org.exoplatform.services.jcr.impl.core.query.Reindexable;
import org.exoplatform.services.jcr.impl.core.query.lucene.CachingMultiIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.DocNumberCache;
import org.exoplatform.services.jcr.impl.core.query.lucene.FieldNames;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexFormatVersion;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexInfos;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexMerger;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexUpdateMonitor;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexUpdateMonitorListener;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingQueue;
import org.exoplatform.services.jcr.impl.core.query.lucene.IndexingQueueStore;
import org.exoplatform.services.jcr.impl.core.query.lucene.NamespaceMappings;
import org.exoplatform.services.jcr.impl.core.query.lucene.OfflinePersistentIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.PersistentIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.ReadOnlyIndexReader;
import org.exoplatform.services.jcr.impl.core.query.lucene.Recovery;
import org.exoplatform.services.jcr.impl.core.query.lucene.RedoLog;
import org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.Util;
import org.exoplatform.services.jcr.impl.core.query.lucene.VolatileIndex;
import org.exoplatform.services.jcr.impl.core.query.lucene.directory.DirectoryManager;
import org.exoplatform.services.rpc.RPCException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiIndex
implements IndexerIoModeListener,
IndexUpdateMonitorListener {
    private static final Logger log = LoggerFactory.getLogger((String)"exo.jcr.component.core.MultiIndex");
    private IndexInfos indexNames;
    private final Set<String> deletable = new HashSet<String>();
    private final List<PersistentIndex> indexes = new ArrayList<PersistentIndex>();
    private final List<PersistentIndex> staleIndexes = new ArrayList<PersistentIndex>();
    private final NamespaceMappings nsMappings;
    private final DirectoryManager directoryManager;
    private final Directory indexDir;
    private final SearchIndex handler;
    private VolatileIndex volatileIndex;
    private OfflinePersistentIndex offlineIndex;
    private final IndexUpdateMonitor indexUpdateMonitor;
    private CachingMultiIndexReader multiReader;
    private final DocNumberCache cache;
    private final Object updateMonitor = new Object();
    private boolean redoLogApplied = false;
    private long lastFlushTime;
    private long lastFileSystemFlushTime;
    private IndexMerger merger;
    private static final Timer FLUSH_TIMER = new Timer("MultiIndex Flush Timer", true);
    private TimerTask flushTask;
    private RedoLog redoLog = null;
    private IndexingQueue indexingQueue;
    private final IndexingTree indexingTree;
    private long nextTransactionId = 0L;
    private long currentTransactionId = -1L;
    private final AtomicBoolean online = new AtomicBoolean(true);
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final IndexFormatVersion version;
    private final IndexerIoModeHandler modeHandler;
    private final Thread hook = new Thread(){

        public void run() {
            MultiIndex.this.stopped.set(true);
        }
    };
    final String workspaceId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MultiIndex(SearchIndex handler, IndexingTree indexingTree, IndexerIoModeHandler modeHandler, IndexInfos indexInfos, IndexUpdateMonitor indexUpdateMonitor) throws IOException {
        this.modeHandler = modeHandler;
        this.indexUpdateMonitor = indexUpdateMonitor;
        this.directoryManager = handler.getDirectoryManager();
        this.indexDir = this.directoryManager.getDirectory(".");
        this.handler = handler;
        this.workspaceId = handler.getWsId();
        this.cache = new DocNumberCache(handler.getCacheSize());
        this.indexingTree = indexingTree;
        this.nsMappings = handler.getNamespaceMappings();
        this.flushTask = null;
        this.indexNames = indexInfos;
        this.indexNames.setDirectory(this.indexDir);
        this.indexNames.read();
        this.lastFileSystemFlushTime = System.currentTimeMillis();
        this.lastFlushTime = System.currentTimeMillis();
        modeHandler.addIndexerIoModeListener(this);
        indexUpdateMonitor.addIndexUpdateMonitorListener(this);
        this.removeDeletable();
        HashSet<String> currentNames = new HashSet<String>(this.indexNames.getNames());
        for (String name : currentNames) {
            if (!this.directoryManager.hasDirectory(name)) {
                log.debug("index does not exist anymore: " + name);
                continue;
            }
            PersistentIndex index = new PersistentIndex(name, handler.getTextAnalyzer(), handler.getSimilarity(), this.cache, this.indexingQueue, this.directoryManager, modeHandler);
            index.setMaxFieldLength(handler.getMaxFieldLength());
            index.setUseCompoundFile(handler.getUseCompoundFile());
            index.setTermInfosIndexDivisor(handler.getTermInfosIndexDivisor());
            this.indexes.add(index);
        }
        IndexingQueueStore store = new IndexingQueueStore(this.indexDir);
        this.indexingQueue = new IndexingQueue(store);
        this.resetVolatileIndex();
        CachingMultiIndexReader reader = this.getIndexReader(handler.isInitializeHierarchyCache());
        try {
            this.version = IndexFormatVersion.getVersion((IndexReader)reader);
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            reader.release();
            throw throwable;
        }
        reader.release();
        this.indexingQueue.initialize(this);
        if (modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
            this.setReadWrite();
        }
        this.indexNames.setMultiIndex(this);
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Object>(){

            @Override
            public Void run() {
                try {
                    Runtime.getRuntime().addShutdownHook(MultiIndex.this.hook);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numDocs() throws IOException {
        int n;
        if (this.indexNames.size() == 0) {
            return this.volatileIndex.getNumDocuments();
        }
        CachingMultiIndexReader reader = this.getIndexReader();
        try {
            n = reader.numDocs();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            reader.release();
            throw throwable;
        }
        reader.release();
        return n;
    }

    IndexFormatVersion getIndexFormatVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void createInitialIndex(ItemDataConsumer stateMgr, boolean doForceReindexing) throws IOException {
        boolean indexCreated = false;
        this.setOnline(false, false);
        try {
            IOException ex;
            String msg;
            if (doForceReindexing && !this.indexes.isEmpty()) {
                log.info("Removing stale indexes (" + this.handler.getContext().getWorkspacePath(true) + ").");
                ArrayList<PersistentIndex> oldIndexes = new ArrayList<PersistentIndex>(this.indexes);
                for (PersistentIndex persistentIndex : oldIndexes) {
                    this.deleteIndex(persistentIndex);
                }
                this.attemptDelete();
            }
            if (this.indexNames.size() != 0) throw new IllegalStateException("Index already present.");
            try {
                if (this.handler.getContext().isRecoveryFilterUsed() && "from-coordinator".equals(this.handler.getIndexRecoveryMode())) {
                    if (this.handler.getContext().getIndexRecovery() != null && this.handler.getContext().getRPCService() != null && !this.handler.getContext().getRPCService().isCoordinator()) {
                        log.info("Retrieving index from coordinator (" + this.handler.getContext().getWorkspacePath(true) + ")...");
                        indexCreated = this.recoveryIndexFromCoordinator();
                        if (indexCreated) {
                            this.indexNames.read();
                            this.refreshIndexList();
                        } else {
                            log.info("Index can'b be retrieved from coordinator now, because it is offline. Possibly coordinator node performs reindexing now. Switching to local re-indexing.");
                        }
                    } else if (this.handler.getContext().getRPCService() == null) {
                        log.error("RPC Service is not configured but required for copying the index from coordinator node. Index will be created by re-indexing.");
                    } else {
                        if (this.handler.getContext().getIndexRecovery() == null) {
                            log.error("Instance of IndexRecovery class is missing for unknown reason. Index will be created by re-indexing.");
                        }
                        if (this.handler.getContext().getRPCService().isCoordinator()) {
                            log.info("Copying the index from coordinator configured, but this node is the only one in a cluster. Index will be created by re-indexing.");
                        }
                    }
                }
                if (!indexCreated) {
                    this.executeAndLog(new Start(-1L));
                    Reindexable rdbmsReindexableComponent = (Reindexable)this.handler.getContext().getContainer().getComponent(Reindexable.class);
                    long count = this.handler.isRDBMSReindexing() && rdbmsReindexableComponent != null && rdbmsReindexableComponent.isReindexingSupport() ? this.createIndex(rdbmsReindexableComponent.getNodeDataIndexingIterator(this.handler.getReindexingPageSize()), this.indexingTree.getIndexingRoot()) : this.createIndex(this.indexingTree.getIndexingRoot(), stateMgr);
                    this.executeAndLog(new Commit(this.getTransactionId()));
                    log.info("Initial index for {} nodes created ({}).", (Object)new Long(count), (Object)this.handler.getContext().getWorkspacePath(true));
                    this.releaseMultiReader();
                    this.scheduleFlushTask();
                }
            }
            catch (IOException e) {
                msg = "Error indexing workspace.";
                ex = new IOException(msg);
                ex.initCause(e);
                throw ex;
            }
            catch (RPCException e) {
                msg = "Error indexing workspace.";
                ex = new IOException(msg);
                ex.initCause(e);
                throw ex;
            }
            catch (RepositoryException e) {
                msg = "Error indexing workspace.";
                ex = new IOException(msg);
                ex.initCause(e);
                throw ex;
            }
            catch (SuspendException e) {
                msg = "Error indexing workspace.";
                ex = new IOException(msg);
                ex.initCause(e);
                throw ex;
            }
            Object var8_12 = null;
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.setOnline(true, false);
            throw throwable;
        }
        this.setOnline(true, false);
    }

    public void reindex(ItemDataConsumer stateMgr) throws IOException, RepositoryException {
        if (this.stopped.get()) {
            throw new IllegalStateException("Can't invoke reindexing on closed index.");
        }
        if (this.online.get()) {
            throw new IllegalStateException("Can't invoke reindexing while index still online.");
        }
        this.executeAndLog(new Start(-1L));
        Reindexable rdbmsReindexableComponent = (Reindexable)this.handler.getContext().getContainer().getComponent(Reindexable.class);
        long count = this.handler.isRDBMSReindexing() && rdbmsReindexableComponent != null && rdbmsReindexableComponent.isReindexingSupport() ? this.createIndex(rdbmsReindexableComponent.getNodeDataIndexingIterator(this.handler.getReindexingPageSize()), this.indexingTree.getIndexingRoot()) : this.createIndex(this.indexingTree.getIndexingRoot(), stateMgr);
        this.executeAndLog(new Commit(this.getTransactionId()));
        log.info("Created initial index for {} nodes", (Object)new Long(count));
        this.releaseMultiReader();
    }

    synchronized void update(Collection<String> remove, Collection<Document> add) throws IOException {
        if (!this.online.get()) {
            this.doUpdateOffline(remove, add);
        } else if (this.modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
            this.doUpdateRW(remove, add);
        } else {
            this.doUpdateRO(remove, add);
        }
    }

    private void doUpdateRO(final Collection<String> remove, final Collection<Document> add) throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public Object run() throws Exception {
                if (add.size() > MultiIndex.this.handler.getBufferSize()) {
                    try {
                        MultiIndex.this.releaseMultiReader();
                    }
                    catch (IOException e) {
                        log.warn("unable to prepare index reader for queries during update", (Throwable)e);
                    }
                }
                Object object = MultiIndex.this.updateMonitor;
                synchronized (object) {
                    block31: {
                        ReadOnlyIndexReader[] arr$;
                        ReadOnlyIndexReader[] readers = null;
                        try {
                            Iterator it = remove.iterator();
                            block14: while (it.hasNext()) {
                                Term idTerm = new Term(FieldNames.UUID, (String)it.next());
                                int num = MultiIndex.this.volatileIndex.removeDocument(idTerm);
                                if (num == 0) {
                                    for (int i = MultiIndex.this.indexes.size() - 1; i >= 0; --i) {
                                        PersistentIndex idx = (PersistentIndex)MultiIndex.this.indexes.get(i);
                                        if (!MultiIndex.this.indexNames.contains(idx.getName()) || (num = idx.removeDocument(idTerm)) <= 0) continue;
                                        if (!log.isDebugEnabled()) continue block14;
                                        log.debug(idTerm.text() + " has been found in the persisted index " + i);
                                        continue block14;
                                    }
                                    continue;
                                }
                                if (!log.isDebugEnabled()) continue;
                                log.debug(idTerm.text() + " has been found in the volatile index");
                            }
                            MultiReader indexReader = null;
                            for (Document doc : add) {
                                String uuid;
                                boolean addDoc;
                                block30: {
                                    if (doc == null) continue;
                                    addDoc = true;
                                    uuid = doc.get(FieldNames.UUID);
                                    if (!remove.contains(uuid)) {
                                        if (indexReader == null) {
                                            try {
                                                readers = MultiIndex.this.getReadOnlyIndexReaders(false, false);
                                                indexReader = new MultiReader((IndexReader[])readers);
                                            }
                                            catch (Throwable e) {
                                                log.warn("Could not create the MultiReader :" + e.getLocalizedMessage());
                                                log.debug("Could not create the MultiReader", e);
                                            }
                                        }
                                        if (indexReader != null && !indexReader.isCurrent()) {
                                            if (indexReader != null) {
                                                for (ReadOnlyIndexReader reader : readers) {
                                                    reader.release();
                                                }
                                            }
                                            try {
                                                readers = MultiIndex.this.getReadOnlyIndexReaders(false, false);
                                                indexReader = new MultiReader((IndexReader[])readers);
                                            }
                                            catch (Throwable e) {
                                                log.warn("Could not create the MultiReader :" + e.getLocalizedMessage());
                                                log.debug("Could not create the MultiReader", e);
                                            }
                                        }
                                        if (indexReader != null) {
                                            Object var13_18;
                                            TermDocs termDocs = null;
                                            try {
                                                try {
                                                    termDocs = indexReader.termDocs(new Term(FieldNames.UUID, uuid));
                                                    addDoc = !termDocs.next();
                                                }
                                                catch (Exception e) {
                                                    log.debug("Some exception occured, during index check");
                                                    var13_18 = null;
                                                    if (termDocs != null) {
                                                        termDocs.close();
                                                    }
                                                    break block30;
                                                }
                                                var13_18 = null;
                                                if (termDocs == null) break block30;
                                            }
                                            catch (Throwable throwable) {
                                                var13_18 = null;
                                                if (termDocs == null) throw throwable;
                                                termDocs.close();
                                                throw throwable;
                                            }
                                            termDocs.close();
                                        }
                                    }
                                }
                                if (addDoc) {
                                    MultiIndex.this.volatileIndex.addDocuments(new Document[]{doc});
                                    continue;
                                }
                                if (!log.isDebugEnabled()) continue;
                                log.debug("Could find the document {} in the last persisted index", (Object)uuid);
                            }
                            Object var15_20 = null;
                            if (readers == null) break block31;
                            arr$ = readers;
                        }
                        catch (Throwable throwable) {
                            Object var15_21 = null;
                            if (readers != null) {
                                for (void var19_29 : readers) {
                                    var19_29.release();
                                }
                            }
                            MultiIndex.this.releaseMultiReader();
                            throw throwable;
                        }
                        for (void var19_28 : arr$) {
                            var19_28.release();
                        }
                    }
                    MultiIndex.this.releaseMultiReader();
                    return null;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdateRW(Collection<String> remove, Collection<Document> add) throws IOException {
        Object object;
        if (add.size() > this.handler.getBufferSize()) {
            try {
                this.releaseMultiReader();
            }
            catch (IOException e) {
                log.warn("unable to prepare index reader for queries during update", (Throwable)e);
            }
        }
        Object e = this.updateMonitor;
        synchronized (e) {
            this.indexUpdateMonitor.setUpdateInProgress(true, false);
        }
        boolean flush = false;
        try {
            long transactionId = this.nextTransactionId++;
            this.executeAndLog(new Start(transactionId));
            Iterator<String> it = remove.iterator();
            while (it.hasNext()) {
                this.executeAndLog(new DeleteNode(transactionId, it.next()));
            }
            for (Document doc : add) {
                if (doc == null) continue;
                this.executeAndLog(new AddNode(transactionId, doc));
                flush |= this.checkVolatileCommit();
            }
            this.executeAndLog(new Commit(transactionId));
            if (flush) {
                Object object2 = this.updateMonitor;
                synchronized (object2) {
                    this.indexUpdateMonitor.setUpdateInProgress(true, true);
                }
                this.flush();
            }
            Object var10_11 = null;
            object = this.updateMonitor;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            Object object3 = this.updateMonitor;
            synchronized (object3) {
                this.indexUpdateMonitor.setUpdateInProgress(false, flush);
                this.updateMonitor.notifyAll();
                this.releaseMultiReader();
            }
            throw throwable;
        }
        synchronized (object) {
            this.indexUpdateMonitor.setUpdateInProgress(false, flush);
            this.updateMonitor.notifyAll();
            this.releaseMultiReader();
        }
    }

    private void invokeOfflineIndex() throws IOException {
        List<String> processedIDs = this.offlineIndex.getProcessedIDs();
        if (!processedIDs.isEmpty()) {
            this.update(processedIDs, Collections.<Document>emptyList());
            this.executeAndLog(new Start(-1L));
            CreateIndex create = new CreateIndex(this.getTransactionId(), null);
            this.executeAndLog(create);
            this.executeAndLog(new OfflineInvoke(this.getTransactionId(), create.getIndexName()));
            AddIndex add = new AddIndex(this.getTransactionId(), create.getIndexName());
            this.executeAndLog(add);
            this.executeAndLog(new Commit(this.getTransactionId()));
            this.indexNames.write();
        }
        this.offlineIndex.close();
        this.deleteIndex(this.offlineIndex);
        this.offlineIndex = null;
    }

    private void doUpdateOffline(final Collection<String> remove, final Collection<Document> add) throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                Iterator it = remove.iterator();
                while (it.hasNext()) {
                    Term idTerm = new Term(FieldNames.UUID, (String)it.next());
                    MultiIndex.this.offlineIndex.removeDocument(idTerm);
                }
                for (Document doc : add) {
                    if (doc == null) continue;
                    MultiIndex.this.offlineIndex.addDocuments(new Document[]{doc});
                    if (MultiIndex.this.offlineIndex.getRamSizeInBytes() < MultiIndex.this.handler.getMaxVolatileIndexSize()) continue;
                    MultiIndex.this.offlineIndex.commit();
                }
                return null;
            }
        });
    }

    void addDocument(Document doc) throws IOException {
        this.update(Collections.<String>emptyList(), Arrays.asList(doc));
    }

    void removeDocument(String uuid) throws IOException {
        this.update(Arrays.asList(uuid), Collections.<Document>emptyList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized int removeAllDocuments(String uuid) throws IOException {
        Object object;
        int num;
        Object object2 = this.updateMonitor;
        synchronized (object2) {
            this.indexUpdateMonitor.setUpdateInProgress(true, false);
        }
        try {
            Term idTerm = new Term(FieldNames.UUID, uuid.toString());
            this.executeAndLog(new Start(-1L));
            num = this.volatileIndex.removeDocument(idTerm);
            if (num > 0) {
                this.redoLog.append(new DeleteNode(this.getTransactionId(), uuid));
            }
            for (int i = 0; i < this.indexes.size(); ++i) {
                PersistentIndex index = this.indexes.get(i);
                if (!this.indexNames.contains(index.getName())) continue;
                int removed = index.removeDocument(idTerm);
                if (removed > 0) {
                    this.redoLog.append(new DeleteNode(this.getTransactionId(), uuid));
                }
                num += removed;
            }
            this.executeAndLog(new Commit(this.getTransactionId()));
            Object var8_9 = null;
            object = this.updateMonitor;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            Object object3 = this.updateMonitor;
            synchronized (object3) {
                this.indexUpdateMonitor.setUpdateInProgress(false, false);
                this.updateMonitor.notifyAll();
                this.releaseMultiReader();
            }
            throw throwable;
        }
        synchronized (object) {
            this.indexUpdateMonitor.setUpdateInProgress(false, false);
            this.updateMonitor.notifyAll();
            this.releaseMultiReader();
        }
        return num;
    }

    synchronized IndexReader[] getIndexReaders(String[] indexNames, IndexListener listener) throws IOException {
        HashSet<String> names = new HashSet<String>(Arrays.asList(indexNames));
        HashMap<ReadOnlyIndexReader, PersistentIndex> indexReaders = new HashMap<ReadOnlyIndexReader, PersistentIndex>();
        try {
            for (PersistentIndex index : this.indexes) {
                if (!names.contains(index.getName())) continue;
                indexReaders.put(index.getReadOnlyIndexReader(listener), index);
            }
        }
        catch (IOException e) {
            for (Map.Entry entry : indexReaders.entrySet()) {
                final ReadOnlyIndexReader reader = (ReadOnlyIndexReader)entry.getKey();
                try {
                    SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

                        @Override
                        public Object run() throws Exception {
                            reader.release();
                            return null;
                        }
                    });
                }
                catch (IOException ex) {
                    log.warn("Exception releasing index reader: " + ex);
                }
                ((PersistentIndex)entry.getValue()).resetListener();
            }
            throw e;
        }
        return indexReaders.keySet().toArray(new IndexReader[indexReaders.size()]);
    }

    synchronized PersistentIndex getOrCreateIndex(String indexName) throws IOException {
        PersistentIndex index;
        for (PersistentIndex idx : this.indexes) {
            if (!idx.getName().equals(indexName)) continue;
            return idx;
        }
        if (this.modeHandler.getMode() == IndexerIoMode.READ_ONLY) {
            throw new UnsupportedOperationException("Can't create index in READ_ONLY mode.");
        }
        if (indexName == null) {
            while (this.directoryManager.hasDirectory(indexName = this.indexNames.newName())) {
            }
        }
        try {
            index = new PersistentIndex(indexName, this.handler.getTextAnalyzer(), this.handler.getSimilarity(), this.cache, this.indexingQueue, this.directoryManager, this.modeHandler);
        }
        catch (IOException e) {
            if (!this.directoryManager.delete(indexName)) {
                this.deletable.add(indexName);
            }
            throw e;
        }
        index.setMaxFieldLength(this.handler.getMaxFieldLength());
        index.setUseCompoundFile(this.handler.getUseCompoundFile());
        index.setTermInfosIndexDivisor(this.handler.getTermInfosIndexDivisor());
        this.indexes.add(index);
        return index;
    }

    synchronized boolean hasIndex(String indexName) throws IOException {
        for (PersistentIndex idx : this.indexes) {
            if (!idx.getName().equals(indexName)) continue;
            return true;
        }
        return this.directoryManager.hasDirectory(indexName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replaceIndexes(String[] obsoleteIndexes, PersistentIndex index, Collection<Term> deleted) throws IOException {
        if (this.handler.isInitializeHierarchyCache()) {
            long time = 0L;
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis();
            }
            index.getReadOnlyIndexReader(true).release();
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis() - time;
                log.debug("hierarchy cache initialized in {} ms", (Object)new Long(time));
            }
        }
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            Object object;
            Object object2 = this.updateMonitor;
            synchronized (object2) {
                this.indexUpdateMonitor.setUpdateInProgress(true, true);
            }
            try {
                if (this.online.get()) {
                    this.executeAndLog(new Start(-2L));
                }
                HashSet<String> names = new HashSet<String>(Arrays.asList(obsoleteIndexes));
                for (String indexName : names) {
                    if (!this.indexNames.contains(indexName)) continue;
                    this.executeAndLog(new DeleteIndex(this.getTransactionId(), indexName));
                }
                this.executeAndLog(new CreateIndex(this.getTransactionId(), index.getName()));
                this.executeAndLog(new AddIndex(this.getTransactionId(), index.getName()));
                for (Term id : deleted) {
                    index.removeDocument(id);
                }
                index.commit();
                if (this.online.get()) {
                    this.executeAndLog(new Commit(this.getTransactionId()));
                }
                this.indexNames.write();
                Object var9_10 = null;
                object = this.updateMonitor;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                Object object3 = this.updateMonitor;
                synchronized (object3) {
                    this.indexUpdateMonitor.setUpdateInProgress(false, true);
                    this.updateMonitor.notifyAll();
                    this.releaseMultiReader();
                }
                throw throwable;
            }
            synchronized (object) {
                this.indexUpdateMonitor.setUpdateInProgress(false, true);
                this.updateMonitor.notifyAll();
                this.releaseMultiReader();
            }
        }
        if (!this.online.get()) {
            this.attemptDelete();
        }
    }

    public CachingMultiIndexReader getIndexReader() throws IOException {
        return this.getIndexReader(false);
    }

    public synchronized CachingMultiIndexReader getIndexReader(final boolean initCache) throws IOException {
        return (CachingMultiIndexReader)SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<CachingMultiIndexReader>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CachingMultiIndexReader run() throws Exception {
                Object object = MultiIndex.this.updateMonitor;
                synchronized (object) {
                    if (MultiIndex.this.multiReader != null) {
                        MultiIndex.this.multiReader.acquire();
                        return MultiIndex.this.multiReader;
                    }
                    while (MultiIndex.this.indexUpdateMonitor.getUpdateInProgress()) {
                        try {
                            MultiIndex.this.updateMonitor.wait();
                        }
                        catch (InterruptedException e) {
                            throw new IOException("Interrupted while waiting to aquire reader");
                        }
                    }
                    if (MultiIndex.this.multiReader == null) {
                        ReadOnlyIndexReader[] readers = MultiIndex.this.getReadOnlyIndexReaders(initCache, true);
                        MultiIndex.this.multiReader = new CachingMultiIndexReader(readers, MultiIndex.this.cache);
                    }
                    MultiIndex.this.multiReader.acquire();
                    return MultiIndex.this.multiReader;
                }
            }
        });
    }

    private ReadOnlyIndexReader[] getReadOnlyIndexReaders(boolean initCache, boolean withVolatileIndex) throws IOException, FileNotFoundException {
        List<PersistentIndex> persistedIndexesList = this.online.get() ? this.indexes : this.staleIndexes;
        ArrayList<ReadOnlyIndexReader> readerList = new ArrayList<ReadOnlyIndexReader>();
        for (int i = 0; i < persistedIndexesList.size(); ++i) {
            PersistentIndex pIdx = persistedIndexesList.get(i);
            if (!this.indexNames.contains(pIdx.getName())) continue;
            try {
                readerList.add(pIdx.getReadOnlyIndexReader(initCache));
                continue;
            }
            catch (FileNotFoundException e) {
                if (!this.directoryManager.hasDirectory(pIdx.getName())) continue;
                throw e;
            }
        }
        if (withVolatileIndex) {
            readerList.add(this.volatileIndex.getReadOnlyIndexReader());
        }
        return readerList.toArray(new ReadOnlyIndexReader[readerList.size()]);
    }

    VolatileIndex getVolatileIndex() {
        return this.volatileIndex;
    }

    OfflinePersistentIndex getOfflinePersistentIndex() {
        return this.offlineIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            try {
                if (this.flushTask != null) {
                    this.flushTask.cancel();
                }
                try {
                    this.releaseMultiReader();
                }
                catch (IOException e) {
                    log.error("Exception while closing search index.", (Throwable)e);
                }
                if (this.modeHandler.getMode().equals((Object)IndexerIoMode.READ_WRITE)) {
                    try {
                        this.flush();
                    }
                    catch (IOException e) {
                        log.error("Exception while closing search index.", (Throwable)e);
                    }
                }
                this.volatileIndex.close();
                for (int i = 0; i < this.indexes.size(); ++i) {
                    this.indexes.get(i).close();
                }
                this.indexingQueue.close();
                try {
                    this.indexDir.close();
                }
                catch (IOException e) {
                    log.error("Exception while closing directory.", (Throwable)e);
                }
                this.modeHandler.removeIndexerIoModeListener(this);
                this.indexUpdateMonitor.removeIndexUpdateMonitorListener(this);
                this.stopped.set(true);
                Object var4_7 = null;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Object>(){

                    @Override
                    public Void run() {
                        try {
                            Runtime.getRuntime().removeShutdownHook(MultiIndex.this.hook);
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                        return null;
                    }
                });
                throw throwable;
            }
            SecurityHelper.doPrivilegedAction((PrivilegedAction)new /* invalid duplicate definition of identical inner class */);
        }
        if (this.merger != null) {
            this.merger.dispose();
            this.merger = null;
        }
    }

    NamespaceMappings getNamespaceMappings() {
        return this.nsMappings;
    }

    public IndexingQueue getIndexingQueue() {
        return this.indexingQueue;
    }

    Document createDocument(NodeData node) throws RepositoryException {
        return this.createDocument(new NodeDataIndexing(node));
    }

    Document createDocument(NodeDataIndexing node) throws RepositoryException {
        return this.handler.createDocument(node, this.nsMappings, this.version);
    }

    Document createDocument(String id) throws RepositoryException {
        ItemData data = this.handler.getContext().getItemStateManager().getItemData(id);
        if (data == null) {
            throw new ItemNotFoundException("Item id=" + id + " not found");
        }
        if (!data.isNode()) {
            throw new RepositoryException("Item with id " + id + " is not a node");
        }
        return this.createDocument((NodeData)data);
    }

    boolean getRedoLogApplied() {
        return this.redoLogApplied;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deleteIndex(PersistentIndex index) {
        this.indexes.remove(index);
        this.indexNames.removeName(index.getName());
        Set<String> set = this.deletable;
        synchronized (set) {
            log.debug("Moved " + index.getName() + " to deletable");
            this.deletable.add(index.getName());
        }
    }

    public void flush() throws IOException {
        SecurityHelper.doPrivilegedIOExceptionAction((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void run() throws Exception {
                8 var1_1 = this;
                synchronized (var1_1) {
                    MultiIndex.this.executeAndLog(new Start(-1L));
                    MultiIndex.this.commitVolatileIndex();
                    for (int i = MultiIndex.this.indexes.size() - 1; i >= 0; --i) {
                        PersistentIndex index = (PersistentIndex)MultiIndex.this.indexes.get(i);
                        if (!MultiIndex.this.indexNames.contains(index.getName())) continue;
                        index.commit();
                        if (index.getNumDocuments() != 0) continue;
                        MultiIndex.this.executeAndLog(new DeleteIndex(MultiIndex.this.getTransactionId(), index.getName()));
                    }
                    MultiIndex.this.executeAndLog(new Commit(MultiIndex.this.getTransactionId()));
                    MultiIndex.this.indexNames.write();
                    MultiIndex.this.redoLog.clear();
                    MultiIndex.this.lastFlushTime = System.currentTimeMillis();
                    MultiIndex.this.lastFileSystemFlushTime = System.currentTimeMillis();
                }
                MultiIndex.this.attemptDelete();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseMultiReader() throws IOException {
        if (this.multiReader != null) {
            try {
                this.multiReader.release();
                Object var2_1 = null;
                this.multiReader = null;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.multiReader = null;
                throw throwable;
            }
        }
    }

    private void initMerger() throws IOException {
        if (this.merger != null) {
            log.info("IndexMerger initialization called twice.");
        }
        this.merger = new IndexMerger(this);
        this.merger.setMaxMergeDocs(this.handler.getMaxMergeDocs());
        this.merger.setMergeFactor(this.handler.getMergeFactor());
        this.merger.setMinMergeDocs(this.handler.getMinMergeDocs());
        for (PersistentIndex index : this.indexes) {
            this.merger.indexAdded(index.getName(), index.getNumDocuments());
        }
        this.merger.start();
    }

    private void enqueueUnusedSegments() throws IOException {
        String[] dirNames = this.directoryManager.getDirectoryNames();
        for (int i = 0; i < dirNames.length; ++i) {
            if (!dirNames[i].startsWith("_") || this.indexNames.contains(dirNames[i])) continue;
            this.deletable.add(dirNames[i]);
        }
    }

    private void scheduleFlushTask() {
        if (this.flushTask != null) {
            this.flushTask.cancel();
        }
        FLUSH_TIMER.purge();
        this.flushTask = new TimerTask(){

            public void run() {
                MultiIndex.this.checkIndexingQueue();
                MultiIndex.this.checkFlush();
            }
        };
        FLUSH_TIMER.schedule(this.flushTask, 0L, 1000L);
        this.lastFlushTime = System.currentTimeMillis();
        this.lastFileSystemFlushTime = System.currentTimeMillis();
    }

    private void resetVolatileIndex() throws IOException {
        this.volatileIndex = new VolatileIndex(this.handler.getTextAnalyzer(), this.handler.getSimilarity(), this.indexingQueue);
        this.volatileIndex.setUseCompoundFile(this.handler.getUseCompoundFile());
        this.volatileIndex.setMaxFieldLength(this.handler.getMaxFieldLength());
        this.volatileIndex.setBufferSize(this.handler.getBufferSize());
    }

    private long getTransactionId() {
        return this.currentTransactionId;
    }

    private Action executeAndLog(Action a) throws IOException {
        a.execute(this);
        this.redoLog.append(a);
        if (a.getType() == 3 || a.getType() == 6) {
            this.redoLog.flush();
        }
        return a;
    }

    private boolean checkVolatileCommit() throws IOException {
        if (this.volatileIndex.getRamSizeInBytes() >= this.handler.getMaxVolatileIndexSize()) {
            this.commitVolatileIndex();
            return true;
        }
        return false;
    }

    private void commitVolatileIndex() throws IOException {
        if (this.volatileIndex.getNumDocuments() > 0) {
            long time = 0L;
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis();
            }
            CreateIndex create = new CreateIndex(this.getTransactionId(), null);
            this.executeAndLog(create);
            this.executeAndLog(new VolatileCommit(this.getTransactionId(), create.getIndexName()));
            AddIndex add = new AddIndex(this.getTransactionId(), create.getIndexName());
            this.executeAndLog(add);
            this.resetVolatileIndex();
            if (log.isDebugEnabled()) {
                time = System.currentTimeMillis() - time;
                log.debug("Committed in-memory index in " + time + "ms.");
            }
        }
    }

    private long createIndex(NodeData node, ItemDataConsumer stateMgr) throws IOException, RepositoryException {
        MultithreadedIndexing indexing = new MultithreadedIndexing(node, stateMgr);
        return indexing.launch(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(final Queue<Callable<Void>> tasks, final NodeData node, final ItemDataConsumer stateMgr, final AtomicLong count) throws IOException, RepositoryException, InterruptedException {
        if (this.stopped.get() || Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.indexingTree.isExcluded(node)) {
            return;
        }
        this.executeAndLog(new AddNode(this.getTransactionId(), node.getIdentifier(), true));
        if (count.incrementAndGet() % 1000L == 0L) {
            log.info("indexing... {} ({})", (Object)node.getQPath().getAsString(), (Object)new Long(count.get()));
        }
        MultiIndex multiIndex = this;
        synchronized (multiIndex) {
            if (count.get() % 10L == 0L) {
                this.checkIndexingQueue(true);
            }
            this.checkVolatileCommit();
        }
        List<NodeData> children = null;
        try {
            children = stateMgr.getChildNodesData(node);
        }
        catch (RepositoryException e) {
            log.error("Error indexing subtree " + node.getQPath().getAsString() + ". Check JCR consistency. " + e.getMessage(), (Throwable)e);
            return;
        }
        for (final NodeData nodeData : children) {
            Callable<Void> task = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MultiIndex.this.createIndex(tasks, node, stateMgr, count, nodeData);
                    return null;
                }
            };
            if (tasks.offer(task)) continue;
            this.createIndex(tasks, node, stateMgr, count, nodeData);
        }
    }

    private void createIndex(Queue<Callable<Void>> tasks, NodeData node, ItemDataConsumer stateMgr, AtomicLong count, NodeData nodeData) throws RepositoryException, IOException, InterruptedException {
        NodeData childState = null;
        try {
            childState = (NodeData)stateMgr.getItemData(nodeData.getIdentifier());
        }
        catch (RepositoryException e) {
            log.error("Error indexing subtree " + node.getQPath().getAsString() + ". Check JCR consistency. " + e.getMessage(), (Throwable)e);
            return;
        }
        if (childState == null) {
            log.error("Error indexing subtree " + node.getQPath().getAsString() + ". Item not found.");
            return;
        }
        if (nodeData != null) {
            this.createIndex(tasks, nodeData, stateMgr, count);
        }
    }

    private long createIndex(NodeDataIndexingIterator iterator, NodeData rootNode) throws IOException, RepositoryException {
        MultithreadedIndexing indexing = new MultithreadedIndexing(iterator, rootNode);
        return indexing.launch(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createIndex(NodeDataIndexingIterator iterator, NodeData rootNode, AtomicLong count) throws RepositoryException, InterruptedException, IOException {
        for (NodeDataIndexing node : iterator.next()) {
            if (this.stopped.get() || Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (this.indexingTree.isExcluded(node) || !node.getQPath().isDescendantOf(rootNode.getQPath()) && !node.getQPath().equals(rootNode.getQPath())) continue;
            this.executeAndLog(new AddNode(this.getTransactionId(), node, true));
            if (count.incrementAndGet() % 1000L == 0L) {
                log.info("indexing... {} ({})", (Object)node.getQPath().getAsString(), (Object)new Long(count.get()));
            }
            MultiIndex multiIndex = this;
            synchronized (multiIndex) {
                if (count.get() % 10L == 0L) {
                    this.checkIndexingQueue(true);
                }
                this.checkVolatileCommit();
            }
        }
    }

    private void createIndex(Queue<Callable<Void>> tasks, final NodeDataIndexingIterator iterator, final NodeData rootNode, final AtomicLong count) throws IOException, RepositoryException, InterruptedException {
        while (iterator.hasNext()) {
            Callable<Void> task = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MultiIndex.this.createIndex(iterator, rootNode, count);
                    return null;
                }
            };
            if (tasks.offer(task)) continue;
            this.createIndex(iterator, rootNode, count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptDelete() {
        Set<String> set = this.deletable;
        synchronized (set) {
            Iterator<String> it = this.deletable.iterator();
            while (it.hasNext()) {
                String indexName = it.next();
                if (this.directoryManager.delete(indexName)) {
                    it.remove();
                    continue;
                }
                log.info("Unable to delete obsolete index: " + indexName);
            }
        }
    }

    private void removeDeletable() {
        String fileName = "deletable";
        try {
            if (this.indexDir.fileExists(fileName)) {
                this.indexDir.deleteFile(fileName);
            }
        }
        catch (IOException e) {
            log.warn("Unable to remove file 'deletable'.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void checkFlush() {
        block13: {
            long idleTime = this.online.get() ? System.currentTimeMillis() - this.lastFlushTime : 0L;
            long volatileTime = System.currentTimeMillis() - this.lastFileSystemFlushTime;
            if (this.handler.getVolatileIdleTime() > 0 && idleTime > (long)(this.handler.getVolatileIdleTime() * 1000) || this.handler.getMaxVolatileTime() > 0 && volatileTime > (long)(this.handler.getMaxVolatileTime() * 1000)) {
                try {
                    Object object;
                    if (!this.redoLog.hasEntries()) break block13;
                    log.debug("Flushing index after being idle for " + idleTime + " ms.");
                    Object object2 = this.updateMonitor;
                    synchronized (object2) {
                        this.indexUpdateMonitor.setUpdateInProgress(true, true);
                    }
                    try {
                        this.flush();
                        Object var8_6 = null;
                        object = this.updateMonitor;
                    }
                    catch (Throwable throwable) {
                        Object var8_7 = null;
                        Object object3 = this.updateMonitor;
                        synchronized (object3) {
                            this.indexUpdateMonitor.setUpdateInProgress(false, true);
                            this.updateMonitor.notifyAll();
                            this.releaseMultiReader();
                        }
                        throw throwable;
                    }
                    synchronized (object) {
                        this.indexUpdateMonitor.setUpdateInProgress(false, true);
                        this.updateMonitor.notifyAll();
                        this.releaseMultiReader();
                    }
                }
                catch (IOException e) {
                    log.error("Unable to commit volatile index", (Throwable)e);
                }
            }
        }
    }

    private synchronized void checkIndexingQueue() {
        this.checkIndexingQueue(false);
    }

    private void checkIndexingQueue(boolean transactionPresent) {
    }

    @Override
    public void onChangeMode(IndexerIoMode mode) {
        try {
            switch (mode) {
                case READ_ONLY: {
                    this.setReadOny();
                    break;
                }
                case READ_WRITE: {
                    this.setReadWrite();
                }
            }
        }
        catch (IOException e) {
            log.error("An error occurs while changing of mode " + (Object)((Object)mode), (Throwable)e);
        }
    }

    protected void setReadOny() {
        if (this.merger != null) {
            this.merger.dispose();
            this.merger = null;
        }
        this.flushTask.cancel();
        FLUSH_TIMER.purge();
        this.redoLog = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setReadWrite() throws IOException {
        Object object = this.updateMonitor;
        synchronized (object) {
            this.indexUpdateMonitor.setUpdateInProgress(false, true);
            this.updateMonitor.notifyAll();
            this.releaseMultiReader();
        }
        this.redoLog = new RedoLog(this.indexDir);
        this.redoLogApplied = this.redoLog.hasEntries();
        Recovery.run(this, this.redoLog);
        this.enqueueUnusedSegments();
        this.attemptDelete();
        this.initMerger();
        if (this.redoLogApplied) {
            try {
                this.merger.waitUntilIdle();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.flush();
        }
        if (this.indexNames.size() > 0) {
            this.scheduleFlushTask();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshIndexList() throws IOException {
        Object object = this.updateMonitor;
        synchronized (object) {
            this.releaseMultiReader();
            HashSet<String> newList = new HashSet<String>(this.indexNames.getNames());
            Iterator<PersistentIndex> iterator = this.indexes.iterator();
            while (iterator.hasNext()) {
                PersistentIndex index = iterator.next();
                String name = index.getName();
                if (!newList.contains(name)) {
                    index.close();
                    iterator.remove();
                    continue;
                }
                newList.remove(name);
                index.releaseWriterAndReaders();
            }
            for (String name : newList) {
                if (!this.directoryManager.hasDirectory(name)) {
                    log.debug("index does not exist anymore: " + name);
                    continue;
                }
                PersistentIndex index = new PersistentIndex(name, this.handler.getTextAnalyzer(), this.handler.getSimilarity(), this.cache, this.indexingQueue, this.directoryManager, this.modeHandler);
                index.setMaxFieldLength(this.handler.getMaxFieldLength());
                index.setUseCompoundFile(this.handler.getUseCompoundFile());
                index.setTermInfosIndexDivisor(this.handler.getTermInfosIndexDivisor());
                this.indexes.add(index);
            }
            this.resetVolatileIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdateInProgressChange(boolean updateInProgress) {
        if (this.modeHandler.getMode() == IndexerIoMode.READ_ONLY && !updateInProgress) {
            try {
                Object object = this.updateMonitor;
                synchronized (object) {
                    this.updateMonitor.notifyAll();
                    this.releaseMultiReader();
                }
            }
            catch (IOException e) {
                log.error("An error occurred while trying to wake up the sleeping threads", (Throwable)e);
            }
        }
    }

    public boolean isOnline() {
        return this.online.get();
    }

    public boolean isStopped() {
        return this.stopped.get();
    }

    public synchronized void setOnline(boolean isOnline, boolean dropStaleIndexes) throws IOException {
        if (this.online.get() != isOnline) {
            if (isOnline) {
                log.info("Setting index ONLINE ({})", (Object)this.handler.getContext().getWorkspacePath(true));
                if (this.modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
                    this.offlineIndex.commit(true);
                    this.online.set(true);
                    for (PersistentIndex staleIndex : this.staleIndexes) {
                        this.deleteIndex(staleIndex);
                    }
                    this.invokeOfflineIndex();
                    this.staleIndexes.clear();
                    this.initMerger();
                } else {
                    this.online.set(true);
                    this.staleIndexes.clear();
                }
            } else {
                log.info("Setting index OFFLINE ({})", (Object)this.handler.getContext().getWorkspacePath(true));
                if (this.merger != null) {
                    this.merger.dispose();
                    this.merger = null;
                }
                this.offlineIndex = new OfflinePersistentIndex(this.handler.getTextAnalyzer(), this.handler.getSimilarity(), this.cache, this.indexingQueue, this.directoryManager, this.modeHandler);
                if (this.modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
                    this.flush();
                }
                this.releaseMultiReader();
                if (dropStaleIndexes) {
                    this.staleIndexes.addAll(this.indexes);
                }
                this.online.set(false);
            }
        } else if (!this.online.get()) {
            throw new IOException("Index is already in OFFLINE mode.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recoveryIndexFromCoordinator() throws FileNotFoundException, RepositoryException, IOException, SuspendException {
        IndexRecovery indexRecovery;
        block11: {
            indexRecovery = this.handler.getContext().getIndexRecovery();
            if (indexRecovery.checkIndexReady()) break block11;
            boolean bl = false;
            Object var13_4 = null;
            return bl;
        }
        try {
            indexRecovery.setIndexOffline();
            File indexDirectory = new File(this.handler.getContext().getIndexDirectory());
            for (String filePath : indexRecovery.getIndexList()) {
                FileOutputStream out;
                block12: {
                    Object var11_14;
                    File indexFile = new File(indexDirectory, filePath);
                    if (!PrivilegedFileHelper.exists((File)indexFile.getParentFile())) {
                        PrivilegedFileHelper.mkdirs((File)indexFile.getParentFile());
                    }
                    InputStream in = indexRecovery.getIndexFile(filePath);
                    out = PrivilegedFileHelper.fileOutputStream((File)indexFile);
                    try {
                        int len;
                        byte[] buf = new byte[2048];
                        while ((len = in.read(buf)) > 0) {
                            ((OutputStream)out).write(buf, 0, len);
                        }
                        var11_14 = null;
                        if (in == null) break block12;
                    }
                    catch (Throwable throwable) {
                        var11_14 = null;
                        if (in != null) {
                            in.close();
                        }
                        if (out != null) {
                            ((OutputStream)out).close();
                        }
                        throw throwable;
                    }
                    in.close();
                }
                if (out != null) {
                    ((OutputStream)out).close();
                }
                indexRecovery.setIndexOnline();
            }
            Object var13_5 = null;
        }
        catch (Throwable throwable) {
            Object var13_6 = null;
            throw throwable;
        }
        return true;
    }

    private class MultithreadedIndexing {
        private final AtomicReference<Exception> exception = new AtomicReference();
        private final int nThreads = MultiIndex.access$200(MultiIndex.this).getIndexingThreadPoolSize();
        private final CountDownLatch endSignal = new CountDownLatch(this.nThreads);
        private final AtomicInteger runningThreads = new AtomicInteger();
        private final AtomicLong count = new AtomicLong();
        private final Thread[] allIndexingThreads = new Thread[this.nThreads];
        private final Queue<Callable<Void>> tasks = new LinkedBlockingQueue<Callable<Void>>(this.nThreads){
            private static final long serialVersionUID = 1L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Callable<Void> poll() {
                Callable task;
                AtomicInteger atomicInteger = MultithreadedIndexing.this.runningThreads;
                synchronized (atomicInteger) {
                    task = (Callable)super.poll();
                    if (task != null) {
                        MultithreadedIndexing.this.runningThreads.incrementAndGet();
                    }
                }
                return task;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean offer(Callable<Void> o) {
                if (super.offer(o)) {
                    AtomicInteger atomicInteger = MultithreadedIndexing.this.runningThreads;
                    synchronized (atomicInteger) {
                        MultithreadedIndexing.this.runningThreads.notifyAll();
                    }
                    return true;
                }
                return false;
            }
        };
        private final Runnable indexingTask = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                while (MultithreadedIndexing.this.exception.get() == null) {
                    Callable task;
                    while (MultithreadedIndexing.this.exception.get() == null && (task = (Callable)MultithreadedIndexing.this.tasks.poll()) != null) {
                        AtomicInteger atomicInteger;
                        Object var4_7;
                        try {
                            try {
                                task.call();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                var4_7 = null;
                                atomicInteger = MultithreadedIndexing.this.runningThreads;
                                synchronized (atomicInteger) {
                                    MultithreadedIndexing.this.runningThreads.decrementAndGet();
                                    MultithreadedIndexing.this.runningThreads.notifyAll();
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                MultithreadedIndexing.this.exception.set(e);
                                MultithreadedIndexing.this.interruptAll();
                                var4_7 = null;
                                atomicInteger = MultithreadedIndexing.this.runningThreads;
                                synchronized (atomicInteger) {
                                    MultithreadedIndexing.this.runningThreads.decrementAndGet();
                                    MultithreadedIndexing.this.runningThreads.notifyAll();
                                    continue;
                                }
                            }
                            var4_7 = null;
                        }
                        catch (Throwable throwable) {
                            var4_7 = null;
                            atomicInteger = MultithreadedIndexing.this.runningThreads;
                            synchronized (atomicInteger) {
                                MultithreadedIndexing.this.runningThreads.decrementAndGet();
                                MultithreadedIndexing.this.runningThreads.notifyAll();
                                throw throwable;
                            }
                        }
                        atomicInteger = MultithreadedIndexing.this.runningThreads;
                        synchronized (atomicInteger) {
                            MultithreadedIndexing.this.runningThreads.decrementAndGet();
                            MultithreadedIndexing.this.runningThreads.notifyAll();
                        }
                    }
                    AtomicInteger atomicInteger = MultithreadedIndexing.this.runningThreads;
                    synchronized (atomicInteger) {
                        if (MultithreadedIndexing.this.exception.get() == null && MultithreadedIndexing.this.runningThreads.get() > 0) {
                            try {
                                MultithreadedIndexing.this.runningThreads.wait();
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            continue;
                        }
                        break;
                    }
                }
                MultithreadedIndexing.this.endSignal.countDown();
            }
        };

        public MultithreadedIndexing(final NodeData node, final ItemDataConsumer stateMgr) {
            this.tasks.offer(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MultiIndex.this.createIndex((Queue<Callable<Void>>)MultithreadedIndexing.this.tasks, node, stateMgr, MultithreadedIndexing.this.count);
                    return null;
                }
            });
        }

        public MultithreadedIndexing(final NodeDataIndexingIterator iterator, final NodeData rootNode) {
            this.tasks.offer(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    MultiIndex.this.createIndex((Queue<Callable<Void>>)MultithreadedIndexing.this.tasks, iterator, rootNode, MultithreadedIndexing.this.count);
                    return null;
                }
            });
        }

        public long launch(boolean asynchronous) throws IOException, RepositoryException {
            this.startThreads();
            if (!asynchronous) {
                try {
                    this.endSignal.await();
                    if (this.exception.get() != null) {
                        if (this.exception.get() instanceof IOException) {
                            throw (IOException)this.exception.get();
                        }
                        if (this.exception.get() instanceof RepositoryException) {
                            throw (RepositoryException)((Object)this.exception.get());
                        }
                        throw new RuntimeException("Error while indexing", this.exception.get());
                    }
                    return this.count.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            return -1L;
        }

        private void startThreads() {
            for (int i = 0; i < this.nThreads; ++i) {
                this.allIndexingThreads[i] = new Thread(this.indexingTask, "Indexing Thread #" + (i + 1));
                this.allIndexingThreads[i].start();
            }
        }

        private void interruptAll() {
            for (int i = 0; i < this.nThreads; ++i) {
                Thread t = this.allIndexingThreads[i];
                if (t == null) continue;
                t.interrupt();
            }
        }
    }

    private static class OfflineInvoke
    extends Action {
        private final String targetIndex;

        OfflineInvoke(long transactionId, String targetIndex) {
            super(transactionId, 8);
            this.targetIndex = targetIndex;
        }

        static OfflineInvoke fromString(long transactionId, String arguments) {
            return new OfflineInvoke(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            OfflinePersistentIndex offlineIndex = index.getOfflinePersistentIndex();
            PersistentIndex persistentIndex = index.getOrCreateIndex(this.targetIndex);
            persistentIndex.copyIndex(offlineIndex);
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("OFF_INV");
            logLine.append(' ');
            logLine.append(this.targetIndex);
            return logLine.toString();
        }
    }

    private static class VolatileCommit
    extends Action {
        private final String targetIndex;

        VolatileCommit(long transactionId, String targetIndex) {
            super(transactionId, 4);
            this.targetIndex = targetIndex;
        }

        static VolatileCommit fromString(long transactionId, String arguments) {
            return new VolatileCommit(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            VolatileIndex volatileIndex = index.getVolatileIndex();
            PersistentIndex persistentIndex = index.getOrCreateIndex(this.targetIndex);
            persistentIndex.copyIndex(volatileIndex);
            index.resetVolatileIndex();
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("VOL_COM");
            logLine.append(' ');
            logLine.append(this.targetIndex);
            return logLine.toString();
        }
    }

    private static class Start
    extends Action {
        Start(long transactionId) {
            super(transactionId, 0);
        }

        static Start fromString(long transactionId, String arguments) {
            return new Start(transactionId);
        }

        public void execute(MultiIndex index) throws IOException {
            index.currentTransactionId = this.getTransactionId();
        }

        public String toString() {
            return Long.toString(this.getTransactionId()) + ' ' + "STR";
        }
    }

    private static class DeleteNode
    extends Action {
        private static final int ENTRY_LENGTH = Long.toString(Long.MAX_VALUE).length() + "DEL".length() + 32 + 2;
        private final String uuid;

        DeleteNode(long transactionId, String uuid) {
            super(transactionId, 2);
            this.uuid = uuid;
        }

        static DeleteNode fromString(long transactionId, String arguments) {
            if (arguments.length() != 32) {
                throw new IllegalArgumentException("arguments is not a uuid");
            }
            return new DeleteNode(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            String uuidString = this.uuid.toString();
            Document doc = index.indexingQueue.removeDocument(uuidString);
            if (doc != null) {
                Util.disposeDocument(doc);
            }
            Term idTerm = new Term(FieldNames.UUID, uuidString);
            int num = index.volatileIndex.removeDocument(idTerm);
            if (num == 0 && index.modeHandler.getMode() == IndexerIoMode.READ_WRITE) {
                for (int i = index.indexes.size() - 1; i >= 0; --i) {
                    PersistentIndex idx = (PersistentIndex)index.indexes.get(i);
                    if (!index.indexNames.contains(idx.getName()) || (num = idx.removeDocument(idTerm)) <= 0) continue;
                    if (log.isDebugEnabled()) {
                        log.debug(idTerm.text() + " has been found in the persisted index " + i);
                    }
                    return;
                }
            } else if (log.isDebugEnabled()) {
                log.debug(idTerm.text() + " has been found in the volatile index");
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer(ENTRY_LENGTH);
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("DEL");
            logLine.append(' ');
            logLine.append(this.uuid);
            return logLine.toString();
        }
    }

    private static class DeleteIndex
    extends Action {
        private String indexName;

        DeleteIndex(long transactionId, String indexName) {
            super(transactionId, 7);
            this.indexName = indexName;
        }

        static DeleteIndex fromString(long transactionId, String arguments) {
            return new DeleteIndex(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            for (PersistentIndex idx : index.indexes) {
                if (!idx.getName().equals(this.indexName)) continue;
                idx.close();
                index.deleteIndex(idx);
                break;
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("DEL_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }
    }

    private static class CreateIndex
    extends Action {
        private String indexName;

        CreateIndex(long transactionId, String indexName) {
            super(transactionId, 5);
            this.indexName = indexName;
        }

        static CreateIndex fromString(long transactionId, String arguments) {
            return new CreateIndex(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            PersistentIndex idx = index.getOrCreateIndex(this.indexName);
            this.indexName = idx.getName();
        }

        public void undo(MultiIndex index) throws IOException {
            if (index.hasIndex(this.indexName)) {
                PersistentIndex idx = index.getOrCreateIndex(this.indexName);
                idx.close();
                index.deleteIndex(idx);
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("CRE_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }

        String getIndexName() {
            return this.indexName;
        }
    }

    private static class Commit
    extends Action {
        Commit(long transactionId) {
            super(transactionId, 3);
        }

        static Commit fromString(long transactionId, String arguments) {
            return new Commit(transactionId);
        }

        public void execute(MultiIndex index) throws IOException {
            index.lastFlushTime = System.currentTimeMillis();
        }

        public String toString() {
            return Long.toString(this.getTransactionId()) + ' ' + "COM";
        }
    }

    private static class AddNode
    extends Action {
        private static final int ENTRY_LENGTH = Long.toString(Long.MAX_VALUE).length() + "ADD".length() + 32 + 2;
        private final String uuid;
        private Document doc;
        private boolean synch;
        private NodeDataIndexing node;

        AddNode(long transactionId, String uuid) {
            this(transactionId, uuid, false);
        }

        AddNode(long transactionId, String uuid, boolean synch) {
            super(transactionId, 1);
            this.uuid = uuid;
            this.synch = synch;
        }

        AddNode(long transactionId, NodeDataIndexing node, boolean synch) {
            this(transactionId, node.getIdentifier(), synch);
            this.node = node;
        }

        AddNode(long transactionId, Document doc) {
            this(transactionId, doc.get(FieldNames.UUID));
            this.doc = doc;
        }

        static AddNode fromString(long transactionId, String arguments) throws IllegalArgumentException {
            if (arguments.length() != 32) {
                throw new IllegalArgumentException("arguments is not a uuid");
            }
            return new AddNode(transactionId, arguments);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(MultiIndex index) throws IOException {
            if (this.doc == null) {
                try {
                    this.doc = this.node != null ? index.createDocument(this.node) : index.createDocument(this.uuid);
                }
                catch (RepositoryException e) {
                    log.debug(e.getMessage());
                }
            }
            if (this.doc != null) {
                if (this.synch) {
                    MultiIndex multiIndex = index;
                    synchronized (multiIndex) {
                        index.volatileIndex.addDocuments(new Document[]{this.doc});
                    }
                } else {
                    index.volatileIndex.addDocuments(new Document[]{this.doc});
                }
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer(ENTRY_LENGTH);
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("ADD");
            logLine.append(' ');
            logLine.append(this.uuid);
            return logLine.toString();
        }
    }

    private static class AddIndex
    extends Action {
        private String indexName;

        AddIndex(long transactionId, String indexName) {
            super(transactionId, 6);
            this.indexName = indexName;
        }

        static AddIndex fromString(long transactionId, String arguments) {
            return new AddIndex(transactionId, arguments);
        }

        public void execute(MultiIndex index) throws IOException {
            PersistentIndex idx = index.getOrCreateIndex(this.indexName);
            if (!index.indexNames.contains(this.indexName)) {
                index.indexNames.addName(this.indexName);
                if (index.merger != null) {
                    index.merger.indexAdded(this.indexName, idx.getNumDocuments());
                }
            }
        }

        public String toString() {
            StringBuffer logLine = new StringBuffer();
            logLine.append(Long.toString(this.getTransactionId()));
            logLine.append(' ');
            logLine.append("ADD_IDX");
            logLine.append(' ');
            logLine.append(this.indexName);
            return logLine.toString();
        }
    }

    public static abstract class Action {
        static final String START = "STR";
        public static final int TYPE_START = 0;
        static final String ADD_NODE = "ADD";
        public static final int TYPE_ADD_NODE = 1;
        static final String DELETE_NODE = "DEL";
        public static final int TYPE_DELETE_NODE = 2;
        static final String COMMIT = "COM";
        public static final int TYPE_COMMIT = 3;
        static final String VOLATILE_COMMIT = "VOL_COM";
        static final String OFFLINE_INVOKE = "OFF_INV";
        public static final int TYPE_VOLATILE_COMMIT = 4;
        public static final int TYPE_OFFLINE_INVOKE = 8;
        static final String CREATE_INDEX = "CRE_IDX";
        public static final int TYPE_CREATE_INDEX = 5;
        static final String ADD_INDEX = "ADD_IDX";
        public static final int TYPE_ADD_INDEX = 6;
        static final String DELETE_INDEX = "DEL_IDX";
        public static final int TYPE_DELETE_INDEX = 7;
        static final long INTERNAL_TRANSACTION = -1L;
        static final long INTERNAL_TRANS_REPL_INDEXES = -2L;
        private final long transactionId;
        private final int type;

        Action(long transactionId, int type) {
            this.transactionId = transactionId;
            this.type = type;
        }

        long getTransactionId() {
            return this.transactionId;
        }

        int getType() {
            return this.type;
        }

        public abstract void execute(MultiIndex var1) throws IOException;

        public void undo(MultiIndex index) throws IOException {
        }

        public abstract String toString();

        static Action fromString(String line) throws IllegalArgumentException {
            Action a;
            long transactionId;
            int endTransIdx = line.indexOf(32);
            if (endTransIdx == -1) {
                throw new IllegalArgumentException(line);
            }
            try {
                transactionId = Long.parseLong(line.substring(0, endTransIdx));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(line);
            }
            int endActionIdx = line.indexOf(32, endTransIdx + 1);
            if (endActionIdx == -1) {
                endActionIdx = line.length();
            }
            String actionLabel = line.substring(endTransIdx + 1, endActionIdx);
            String arguments = "";
            if (endActionIdx + 1 <= line.length()) {
                arguments = line.substring(endActionIdx + 1);
            }
            if (actionLabel.equals(ADD_NODE)) {
                a = AddNode.fromString(transactionId, arguments);
            } else if (actionLabel.equals(ADD_INDEX)) {
                a = AddIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(COMMIT)) {
                a = Commit.fromString(transactionId, arguments);
            } else if (actionLabel.equals(CREATE_INDEX)) {
                a = CreateIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(DELETE_INDEX)) {
                a = DeleteIndex.fromString(transactionId, arguments);
            } else if (actionLabel.equals(DELETE_NODE)) {
                a = DeleteNode.fromString(transactionId, arguments);
            } else if (actionLabel.equals(START)) {
                a = Start.fromString(transactionId, arguments);
            } else if (actionLabel.equals(VOLATILE_COMMIT)) {
                a = VolatileCommit.fromString(transactionId, arguments);
            } else if (actionLabel.equals(OFFLINE_INVOKE)) {
                a = OfflineInvoke.fromString(transactionId, arguments);
            } else {
                throw new IllegalArgumentException(line);
            }
            return a;
        }
    }
}

