/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.common.util;

import org.exoplatform.services.common.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree<E> {
    protected E value;
    protected transient Tree<E> parent;
    protected transient Tree<E> firstChild;
    protected transient int size = 0;
    protected transient Tree<E> nextSibling;

    public Tree(E value) {
        this.value = value;
    }

    public Tree(E value, Tree<E> parent) {
        this.value = value;
        this.parent = parent;
        parent.addChild(this);
    }

    public void addChild(Tree<E> node) {
        if (node.parent != this) {
            node.parent = this;
        }
        ++this.size;
        if (this.firstChild == null) {
            this.firstChild = node;
            return;
        }
        Tree<E> n = this.firstChild;
        while (n.nextSibling != null) {
            n = n.nextSibling;
        }
        n.nextSibling = node;
    }

    public void insertChild(int idx, Tree<E> node) {
        this.checkRange(idx);
        if (node.parent != this) {
            node.parent = this;
        }
        ++this.size;
        if (idx == 0) {
            Tree<E> temp = this.firstChild;
            this.firstChild = node;
            node.nextSibling = temp;
            return;
        }
        Tree<E> n = this.getElement(idx - 1);
        Tree<E> temp = n.nextSibling;
        n.nextSibling = node;
        node.nextSibling = temp;
    }

    public Iterator<E> iteratorChildren() {
        return new Iterator<E>(this.firstChild);
    }

    public Tree<E> getChild(int idx) {
        this.checkRange(idx);
        return this.getElement(idx);
    }

    public Tree<E> removeChild(int idx) {
        this.checkRange(idx);
        Tree<E> n = this.getElement(idx - 1);
        if (n == null) {
            return null;
        }
        Tree<E> temp = n.nextSibling;
        n.nextSibling = temp.nextSibling;
        --this.size;
        return temp;
    }

    public Tree<E>[] getChildren() {
        Tree[] values = new Tree[this.size];
        Tree<E> n = this.firstChild;
        for (int i = 0; i < this.size; ++i) {
            values[i] = n;
            n = n.nextSibling;
        }
        return values;
    }

    private Tree<E> getElement(int idx) {
        Tree<E> n = this.firstChild;
        for (int i = 0; n.nextSibling != null && i != idx; ++i) {
            n = n.nextSibling;
        }
        return n;
    }

    private void checkRange(int index) {
        if (this.firstChild == null) {
            throw new IndexOutOfBoundsException("Node has any children");
        }
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("Negative index : " + index);
        }
    }

    public E getValue() {
        return this.value;
    }

    public void setValue(E value) {
        this.value = value;
    }

    protected Tree<E> getNextSibling() {
        return this.nextSibling;
    }

    public int getSize() {
        return this.size;
    }

    public <T extends Tree> T getParent() {
        return (T)this.parent;
    }
}

