/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.replication.test;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.version.Version;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.ext.replication.test.BaseReplicationTestCase;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class VersionTestCase
extends BaseReplicationTestCase {
    private static final Log log = ExoLogger.getLogger("exo.jcr.component.ext.VersionTestCase");

    public VersionTestCase(RepositoryService repositoryService, String reposytoryName, String workspaceName, String userName, String password) {
        super(repositoryService, reposytoryName, workspaceName, userName, password);
        log.info("NtFileTestCase inited");
    }

    public StringBuffer addVersionNode(String repoPath, String value) {
        StringBuffer sb = new StringBuffer();
        try {
            Node srcVersionNode = this.addNodePath(repoPath);
            srcVersionNode.setProperty("jcr:data", value);
            srcVersionNode.addMixin("mix:versionable");
            this.session.save();
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't create versioning node: ", e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer checkVersionNode(String repoPath, String checkedValue) {
        StringBuffer sb = new StringBuffer();
        String normalizePath = this.getNormalizePath(repoPath);
        try {
            Node destVersionNode = (Node)this.session.getItem(normalizePath);
            if (checkedValue.equals(destVersionNode.getProperty("jcr:data").getString())) {
                sb.append("ok");
            } else {
                sb.append("fail");
            }
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't create versioning node: ", e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer addNewVersion(String repoPath, String newValue) {
        StringBuffer sb = new StringBuffer();
        String normalizePath = this.getNormalizePath(repoPath);
        try {
            Node srcVersionNode = (Node)this.session.getItem(normalizePath);
            srcVersionNode.checkin();
            this.session.save();
            srcVersionNode.checkout();
            srcVersionNode.setProperty("jcr:data", newValue);
            this.session.save();
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't add versioning node value: ", e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer restorePreviousVersion(String repoPath) {
        StringBuffer sb = new StringBuffer();
        String normalizePath = this.getNormalizePath(repoPath);
        try {
            Node srcVersionNode = (Node)this.session.getItem(normalizePath);
            Version baseVersion = srcVersionNode.getBaseVersion();
            srcVersionNode.restore(baseVersion, true);
            this.session.save();
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't restore previous version: ", e);
            sb.append("fail");
        }
        return sb;
    }

    public StringBuffer restoreBaseVersion(String repoPath) {
        StringBuffer sb = new StringBuffer();
        String normalizePath = this.getNormalizePath(repoPath);
        try {
            Node srcVersionNode = (Node)this.session.getItem(normalizePath);
            Version baseVersion1 = srcVersionNode.getBaseVersion();
            Version[] predesessors = baseVersion1.getPredecessors();
            Version restoreToBaseVersion = predesessors[0];
            srcVersionNode.restore(restoreToBaseVersion, true);
            this.session.save();
            sb.append("ok");
        }
        catch (RepositoryException e) {
            log.error((Object)"Can't restore previous version: ", e);
            sb.append("fail");
        }
        return sb;
    }
}

