/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;

public class ImageUtils {
    public static InputStream scaleImage(BufferedImage image, int maxWidth, int maxHeight) throws Exception {
        return ImageUtils.scaleImage(image, maxWidth, maxHeight, false);
    }

    public static InputStream scaleImage(BufferedImage image, int maxWidth, int maxHeight, boolean crop) throws Exception {
        int dh;
        int dw;
        int imageWidth = image.getWidth(null);
        int imageHeight = image.getHeight(null);
        double widthRatio = (double)maxWidth / (double)imageWidth;
        double heightRatio = (double)maxHeight / (double)imageHeight;
        int dy = 0;
        int dx = 0;
        if (!crop) {
            if (maxWidth > 0 && imageWidth > maxWidth) {
                imageHeight = (int)((double)imageHeight * widthRatio);
                imageWidth = maxWidth;
            }
            if (maxHeight > 0 && imageHeight > maxHeight) {
                imageWidth = (int)((double)imageWidth * heightRatio);
                imageHeight = maxHeight;
            }
            dw = imageWidth;
            dh = imageHeight;
        } else if (maxHeight == 0) {
            imageHeight = (int)((double)imageHeight * widthRatio);
            dw = imageWidth = maxWidth;
            dh = imageHeight;
        } else if (maxWidth == 0) {
            imageWidth = (int)((double)imageWidth * heightRatio);
            imageHeight = maxHeight;
            dw = imageWidth;
            dh = imageHeight;
        } else {
            double srcRatio = (double)imageWidth / (double)imageHeight;
            double tgtRatio = (double)maxWidth / (double)maxHeight;
            if (srcRatio < tgtRatio) {
                dx = 0;
                dw = maxWidth;
                dh = (int)((double)imageHeight * widthRatio);
                dy = maxHeight / 2 - dh / 2;
            } else {
                dy = 0;
                dh = maxHeight;
                dw = (int)((double)imageWidth * heightRatio);
                dx = maxWidth / 2 - dw / 2;
            }
            imageWidth = maxWidth;
            imageHeight = maxHeight;
        }
        BufferedImage thumbImage = new BufferedImage(imageWidth, imageHeight, 1);
        Graphics2D graphics2D = thumbImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.drawImage(image, dx, dy, dw, dh, null);
        graphics2D.dispose();
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName("jpeg");
        ImageWriter writer = iter.next();
        JPEGImageWriteParam iwp = (JPEGImageWriteParam)writer.getDefaultWriteParam();
        int quality = 85;
        quality = Math.max(0, Math.min(quality, 100));
        iwp.setCompressionMode(2);
        iwp.setCompressionQuality((float)quality / 100.0f);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        writer.setOutput(ImageIO.createImageOutputStream(out));
        IIOImage iioImage = new IIOImage(thumbImage, null, null);
        writer.write(null, iioImage, iwp);
        writer.dispose();
        ByteArrayInputStream bis = new ByteArrayInputStream(out.toByteArray());
        return bis;
    }
}

