/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.portlet.aspects;

import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.portlet.PortletInvokerInterceptor;

public class SessionInvalidatorInterceptor
extends PortletInvokerInterceptor {
    private static final String IDENTITY_TOKEN = "javax.portlet.identity.token";
    private static final Logger log = LoggerFactory.getLogger(SessionInvalidatorInterceptor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        HttpServletRequest req = invocation.getDispatchedRequest();
        this.check(req);
        try {
            PortletInvocationResponse portletInvocationResponse = super.invoke(invocation);
            return portletInvocationResponse;
        }
        finally {
            this.update(req);
        }
    }

    public void update(HttpServletRequest request) {
        String portalIdentity = request.getRemoteUser();
        boolean trace = log.isTraceEnabled();
        String contextPath = request.getContextPath();
        HttpSession session = request.getSession(false);
        if (session != null) {
            String id = session.getId();
            String sessionIdentity = (String)session.getAttribute(IDENTITY_TOKEN);
            if (portalIdentity != null) {
                if (!portalIdentity.equals(sessionIdentity)) {
                    if (trace) {
                        log.trace((Object)("Updating portlet session " + id + " (" + contextPath + ") from " + sessionIdentity + " to " + portalIdentity));
                    }
                    session.setAttribute(IDENTITY_TOKEN, (Object)portalIdentity);
                }
            } else if (sessionIdentity != null) {
                if (trace) {
                    log.trace((Object)("Updating portlet session " + id + " (" + contextPath + ") by removing the " + sessionIdentity + " value"));
                }
                session.removeAttribute(IDENTITY_TOKEN);
            }
        }
    }

    public void check(HttpServletRequest request) {
        boolean trace = log.isTraceEnabled();
        String portalIdentity = request.getRemoteUser();
        String contextPath = request.getContextPath();
        HttpSession session = request.getSession(false);
        if (session != null) {
            String id = session.getId();
            String sessionIdentity = (String)session.getAttribute(IDENTITY_TOKEN);
            if (portalIdentity == null) {
                if (sessionIdentity != null) {
                    if (trace) {
                        log.trace((Object)("Detected user logout for session " + id + " (" + contextPath + ")"));
                    }
                    this.purge(session);
                }
            } else if (sessionIdentity != null && !sessionIdentity.equals(portalIdentity)) {
                if (trace) {
                    log.trace((Object)("Detected different user for session " + id + " (" + contextPath + ")"));
                }
                this.purge(session);
            }
        }
    }

    private void purge(HttpSession session) {
        for (String name : Collections.list(session.getAttributeNames())) {
            session.removeAttribute(name);
        }
    }
}

