/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.newsletter.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.newsletter.NewsletterConstant;
import org.exoplatform.services.wcm.newsletter.NewsletterSubscriptionConfig;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewsletterSubscriptionHandler {
    private static Log log = ExoLogger.getLogger(NewsletterSubscriptionHandler.class);
    private RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
    private String workspace;
    private boolean isRemove;

    public boolean isRemove() {
        return this.isRemove;
    }

    public void setRemove(boolean isRemove) {
        this.isRemove = isRemove;
    }

    public List<String> updatePermissionForSubscriptionNode(Node subscriptionNode, NewsletterSubscriptionConfig subscriptionConfig, boolean isAddNew) throws Exception {
        ExtendedNode extendedSubscriptionNode = (ExtendedNode)ExtendedNode.class.cast(subscriptionNode);
        ArrayList<String> afterRemovePermisions = new ArrayList<String>();
        if (extendedSubscriptionNode.canAddMixin("exo:privilegeable") || extendedSubscriptionNode.isNodeType("exo:privilegeable")) {
            List<String> allPermissions;
            if (extendedSubscriptionNode.canAddMixin("exo:privilegeable")) {
                extendedSubscriptionNode.addMixin("exo:privilegeable");
            }
            ArrayList<String> newRedactors = new ArrayList<String>();
            if (subscriptionConfig.getRedactor() != null && subscriptionConfig.getRedactor().trim().length() > 0) {
                newRedactors.addAll(Arrays.asList(subscriptionConfig.getRedactor().split(",")));
            }
            Node categoryNode = subscriptionNode.getParent();
            Node categoriesNode = categoryNode.getParent();
            List<String> listModerators = NewsletterConstant.getAllPermissionOfNode(categoryNode);
            List<Object> listAddministrators = new ArrayList<String>();
            if (categoriesNode.hasProperty("exo:newsletteraddministrator")) {
                Value[] values = categoriesNode.getProperty("exo:newsletteraddministrator").getValues();
                listAddministrators = NewsletterConstant.convertValuesToArray(values);
            }
            listAddministrators.addAll(listModerators);
            String[] permissions = new String[]{"remove", "add_node", "set_property"};
            ExtendedNode categoryExtend = (ExtendedNode)ExtendedNode.class.cast(categoryNode);
            for (String string : newRedactors) {
                if (listModerators.contains(string)) continue;
                categoryExtend.setPermission(string, permissions);
            }
            categoryExtend.getSession().save();
            for (String string : newRedactors) {
                extendedSubscriptionNode.setPermission(string, PermissionType.ALL);
            }
            permissions = new String[]{"read", "add_node", "remove", "set_property"};
            for (String string : listAddministrators) {
                if (newRedactors.contains(string)) continue;
                extendedSubscriptionNode.setPermission(string, permissions);
                newRedactors.add(string);
            }
            permissions = new String[]{"read", "set_property"};
            if (isAddNew) {
                extendedSubscriptionNode.setPermission("any", permissions);
            }
            if ((allPermissions = NewsletterConstant.getAllPermissionOfNode(subscriptionNode)) != null && allPermissions.size() > 0) {
                for (String oldPer : allPermissions) {
                    if (newRedactors.contains(oldPer)) continue;
                    extendedSubscriptionNode.removePermission(oldPer, "add_node");
                    extendedSubscriptionNode.removePermission(oldPer, "remove");
                    extendedSubscriptionNode.removePermission(oldPer, "add_node,set_property,remove");
                    extendedSubscriptionNode.setPermission(oldPer, permissions);
                    afterRemovePermisions.add(oldPer);
                }
            }
        }
        extendedSubscriptionNode.save();
        return afterRemovePermisions;
    }

    @Deprecated
    public NewsletterSubscriptionHandler(String repository, String workspace) {
        this.workspace = workspace;
    }

    public NewsletterSubscriptionHandler(String workspace) {
        this.workspace = workspace;
    }

    private NewsletterSubscriptionConfig getSubscriptionFormNode(Node subscriptionNode) throws Exception {
        NewsletterSubscriptionConfig subscriptionConfig = new NewsletterSubscriptionConfig();
        subscriptionConfig.setName(subscriptionNode.getName());
        subscriptionConfig.setTitle(subscriptionNode.getProperty("exo:newsletterSubscriptionTitle").getString());
        if (subscriptionNode.hasProperty("exo:newsletterSubscriptionDecription")) {
            subscriptionConfig.setDescription(subscriptionNode.getProperty("exo:newsletterSubscriptionDecription").getString());
        }
        subscriptionConfig.setCategoryName(subscriptionNode.getProperty("exo:newsletterSubscriptionCategoryName").getString());
        String permission = "";
        for (String per : NewsletterConstant.getAllPermissionOfNode(subscriptionNode)) {
            if (permission.length() > 0) {
                permission = permission + ",";
            }
            permission = permission + per;
        }
        subscriptionConfig.setRedactor(permission);
        return subscriptionConfig;
    }

    public void add(SessionProvider sessionProvider, String portalName, NewsletterSubscriptionConfig subscription) throws Exception {
        log.info((Object)("Trying to add subcription " + subscription.getName()));
        Session session = null;
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            session = sessionProvider.getSession(this.workspace, manageableRepository);
            String path = NewsletterConstant.generateCategoryPath(portalName);
            Node categoryNode = ((Node)session.getItem(path)).getNode(subscription.getCategoryName());
            Node subscriptionNode = categoryNode.addNode(subscription.getName(), "exo:newsletterSubscription");
            subscriptionNode.setProperty("exo:newsletterSubscriptionTitle", subscription.getTitle());
            subscriptionNode.setProperty("exo:newsletterSubscriptionDecription", subscription.getDescription());
            subscriptionNode.setProperty("exo:newsletterSubscriptionCategoryName", subscription.getCategoryName());
            this.updatePermissionForSubscriptionNode(subscriptionNode, subscription, true);
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Add subcription " + subscription.getName() + " failed because of "), (Throwable)e);
            throw e;
        }
    }

    public void edit(SessionProvider sessionProvider, String portalName, NewsletterSubscriptionConfig subscription) {
        log.info((Object)("Trying to edit subcription " + subscription.getName()));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String path = NewsletterConstant.generateCategoryPath(portalName);
            Node categoryNode = ((Node)session.getItem(path)).getNode(subscription.getCategoryName());
            Node subscriptionNode = categoryNode.getNode(subscription.getName());
            subscriptionNode.setProperty("exo:newsletterSubscriptionTitle", subscription.getTitle());
            subscriptionNode.setProperty("exo:newsletterSubscriptionDecription", subscription.getDescription());
            subscriptionNode.setProperty("exo:newsletterSubscriptionCategoryName", subscription.getCategoryName());
            List<String> candicateRemove = this.updatePermissionForSubscriptionNode(subscriptionNode, subscription, false);
            if (this.isRemove) {
                List<String> ableToRemove = NewsletterConstant.removePermission(subscriptionNode, null, candicateRemove, false, portalName, session);
                String[] removePer = new String[ableToRemove.size()];
                NewsletterConstant.removeAccessPermission(ableToRemove.toArray(removePer));
            }
            categoryNode.save();
        }
        catch (Exception e) {
            log.error((Object)("Edit subcription " + subscription.getName() + " failed because of "), (Throwable)e);
        }
    }

    public void delete(SessionProvider sessionProvider, String portalName, String categoryName, NewsletterSubscriptionConfig subscription) {
        log.info((Object)("Trying to delete subcription " + subscription.getName()));
        try {
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session session = sessionProvider.getSession(this.workspace, manageableRepository);
            String path = NewsletterConstant.generateCategoryPath(portalName);
            Node categoryNode = ((Node)session.getItem(path)).getNode(categoryName);
            Node subscriptionNode = categoryNode.getNode(subscription.getName());
            List<String> candicateRemove = NewsletterConstant.getAllRedactor(portalName, session);
            if (this.isRemove) {
                List<String> ableToRemove = NewsletterConstant.removePermission(subscriptionNode, null, candicateRemove, false, portalName, session);
                String[] removePer = new String[ableToRemove.size()];
                NewsletterConstant.removeAccessPermission(ableToRemove.toArray(removePer));
            }
            subscriptionNode.remove();
            session.save();
        }
        catch (Exception e) {
            log.error((Object)("Delete subcription " + subscription.getName() + " failed because of "), (Throwable)e);
        }
    }

    public List<NewsletterSubscriptionConfig> getSubscriptionsByCategory(SessionProvider sessionProvider, String portalName, String categoryName) throws Exception {
        ArrayList<NewsletterSubscriptionConfig> listSubscriptions = new ArrayList<NewsletterSubscriptionConfig>();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String path = NewsletterConstant.generateCategoryPath(portalName);
        try {
            Node categoryNode = ((Node)session.getItem(path)).getNode(categoryName);
            NodeIterator nodeIterator = categoryNode.getNodes();
            while (nodeIterator.hasNext()) {
                try {
                    Node childNode = nodeIterator.nextNode();
                    if (!childNode.isNodeType("exo:newsletterSubscription")) continue;
                    listSubscriptions.add(this.getSubscriptionFormNode(childNode));
                }
                catch (Exception ex) {
                    log.error((Object)("Error when get subcriptions by category " + categoryName + " failed because of "), (Throwable)ex);
                }
            }
        }
        catch (RepositoryException repo) {
            return new ArrayList<NewsletterSubscriptionConfig>();
        }
        return listSubscriptions;
    }

    public List<NewsletterSubscriptionConfig> getSubscriptionByRedactor(String portalName, String categoryName, String userName, SessionProvider sessionProvider) throws Exception {
        ArrayList<NewsletterSubscriptionConfig> listSubs = new ArrayList<NewsletterSubscriptionConfig>();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String categoriesPath = NewsletterConstant.generateCategoryPath(portalName);
        String categoryPath = categoriesPath + "/" + categoryName;
        Node categoryNode = (Node)session.getItem(categoryPath);
        NodeIterator subscriptionIterator = categoryNode.getNodes();
        while (subscriptionIterator.hasNext()) {
            try {
                Node subscriptionNode = subscriptionIterator.nextNode();
                if (!subscriptionNode.isNodeType("exo:newsletterSubscription") || !NewsletterConstant.hasPermission(userName, subscriptionNode)) continue;
                listSubs.add(this.getSubscriptionFormNode(subscriptionNode));
            }
            catch (Exception ex) {
                log.error((Object)("Error when get subcriptions by category " + categoryName + " failed because of "), (Throwable)ex);
            }
        }
        return listSubs;
    }

    public List<NewsletterSubscriptionConfig> getSubscriptionIdsByPublicUser(SessionProvider sessionProvider, String portalName, String userEmail) throws Exception {
        ArrayList<NewsletterSubscriptionConfig> listSubscriptions = new ArrayList<NewsletterSubscriptionConfig>();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String sqlQuery = "select * from exo:newsletterSubscription where exo:newsletterSubscribedUser = '" + userEmail + "'";
        Query query = queryManager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        while (nodeIterator.hasNext()) {
            try {
                listSubscriptions.add(this.getSubscriptionFormNode(nodeIterator.nextNode()));
            }
            catch (Exception ex) {
                log.error((Object)"getSubscriptionIdsByPublicUser() failed because of ", (Throwable)ex);
            }
        }
        return listSubscriptions;
    }

    public NewsletterSubscriptionConfig getSubscriptionsByName(SessionProvider sessionProvider, String portalName, String categoryName, String subCriptionName) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String path = NewsletterConstant.generateCategoryPath(portalName);
        Node categoryNode = ((Node)session.getItem(path)).getNode(categoryName);
        try {
            Node subNode = categoryNode.getNode(subCriptionName);
            return this.getSubscriptionFormNode(subNode);
        }
        catch (Exception e) {
            log.info((Object)("Node name is not found: " + subCriptionName));
            return null;
        }
    }

    public long getNumberOfNewslettersWaiting(SessionProvider sessionProvider, String portalName, String categoryName, String subScriptionName) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(this.workspace, manageableRepository);
        String path = NewsletterConstant.generateCategoryPath(portalName) + "/" + categoryName + "/" + subScriptionName;
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        String sqlQuery = "select * from exo:newsletterEntry where jcr:path LIKE '" + path + "[%]/%' and " + "exo:newsletterEntryStatus" + " = '" + "awaiting" + "'";
        Query query = queryManager.createQuery(sqlQuery, "sql");
        QueryResult queryResult = query.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        return nodeIterator.getSize();
    }
}

