/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.rewrite;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.List;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.rewrite.ConcatVisitor;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.DomWalker;
import org.apache.shindig.gadgets.uri.ConcatUriManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptConcatContentRewriter
extends DomWalker.Rewriter {
    private final ContentRewriterFeature.Factory featureConfigFactory;
    private final ConcatUriManager concatUriManager;

    @Inject
    public ScriptConcatContentRewriter(ContentRewriterFeature.Factory featureConfigFactory, ConcatUriManager concatUriManager) {
        this.featureConfigFactory = featureConfigFactory;
        this.concatUriManager = concatUriManager;
    }

    @Override
    protected List<DomWalker.Visitor> makeVisitors(Gadget context, Uri gadgetUri) {
        ContentRewriterFeature.Config config = this.featureConfigFactory.get(gadgetUri);
        return Arrays.asList(new ConcatVisitor.Js(config, this.concatUriManager));
    }
}

