/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.web.application.javascript;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import javax.servlet.ServletContext;
import org.exoplatform.web.application.javascript.JavascriptKey;

public class Javascript {
    private final JavascriptKey key;
    private final ServletContext context;
    private final int priority;

    public Javascript(JavascriptKey key, ServletContext context, Integer priority) {
        this.key = key;
        this.context = context;
        this.priority = priority != null ? priority : -1;
    }

    public String getPath() {
        if (this.key.isExternalScript()) {
            return this.key.getScriptPath();
        }
        return this.key.getContextPath() + this.key.getScriptPath();
    }

    public JavascriptKey getKey() {
        return this.key;
    }

    public ServletContext getContext() {
        return this.context;
    }

    public int getPriority() {
        return this.priority;
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader(this.context.getResourceAsStream(this.key.getScriptPath())));
    }
}

