/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search.base;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.search.base.AbstractPageList;
import org.exoplatform.services.wcm.search.base.ArrayNodePageList;
import org.exoplatform.services.wcm.search.base.NodeSearchFilter;
import org.exoplatform.services.wcm.search.base.QueryData;
import org.exoplatform.services.wcm.search.base.QueryResultPageList;
import org.exoplatform.services.wcm.search.base.SearchDataCreator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageListFactory {
    public static <E> AbstractPageList<E> createPageList(String queryStatement, String workspace, String language, boolean isSystemSession, NodeSearchFilter filter, SearchDataCreator<E> dataCreator, int pageSize, int bufferSize) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionProvider sessionProvider;
        Session session;
        QueryManager queryManager;
        Query query;
        QueryResult result;
        int totalNodes;
        if (pageSize == 0) {
            pageSize = 10;
        }
        if (bufferSize < pageSize) {
            bufferSize = Math.max(pageSize, 100);
        }
        if ((totalNodes = (int)(result = (query = (queryManager = (session = (sessionProvider = isSystemSession ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider()).getSession(workspace, WCMCoreUtils.getRepository())).getWorkspace().getQueryManager()).createQuery(queryStatement, language)).execute()).getNodes().getSize()) <= 100) {
            return new ArrayNodePageList<E>(result, pageSize, filter, dataCreator);
        }
        QueryData queryData = new QueryData(queryStatement, workspace, language, isSystemSession);
        QueryResultPageList ret = new QueryResultPageList(pageSize, queryData, totalNodes, bufferSize, filter, dataCreator);
        return ret;
    }

    public static <E> AbstractPageList<E> createPageList(String queryStatement, String workspace, String language, boolean isSystemSession, NodeSearchFilter filter, SearchDataCreator<E> dataCreator) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return PageListFactory.createPageList(queryStatement, workspace, language, isSystemSession, filter, dataCreator, 10, 100);
    }

    public static <E> AbstractPageList<E> createPageList(List<Node> nodes, int pageSize, NodeSearchFilter filter, SearchDataCreator<E> dataCreator) {
        return new ArrayNodePageList<E>(nodes, pageSize, filter, dataCreator);
    }

    public static <E> List<E> createPageList(String queryStatement, String workspace, String language, boolean isSystemSession, SearchDataCreator<E> dataCreator) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionProvider sessionProvider = isSystemSession ? WCMCoreUtils.getSystemSessionProvider() : WCMCoreUtils.getUserSessionProvider();
        Session session = sessionProvider.getSession(workspace, WCMCoreUtils.getRepository());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryStatement, language);
        QueryResult queryResult = query.execute();
        ArrayList<E> dataList = new ArrayList<E>();
        try {
            NodeIterator nodeIterator = queryResult.getNodes();
            RowIterator rowIterator = queryResult.getRows();
            while (nodeIterator.hasNext()) {
                E data;
                Node node = nodeIterator.nextNode();
                Row row = rowIterator.nextRow();
                if (dataCreator == null || node == null || (data = dataCreator.createData(node, row)) == null) continue;
                dataList.add(data);
            }
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return dataList;
    }
}

