/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.listener.navigation;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.ValueFactory;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NavigationService;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.navigation.NodeModel;
import org.exoplatform.portal.mop.navigation.Scope;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationEventListenerDelegate {
    private String lifecycleName;

    public NavigationEventListenerDelegate(String lifecycleName, ExoContainer container) {
        this.lifecycleName = lifecycleName;
    }

    public void updateLifecyleOnCreateNavigation(NavigationContext navigationContext) throws Exception {
    }

    public void updateLifecycleOnChangeNavigation(NavigationContext navigationContext, String remoteUser, WebpagePublicationPlugin plugin) throws Exception {
        if (navigationContext.getKey().getTypeName().equals(PortalConfig.PORTAL_TYPE)) {
            this.updateRemovedPageNode(navigationContext, remoteUser, plugin);
            this.updateAddedPageNode(navigationContext, remoteUser);
        }
    }

    public void updateLifecyleOnRemoveNavigation(NavigationContext navigationContext) throws Exception {
    }

    private void updateAddedPageNode(NavigationContext navigationContext, String remoteUser) throws Exception {
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)WCMCoreUtils.getService(UserPortalConfigService.class);
        WCMConfigurationService wcmConfigurationService = (WCMConfigurationService)WCMCoreUtils.getService(WCMConfigurationService.class);
        NavigationService navigationService = (NavigationService)WCMCoreUtils.getService(NavigationService.class);
        NodeContext nodeContext = navigationService.loadNode(NodeModel.SELF_MODEL, navigationContext, Scope.ALL, null);
        String portletName = wcmConfigurationService.getRuntimeContextParam("SCVPortlet");
        for (NodeContext<?> context : PublicationUtil.convertAllNodeContextToList(nodeContext)) {
            Page page = null;
            page = remoteUser == null ? userPortalConfigService.getPage(context.getState().getPageRef()) : userPortalConfigService.getPage(context.getState().getPageRef(), remoteUser);
            if (page == null) continue;
            for (String applicationId : PublicationUtil.getListApplicationIdByPage(page, portletName)) {
                List<String> listExistedApplicationId;
                Node content = PublicationUtil.getNodeByApplicationId(applicationId);
                if (content == null || (listExistedApplicationId = PublicationUtil.getValuesAsString(content, "publication:applicationIDs")).contains(PublicationUtil.setMixedApplicationId(page.getPageId(), applicationId))) continue;
                this.saveAddedPageNode(navigationContext.getKey().getName(), context, applicationId, content);
            }
        }
    }

    private void updateRemovedPageNode(NavigationContext navigationContext, String remoteUser, WebpagePublicationPlugin plugin) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        NavigationService navigationService = (NavigationService)container.getComponentInstanceOfType(NavigationService.class);
        NodeContext nodeContext = navigationService.loadNode(NodeModel.SELF_MODEL, navigationContext, Scope.ALL, null);
        String portalName = navigationContext.getKey().getName();
        ArrayList<NodeContext<?>> listNodeContext = PublicationUtil.convertAllNodeContextToList(nodeContext);
        ArrayList<String> listPortalNavigationUri = new ArrayList<String>();
        ArrayList<String> listPageReference = new ArrayList<String>();
        for (NodeContext nodeContext2 : listNodeContext) {
            String mixedNavigationNodeUri = PublicationUtil.setMixedNavigationUri(portalName, PublicationUtil.buildUserNodeURI(nodeContext2).toString());
            listPortalNavigationUri.add(mixedNavigationNodeUri);
            listPageReference.add(nodeContext2.getState().getPageRef());
        }
        RepositoryService repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        WCMConfigurationService wCMConfigurationService = (WCMConfigurationService)WCMCoreUtils.getService(WCMConfigurationService.class);
        ManageableRepository repository = repositoryService.getCurrentRepository();
        NodeLocation nodeLocation = wCMConfigurationService.getLivePortalsLocation(repository.getConfiguration().getName());
        String portletName = wCMConfigurationService.getRuntimeContextParam("SCVPortlet");
        String workspaceName = nodeLocation.getWorkspace();
        String path = nodeLocation.getPath();
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Session session = sessionProvider.getSession(workspaceName, repositoryService.getCurrentRepository());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery("select * from " + plugin.getLifecycleType() + " where publication:lifecycleName='" + this.lifecycleName + "' and jcr:path like '" + path + "/%' order by jcr:score", "sql");
        QueryResult results = query.execute();
        NodeIterator nodeIterator = results.getNodes();
        while (nodeIterator.hasNext()) {
            Node content = nodeIterator.nextNode();
            String navigationNodeUri = "";
            for (String existedNavigationNodeUri : PublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs")) {
                if (!existedNavigationNodeUri.startsWith("/" + portalName)) continue;
                navigationNodeUri = existedNavigationNodeUri;
            }
            String pageId = "";
            for (String existedPageId : PublicationUtil.getValuesAsString(content, "publication:webPageIDs")) {
                if (listPageReference.contains(existedPageId)) continue;
                pageId = existedPageId;
            }
            if (pageId.equals("")) continue;
            String applicationId = "";
            UserPortalConfigService userPortalConfigService = (UserPortalConfigService)WCMCoreUtils.getService(UserPortalConfigService.class);
            Page page = null;
            page = remoteUser == null ? userPortalConfigService.getPage(pageId) : userPortalConfigService.getPage(pageId, remoteUser);
            for (String applicationIdTmp : PublicationUtil.getListApplicationIdByPage(page, portletName)) {
                applicationIdTmp = PublicationUtil.setMixedApplicationId(pageId, applicationIdTmp);
                List<String> listExistedApplicationId = PublicationUtil.getValuesAsString(content, "publication:applicationIDs");
                if (!listExistedApplicationId.contains(applicationIdTmp)) continue;
                applicationId = applicationIdTmp;
            }
            this.saveRemovedPageNode(navigationNodeUri, pageId, applicationId, content);
        }
    }

    private void saveAddedPageNode(String portalName, NodeContext<?> nodeContext, String applicationId, Node content) throws Exception {
        String mixedApplicationId;
        PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
        String nodeLifecycleName = null;
        try {
            nodeLifecycleName = publicationService.getNodeLifecycleName(content);
        }
        catch (NotInPublicationLifecycleException e) {
            return;
        }
        if (!this.lifecycleName.equals(nodeLifecycleName)) {
            return;
        }
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        List<String> listExistedApplicationId = PublicationUtil.getValuesAsString(content, "publication:applicationIDs");
        if (listExistedApplicationId.contains(mixedApplicationId = PublicationUtil.setMixedApplicationId(nodeContext.getState().getPageRef(), applicationId))) {
            return;
        }
        listExistedApplicationId.add(mixedApplicationId);
        content.setProperty("publication:applicationIDs", PublicationUtil.toValues(valueFactory, listExistedApplicationId));
        List<String> listExistedNavigationNodeUri = PublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs");
        String mixedNavigationNodeUri = PublicationUtil.setMixedNavigationUri(portalName, PublicationUtil.buildUserNodeURI(nodeContext).toString());
        listExistedNavigationNodeUri.add(mixedNavigationNodeUri);
        content.setProperty("publication:navigationNodeURIs", PublicationUtil.toValues(valueFactory, listExistedNavigationNodeUri));
        List<String> listExistedWebPageId = PublicationUtil.getValuesAsString(content, "publication:webPageIDs");
        listExistedWebPageId.add(nodeContext.getState().getPageRef());
        content.setProperty("publication:webPageIDs", PublicationUtil.toValues(valueFactory, listExistedWebPageId));
        session.save();
    }

    private void saveRemovedPageNode(String navigationNodeUri, String pageId, String applicationId, Node content) throws Exception {
        Session session = content.getSession();
        ValueFactory valueFactory = session.getValueFactory();
        List<String> listExistedNavigationNodeUri = PublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs");
        List<String> listExistedNavigationNodeUriTmp = PublicationUtil.getValuesAsString(content, "publication:navigationNodeURIs");
        if (listExistedNavigationNodeUri.contains(navigationNodeUri)) {
            listExistedNavigationNodeUriTmp.remove(navigationNodeUri);
        }
        content.setProperty("publication:navigationNodeURIs", PublicationUtil.toValues(valueFactory, listExistedNavigationNodeUriTmp));
        List<String> listExistedPageId = PublicationUtil.getValuesAsString(content, "publication:webPageIDs");
        List<String> listExistedPageIdTmp = PublicationUtil.getValuesAsString(content, "publication:webPageIDs");
        if (listExistedPageId.contains(pageId)) {
            listExistedPageIdTmp.remove(pageId);
        }
        content.setProperty("publication:webPageIDs", PublicationUtil.toValues(valueFactory, listExistedPageIdTmp));
        List<String> listExistedApplicationId = PublicationUtil.getValuesAsString(content, "publication:applicationIDs");
        List<String> listExistedApplicationIdTmp = PublicationUtil.getValuesAsString(content, "publication:applicationIDs");
        if (listExistedApplicationId.contains(applicationId)) {
            listExistedApplicationIdTmp.remove(applicationId);
        }
        content.setProperty("publication:applicationIDs", PublicationUtil.toValues(valueFactory, listExistedApplicationIdTmp));
        session.save();
    }
}

