/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.mop.core.api.workspace;

import java.util.Collection;
import org.chromattic.api.RelationshipType;
import org.chromattic.api.annotations.Destroy;
import org.chromattic.api.annotations.ManyToOne;
import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.gatein.mop.api.workspace.ObjectType;
import org.gatein.mop.api.workspace.Page;
import org.gatein.mop.api.workspace.Templatized;
import org.gatein.mop.api.workspace.WorkspaceObject;
import org.gatein.mop.api.workspace.link.PageLink;
import org.gatein.mop.core.api.workspace.NavigationImpl;
import org.gatein.mop.core.api.workspace.PageContainer;
import org.gatein.mop.core.api.workspace.SiteImpl;
import org.gatein.mop.core.api.workspace.TemplatizedImpl;
import org.gatein.mop.core.api.workspace.UIContainerImpl;
import org.gatein.mop.core.api.workspace.WorkspaceCustomizationContextImpl;
import org.gatein.mop.core.api.workspace.WorkspaceObjectImpl;

@PrimaryType(name="mop:page")
public abstract class PageImpl
extends WorkspaceObjectImpl
implements Page {
    @OneToMany(type=RelationshipType.PATH)
    @MappedBy(value="mop:template")
    public abstract Collection<NavigationImpl> getTemplatizedNavigations();

    @OneToMany(type=RelationshipType.PATH)
    @MappedBy(value="mop:template")
    public abstract Collection<PageImpl> getTemplatizedPages();

    @OneToMany(type=RelationshipType.PATH)
    @MappedBy(value="mop:template")
    public abstract Collection<? extends TemplatizedImpl> getTemplatizedObjects();

    @OneToOne
    @MappedBy(value="mop:children")
    @Owner
    public abstract PageContainer getChildrenContainer();

    @ManyToOne
    public abstract PageContainer getParentContainer();

    @OneToOne
    @MappedBy(value="mop:rootpage")
    public abstract SiteImpl getSiteParent();

    @OneToOne
    @MappedBy(value="mop:rootcomponent")
    @Owner
    public abstract UIContainerImpl getRootComponent();

    @Destroy
    public abstract void destroy();

    @OneToOne(type=RelationshipType.EMBEDDED)
    @Owner
    public abstract WorkspaceCustomizationContextImpl getCustomizationContext();

    public Templatized templatize(WorkspaceObject object) {
        TemplatizedImpl templatized;
        if (object instanceof NavigationImpl) {
            NavigationImpl nav = (NavigationImpl)object;
            templatized = nav.getTemplatized();
            if (templatized != null) {
                throw new IllegalArgumentException("The object is already templatized");
            }
        } else {
            throw new UnsupportedOperationException();
        }
        templatized = (TemplatizedImpl)object.adapt(TemplatizedImpl.class);
        templatized.setTemplate(this);
        return templatized;
    }

    public ObjectType<? extends Page> getObjectType() {
        return ObjectType.PAGE;
    }

    public SiteImpl getSite() {
        PageContainer parent = this.getParentContainer();
        if (parent != null) {
            return parent.getOwner().getSite();
        }
        return this.getSiteParent();
    }

    public PageImpl getParent() {
        PageContainer parent = this.getParentContainer();
        if (parent != null) {
            return parent.getOwner();
        }
        return null;
    }

    public PageImpl addChild(String name) throws NullPointerException, IllegalArgumentException {
        PageContainer childrenContainer = this.getChildrenContainer();
        return childrenContainer.addPage(name);
    }

    public Collection<Page> getChildren() {
        PageContainer childrenContainer = this.getChildrenContainer();
        return childrenContainer.getPages().values();
    }

    public PageImpl getChild(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        PageContainer childrenContainer = this.getChildrenContainer();
        return childrenContainer.getPages().get(name);
    }

    public Collection<PageLink> getNavigations() {
        throw new UnsupportedOperationException();
    }
}

