/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss.fifo;

import java.io.Serializable;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.jboss.AbstractExoCache;
import org.exoplatform.services.cache.impl.jboss.AbstractExoCacheCreator;
import org.exoplatform.services.cache.impl.jboss.fifo.FIFOExoCacheConfig;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.eviction.FIFOAlgorithmConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIFOExoCacheCreator
extends AbstractExoCacheCreator {
    public static final String EXPECTED_IMPL = "FIFO";

    @Override
    public String getExpectedImplementation() {
        return EXPECTED_IMPL;
    }

    @Override
    public Class<? extends ExoCacheConfig> getExpectedConfigType() {
        return FIFOExoCacheConfig.class;
    }

    @Override
    public ExoCache<Serializable, Object> create(ExoCacheConfig config, Cache<Serializable, Object> cache) throws ExoCacheInitException {
        if (config instanceof FIFOExoCacheConfig) {
            FIFOExoCacheConfig fifoConfig = (FIFOExoCacheConfig)config;
            return this.create(config, cache, fifoConfig.getMaxNodes(), fifoConfig.getMinTimeToLive());
        }
        long period = config.getLiveTime();
        return this.create(config, cache, config.getMaxSize(), period > 0L ? period * 1000L : 0L);
    }

    private ExoCache<Serializable, Object> create(ExoCacheConfig config, Cache<Serializable, Object> cache, int maxNodes, long minTimeToLive) throws ExoCacheInitException {
        final FIFOAlgorithmConfig fifo = new FIFOAlgorithmConfig(maxNodes);
        fifo.setMinTimeToLive(minTimeToLive);
        Fqn<String> rooFqn = this.addEvictionRegion(config, cache, (EvictionAlgorithmConfig)fifo);
        return new AbstractExoCache<Serializable, Object>(config, cache, rooFqn){

            public void setMaxSize(int max) {
                fifo.setMaxNodes(max);
            }

            public void setLiveTime(long period) {
                fifo.setMinTimeToLive(period);
            }

            @ManagedName(value="MaxNodes")
            @ManagedDescription(value="This is the maximum number of nodes allowed in this region. 0 denotes immediate expiry, -1 denotes no limit.")
            public int getMaxSize() {
                return fifo.getMaxNodes();
            }

            @ManagedName(value="MinTimeToLive")
            @ManagedDescription(value="the minimum amount of time a node must be allowed to live after being accessed before it is allowed to be considered for eviction. 0 denotes that this feature is disabled, which is the default value.")
            public long getLiveTime() {
                return fifo.getMinTimeToLive();
            }
        };
    }
}

