/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.metamodel.typegen;

import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.jcr.PropertyType;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.chromattic.common.xml.DocumentEmitter;
import org.chromattic.common.xml.ElementEmitter;
import org.chromattic.metamodel.typegen.NodeType;
import org.chromattic.metamodel.typegen.NodeTypeSerializer;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLNodeTypeSerializer
extends NodeTypeSerializer {
    private DocumentEmitter docXML;
    private ElementEmitter nodeTypesXML;
    private ElementEmitter nodeTypeXML;
    private ElementEmitter propertyDefinitionsXML;
    private ElementEmitter childNodeDefinitionsXML;

    public XMLNodeTypeSerializer(List<NodeType> nodeTypes, Map<String, String> mappings) {
        super(nodeTypes, mappings);
    }

    public XMLNodeTypeSerializer(List<NodeType> nodeTypes) {
        super(nodeTypes);
    }

    public XMLNodeTypeSerializer(Map<String, String> mappings) {
        super(mappings);
    }

    public XMLNodeTypeSerializer() {
    }

    @Override
    public void writeTo(Writer writer) throws Exception {
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler handler = factory.newTransformerHandler();
        handler.getTransformer().setOutputProperty("method", "xml");
        handler.getTransformer().setOutputProperty("encoding", "UTF-8");
        handler.getTransformer().setOutputProperty("indent", "yes");
        handler.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        handler.setResult(new StreamResult(writer));
        this.docXML = new DocumentEmitter((ContentHandler)handler, (LexicalHandler)handler);
        this.docXML.comment("Node type generation prototype");
        this.writeTo();
    }

    @Override
    public void startNodeTypes(Map<String, String> mappings) throws SAXException {
        this.nodeTypesXML = this.docXML.documentElement("nodeTypes");
        for (Map.Entry<String, String> mapping : mappings.entrySet()) {
            this.nodeTypesXML.withNamespace(mapping.getKey(), mapping.getValue());
        }
    }

    @Override
    public void startNodeType(String javaClassName, String name, boolean mixin, boolean orderableChildNodes, Collection<String> superTypeNames) throws SAXException {
        this.nodeTypesXML.comment(" Node type generated for the class " + javaClassName + " ");
        this.nodeTypeXML = this.nodeTypesXML.element("nodeType").withAttribute("name", name).withAttribute("isMixin", Boolean.toString(mixin)).withAttribute("hasOrderableChildNodes", Boolean.toString(orderableChildNodes));
        ElementEmitter superTypesWriter = this.nodeTypeXML.element("supertypes");
        for (String superTypeName : superTypeNames) {
            superTypesWriter.element("supertype").content(superTypeName);
        }
    }

    @Override
    public void startProperties() throws SAXException {
        this.propertyDefinitionsXML = this.nodeTypeXML.element("propertyDefinitions");
    }

    @Override
    public void property(String name, int requiredType, boolean multiple, Collection<String> defaultValues, Collection<String> valueConstraints) throws SAXException {
        ElementEmitter propertyDefinitionXML = this.propertyDefinitionsXML.element("propertyDefinition").withAttribute("name", name).withAttribute("requiredType", PropertyType.nameFromValue((int)requiredType)).withAttribute("autoCreated", Boolean.FALSE.toString()).withAttribute("mandatory", Boolean.FALSE.toString()).withAttribute("onParentVersion", "COPY").withAttribute("protected", Boolean.FALSE.toString()).withAttribute("multiple", Boolean.toString(multiple));
        ElementEmitter valueConstraintsXML = propertyDefinitionXML.element("valueConstraints");
        if (valueConstraints != null) {
            for (String valueConstraint : valueConstraints) {
                valueConstraintsXML.element("valueConstraint").content(valueConstraint);
            }
        }
        valueConstraintsXML.close();
        if (defaultValues != null) {
            ElementEmitter defaultValuesXML = propertyDefinitionXML.element("defaultValues");
            for (String s : defaultValues) {
                defaultValuesXML.element("defaultValue").content(s);
            }
        }
    }

    @Override
    public void endProperties() throws SAXException {
        this.propertyDefinitionsXML.close();
        this.propertyDefinitionsXML = null;
    }

    @Override
    public void startChildNodes() throws SAXException {
        this.childNodeDefinitionsXML = this.nodeTypeXML.element("childNodeDefinitions");
    }

    @Override
    public void childNode(String name, String nodeTypeName, boolean mandatory, boolean autocreated) throws SAXException {
        this.childNodeDefinitionsXML.element("childNodeDefinition").withAttribute("name", name).withAttribute("defaultPrimaryType", nodeTypeName).withAttribute("autoCreated", Boolean.valueOf(autocreated).toString()).withAttribute("mandatory", Boolean.valueOf(mandatory).toString()).withAttribute("onParentVersion", "COPY").withAttribute("protected", "false").withAttribute("sameNameSiblings", "false").element("requiredPrimaryTypes").element("requiredPrimaryType").content(nodeTypeName);
    }

    @Override
    public void endChildNodes() throws SAXException {
        this.childNodeDefinitionsXML.close();
        this.childNodeDefinitionsXML = null;
    }

    @Override
    public void endNodeType() throws SAXException {
        this.nodeTypeXML.close();
        this.nodeTypeXML = null;
    }

    @Override
    public void endNodeTypes() throws SAXException {
        this.docXML.close();
        this.docXML = null;
    }
}

