/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDetector
implements Detector {
    private final List<Detector> detectors;

    public CompositeDetector(List<Detector> detectors) {
        this.detectors = detectors;
    }

    @Override
    public MediaType detect(InputStream input, Metadata metadata) throws IOException {
        MediaType type = MediaType.OCTET_STREAM;
        for (Detector detector : this.detectors) {
            MediaType detected = detector.detect(input, metadata);
            if (!detected.isSpecializationOf(type)) continue;
            type = detected;
        }
        return type;
    }
}

