/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.linter;

import com.google.caja.ancillary.linter.ExitModes;
import com.google.caja.ancillary.linter.ScopeAnalyzer;
import com.google.caja.ancillary.linter.VariableLiveness;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.js.ReturnStmt;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.ThrowStmt;
import com.google.caja.reporting.MessageContext;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.MoreAsserts;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

public class VariableLivenessTest
extends CajaTestCase {
    public final void testSimpleDeclaration() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var x = 1; return x;")), "Block", "  Declaration", "    Identifier : x", "    IntegerLiteral : 1", "  ReturnStmt ; liveness=(x)", "    Reference ; liveness=(x)", "      Identifier : x");
    }

    public final void testSimpleAssignment() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var x, y; x = 1; return x;")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : x", "    Declaration", "      Identifier : y", "  ExpressionStmt", "    AssignOperation : ASSIGN", "      Reference", "        Identifier : x", "      IntegerLiteral : 1", "  ReturnStmt ; liveness=(x)", "    Reference ; liveness=(x)", "      Identifier : x");
    }

    public final void testConditionWithElse1() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var x; if (r)  x = 1;  else  x = 2;  return x;")), "Block", "  Declaration", "    Identifier : x", "  Conditional", "    Reference", "      Identifier : r", "    ExpressionStmt", "      AssignOperation : ASSIGN", "        Reference", "          Identifier : x", "        IntegerLiteral : 1", "    ExpressionStmt", "      AssignOperation : ASSIGN", "        Reference", "          Identifier : x", "        IntegerLiteral : 2", "  ReturnStmt ; liveness=(x)", "    Reference ; liveness=(x)", "      Identifier : x");
    }

    public final void testConditionWithElse2() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var x = 1, y, z, w;if (r && (w = 1))  z = 1, y = 3;else  z = 2;return;")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : x", "      IntegerLiteral : 1", "    Declaration ; liveness=(x)", "      Identifier : y", "    Declaration ; liveness=(x)", "      Identifier : z", "    Declaration ; liveness=(x)", "      Identifier : w", "  Conditional ; liveness=(x)", "    ControlOperation : LOGICAL_AND ; liveness=(x)", "      Reference ; liveness=(x)", "        Identifier : r", "      AssignOperation : ASSIGN ; liveness=(x)", "        Reference ; liveness=(x)", "          Identifier : w", "        IntegerLiteral : 1 ; liveness=(x)", "    ExpressionStmt ; liveness=(x w)", "      SpecialOperation : COMMA ; liveness=(x w)", "        AssignOperation : ASSIGN ; liveness=(x w)", "          Reference ; liveness=(x w)", "            Identifier : z", "          IntegerLiteral : 1 ; liveness=(x w)", "        AssignOperation : ASSIGN ; liveness=(x w z)", "          Reference ; liveness=(x w z)", "            Identifier : y", "          IntegerLiteral : 3 ; liveness=(x w z)", "    ExpressionStmt ; liveness=(x)", "      AssignOperation : ASSIGN ; liveness=(x)", "        Reference ; liveness=(x)", "          Identifier : z", "        IntegerLiteral : 2 ; liveness=(x)", "  ReturnStmt ; liveness=(x z)");
    }

    public final void testConditionWithoutElse() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var x = 1, y, z;if (r)  z = 1, y = 3;return;")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : x", "      IntegerLiteral : 1", "    Declaration ; liveness=(x)", "      Identifier : y", "    Declaration ; liveness=(x)", "      Identifier : z", "  Conditional ; liveness=(x)", "    Reference ; liveness=(x)", "      Identifier : r", "    ExpressionStmt ; liveness=(x)", "      SpecialOperation : COMMA ; liveness=(x)", "        AssignOperation : ASSIGN ; liveness=(x)", "          Reference ; liveness=(x)", "            Identifier : z", "          IntegerLiteral : 1 ; liveness=(x)", "        AssignOperation : ASSIGN ; liveness=(x z)", "          Reference ; liveness=(x z)", "            Identifier : y", "          IntegerLiteral : 3 ; liveness=(x z)", "  ReturnStmt ; liveness=(x)");
    }

    public final void testConditionWithReturn() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var x = 1, y, z;if (r)  z = 1, y = 3;else  return;return z;")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : x", "      IntegerLiteral : 1", "    Declaration ; liveness=(x)", "      Identifier : y", "    Declaration ; liveness=(x)", "      Identifier : z", "  Conditional ; liveness=(x)", "    Reference ; liveness=(x)", "      Identifier : r", "    ExpressionStmt ; liveness=(x)", "      SpecialOperation : COMMA ; liveness=(x)", "        AssignOperation : ASSIGN ; liveness=(x)", "          Reference ; liveness=(x)", "            Identifier : z", "          IntegerLiteral : 1 ; liveness=(x)", "        AssignOperation : ASSIGN ; liveness=(x z)", "          Reference ; liveness=(x z)", "            Identifier : y", "          IntegerLiteral : 3 ; liveness=(x z)", "    ReturnStmt ; liveness=(x)", "  ReturnStmt ; liveness=(x z y)", "    Reference ; liveness=(x z y)", "      Identifier : z");
    }

    public final void testTernaryOp() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b, c;((a = x) || (b = y)) ? (c = z) : (c = w);;")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "    Declaration", "      Identifier : c", "  ExpressionStmt", "    ControlOperation : TERNARY", "      ControlOperation : LOGICAL_OR", "        AssignOperation : ASSIGN", "          Reference", "            Identifier : a", "          Reference", "            Identifier : x", "        AssignOperation : ASSIGN ; liveness=(a)", "          Reference ; liveness=(a)", "            Identifier : b", "          Reference ; liveness=(a)", "            Identifier : y", "      AssignOperation : ASSIGN ; liveness=(a)", "        Reference ; liveness=(a)", "          Identifier : c", "        Reference ; liveness=(a)", "          Identifier : z", "      AssignOperation : ASSIGN ; liveness=(a b)", "        Reference ; liveness=(a b)", "          Identifier : c", "        Reference ; liveness=(a b)", "          Identifier : w", "  Noop ; liveness=(a c)");
    }

    public final void testForLoop() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("for (var i = 0, j, k = 3, n; i < (n = arr.length); ++j, ++k) {  var v = arr[i], e;  if (v) {    e = 3;  } else {    break;  }  ;};")), "Block", "  ForLoop : ", "    MultiDeclaration", "      Declaration", "        Identifier : i", "        IntegerLiteral : 0", "      Declaration ; liveness=(i)", "        Identifier : j", "      Declaration ; liveness=(i)", "        Identifier : k", "        IntegerLiteral : 3 ; liveness=(i)", "      Declaration ; liveness=(i k)", "        Identifier : n", "    SimpleOperation : LESS_THAN ; liveness=(i k)", "      Reference ; liveness=(i k)", "        Identifier : i", "      AssignOperation : ASSIGN ; liveness=(i k)", "        Reference ; liveness=(i k)", "          Identifier : n", "        SpecialOperation : MEMBER_ACCESS ; liveness=(i k)", "          Reference ; liveness=(i k)", "            Identifier : arr", "          Reference ; liveness=(i k)", "            Identifier : length", "    ExpressionStmt ; liveness=(i k n v e)", "      SpecialOperation : COMMA ; liveness=(i k n v e)", "        AssignOperation : PRE_INCREMENT ; liveness=(i k n v e)", "          Reference ; liveness=(i k n v e)", "            Identifier : j", "        AssignOperation : PRE_INCREMENT ; liveness=(i k n v e j)", "          Reference ; liveness=(i k n v e j)", "            Identifier : k", "    Block ; liveness=(i k n)", "      MultiDeclaration ; liveness=(i k n)", "        Declaration ; liveness=(i k n)", "          Identifier : v", "          SpecialOperation : SQUARE_BRACKET ; liveness=(i k n)", "            Reference ; liveness=(i k n)", "              Identifier : arr", "            Reference ; liveness=(i k n)", "              Identifier : i", "        Declaration ; liveness=(i k n v)", "          Identifier : e", "      Conditional ; liveness=(i k n v)", "        Reference ; liveness=(i k n v)", "          Identifier : v", "        Block ; liveness=(i k n v)", "          ExpressionStmt ; liveness=(i k n v)", "            AssignOperation : ASSIGN ; liveness=(i k n v)", "              Reference ; liveness=(i k n v)", "                Identifier : e", "              IntegerLiteral : 3 ; liveness=(i k n v)", "        Block ; liveness=(i k n v)", "          BreakStmt :  ; liveness=(i k n v)", "      Noop ; liveness=(i k n v e)", "  Noop ; liveness=(i k n)");
    }

    public final void testForLoopThatDoesNotComplete() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b;x: for (var i = 0; ; a = 1) {  b = 1;  break x;};")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "  ForLoop : x", "    Declaration", "      Identifier : i", "      IntegerLiteral : 0", "    BooleanLiteral : true ; liveness=(i)", "    ExpressionStmt", "      AssignOperation : ASSIGN", "        Reference", "          Identifier : a", "        IntegerLiteral : 1", "    Block ; liveness=(i)", "      ExpressionStmt ; liveness=(i)", "        AssignOperation : ASSIGN ; liveness=(i)", "          Reference ; liveness=(i)", "            Identifier : b", "          IntegerLiteral : 1 ; liveness=(i)", "      BreakStmt : x ; liveness=(i b)", "  Noop ; liveness=(i)");
    }

    public final void testForEachLoop() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a = 1, b, c;for (var k in (b = obj)) {  c = 1;};")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "      IntegerLiteral : 1", "    Declaration ; liveness=(a)", "      Identifier : b", "    Declaration ; liveness=(a)", "      Identifier : c", "  ForEachLoop :  ; liveness=(a)", "    Declaration ; liveness=(a b)", "      Identifier : k", "    AssignOperation : ASSIGN ; liveness=(a)", "      Reference ; liveness=(a)", "        Identifier : b", "      Reference ; liveness=(a)", "        Identifier : obj", "    Block ; liveness=(a b k)", "      ExpressionStmt ; liveness=(a b k)", "        AssignOperation : ASSIGN ; liveness=(a b k)", "          Reference ; liveness=(a b k)", "            Identifier : c", "          IntegerLiteral : 1 ; liveness=(a b k)", "  Noop ; liveness=(a b)");
    }

    public final void testDoWhileLoop() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b = 0, c, d;do {  a += 1;} while (c = d + 1);;")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "      IntegerLiteral : 0", "    Declaration ; liveness=(b)", "      Identifier : c", "    Declaration ; liveness=(b)", "      Identifier : d", "  DoWhileLoop :  ; liveness=(b)", "    Block ; liveness=(b)", "      ExpressionStmt ; liveness=(b)", "        AssignOperation : ASSIGN_SUM ; liveness=(b)", "          Reference ; liveness=(b)", "            Identifier : a", "          IntegerLiteral : 1 ; liveness=(b)", "    AssignOperation : ASSIGN ; liveness=(b a)", "      Reference ; liveness=(b a)", "        Identifier : c", "      SimpleOperation : ADDITION ; liveness=(b a)", "        Reference ; liveness=(b a)", "          Identifier : d", "        IntegerLiteral : 1 ; liveness=(b a)", "  Noop ; liveness=(b a c)");
    }

    public final void testWhileLoop() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b = 0, c, d;while (c = d + 1) {  a += 1;  ;};")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "      IntegerLiteral : 0", "    Declaration ; liveness=(b)", "      Identifier : c", "    Declaration ; liveness=(b)", "      Identifier : d", "  WhileLoop :  ; liveness=(b)", "    AssignOperation : ASSIGN ; liveness=(b)", "      Reference ; liveness=(b)", "        Identifier : c", "      SimpleOperation : ADDITION ; liveness=(b)", "        Reference ; liveness=(b)", "          Identifier : d", "        IntegerLiteral : 1 ; liveness=(b)", "    Block ; liveness=(b c)", "      ExpressionStmt ; liveness=(b c)", "        AssignOperation : ASSIGN_SUM ; liveness=(b c)", "          Reference ; liveness=(b c)", "            Identifier : a", "          IntegerLiteral : 1 ; liveness=(b c)", "      Noop ; liveness=(b c a)", "  Noop ; liveness=(b c)");
    }

    public final void testTryCatchFinally() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b = 0, c, d;try {  a = f();  ;} catch (e) {  c = e;  return;} finally {  d = 1;  ;};")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "      IntegerLiteral : 0", "    Declaration ; liveness=(b)", "      Identifier : c", "    Declaration ; liveness=(b)", "      Identifier : d", "  TryStmt ; liveness=(b)", "    Block ; liveness=(b)", "      ExpressionStmt ; liveness=(b)", "        AssignOperation : ASSIGN ; liveness=(b)", "          Reference ; liveness=(b)", "            Identifier : a", "          SpecialOperation : FUNCTION_CALL ; liveness=(b)", "            Reference ; liveness=(b)", "              Identifier : f", "      Noop ; liveness=(b a)", "    CatchStmt ; liveness=(b)", "      Declaration ; liveness=(b)", "        Identifier : e", "      Block ; liveness=(b e@2)", "        ExpressionStmt ; liveness=(b e@2)", "          AssignOperation : ASSIGN ; liveness=(b e@2)", "            Reference ; liveness=(b e@2)", "              Identifier : c", "            Reference ; liveness=(b e@2)", "              Identifier : e", "        ReturnStmt ; liveness=(b e@2 c)", "    FinallyStmt ; liveness=(b)", "      Block ; liveness=(b)", "        ExpressionStmt ; liveness=(b)", "          AssignOperation : ASSIGN ; liveness=(b)", "            Reference ; liveness=(b)", "              Identifier : d", "            IntegerLiteral : 1 ; liveness=(b)", "        Noop ; liveness=(b d)", "  Noop ; liveness=(b d)");
    }

    public final void testTryCatch() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b = 0, c, d;try {  a = f();  c = 1;} catch (e) {  c = d = e;};")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "      IntegerLiteral : 0", "    Declaration ; liveness=(b)", "      Identifier : c", "    Declaration ; liveness=(b)", "      Identifier : d", "  TryStmt ; liveness=(b)", "    Block ; liveness=(b)", "      ExpressionStmt ; liveness=(b)", "        AssignOperation : ASSIGN ; liveness=(b)", "          Reference ; liveness=(b)", "            Identifier : a", "          SpecialOperation : FUNCTION_CALL ; liveness=(b)", "            Reference ; liveness=(b)", "              Identifier : f", "      ExpressionStmt ; liveness=(b a)", "        AssignOperation : ASSIGN ; liveness=(b a)", "          Reference ; liveness=(b a)", "            Identifier : c", "          IntegerLiteral : 1 ; liveness=(b a)", "    CatchStmt ; liveness=(b)", "      Declaration ; liveness=(b)", "        Identifier : e", "      Block ; liveness=(b e@2)", "        ExpressionStmt ; liveness=(b e@2)", "          AssignOperation : ASSIGN ; liveness=(b e@2)", "            Reference ; liveness=(b e@2)", "              Identifier : c", "            AssignOperation : ASSIGN ; liveness=(b e@2)", "              Reference ; liveness=(b e@2)", "                Identifier : d", "              Reference ; liveness=(b e@2)", "                Identifier : e", "  Noop ; liveness=(b c)");
    }

    public final void testTryCatchWithReturn() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b = 0, c;try {  a = f();} catch (e) {  return null;};")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "      IntegerLiteral : 0", "    Declaration ; liveness=(b)", "      Identifier : c", "  TryStmt ; liveness=(b)", "    Block ; liveness=(b)", "      ExpressionStmt ; liveness=(b)", "        AssignOperation : ASSIGN ; liveness=(b)", "          Reference ; liveness=(b)", "            Identifier : a", "          SpecialOperation : FUNCTION_CALL ; liveness=(b)", "            Reference ; liveness=(b)", "              Identifier : f", "    CatchStmt ; liveness=(b)", "      Declaration ; liveness=(b)", "        Identifier : e", "      Block ; liveness=(b e@2)", "        ReturnStmt ; liveness=(b e@2)", "          NullLiteral : null ; liveness=(b e@2)", "  Noop ; liveness=(b a)");
    }

    public final void testTryFinally() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b = 0, d;try {  a = f();  ;} finally {  d = 1;  ;};")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "      IntegerLiteral : 0", "    Declaration ; liveness=(b)", "      Identifier : d", "  TryStmt ; liveness=(b)", "    Block ; liveness=(b)", "      ExpressionStmt ; liveness=(b)", "        AssignOperation : ASSIGN ; liveness=(b)", "          Reference ; liveness=(b)", "            Identifier : a", "          SpecialOperation : FUNCTION_CALL ; liveness=(b)", "            Reference ; liveness=(b)", "              Identifier : f", "      Noop ; liveness=(b a)", "    FinallyStmt ; liveness=(b)", "      Block ; liveness=(b)", "        ExpressionStmt ; liveness=(b)", "          AssignOperation : ASSIGN ; liveness=(b)", "            Reference ; liveness=(b)", "              Identifier : d", "            IntegerLiteral : 1 ; liveness=(b)", "        Noop ; liveness=(b d)", "  Noop ; liveness=(b d)");
    }

    public final void testTryAndCatchBreak() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a;do {  try {    a = f();    break;  } catch (ex) {    a = 1;    break;  }} while (false);;")), "Block", "  Declaration", "    Identifier : a", "  DoWhileLoop : ", "    Block", "      TryStmt", "        Block", "          ExpressionStmt", "            AssignOperation : ASSIGN", "              Reference", "                Identifier : a", "              SpecialOperation : FUNCTION_CALL", "                Reference", "                  Identifier : f", "          BreakStmt :  ; liveness=(a)", "        CatchStmt", "          Declaration", "            Identifier : ex", "          Block ; liveness=(ex@4)", "            ExpressionStmt ; liveness=(ex@4)", "              AssignOperation : ASSIGN ; liveness=(ex@4)", "                Reference ; liveness=(ex@4)", "                  Identifier : a", "                IntegerLiteral : 1 ; liveness=(ex@4)", "            BreakStmt :  ; liveness=(ex@4 a)", "    BooleanLiteral : false", "  Noop ; liveness=(a)");
    }

    public final void testTryReturns() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a;do {  try {    return f();  } catch (ex) {    a = 1;    break;  }} while (false);;")), "Block", "  Declaration", "    Identifier : a", "  DoWhileLoop : ", "    Block", "      TryStmt", "        Block", "          ReturnStmt", "            SpecialOperation : FUNCTION_CALL", "              Reference", "                Identifier : f", "        CatchStmt", "          Declaration", "            Identifier : ex", "          Block ; liveness=(ex@4)", "            ExpressionStmt ; liveness=(ex@4)", "              AssignOperation : ASSIGN ; liveness=(ex@4)", "                Reference ; liveness=(ex@4)", "                  Identifier : a", "                IntegerLiteral : 1 ; liveness=(ex@4)", "            BreakStmt :  ; liveness=(ex@4 a)", "    BooleanLiteral : false", "  Noop ; liveness=(a)");
    }

    public final void testTryAlwaysThrows() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a;try {  throw new Error;\n} catch (ex) {  a = 1;};")), "Block", "  Declaration", "    Identifier : a", "  TryStmt", "    Block", "      ThrowStmt", "        SpecialOperation : CONSTRUCTOR", "          Reference", "            Identifier : Error", "    CatchStmt", "      Declaration", "        Identifier : ex", "      Block ; liveness=(ex@2)", "        ExpressionStmt ; liveness=(ex@2)", "          AssignOperation : ASSIGN ; liveness=(ex@2)", "            Reference ; liveness=(ex@2)", "              Identifier : a", "            IntegerLiteral : 1 ; liveness=(ex@2)", "  Noop ; liveness=(a)");
    }

    public final void testSwitchStmtWithDefault() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b;switch (x) {  case 0:    return null;  case 1:    if (y) { return null; }  case (b = 2):    a = 1;    break;  default:    a = 2;};")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "  SwitchStmt : ", "    Reference", "      Identifier : x", "    CaseStmt", "      IntegerLiteral : 0", "      ReturnStmt", "        NullLiteral : null", "    CaseStmt", "      IntegerLiteral : 1", "      Conditional", "        Reference", "          Identifier : y", "        Block", "          ReturnStmt", "            NullLiteral : null", "    CaseStmt", "      AssignOperation : ASSIGN", "        Reference", "          Identifier : b", "        IntegerLiteral : 2", "      Block ; liveness=(b)", "        ExpressionStmt ; liveness=(b)", "          AssignOperation : ASSIGN ; liveness=(b)", "            Reference ; liveness=(b)", "              Identifier : a", "            IntegerLiteral : 1 ; liveness=(b)", "        BreakStmt :  ; liveness=(b a)", "    DefaultCaseStmt", "      ExpressionStmt", "        AssignOperation : ASSIGN", "          Reference", "            Identifier : a", "          IntegerLiteral : 2", "  Noop ; liveness=(a)");
    }

    public final void testSwitchStmtWithNonCompletingDefault() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a;switch (s) {  case 'a': a = false; break;  case 'b': a = true;  break;  default:    return null;};")), "Block", "  Declaration", "    Identifier : a", "  SwitchStmt : ", "    Reference", "      Identifier : s", "    CaseStmt", "      StringLiteral : 'a'", "      Block", "        ExpressionStmt", "          AssignOperation : ASSIGN", "            Reference", "              Identifier : a", "            BooleanLiteral : false", "        BreakStmt :  ; liveness=(a)", "    CaseStmt", "      StringLiteral : 'b'", "      Block", "        ExpressionStmt", "          AssignOperation : ASSIGN", "            Reference", "              Identifier : a", "            BooleanLiteral : true", "        BreakStmt :  ; liveness=(a)", "    DefaultCaseStmt", "      ReturnStmt", "        NullLiteral : null", "  Noop ; liveness=(a)");
    }

    public final void testSwitchStmtWithoutDefault() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b;switch (b = 1, x) {  case 0:    return null;  case 1:    if (y) { return null; }  case (b = 2):    a = 1;    break;};")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "  SwitchStmt : ", "    SpecialOperation : COMMA", "      AssignOperation : ASSIGN", "        Reference", "          Identifier : b", "        IntegerLiteral : 1", "      Reference ; liveness=(b)", "        Identifier : x", "    CaseStmt ; liveness=(b)", "      IntegerLiteral : 0 ; liveness=(b)", "      ReturnStmt ; liveness=(b)", "        NullLiteral : null ; liveness=(b)", "    CaseStmt ; liveness=(b)", "      IntegerLiteral : 1 ; liveness=(b)", "      Conditional ; liveness=(b)", "        Reference ; liveness=(b)", "          Identifier : y", "        Block ; liveness=(b)", "          ReturnStmt ; liveness=(b)", "            NullLiteral : null ; liveness=(b)", "    CaseStmt ; liveness=(b)", "      AssignOperation : ASSIGN ; liveness=(b)", "        Reference ; liveness=(b)", "          Identifier : b", "        IntegerLiteral : 2 ; liveness=(b)", "      Block ; liveness=(b)", "        ExpressionStmt ; liveness=(b)", "          AssignOperation : ASSIGN ; liveness=(b)", "            Reference ; liveness=(b)", "              Identifier : a", "            IntegerLiteral : 1 ; liveness=(b)", "        BreakStmt :  ; liveness=(b a)", "  Noop ; liveness=(b)");
    }

    public final void testSwitchAllBreak() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b;switch (x) {  case 0:    b = 1;  case 1:  case 2:    a = true;    break;  default:    a = false;    break;};")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "  SwitchStmt : ", "    Reference", "      Identifier : x", "    CaseStmt", "      IntegerLiteral : 0", "      ExpressionStmt", "        AssignOperation : ASSIGN", "          Reference", "            Identifier : b", "          IntegerLiteral : 1", "    CaseStmt", "      IntegerLiteral : 1", "      Noop", "    CaseStmt", "      IntegerLiteral : 2", "      Block", "        ExpressionStmt", "          AssignOperation : ASSIGN", "            Reference", "              Identifier : a", "            BooleanLiteral : true", "        BreakStmt :  ; liveness=(a)", "    DefaultCaseStmt", "      Block", "        ExpressionStmt", "          AssignOperation : ASSIGN", "            Reference", "              Identifier : a", "            BooleanLiteral : false", "        BreakStmt :  ; liveness=(a)", "  Noop ; liveness=(a)");
    }

    public final void testSwitchNoCases() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b;switch (a = x) {};")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "  SwitchStmt : ", "    AssignOperation : ASSIGN", "      Reference", "        Identifier : a", "      Reference", "        Identifier : x", "  Noop ; liveness=(a)");
    }

    public final void testFunctionBody() throws Exception {
        String inFoo = " ; liveness=(foo@2 this@2 arguments@2 x@2 y@2)";
        String inA = " ; liveness=(b@2 this@2 arguments@2)";
        String inBar = " ; liveness=(bar@2 this@2 arguments@2 x@2)";
        VariableLivenessTest.assertLiveness(this.js(this.fromString("foo(1, 2);function foo(x, y) {  return x + bar(y);}var a = function b() { return this; };function bar(x) { return [x, x]; };")), "Block", "  ExpressionStmt ; liveness=(foo bar)", "    SpecialOperation : FUNCTION_CALL ; liveness=(foo bar)", "      Reference ; liveness=(foo bar)", "        Identifier : foo", "      IntegerLiteral : 1 ; liveness=(foo bar)", "      IntegerLiteral : 2 ; liveness=(foo bar)", "  FunctionDeclaration", "    Identifier : foo", "    FunctionConstructor", "      Identifier : foo", "      FormalParam", "        Identifier : x", "      FormalParam", "        Identifier : y", "      Block" + inFoo, "        ReturnStmt" + inFoo, "          SimpleOperation : ADDITION" + inFoo, "            Reference" + inFoo, "              Identifier : x", "            SpecialOperation : FUNCTION_CALL" + inFoo, "              Reference" + inFoo, "                Identifier : bar", "              Reference" + inFoo, "                Identifier : y", "  Declaration ; liveness=(foo bar)", "    Identifier : a", "    FunctionConstructor ; liveness=(foo bar)", "      Identifier : b", "      Block" + inA, "        ReturnStmt" + inA, "          Reference" + inA, "            Identifier : this", "  FunctionDeclaration ; liveness=(foo)", "    Identifier : bar", "    FunctionConstructor ; liveness=(foo)", "      Identifier : bar", "      FormalParam", "        Identifier : x", "      Block" + inBar, "        ReturnStmt" + inBar, "          ArrayConstructor" + inBar, "            Reference" + inBar, "              Identifier : x", "            Reference" + inBar, "              Identifier : x", "  Noop ; liveness=(foo bar a)");
    }

    public final void testBreaksAndContinues() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b;do {  if (f()) {    b = 0;    a = g();  } else {    a += 1;    break;  }} while (a < 10);;")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "  DoWhileLoop : ", "    Block", "      Conditional", "        SpecialOperation : FUNCTION_CALL", "          Reference", "            Identifier : f", "        Block", "          ExpressionStmt", "            AssignOperation : ASSIGN", "              Reference", "                Identifier : b", "              IntegerLiteral : 0", "          ExpressionStmt ; liveness=(b)", "            AssignOperation : ASSIGN ; liveness=(b)", "              Reference ; liveness=(b)", "                Identifier : a", "              SpecialOperation : FUNCTION_CALL ; liveness=(b)", "                Reference ; liveness=(b)", "                  Identifier : g", "        Block", "          ExpressionStmt", "            AssignOperation : ASSIGN_SUM", "              Reference", "                Identifier : a", "              IntegerLiteral : 1", "          BreakStmt :  ; liveness=(a)", "    SimpleOperation : LESS_THAN ; liveness=(b a)", "      Reference ; liveness=(b a)", "        Identifier : a", "      IntegerLiteral : 10 ; liveness=(b a)", "  Noop ; liveness=(a)");
    }

    public final void testAnonymousFunctions() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a;(function () {  a = 1;})();;")), "Block", "  Declaration", "    Identifier : a", "  ExpressionStmt", "    SpecialOperation : FUNCTION_CALL", "      FunctionConstructor", "        Identifier", "        Block ; liveness=(this@3 arguments@3)", "          ExpressionStmt ; liveness=(this@3 arguments@3)", "            AssignOperation : ASSIGN ; liveness=(this@3 arguments@3)", "              Reference ; liveness=(this@3 arguments@3)", "                Identifier : a", "              IntegerLiteral : 1 ; liveness=(this@3 arguments@3)", "  Noop ; liveness=(a)");
    }

    public final void testWithBlock() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b, c, d = 1;with (a = obj) {  b = c = d;  ;};")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "    Declaration", "      Identifier : c", "    Declaration", "      Identifier : d", "      IntegerLiteral : 1", "  WithStmt ; liveness=(d)", "    AssignOperation : ASSIGN ; liveness=(d)", "      Reference ; liveness=(d)", "        Identifier : a", "      Reference ; liveness=(d)", "        Identifier : obj", "    Block", "      ExpressionStmt", "        AssignOperation : ASSIGN", "          Reference", "            Identifier : b", "          AssignOperation : ASSIGN", "            Reference", "              Identifier : c", "            Reference", "              Identifier : d", "      Noop", "  Noop ; liveness=(d a)");
    }

    public final void testUnreachableCode1() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b, c = 1;do {  a = 1;  break;  b = 1;} while(false);;")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "    Declaration", "      Identifier : c", "      IntegerLiteral : 1", "  DoWhileLoop :  ; liveness=(c)", "    Block ; liveness=(c)", "      ExpressionStmt ; liveness=(c)", "        AssignOperation : ASSIGN ; liveness=(c)", "          Reference ; liveness=(c)", "            Identifier : a", "          IntegerLiteral : 1 ; liveness=(c)", "      BreakStmt :  ; liveness=(c a)", "      ExpressionStmt", "        AssignOperation : ASSIGN", "          Reference", "            Identifier : b", "          IntegerLiteral : 1", "    BooleanLiteral : false", "  Noop ; liveness=(c a)");
    }

    public final void testUnreachableCode2() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a, b, c = 1;do {  a = 1;  continue;  b = 1;} while(false);;")), "Block", "  MultiDeclaration", "    Declaration", "      Identifier : a", "    Declaration", "      Identifier : b", "    Declaration", "      Identifier : c", "      IntegerLiteral : 1", "  DoWhileLoop :  ; liveness=(c)", "    Block ; liveness=(c)", "      ExpressionStmt ; liveness=(c)", "        AssignOperation : ASSIGN ; liveness=(c)", "          Reference ; liveness=(c)", "            Identifier : a", "          IntegerLiteral : 1 ; liveness=(c)", "      ContinueStmt :  ; liveness=(c a)", "      ExpressionStmt", "        AssignOperation : ASSIGN", "          Reference", "            Identifier : b", "          IntegerLiteral : 1", "    BooleanLiteral : false ; liveness=(c a)", "  Noop ; liveness=(c a)");
    }

    public final void testLoopLabels() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a = null;foo: while (1) {  if (rand)    break;  else    break foo;  unreachable;};")), "Block", "  Declaration", "    Identifier : a", "    NullLiteral : null", "  WhileLoop : foo ; liveness=(a)", "    IntegerLiteral : 1 ; liveness=(a)", "    Block ; liveness=(a)", "      Conditional ; liveness=(a)", "        Reference ; liveness=(a)", "          Identifier : rand", "        BreakStmt :  ; liveness=(a)", "        BreakStmt : foo ; liveness=(a)", "      ExpressionStmt", "        Reference", "          Identifier : unreachable", "  Noop ; liveness=(a)");
    }

    public final void testLogicOps() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a;t && ((a = foo) && a.indexOf('f') >= 0) || f;")), "Block", "  Declaration", "    Identifier : a", "  ExpressionStmt", "    ControlOperation : LOGICAL_OR", "      ControlOperation : LOGICAL_AND", "        Reference", "          Identifier : t", "        ControlOperation : LOGICAL_AND", "          AssignOperation : ASSIGN", "            Reference", "              Identifier : a", "            Reference", "              Identifier : foo", "          SimpleOperation : GREATER_EQUALS ; liveness=(a)", "            SpecialOperation : FUNCTION_CALL ; liveness=(a)", "              SpecialOperation : MEMBER_ACCESS ; liveness=(a)", "                Reference ; liveness=(a)", "                  Identifier : a", "                Reference ; liveness=(a)", "                  Identifier : indexOf", "              StringLiteral : 'f' ; liveness=(a)", "            IntegerLiteral : 0 ; liveness=(a)", "      Reference", "        Identifier : f");
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a;t && (a = foo) && a.indexOf('f') >= 0 || f;")), "Block", "  Declaration", "    Identifier : a", "  ExpressionStmt", "    ControlOperation : LOGICAL_OR", "      ControlOperation : LOGICAL_AND", "        ControlOperation : LOGICAL_AND", "          Reference", "            Identifier : t", "          AssignOperation : ASSIGN", "            Reference", "              Identifier : a", "            Reference", "              Identifier : foo", "        SimpleOperation : GREATER_EQUALS ; liveness=(a)", "          SpecialOperation : FUNCTION_CALL ; liveness=(a)", "            SpecialOperation : MEMBER_ACCESS ; liveness=(a)", "              Reference ; liveness=(a)", "                Identifier : a", "              Reference ; liveness=(a)", "                Identifier : indexOf", "            StringLiteral : 'f' ; liveness=(a)", "          IntegerLiteral : 0 ; liveness=(a)", "      Reference", "        Identifier : f");
        VariableLivenessTest.assertLiveness(this.js(this.fromString("var a;if (b || (a = c)) {} else {};")), "Block", "  Declaration", "    Identifier : a", "  Conditional", "    ControlOperation : LOGICAL_OR", "      Reference", "        Identifier : b", "      AssignOperation : ASSIGN", "        Reference", "          Identifier : a", "        Reference", "          Identifier : c", "    Block", "    Block ; liveness=(a)", "  Noop");
    }

    public final void testLiveBreaks() throws Exception {
        ExitModes exits = VariableLivenessTest.setup(this.js(this.fromString("a: for (var i = 0; i < 10; ++i) {\n  if (foo()) {\n    continue a;\n  } else if (bar()) {\n    break a;\n  } else if (baz()) {\n    break b;\n  }\n}\nswitch (x) {\n  case 0: f(); break;\n  case 1: continue;\n  case 2: break b;\n}\nx: for (var x in o) {\n  break x;\n}\nfoo: {\n  if (Math.random()) {\n    break foo;\n  } else if (Math.random()) {\n    break;\n  } else {\n    break bar;\n  }\n}\nbreak;\n")));
        Iterator<Statement> stmts = exits.liveExits().iterator();
        VariableLivenessTest.assertTrue((boolean)stmts.hasNext());
        VariableLivenessTest.assertEquals((String)"testLiveBreaks:7", (String)this.formatShort(stmts.next().getFilePosition()));
        VariableLivenessTest.assertTrue((boolean)stmts.hasNext());
        VariableLivenessTest.assertEquals((String)"testLiveBreaks:12", (String)this.formatShort(stmts.next().getFilePosition()));
        VariableLivenessTest.assertTrue((boolean)stmts.hasNext());
        VariableLivenessTest.assertEquals((String)"testLiveBreaks:13", (String)this.formatShort(stmts.next().getFilePosition()));
        VariableLivenessTest.assertTrue((boolean)stmts.hasNext());
        VariableLivenessTest.assertEquals((String)"testLiveBreaks:24", (String)this.formatShort(stmts.next().getFilePosition()));
        VariableLivenessTest.assertTrue((boolean)stmts.hasNext());
        VariableLivenessTest.assertEquals((String)"testLiveBreaks:27", (String)this.formatShort(stmts.next().getFilePosition()));
        VariableLivenessTest.assertFalse((boolean)stmts.hasNext());
    }

    public final void testDirectives() throws Exception {
        VariableLivenessTest.assertLiveness(this.js(this.fromString("\"use strict\";")), "Block", "  DirectivePrologue", "    Directive : use strict");
    }

    private static ExitModes setup(ParseTreeNode js) {
        ScopeAnalyzer sa = new ScopeAnalyzer();
        sa.computeLexicalScopes(AncestorChain.instance(js));
        return VariableLiveness.calculateLiveness((ParseTreeNode)js).exits;
    }

    private static void assertLiveness(ParseTreeNode js, String ... golden) {
        ExitModes exits = VariableLivenessTest.setup(js);
        for (Statement stmt : exits.liveExits()) {
            if (stmt instanceof ThrowStmt || stmt instanceof ReturnStmt) continue;
            VariableLivenessTest.fail((String)("Unexpected exit at " + stmt.getFilePosition()));
        }
        StringBuilder sb = new StringBuilder();
        try {
            MessageContext mc = new MessageContext();
            mc.relevantKeys = Collections.singleton(VariableLiveness.LIVENESS);
            js.format(mc, sb);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        MoreAsserts.assertListsEqual(Arrays.asList(golden), Arrays.asList(sb.toString().replaceAll("@0", "").split("( ; liveness=\\(\\))?(?:\n|$)")));
    }
}

