/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.ancillary.servlet;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.HtmlLexer;
import com.google.caja.lexer.HtmlTokenType;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.Token;
import com.google.caja.util.Sets;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HtmlReducer {
    private static final Set<String> DD_DL_CLOSERS = Sets.immutableSet("<dd", "<dt");
    private static final Set<String> RP_RT_CLOSERS = Sets.immutableSet("<rp", "<rt");
    private static final Set<String> P_CLOSERS = Sets.immutableSet("<address", "<article", "<aside", "<blockquote", "<dir", "<div", "<dl", "<fieldset", "<footer", "<form", "<h1", "<h2", "<h3", "<h4", "<h5", "<h6", "<header", "<hgroup", "<hr", "<menu", "<nav", "<ol", "<p", "<pre", "<section", "<table", "<ul");
    private static final Set<String> THEAD_CLOSERS = Sets.immutableSet("<tfoot", "<tbody");
    private static final Set<String> TBODY_OPENERS = Sets.immutableSet("tbody", "thead", "tfoot");
    private static final Set<String> TBODY_CLOSERS = Sets.immutableSet("<tfoot", "<thead");

    HtmlReducer() {
    }

    static void reduce(String s, StringBuilder out) throws ParseException {
        CharProducer cp = CharProducer.Factory.fromString((CharSequence)s, InputSource.UNKNOWN);
        HtmlLexer lexer = new HtmlLexer(cp);
        lexer.setTreatedAsXml(false);
        Token lookahead = null;
        String lastTagSkipped = null;
        while (lexer.hasNext() || lookahead != null) {
            Token t2;
            Token t;
            if (lookahead == null) {
                t = lexer.next();
            } else {
                t = lookahead;
                lookahead = null;
            }
            if (t.type != HtmlTokenType.TAGBEGIN) {
                HtmlReducer.emitToken(t, out);
                lastTagSkipped = null;
                continue;
            }
            boolean isEndTag = t.text.startsWith("</");
            String tagName = t.text.substring(isEndTag ? 2 : 1);
            boolean skip = false;
            Token token = t2 = lexer.hasNext() ? lexer.next() : null;
            if (t2 == null || t2.type != HtmlTokenType.TAGEND) {
                out.append(t.text);
                lastTagSkipped = null;
                lookahead = t2;
                continue;
            }
            Token token2 = lookahead = lexer.hasNext() ? lexer.next() : null;
            if ("html".equals(tagName)) {
                skip = lookahead == null || lookahead.type != HtmlTokenType.COMMENT;
            } else if ("head".equals(tagName)) {
                skip = !isEndTag ? lookahead == null || lookahead.type == HtmlTokenType.TAGBEGIN : lookahead == null || !HtmlReducer.isSpaceOrComment(lookahead);
            } else if ("body".equals(tagName)) {
                skip = !isEndTag ? lookahead == null || !HtmlReducer.isSpaceOrComment(lookahead) && !"<style".equals(lookahead.text) && !"<script".equals(lookahead.text) : lookahead == null || lookahead.type != HtmlTokenType.COMMENT;
            } else if ("li".equals(tagName)) {
                skip = isEndTag && (lookahead == null || lookahead.type == HtmlTokenType.TAGBEGIN && ("<li".equals(lookahead.text) || lookahead.text.startsWith("</")));
            } else if ("dt".equals(tagName) || "dd".equals(tagName)) {
                if (isEndTag) {
                    skip = lookahead == null || lookahead.type == HtmlTokenType.TAGBEGIN && (DD_DL_CLOSERS.contains(lookahead.text) || lookahead.text.startsWith("</"));
                }
            } else if ("p".equals(tagName)) {
                if (isEndTag) {
                    skip = lookahead == null || lookahead.type == HtmlTokenType.TAGBEGIN && (P_CLOSERS.contains(lookahead.text) || lookahead.text.startsWith("</") && !"</a".equals(lookahead.text));
                }
            } else if ("rt".equals(tagName) || "rp".equals(tagName)) {
                if (isEndTag) {
                    skip = lookahead == null || lookahead.type == HtmlTokenType.TAGBEGIN && (RP_RT_CLOSERS.contains(lookahead.text) || lookahead.text.startsWith("</"));
                }
            } else if ("optgroup".equals(tagName)) {
                if (isEndTag) {
                    skip = lookahead == null || lookahead.type == HtmlTokenType.TAGBEGIN && ("<optgroup".equals(lookahead.text) || lookahead.text.startsWith("</"));
                }
            } else if ("option".equals(tagName)) {
                if (isEndTag) {
                    skip = lookahead == null || lookahead.type == HtmlTokenType.TAGBEGIN && ("<optgroup".equals(lookahead.text) || "<option".equals(lookahead.text) || lookahead.text.startsWith("</"));
                }
            } else if ("colgroup".equals(tagName)) {
                skip = !isEndTag ? lookahead != null && "<colgroup".equals(lookahead.text) && !"colgroup".equals(lastTagSkipped) : lookahead == null || !HtmlReducer.isSpaceOrComment(lookahead);
            } else if ("thead".equals(tagName)) {
                if (isEndTag) {
                    skip = lookahead != null && THEAD_CLOSERS.contains(lookahead.text);
                }
            } else if ("tbody".equals(tagName)) {
                skip = !isEndTag ? lookahead != null && "<tr".equals(lookahead.text) && !TBODY_OPENERS.contains(lastTagSkipped) : lookahead == null || TBODY_CLOSERS.contains(lookahead.text) || lookahead.text.startsWith("</");
            } else if ("tfoot".equals(tagName)) {
                if (isEndTag) {
                    skip = lookahead == null || "<tbody".equals(lookahead.text) || lookahead.text.startsWith("</");
                }
            } else if ("tr".equals(tagName)) {
                if (isEndTag) {
                    skip = lookahead == null || "<tr".equals(lookahead.text) || lookahead.text.startsWith("</");
                }
            } else if (("td".equals(tagName) || "th".equals(tagName)) && isEndTag) {
                boolean bl = skip = lookahead == null || "<td".equals(lookahead.text) || "<th".equals(lookahead.text) || lookahead.text.startsWith("</");
            }
            if (!skip) {
                out.append(t.text);
                HtmlReducer.emitToken(t2, out);
                lastTagSkipped = null;
                continue;
            }
            lastTagSkipped = tagName;
        }
    }

    private static boolean isSpaceOrComment(Token<HtmlTokenType> t) {
        if (t.type == HtmlTokenType.COMMENT) {
            return true;
        }
        if (t.type == HtmlTokenType.TEXT) {
            return Character.isWhitespace(t.text.charAt(0));
        }
        return false;
    }

    private static void emitToken(Token<HtmlTokenType> t, StringBuilder out) {
        switch ((HtmlTokenType)t.type) {
            case ATTRNAME: {
                out.append(' ');
                break;
            }
            case ATTRVALUE: {
                out.append('=');
                break;
            }
            case TAGEND: {
                if (t.text.charAt(0) != '/') break;
                out.append(' ');
                break;
            }
        }
        out.append(t.text);
    }
}

