/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.config;

import com.google.caja.config.ConfigUtil;
import com.google.caja.config.WhiteList;
import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.ParseException;
import com.google.caja.reporting.Message;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.MoreAsserts;
import com.google.caja.util.TestUtil;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;

public class ConfigUtilTest
extends CajaTestCase {
    private static final String JSON_STRING = "(?:\"(?:[^\"\\\\]|\\\\.)*\")";
    private static final String JSON_NUMBER = "(?:[+-]?(?:(?:(?:0|[1-9][0-9]*)(?:\\.[0-9]*)?)|\\.[0-9]+)(?:[eE][+-]?[0-9]+)?)";
    private static final String JSON_ATOM = "(?:(?:\"(?:[^\"\\\\]|\\\\.)*\")|null|true|false|(?:[+-]?(?:(?:(?:0|[1-9][0-9]*)(?:\\.[0-9]*)?)|\\.[0-9]+)(?:[eE][+-]?[0-9]+)?))";
    private static final String JSON_FLAT_OBJECT = "\\{(?:(?:\"(?:[^\"\\\\]|\\\\.)*\"):(?:(?:\"(?:[^\"\\\\]|\\\\.)*\")|null|true|false|(?:[+-]?(?:(?:(?:0|[1-9][0-9]*)(?:\\.[0-9]*)?)|\\.[0-9]+)(?:[eE][+-]?[0-9]+)?)),?)*\\}";

    public final void testEmptyConfigAllowNothing() throws Exception {
        WhiteList w = ConfigUtil.loadWhiteListFromJson(new StringReader("{}"), this.makeSrc(), ConfigUtil.RESOURCE_RESOLVER, this.mq);
        ConfigUtilTest.assertTrue((boolean)w.allowedItems().isEmpty());
        this.assertMessages(new String[0]);
    }

    public final void testAllowed() throws Exception {
        WhiteList w = ConfigUtil.loadWhiteListFromJson(new StringReader("{ \"allowed\": [ \"foo\", { \"key\" : \"bar\" } ] }"), this.makeSrc(), ConfigUtil.RESOURCE_RESOLVER, this.mq);
        ConfigUtilTest.assertTrue((boolean)w.allowedItems().contains("foo"));
        ConfigUtilTest.assertTrue((boolean)w.allowedItems().contains("bar"));
        ConfigUtilTest.assertEquals((int)2, (int)w.allowedItems().size());
        this.assertMessages(new String[0]);
    }

    public final void testDenied() throws Exception {
        WhiteList w = ConfigUtil.loadWhiteListFromJson(new StringReader("{ \"denied\": [ \"foo\", { \"key\" : \"bar\" } ], \"allowed\": [ \"bar\", { \"key\" : \"boo\" } ],}"), this.makeSrc(), ConfigUtil.RESOURCE_RESOLVER, this.mq);
        ConfigUtilTest.assertTrue((String)"boo", (boolean)w.allowedItems().contains("boo"));
        ConfigUtilTest.assertFalse((String)"bar", (boolean)w.allowedItems().contains("bar"));
        ConfigUtilTest.assertFalse((String)"foo", (boolean)w.allowedItems().contains("foo"));
        ConfigUtilTest.assertEquals((int)1, (int)w.allowedItems().size());
        this.assertMessages(new String[0]);
    }

    public final void testMisspelledDenied() throws Exception {
        ConfigUtil.loadWhiteListFromJson(new StringReader("{ \"denies\": [ \"foo\", { \"key\" : \"bar\" } ], \"allowed\": [ \"bar\", { \"key\" : \"boo\" } ],}"), this.makeSrc(), ConfigUtil.RESOURCE_RESOLVER, this.mq);
        this.assertMessages("WARNING: testMisspelledDenied:1+1: unrecognized key denies");
    }

    public final void testAllowedOverridden() throws Exception {
        WhiteList w = ConfigUtil.loadWhiteListFromJson(new StringReader("{ \"inherits\": [\"" + TestUtil.makeContentUrl("{ \"allowed\": [ \"foo\", \"bar\" ]}") + "\"]," + " \"denied\": [ \"foo\" ]," + "}"), this.makeSrc(), ConfigUtil.RESOURCE_RESOLVER, this.mq);
        ConfigUtilTest.assertTrue((String)"bar", (boolean)w.allowedItems().contains("bar"));
        ConfigUtilTest.assertFalse((String)"foo", (boolean)w.allowedItems().contains("foo"));
        ConfigUtilTest.assertEquals((int)1, (int)w.allowedItems().size());
        this.assertMessages(new String[0]);
    }

    public final void testDeniedOverridden() throws Exception {
        WhiteList w = ConfigUtil.loadWhiteListFromJson(new StringReader("{ \"inherits\": [\"" + TestUtil.makeContentUrl("{ \"allowed\": [ \"foo\" ], \"denied\": [ \"foo\", \"bar\" ]}") + "\"]," + " \"allowed\": [ \"bar\" ]," + "}"), this.makeSrc(), ConfigUtil.RESOURCE_RESOLVER, this.mq);
        ConfigUtilTest.assertTrue((String)"bar", (boolean)w.allowedItems().contains("bar"));
        ConfigUtilTest.assertFalse((String)"foo", (boolean)w.allowedItems().contains("foo"));
        ConfigUtilTest.assertEquals((int)1, (int)w.allowedItems().size());
        this.assertMessages(new String[0]);
    }

    public final void testDefinitionOverridden() throws Exception {
        WhiteList w = ConfigUtil.loadWhiteListFromJson(new StringReader("{ \"inherits\": [\"" + TestUtil.makeContentUrl("{ \"types\": [     { \"key\": \"foo\", \"name\": \"Foo\" },     { \"key\": \"bar\", \"name\": \"Bar\" }     ],}") + "\"]," + " \"types\": [" + "     { \"key\": \"foo\", \"name\": \"FOO\" }," + "     { \"key\": \"baz\", \"name\": \"BAZ\" }" + "     ]" + "}"), this.makeSrc(), ConfigUtil.RESOURCE_RESOLVER, this.mq);
        ConfigUtilTest.assertEquals((Object)"FOO", (Object)w.typeDefinitions().get("foo").get("name", null));
        ConfigUtilTest.assertEquals((Object)"Bar", (Object)w.typeDefinitions().get("bar").get("name", null));
        ConfigUtilTest.assertEquals((Object)"BAZ", (Object)w.typeDefinitions().get("baz").get("name", null));
        this.assertMessages(new String[0]);
    }

    public final void testMissingUrl() throws Exception {
        try {
            ConfigUtil.loadWhiteListFromJson(new StringReader("{ \"inherits\": [ {} ]}"), this.makeSrc(), ConfigUtil.RESOURCE_RESOLVER, this.mq);
            ConfigUtilTest.fail((String)"parsing not aborted");
        }
        catch (ParseException ex) {
            this.assertMessages(new String[0]);
            ex.toMessageQueue(this.mq);
        }
        this.assertMessages("FATAL_ERROR: testMissingUrl:1+1: malformed config file: expected inherits src, not null");
    }

    public final void testDuplicatedDefinitionsOk() throws Exception {
        WhiteList w = ConfigUtil.loadWhiteListFromJson(new StringReader("{ \"inherits\": [\"" + TestUtil.makeContentUrl("{ \"types\": [     { \"key\": \"foo\", \"name\": \"Foo\" },     ]}") + "\", \"" + TestUtil.makeContentUrl("{ \"types\": [     { \"key\": \"foo\", \"name\": \"Foo\" },     ],}") + "\"]" + "}"), this.makeSrc(), ConfigUtil.RESOURCE_RESOLVER, this.mq);
        ConfigUtilTest.assertEquals((Object)"Foo", (Object)w.typeDefinitions().get("foo").get("name", null));
        this.assertMessages(new String[0]);
    }

    public final void testOverriddenDuplicatedDefinitionsOk() throws Exception {
        WhiteList w = ConfigUtil.loadWhiteListFromJson(new StringReader("{ \"inherits\": [\"" + TestUtil.makeContentUrl("{ \"types\": [     { \"key\": \"foo\", \"name\": \"Foo\" },     ]}") + "\", \"" + TestUtil.makeContentUrl("{ \"types\": [     { \"key\": \"foo\", \"name\": \"Foo!!\" },     ],}") + "\"]," + " \"types\": [" + "     { \"key\": \"foo\", \"name\": \"FOO\" }," + "     ]" + "}"), this.makeSrc(), ConfigUtil.RESOURCE_RESOLVER, this.mq);
        ConfigUtilTest.assertEquals((Object)"FOO", (Object)w.typeDefinitions().get("foo").get("name", null));
        this.assertMessages(new String[0]);
    }

    public final void testUnresolvedAmbiguousDefinition() throws Exception {
        WhiteList w = ConfigUtil.loadWhiteListFromJson(new StringReader("{ \"inherits\": [\"" + TestUtil.makeContentUrl("{ \"types\": [     { \"key\": \"foo\", \"name\": \"Foo\" },     ]}") + "\", \"" + TestUtil.makeContentUrl("{ \"types\": [     { \"key\": \"foo\", \"name\": \"Foo!!\" },     ],}") + "\"]" + "}"), this.makeSrc(), ConfigUtil.RESOURCE_RESOLVER, this.mq);
        ConfigUtilTest.assertEquals((Object)"Foo", (Object)w.typeDefinitions().get("foo").get("name", null));
        this.assertMessages("FATAL_ERROR: testUnresolvedAmbiguousDefinition:1+1: ambiguous type definition {@} != {@}");
    }

    public final void testConflictsBetweenInheritedTypesResolved() throws Exception {
        WhiteList w = ConfigUtil.loadWhiteListFromJson(new StringReader("{ \"inherits\": [\"" + TestUtil.makeContentUrl("{ \"inherits\": [\"" + TestUtil.makeContentUrl("{ \"types\": [     { \"key\": \"foo\", \"name\": \"Foo-1\" },     ]}") + "\", \"" + TestUtil.makeContentUrl("{ \"types\": [     { \"key\": \"foo\", \"name\": \"Foo-2\" },     ],}") + "\"]" + "}") + "\"]," + " \"types\": [" + "     { \"key\": \"foo\", \"name\": \"Foo-3\" }," + "     ]" + "}"), this.makeSrc(), ConfigUtil.RESOURCE_RESOLVER, this.mq);
        ConfigUtilTest.assertEquals((Object)"Foo-3", (Object)w.typeDefinitions().get("foo").get("name", null));
        this.assertMessages(new String[0]);
    }

    private void assertMessages(String ... golden) {
        ArrayList<String> actual = new ArrayList<String>();
        for (Message msg : this.mq.getMessages()) {
            String msgText = msg.format(this.mc).replaceAll(JSON_FLAT_OBJECT, "{@}");
            actual.add((Object)((Object)msg.getMessageLevel()) + ": " + msgText);
        }
        MoreAsserts.assertListsEqual(Arrays.asList(golden), actual);
    }

    private FilePosition makeSrc() {
        return FilePosition.startOfFile(this.is);
    }
}

