/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.Chardet;
import com.google.caja.util.Pair;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import junit.framework.TestCase;

public class ChardetTest
extends TestCase {
    public final void testEmptyDocument() throws IOException {
        ChardetTest.assertCharset("", new byte[0], "UTF-8");
    }

    public final void testMetaHttpEquiv() throws IOException {
        String metaInputUtf8 = "<html><head><meta http-equiv=\"Content-type\" value=\"text/html;charset=UTF-8\"></head><body>Hello, World!</body></html>";
        ChardetTest.assertCharset(metaInputUtf8, metaInputUtf8.getBytes("UTF-8"), "UTF-8");
        String metaInputUtf16BE = "<html><head><meta http-equiv=\"Content-type\" value=\"text/html;charset =UTF-16BE\"></head><body>Hello, World!</body></html>";
        ChardetTest.assertCharset(metaInputUtf16BE, metaInputUtf16BE.getBytes("UTF-16BE"), "UTF-16BE");
        String metaInputUtf16LE = "<html><head><meta http-equiv=\"Content-type\" value=\"text/html;charset= 'UTF-16LE\"></head><body>Hello, World!</body></html>";
        ChardetTest.assertCharset(metaInputUtf16LE, metaInputUtf16LE.getBytes("UTF-16LE"), "UTF-16LE");
    }

    public final void testBOM() throws IOException {
        String html = "<html>Hello, World!</html>";
        String htmlWithBom = "\ufeff" + html;
        ChardetTest.assertCharset(html, htmlWithBom.getBytes("UTF-8"), "UTF-8");
        ChardetTest.assertCharset(html, htmlWithBom.getBytes("UTF-16LE"), "UTF-16LE");
        ChardetTest.assertCharset(html, htmlWithBom.getBytes("UTF-16BE"), "UTF-16BE");
        if (Chardet.supportedCharsetName("UTF-32LE") != null) {
            ChardetTest.assertCharset(html, htmlWithBom.getBytes("UTF-32LE"), "UTF-32LE");
            ChardetTest.assertCharset(html, htmlWithBom.getBytes("UTF-32BE"), "UTF-32BE");
        }
        if (Chardet.supportedCharsetName("UTF-7") != null) {
            ChardetTest.assertCharset(html, htmlWithBom.getBytes("UTF-7"), "UTF-7");
        }
        if (Chardet.supportedCharsetName("UTF-1") != null) {
            ChardetTest.assertCharset(html, htmlWithBom.getBytes("UTF-1"), "UTF-1");
        }
    }

    public final void testXmlPrologue() throws IOException {
        String html = "<html>Hello, World!</html>";
        String xmlUtf8 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + html;
        ChardetTest.assertCharset(xmlUtf8, xmlUtf8.getBytes("UTF-8"), "UTF-8");
        String xmlUtf16BE = "<?xml version=\"1.0\" encoding=\"UTF-16BE\"?>" + html;
        ChardetTest.assertCharset(xmlUtf16BE, xmlUtf16BE.getBytes("UTF-16BE"), "UTF-16BE");
        String xmlUtf16LE = "<?xml version=\"1.0\" encoding=\"UTF-16LE\"?>" + html;
        ChardetTest.assertCharset(xmlUtf16LE, xmlUtf16LE.getBytes("UTF-16LE"), "UTF-16LE");
    }

    public final void testCharsetInText() throws IOException {
        String html = "<html><head><title>charset=UTF-16LE</title></head><body>Hello, World!</body></html>";
        for (String encoding : new String[]{"UTF-8", "UTF-16LE", "UTF-16BE"}) {
            ChardetTest.assertCharset(html, ("\ufeff" + html).getBytes(encoding), encoding);
        }
    }

    private static void assertCharset(String golden, byte[] bytes, String expectedCharset) throws IOException {
        int n;
        Pair<Reader, String> p = Chardet.guessCharset(new ByteArrayInputStream(bytes));
        ChardetTest.assertEquals((String)expectedCharset, (String)((String)p.b));
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((n = ((Reader)p.a).read(buf)) > 0) {
            sb.append(buf, 0, n);
        }
        ChardetTest.assertEquals((String)golden, (String)sb.toString());
    }
}

