/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.lexer;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.PositionInferer;
import com.google.caja.parser.html.Nodes;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.Lists;
import com.google.caja.util.MoreAsserts;
import com.google.caja.util.Sets;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PositionInfererTest
extends CajaTestCase {
    public final void testNoGuides() throws ParseException {
        DocumentFragment f = this.xmlFragment(this.fromString("<br/>"));
        FilePosition spanningPos = Nodes.getFilePositionFor(f);
        PositionInfererTest.clearAllPositionsExcept(f, Sets.<String>newHashSet());
        this.assertPositions(Arrays.asList("#document-fragment ???", "  br ???"), f);
        PositionInfererTest.doInference(f, spanningPos);
        this.assertPositions(Arrays.asList("#document-fragment 1+6", "  br 1+6"), f);
    }

    public final void testGaps() throws ParseException {
        DocumentFragment f = this.xmlFragment(this.fromString("<br/>Foo<br/>"));
        FilePosition spanningPos = Nodes.getFilePositionFor(f);
        PositionInfererTest.clearAllPositionsExcept(f, Sets.newHashSet("br"));
        this.assertPositions(Arrays.asList("#document-fragment ???", "  br 1+1 - 6", "  #text ???", "  br 1+9 - 14"), f);
        PositionInfererTest.doInference(f, spanningPos);
        this.assertPositions(Arrays.asList("#document-fragment 1+1 - 14", "  br 1+1 - 6", "  #text 1+6 - 9", "  br 1+9 - 14"), f);
    }

    public final void testSparseRelations() throws ParseException {
        DocumentFragment f = this.xmlFragment(this.fromString("<b><hr/><br/></b>\n<img src='10' title='foo' />\n<p><img/></p>"));
        FilePosition spanningPos = Nodes.getFilePositionFor(f);
        PositionInfererTest.clearAllPositionsExcept(f, Sets.newHashSet("hr", "br", "title", "p"));
        this.assertPositions(Arrays.asList("#document-fragment ???", "  b ???", "    hr 1+4 - 9", "    br 1+9 - 14", "  #text ???", "  img ???", "    src ???", "      #text ???", "    title 2+15 - 20", "      #text ???", "  #text ???", "  p 3+1 - 14", "    img ???"), f);
        System.err.println("spanningPos=" + spanningPos);
        PositionInfererTest.doInference(f, spanningPos);
        this.assertPositions(Arrays.asList("#document-fragment 1+4 - 3+14", "  b 1+4 - 14", "    hr 1+4 - 9", "    br 1+9 - 14", "  #text 1+14", "  img 1+14 - 2+20", "    src 1+14", "      #text 1+14", "    title 2+15 - 20", "      #text 2+20", "  #text 2+20 - 3+1", "  p 3+1 - 14", "    img 3+1"), f);
    }

    public final void testDoesNotDamageKnownData() throws ParseException {
        DocumentFragment f = this.xmlFragment(this.fromString("<b><hr/><br/></b>\n<img src='10' title='foo' />\n<p><img/></p>"));
        FilePosition spanningPos = Nodes.getFilePositionFor(f);
        List<String> positions = Arrays.asList("#document-fragment 1+1 - 3+14", "  b 1+1 - 18", "    hr 1+4 - 9", "    br 1+9 - 14", "  #text 1+18 - 2+1", "  img 2+1 - 29", "    src 2+6 - 9", "      #text 2+10 - 14", "    title 2+15 - 20", "      #text 2+21 - 26", "  #text 2+29 - 3+1", "  p 3+1 - 14", "    img 3+4 - 10");
        this.assertPositions(positions, f);
        PositionInfererTest.doInference(f, spanningPos);
        this.assertPositions(positions, f);
    }

    private static void clearAllPositionsExcept(Node n, Set<String> exceptions) {
        if (!exceptions.contains(n.getNodeName())) {
            Nodes.setFilePositionFor(n, FilePosition.UNKNOWN);
        }
        for (Node node : Nodes.childrenOf(n)) {
            PositionInfererTest.clearAllPositionsExcept(node, exceptions);
        }
        if (n instanceof Element) {
            for (Attr attr : Nodes.attributesOf((Element)n)) {
                PositionInfererTest.clearAllPositionsExcept(attr, exceptions);
            }
        }
    }

    private void assertPositions(List<String> golden, Node n) {
        List<String> actual = Lists.newArrayList();
        PositionInfererTest.appendNodePositions(n, 0, actual);
        MoreAsserts.assertListsEqual(golden, actual);
    }

    private static void appendNodePositions(Node n, int depth, List<String> out) {
        StringBuilder sb = new StringBuilder();
        int i = depth;
        while (--i >= 0) {
            sb.append("  ");
        }
        sb.append(n.getNodeName()).append(" ");
        FilePosition p = Nodes.getFilePositionFor(n);
        if (FilePosition.UNKNOWN.equals(p)) {
            sb.append("???");
        } else {
            sb.append(p.startLineNo()).append('+').append(p.startCharInLine());
            if (p.length() != 0) {
                sb.append(" - ");
                if (p.endLineNo() != p.startLineNo()) {
                    sb.append(p.endLineNo()).append('+');
                }
                sb.append(p.endCharInLine());
            }
        }
        out.add(sb.toString());
        if (n instanceof Element) {
            for (Attr attr : Nodes.attributesOf((Element)n)) {
                PositionInfererTest.appendNodePositions(attr, depth + 1, out);
            }
        }
        for (Node node : Nodes.childrenOf(n)) {
            PositionInfererTest.appendNodePositions(node, depth + 1, out);
        }
    }

    private static void doInference(Node n, final FilePosition spanningPos) {
        PositionInferer inferer = new PositionInferer(spanningPos){

            protected FilePosition getPosForNode(Object o) {
                if (o == null) {
                    return spanningPos;
                }
                return Nodes.getFilePositionFor((Node)o);
            }

            protected void setPosForNode(Object o, FilePosition pos) {
                if (o == null) {
                    return;
                }
                Node n = (Node)o;
                FilePosition old = Nodes.getFilePositionFor(n);
                if (old.source().equals(InputSource.UNKNOWN)) {
                    Nodes.setFilePositionFor((Node)o, pos);
                }
            }
        };
        inferer.contains(null, n);
        PositionInfererTest.addRelations(n, inferer);
        inferer.solve();
    }

    private static void addRelations(Node n, PositionInferer inferer) {
        if (n instanceof Element) {
            Node firstChild = n.getFirstChild();
            for (Attr attr : Nodes.attributesOf((Element)n)) {
                inferer.contains(n, attr);
                inferer.precedes(attr, attr.getFirstChild());
                if (firstChild == null) continue;
                inferer.precedes(attr, firstChild);
            }
        }
        for (Node node : Nodes.childrenOf(n)) {
            inferer.contains(n, node);
            PositionInfererTest.addRelations(node, inferer);
        }
        Node next = n.getNextSibling();
        if (next != null) {
            inferer.adjacent(n, next);
        }
    }
}

