/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.parser.quasiliteral;

import com.google.caja.lexer.FilePosition;
import com.google.caja.lexer.Keyword;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.ParseTreeNodeContainer;
import com.google.caja.parser.js.Block;
import com.google.caja.parser.js.CatchStmt;
import com.google.caja.parser.js.Declaration;
import com.google.caja.parser.js.DirectivePrologue;
import com.google.caja.parser.js.Expression;
import com.google.caja.parser.js.FormalParam;
import com.google.caja.parser.js.FunctionConstructor;
import com.google.caja.parser.js.FunctionDeclaration;
import com.google.caja.parser.js.Identifier;
import com.google.caja.parser.js.MultiDeclaration;
import com.google.caja.parser.js.Operation;
import com.google.caja.parser.js.Operator;
import com.google.caja.parser.js.Reference;
import com.google.caja.parser.js.Statement;
import com.google.caja.parser.js.SyntheticNodes;
import com.google.caja.parser.js.UncajoledModule;
import com.google.caja.parser.js.scope.ScopeType;
import com.google.caja.parser.quasiliteral.Permit;
import com.google.caja.parser.quasiliteral.QuasiBuilder;
import com.google.caja.parser.quasiliteral.RewriterMessageType;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageType;
import com.google.caja.reporting.MessageTypeInt;
import com.google.caja.util.Lists;
import com.google.caja.util.Maps;
import com.google.caja.util.Pair;
import com.google.caja.util.Sets;
import com.google.caja.util.SyntheticAttributeKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scope {
    private final Scope parent;
    private final MessageQueue mq;
    private final ScopeType type;
    private boolean hasFreeThis = false;
    private boolean containsArguments = false;
    private int tempVariableCounter = 0;
    private final Map<String, Pair<LocalType, FilePosition>> locals = Maps.newLinkedHashMap();
    private final List<Statement> startStatements = Lists.newArrayList();
    private final Set<String> importedVariables = Sets.newTreeSet();
    private final Permit permitsUsed;
    public static final Set<String> UNMASKABLE_IDENTIFIERS = Sets.immutableSet("Array", "Infinity", "NaN", "Object", "arguments", "cajita");
    public static final SyntheticAttributeKey<Boolean> FOR_SIDE_EFFECT = new SyntheticAttributeKey<Boolean>(Boolean.class, "forSideEffect");

    public static Scope fromProgram(Block root, MessageQueue mq) {
        Scope s = new Scope(ScopeType.PROGRAM, mq);
        Scope.walkBlock(s, root);
        return s;
    }

    public static Scope fromPlainBlock(Scope parent) {
        return new Scope(ScopeType.BLOCK, parent);
    }

    public static Scope fromCatchStmt(Scope parent, CatchStmt root) {
        Scope s = new Scope(ScopeType.CATCH, parent);
        Scope.declare(s, root.getException().getIdentifier(), LocalType.CAUGHT_EXCEPTION);
        return s;
    }

    public static Scope fromParseTreeNodeContainer(Scope parent, ParseTreeNodeContainer root) {
        Scope s = new Scope(ScopeType.BLOCK, parent);
        Scope.walkBlock(s, root);
        return s;
    }

    public static Scope fromFunctionConstructor(Scope parent, FunctionConstructor root) {
        Scope s = new Scope(ScopeType.FUNCTION, parent);
        if (root.getIdentifierName() != null) {
            Scope.declare(s, root.getIdentifier(), LocalType.FUNCTION);
        }
        for (FormalParam n : root.getParams()) {
            Scope.walkBlock(s, n);
        }
        Scope.walkBlock(s, root.getBody());
        return s;
    }

    private Scope(ScopeType type, MessageQueue mq) {
        this.type = type;
        this.parent = null;
        this.mq = mq;
        this.permitsUsed = new Permit();
    }

    private Scope(ScopeType type, Scope parent) {
        this.type = type;
        this.parent = parent;
        this.mq = parent.mq;
        this.permitsUsed = parent.permitsUsed;
    }

    public Scope getParent() {
        return this.parent;
    }

    public boolean isOuter() {
        if (this.type == ScopeType.FUNCTION) {
            return false;
        }
        if (this.parent == null) {
            return true;
        }
        return this.parent.isOuter();
    }

    public List<Statement> getStartStatements() {
        for (Statement stmt : this.startStatements) {
            Scope.markForSideEffect(stmt);
        }
        return Collections.unmodifiableList(this.startStatements);
    }

    public void addStartStatement(Statement s) {
        int pos = this.startStatements.size();
        if (s.getClass() == Declaration.class) {
            Declaration d = (Declaration)s;
            if (d.getInitializer() == null) {
                int i = 0;
                if (i < pos && this.startStatements.get(i) instanceof DirectivePrologue) {
                    ++i;
                }
                if (i < pos) {
                    Statement si = this.startStatements.get(i);
                    if (si instanceof MultiDeclaration) {
                        ((MultiDeclaration)si).appendChild(d);
                        return;
                    }
                    if (si.getClass() == Declaration.class) {
                        this.startStatements.set(i, new MultiDeclaration(FilePosition.UNKNOWN, Arrays.asList((Declaration)si, d)));
                        return;
                    }
                }
                pos = i;
            }
        } else if (s instanceof DirectivePrologue) {
            if (0 < pos && this.startStatements.get(0) instanceof DirectivePrologue) {
                ((DirectivePrologue)this.startStatements.get(0)).createMutation().appendChildren(((DirectivePrologue)s).children());
                return;
            }
            pos = 0;
        }
        this.startStatements.add(pos, s);
    }

    public Set<String> getImportedVariables() {
        return this.importedVariables;
    }

    public Iterable<String> getLocals() {
        return Collections.unmodifiableSet(this.locals.keySet());
    }

    public FilePosition getLocationOfDeclaration(String localName) {
        return (FilePosition)this.locals.get((Object)localName).b;
    }

    public void addStartOfScopeStatement(Statement s) {
        this.getClosestDeclarationContainer().addStartStatement(s);
    }

    public Identifier declareStartOfScopeTempVariable() {
        Scope s = this.getClosestDeclarationContainer();
        Identifier id = SyntheticNodes.s(new Identifier(FilePosition.UNKNOWN, "x" + s.tempVariableCounter++ + "___"));
        s.addStartOfScopeStatement((Statement)QuasiBuilder.substV("var @id;", "id", id));
        return id;
    }

    public void declareStartOfScopeVariable(Identifier id) {
        Scope s = this.getClosestDeclarationContainer();
        s.addStartOfScopeStatement((Statement)QuasiBuilder.substV("var @id;", "id", id));
    }

    public Scope getClosestDeclarationContainer() {
        if (!this.type.isDeclarationContainer) {
            assert (this.parent != null);
            return this.parent.getClosestDeclarationContainer();
        }
        return this;
    }

    public boolean hasFreeThis() {
        return this.hasFreeThis;
    }

    public boolean hasFreeArguments() {
        return this.containsArguments;
    }

    public boolean isDefined(String name) {
        return this.getType(name) != null;
    }

    public Scope thatDefines(String name) {
        boolean isThis = "this".equals(name);
        boolean isArguments = "arguments".equals(name);
        boolean isThisOrArguments = isThis || isArguments;
        Scope s = this;
        while (s != null) {
            if (s.locals.containsKey(name)) {
                return s;
            }
            if (isThisOrArguments) {
                if (s.type == ScopeType.FUNCTION) {
                    return s;
                }
                if (s.type == ScopeType.PROGRAM && isThis) {
                    return s;
                }
            }
            s = s.parent;
        }
        return null;
    }

    public ScopeType getType() {
        return this.type;
    }

    private boolean isDefinedAs(String name, LocalType type) {
        return this.isDefined(name) && this.getType(name).implies(type);
    }

    public boolean isFunction(String name) {
        return this.isDefinedAs(name, LocalType.FUNCTION);
    }

    public boolean isException(String name) {
        return this.isDefinedAs(name, LocalType.CAUGHT_EXCEPTION);
    }

    public boolean isDeclaredFunctionReference(ParseTreeNode node) {
        return node instanceof Reference && this.isDeclaredFunction(((Reference)node).getIdentifierName());
    }

    public boolean isDeclaredFunction(String name) {
        return this.isDefinedAs(name, LocalType.DECLARED_FUNCTION);
    }

    public boolean isData(String name) {
        return this.isDefinedAs(name, LocalType.DATA);
    }

    public boolean isImported(String name) {
        if (this.locals.containsKey(name)) {
            return false;
        }
        if (this.parent == null) {
            return this.importedVariables.contains(name);
        }
        return this.parent.isImported(name);
    }

    public boolean isOuter(String name) {
        if (this.parent == null) {
            return true;
        }
        if (this.locals.containsKey(name)) {
            return false;
        }
        if (this.type == ScopeType.FUNCTION && ("this".equals(name) || "arguments".equals(name))) {
            return false;
        }
        if (this.type == ScopeType.PROGRAM && "this".equals(name)) {
            return false;
        }
        return this.parent.isOuter(name);
    }

    private LocalType getType(String name) {
        Scope current = this;
        do {
            Pair<LocalType, FilePosition> symbolDefinition;
            if ((symbolDefinition = current.locals.get(name)) == null) continue;
            return (LocalType)((Object)symbolDefinition.a);
        } while ((current = current.parent) != null);
        return null;
    }

    private static void addImportedVariable(Scope s, String name) {
        Scope target = s;
        while (target.getParent() != null) {
            target = target.getParent();
        }
        if (target.importedVariables.contains(name)) {
            return;
        }
        target.importedVariables.add(name);
    }

    private static LocalType computeDeclarationType(Declaration decl) {
        return decl instanceof FunctionDeclaration ? LocalType.DECLARED_FUNCTION : LocalType.DATA;
    }

    private static void walkBlock(Scope s, ParseTreeNode root) {
        SymbolHarvestVisitor v = new SymbolHarvestVisitor();
        v.visit(root);
        for (Declaration decl : v.getDeclarations()) {
            Scope.declare(s, decl.getIdentifier(), Scope.computeDeclarationType(decl));
        }
        for (Reference ref : v.getReferences()) {
            String name = ref.getIdentifierName();
            if ("arguments".equals(name)) {
                s.containsArguments = true;
                continue;
            }
            if (Keyword.THIS.toString().equals(name)) {
                s.hasFreeThis = true;
                continue;
            }
            if (s.isDefined(name)) continue;
            Scope.addImportedVariable(s, name);
        }
    }

    private static void declare(Scope s, Identifier ident, LocalType type) {
        LocalType oldType;
        Pair<LocalType, FilePosition> oldDefinition;
        String name = ident.getName();
        if (UNMASKABLE_IDENTIFIERS.contains(name)) {
            s.mq.addMessage((MessageTypeInt)RewriterMessageType.CANNOT_MASK_IDENTIFIER, ident.getFilePosition(), MessagePart.Factory.valueOf(name));
        }
        if ((oldDefinition = s.locals.get(name)) != null && ((oldType = (LocalType)((Object)oldDefinition.a)) != type || oldType.implies(LocalType.FUNCTION) || type.implies(LocalType.FUNCTION))) {
            s.mq.getMessages().add(new Message((MessageTypeInt)MessageType.SYMBOL_REDEFINED, MessageLevel.ERROR, ident.getFilePosition(), MessagePart.Factory.valueOf(name), (MessagePart)oldDefinition.b));
        }
        Scope ancestor = s.parent;
        while (ancestor != null) {
            Pair<LocalType, FilePosition> maskedDefinition = ancestor.locals.get(name);
            if (maskedDefinition != null) {
                MessageLevel level;
                LocalType maskedType = (LocalType)((Object)maskedDefinition.a);
                if (maskedType == type || maskedType == LocalType.DECLARED_FUNCTION && type == LocalType.FUNCTION) break;
                MessageLevel messageLevel = level = type == LocalType.CAUGHT_EXCEPTION || maskedType == LocalType.CAUGHT_EXCEPTION ? MessageLevel.ERROR : MessageLevel.LINT;
                if (ident.getAttributes().is(SyntheticNodes.SYNTHETIC) || ident.getFilePosition() == null) break;
                s.mq.getMessages().add(new Message((MessageTypeInt)MessageType.MASKING_SYMBOL, level, ident.getFilePosition(), MessagePart.Factory.valueOf(name), (MessagePart)maskedDefinition.b));
                break;
            }
            ancestor = ancestor.parent;
        }
        s.locals.put(name, Pair.pair(type, ident.getFilePosition()));
    }

    public Expression getPermitsUsed(Identifier varName) {
        Permit subPermit = this.permitsUsed.canRead(varName);
        if (null == subPermit) {
            return null;
        }
        return (Expression)QuasiBuilder.substV("(" + subPermit.getPermitsUsedAsJSONString() + ")", new Object[0]);
    }

    public Permit permitRead(ParseTreeNode o) {
        Reference r;
        if (o instanceof Reference && this.isImported((r = (Reference)o).getIdentifierName())) {
            return this.permitsUsed.canRead(o);
        }
        return null;
    }

    static void markForSideEffect(ParseTreeNode node) {
        if (node instanceof Statement) {
            node.getAttributes().set(FOR_SIDE_EFFECT, true);
            for (ParseTreeNode parseTreeNode : node.children()) {
                Scope.markForSideEffect(parseTreeNode);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SymbolHarvestVisitor {
        private final List<Reference> references = Lists.newArrayList();
        private final List<Declaration> declarations = Lists.newArrayList();
        private final List<String> exceptionVariables = Lists.newArrayList();

        private SymbolHarvestVisitor() {
        }

        public List<Reference> getReferences() {
            return this.references;
        }

        public List<Declaration> getDeclarations() {
            return this.declarations;
        }

        public void visit(ParseTreeNode node) {
            if (node instanceof FunctionConstructor) {
                this.visitFunctionConstructor((FunctionConstructor)node);
            } else if (node instanceof CatchStmt) {
                this.visitCatchStmt((CatchStmt)node);
            } else if (node instanceof Declaration) {
                this.visitDeclaration((Declaration)node);
            } else if (node instanceof Operation) {
                this.visitOperation((Operation)node);
            } else if (node instanceof Reference) {
                this.visitReference((Reference)node);
            } else if (node instanceof UncajoledModule) {
                this.visitModuleEnvelope((UncajoledModule)node);
            } else {
                this.visitChildren(node);
            }
        }

        private void visitChildren(ParseTreeNode node) {
            for (ParseTreeNode parseTreeNode : node.children()) {
                this.visit(parseTreeNode);
            }
        }

        private void visitFunctionConstructor(FunctionConstructor node) {
            if (node.getAttributes().is(SyntheticNodes.SYNTHETIC)) {
                this.visitChildren(node);
            }
        }

        private void visitCatchStmt(CatchStmt node) {
            this.exceptionVariables.add(node.getException().getIdentifierName());
            this.visit(node.getBody());
            this.exceptionVariables.remove(this.exceptionVariables.size() - 1);
        }

        private void visitDeclaration(Declaration node) {
            this.declarations.add(node);
            if (node.getInitializer() != null) {
                this.visit(node.getInitializer());
            }
        }

        private void visitOperation(Operation node) {
            if (node.getOperator() == Operator.MEMBER_ACCESS) {
                this.visit(node.children().get(0));
            } else {
                this.visitChildren(node);
            }
        }

        private void visitReference(Reference node) {
            if (!node.getIdentifier().getAttributes().is(SyntheticNodes.SYNTHETIC) && !this.exceptionVariables.contains(node.getIdentifierName())) {
                this.references.add(node);
            }
        }

        private void visitModuleEnvelope(UncajoledModule node) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum LocalType {
        FUNCTION(new LocalType[0]),
        DECLARED_FUNCTION(FUNCTION),
        DATA(new LocalType[0]),
        CAUGHT_EXCEPTION(new LocalType[0]);

        private final Set<LocalType> implications = Sets.newHashSet();

        private LocalType(LocalType ... implications) {
            this.implications.add(this);
            for (LocalType implication : implications) {
                this.implications.addAll(implication.implications);
            }
        }

        public boolean implies(LocalType type) {
            return this.implications.contains((Object)type);
        }
    }
}

