/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin;

import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.GuessContentType;
import com.google.caja.lexer.InputSource;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriToFile;
import com.google.caja.util.Charsets;
import com.google.caja.util.ContentType;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;

abstract class FileSystemUriFetcher
implements UriFetcher {
    private final UriToFile uriToFile;

    FileSystemUriFetcher(UriToFile uriToFile) {
        this.uriToFile = uriToFile;
    }

    public final FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
        URI uri = ref.getUri();
        File f = this.uriToFile.apply(uri);
        if (f == null) {
            throw new UriFetcher.UriFetchException(ref, mimeType);
        }
        try {
            CharProducer cp = CharProducer.Factory.create(this.newReader(f), new InputSource(uri));
            ContentType ct = GuessContentType.guess(null, f.getName(), cp);
            return FetchedData.fromCharProducer(cp, ct != null ? ct.mimeType : "", Charsets.UTF_8.name());
        }
        catch (IOException ex) {
            throw new UriFetcher.UriFetchException(ref, mimeType, ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final byte[] fetchBinary(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
        File f = this.uriToFile.apply(ref.getUri());
        if (f == null) {
            throw new UriFetcher.UriFetchException(ref, mimeType);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream((int)f.length());
        try {
            InputStream in = this.newInputStream(f);
            try {
                int n;
                byte[] buf = new byte[4096];
                while ((n = in.read(buf)) > 0) {
                    out.write(buf, 0, n);
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException ex) {
            throw new UriFetcher.UriFetchException(ref, mimeType, ex);
        }
        return out.toByteArray();
    }

    protected abstract Reader newReader(File var1) throws FileNotFoundException;

    protected abstract InputStream newInputStream(File var1) throws FileNotFoundException;
}

