/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.stages;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lexer.CharProducer;
import com.google.caja.lexer.ExternalReference;
import com.google.caja.lexer.FetchedData;
import com.google.caja.lexer.InputSource;
import com.google.caja.lexer.ParseException;
import com.google.caja.lexer.TokenConsumer;
import com.google.caja.lexer.escaping.UriUtil;
import com.google.caja.parser.ParseTreeNode;
import com.google.caja.parser.html.Dom;
import com.google.caja.plugin.DataUriFetcher;
import com.google.caja.plugin.Job;
import com.google.caja.plugin.Jobs;
import com.google.caja.plugin.PluginMeta;
import com.google.caja.plugin.UriFetcher;
import com.google.caja.plugin.UriPolicy;
import com.google.caja.reporting.RenderContext;
import com.google.caja.util.CajaTestCase;
import com.google.caja.util.ContentType;
import com.google.caja.util.Lists;
import com.google.caja.util.MoreAsserts;
import com.google.caja.util.Pair;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class PipelineStageTestCase
extends CajaTestCase {
    protected PluginMeta meta;
    private TestUriFetcher uriFetcher;

    protected void setUp() throws Exception {
        super.setUp();
        this.uriFetcher = new TestUriFetcher();
        this.meta = new PluginMeta(this.uriFetcher, new TestUriPolicy());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.meta = null;
        this.uriFetcher = null;
    }

    protected void assertPipeline(JobStub inputJob, JobStub ... outputJobs) throws Exception {
        Jobs jobs = new Jobs(this.mc, this.mq, this.meta);
        this.parseJob(inputJob, jobs);
        PipelineStageTestCase.assertTrue((boolean)this.runPipeline(jobs));
        this.assertOutputJobs(outputJobs, jobs);
    }

    protected void assertPipelineFails(JobStub inputJob, JobStub ... outputJobs) throws Exception {
        Jobs jobs = new Jobs(this.mc, this.mq, this.meta);
        this.parseJob(inputJob, jobs);
        PipelineStageTestCase.assertFalse((boolean)this.runPipeline(jobs));
        this.assertOutputJobs(outputJobs, jobs);
    }

    private void assertOutputJobs(JobStub[] outputJobs, Jobs jobs) {
        List<JobStub> actualJobs = Lists.newArrayList();
        for (Job job : jobs.getJobs()) {
            StringBuilder sb = new StringBuilder();
            ParseTreeNode node = job.getRoot();
            TokenConsumer tc = node.makeRenderer(sb, null);
            node.render(new RenderContext(tc));
            tc.noMoreTokens();
            actualJobs.add(new JobStub(sb.toString(), job.getType()));
        }
        MoreAsserts.assertListsEqual(Arrays.asList(outputJobs), actualJobs);
    }

    private void parseJob(JobStub inputJob, Jobs outputJobs) throws ParseException {
        switch (inputJob.type) {
            case HTML: {
                outputJobs.getJobs().add(Job.domJob(null, new Dom(this.htmlFragment(this.fromString(inputJob.content, this.is))), this.is.getUri()));
                break;
            }
            case CSS: {
                outputJobs.getJobs().add(Job.cssJob(null, this.css(this.fromString(inputJob.content, this.is)), this.is.getUri()));
                break;
            }
            case JS: {
                outputJobs.getJobs().add(Job.jsJob(null, this.js(this.fromString(inputJob.content, this.is)), null));
                break;
            }
            default: {
                throw new IllegalArgumentException(inputJob.type.name());
            }
        }
    }

    protected void addUrlToPluginEnvironment(String uri, String content) {
        URI absUrl = this.is.getUri().resolve(uri);
        this.addUrlToPluginEnvironment(absUrl, this.fromString(content, new InputSource(absUrl)));
    }

    protected void addUrlToPluginEnvironment(URI uri, CharProducer cp) {
        URI absUrl = this.is.getUri().resolve(uri);
        this.uriFetcher.filesToLoad.add(Pair.pair(absUrl, cp));
    }

    protected abstract boolean runPipeline(Jobs var1) throws Exception;

    protected static JobStub job(String content, ContentType type) {
        return new JobStub(content, type);
    }

    private static String decode(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new SomethingWidgyHappenedError(ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TestUriPolicy
    implements UriPolicy {
        private TestUriPolicy() {
        }

        @Override
        public String rewriteUri(ExternalReference u, UriPolicy.UriEffect effect, UriPolicy.LoaderType loader, Map<String, ?> hints) {
            return "http://proxy/?uri=" + UriUtil.encode(u.getUri().toString()) + "&effect=" + (Object)((Object)effect) + "&loader=" + (Object)((Object)loader);
        }
    }

    private static class TestUriFetcher
    implements UriFetcher {
        private List<Pair<URI, CharProducer>> filesToLoad = Lists.newArrayList();
        private DataUriFetcher dataFetcher = new DataUriFetcher();

        private TestUriFetcher() {
        }

        public FetchedData fetch(ExternalReference ref, String mimeType) throws UriFetcher.UriFetchException {
            URI uri = ref.getUri();
            Iterator<Pair<URI, CharProducer>> it = this.filesToLoad.iterator();
            while (it.hasNext()) {
                Pair<URI, CharProducer> entry = it.next();
                if (!ref.getUri().equals(entry.a)) continue;
                it.remove();
                return FetchedData.fromCharProducer(((CharProducer)entry.b).clone(), mimeType, "uTF-8");
            }
            if ("data".equals(uri.getScheme())) {
                return this.dataFetcher.fetch(ref, mimeType);
            }
            if (!"content".equals(uri.getScheme())) {
                throw new UriFetcher.UriFetchException(ref, mimeType);
            }
            return FetchedData.fromCharProducer(CharProducer.Factory.fromString((CharSequence)PipelineStageTestCase.decode(uri.getRawSchemeSpecificPart()), new InputSource(uri)), mimeType, "UTF-8");
        }
    }

    protected static final class JobStub {
        final String content;
        final ContentType type;

        JobStub(String content, ContentType type) {
            if (content == null || type == null) {
                throw new NullPointerException();
            }
            this.content = content;
            this.type = type;
        }

        public String toString() {
            return "(" + this.content + ": " + (Object)((Object)this.type) + ")";
        }

        public boolean equals(Object o) {
            if (!(o instanceof JobStub)) {
                return false;
            }
            JobStub that = (JobStub)o;
            return this.content.equals(that.content) && this.type == that.type;
        }

        public int hashCode() {
            return this.content.hashCode() + 31 * this.type.hashCode();
        }
    }
}

