/*
 * Decompiled with CFR 0.152.
 */
package com.google.caja.plugin.templates;

import com.google.caja.SomethingWidgyHappenedError;
import com.google.caja.lang.html.HTML;
import com.google.caja.lang.html.HtmlSchema;
import com.google.caja.lang.html.RegularCriterion;
import com.google.caja.parser.html.AttribKey;
import com.google.caja.parser.html.ElKey;
import com.google.caja.parser.html.Nodes;
import com.google.caja.plugin.PluginMessageType;
import com.google.caja.plugin.templates.IhtmlMessageType;
import com.google.caja.reporting.Message;
import com.google.caja.reporting.MessageLevel;
import com.google.caja.reporting.MessagePart;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.MessageTypeInt;
import java.util.ArrayList;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class TemplateSanitizer {
    private final HtmlSchema schema;
    private final MessageQueue mq;

    public TemplateSanitizer(HtmlSchema schema, MessageQueue mq) {
        this.schema = schema;
        this.mq = mq;
    }

    public boolean sanitize(Node t) {
        boolean valid = true;
        switch (t.getNodeType()) {
            case 11: {
                for (Node node : Nodes.childrenOf(t)) {
                    this.sanitize(node);
                }
                break;
            }
            case 1: {
                Element el = (Element)t;
                ElKey elKey = ElKey.forElement(el);
                if (!this.schema.isElementAllowed(elKey)) {
                    IhtmlMessageType msgType = this.schema.lookupElement(elKey) != null ? IhtmlMessageType.UNSAFE_TAG : IhtmlMessageType.UNKNOWN_TAG;
                    boolean ignore = false;
                    boolean fold = false;
                    Node p = el.getParentNode();
                    if (p != null) {
                        if (TemplateSanitizer.isElementIgnorable(elKey)) {
                            ignore = true;
                        } else if (HtmlSchema.isElementFoldable(elKey)) {
                            fold = true;
                            msgType = IhtmlMessageType.FOLDING_ELEMENT;
                        }
                    }
                    MessageLevel msgLevel = ignore || fold ? MessageLevel.WARNING : msgType.getLevel();
                    this.mq.getMessages().add(new Message((MessageTypeInt)msgType, msgLevel, Nodes.getFilePositionFor(el), elKey));
                    if (ignore) {
                        assert (p != null);
                        p.removeChild(el);
                        return valid;
                    }
                    return valid & this.foldElement(elKey, el);
                }
                valid &= this.sanitizeAttrs(elKey, el, false);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw new SomethingWidgyHappenedError(t.getNodeName());
            }
        }
        for (Node node : Nodes.childrenOf(t)) {
            valid &= this.sanitize(node);
        }
        return valid;
    }

    private boolean sanitizeAttrs(ElKey elKey, Element el, boolean ignore) {
        boolean valid = true;
        NamedNodeMap attrs = el.getAttributes();
        int i = attrs.getLength();
        while (--i >= 0) {
            valid &= this.sanitizeAttr(elKey, el, (Attr)attrs.item(i), ignore);
        }
        return valid;
    }

    private boolean sanitizeAttr(ElKey elKey, Element el, Attr attrib, boolean ignore) {
        boolean valid = true;
        AttribKey attrKey = AttribKey.forAttribute(elKey, attrib);
        HTML.Attribute a = this.schema.lookupAttribute(attrKey);
        if (null == a) {
            if (!ignore) {
                this.mq.getMessages().add(new Message((MessageTypeInt)PluginMessageType.UNKNOWN_ATTRIBUTE, MessageLevel.WARNING, Nodes.getFilePositionFor(attrib), attrKey, elKey));
            }
            valid &= this.removeBadAttribute(el, attrKey);
        } else if (!this.schema.isAttributeAllowed(attrKey)) {
            if (!ignore) {
                this.mq.addMessage((MessageTypeInt)PluginMessageType.UNSAFE_ATTRIBUTE, Nodes.getFilePositionFor(attrib), attrKey, elKey);
            }
            valid &= this.removeBadAttribute(el, attrKey);
        } else {
            RegularCriterion criteria = a.getValueCriterion();
            if (!criteria.accept(attrib.getNodeValue())) {
                if (!ignore) {
                    this.mq.addMessage((MessageTypeInt)PluginMessageType.DISALLOWED_ATTRIBUTE_VALUE, Nodes.getFilePositionForValue(attrib), attrKey, MessagePart.Factory.valueOf(attrib.getNodeValue()));
                }
                valid &= this.removeBadAttribute(el, attrKey);
            }
        }
        return valid;
    }

    private static boolean isElementIgnorable(ElKey elKey) {
        if (!elKey.isHtml()) {
            return false;
        }
        String lcName = elKey.localName;
        return "noscript".equals(lcName) || "noembed".equals(lcName) || "noframes".equals(lcName) || "title".equals(lcName);
    }

    private boolean foldElement(ElKey elKey, Element el) {
        boolean valid = true;
        valid &= this.sanitizeAttrs(elKey, el, true);
        for (Node node : Nodes.childrenOf(el)) {
            valid &= this.sanitize(node);
        }
        for (Attr attr : Nodes.attributesOf(el)) {
            this.mq.addMessage((MessageTypeInt)PluginMessageType.CANNOT_FOLD_ATTRIBUTE, Nodes.getFilePositionFor(attr), MessagePart.Factory.valueOf(attr.getNodeName()), MessagePart.Factory.valueOf(el.getLocalName()));
        }
        ArrayList<Node> foldedChildren = new ArrayList<Node>();
        for (Node node : Nodes.childrenOf(el)) {
            switch (node.getNodeType()) {
                case 1: 
                case 3: 
                case 4: {
                    foldedChildren.add(node);
                    break;
                }
            }
        }
        Node node = el.getNextSibling();
        Node node2 = el.getParentNode();
        node2.removeChild(el);
        for (Node n : foldedChildren) {
            node2.insertBefore(n, node);
        }
        return valid;
    }

    private boolean removeBadAttribute(Element el, AttribKey attrKey) {
        el.removeAttributeNS(attrKey.ns.uri, attrKey.localName);
        return true;
    }
}

